<?php

/**
 * Simple Machines Forum (SMF)
 *
 * @package SMF
 * @author Simple Machines https://www.simplemachines.org
 * @copyright 2022 Simple Machines and individual contributors
 * @license https://www.simplemachines.org/about/smf/license.php BSD
 *
 * @version 2.1.3
 */

if (!defined('SMF'))
	die('No direct access...');

/**
 * Helper function for idn_to_* polyfills.
 *
 * Developers: Do not update the data in this function manually. Instead,
 * run "php -f other/update_unicode_data.php" on the command line.
 *
 * @return array Character maps for IDNA processing.
 */
function idna_maps()
{
	return array(
		"\x41" => "\x61",
		"\x42" => "\x62",
		"\x43" => "\x63",
		"\x44" => "\x64",
		"\x45" => "\x65",
		"\x46" => "\x66",
		"\x47" => "\x67",
		"\x48" => "\x68",
		"\x49" => "\x69",
		"\x4A" => "\x6A",
		"\x4B" => "\x6B",
		"\x4C" => "\x6C",
		"\x4D" => "\x6D",
		"\x4E" => "\x6E",
		"\x4F" => "\x6F",
		"\x50" => "\x70",
		"\x51" => "\x71",
		"\x52" => "\x72",
		"\x53" => "\x73",
		"\x54" => "\x74",
		"\x55" => "\x75",
		"\x56" => "\x76",
		"\x57" => "\x77",
		"\x58" => "\x78",
		"\x59" => "\x79",
		"\x5A" => "\x7A",
		"\xC2\xAA" => "\x61",
		"\xC2\xB2" => "\x32",
		"\xC2\xB3" => "\x33",
		"\xC2\xB5" => "\xCE\xBC",
		"\xC2\xB9" => "\x31",
		"\xC2\xBA" => "\x6F",
		"\xC2\xBC" => "\x31\xE2\x81\x84\x34",
		"\xC2\xBD" => "\x31\xE2\x81\x84\x32",
		"\xC2\xBE" => "\x33\xE2\x81\x84\x34",
		"\xC3\x80" => "\xC3\xA0",
		"\xC3\x81" => "\xC3\xA1",
		"\xC3\x82" => "\xC3\xA2",
		"\xC3\x83" => "\xC3\xA3",
		"\xC3\x84" => "\xC3\xA4",
		"\xC3\x85" => "\xC3\xA5",
		"\xC3\x86" => "\xC3\xA6",
		"\xC3\x87" => "\xC3\xA7",
		"\xC3\x88" => "\xC3\xA8",
		"\xC3\x89" => "\xC3\xA9",
		"\xC3\x8A" => "\xC3\xAA",
		"\xC3\x8B" => "\xC3\xAB",
		"\xC3\x8C" => "\xC3\xAC",
		"\xC3\x8D" => "\xC3\xAD",
		"\xC3\x8E" => "\xC3\xAE",
		"\xC3\x8F" => "\xC3\xAF",
		"\xC3\x90" => "\xC3\xB0",
		"\xC3\x91" => "\xC3\xB1",
		"\xC3\x92" => "\xC3\xB2",
		"\xC3\x93" => "\xC3\xB3",
		"\xC3\x94" => "\xC3\xB4",
		"\xC3\x95" => "\xC3\xB5",
		"\xC3\x96" => "\xC3\xB6",
		"\xC3\x98" => "\xC3\xB8",
		"\xC3\x99" => "\xC3\xB9",
		"\xC3\x9A" => "\xC3\xBA",
		"\xC3\x9B" => "\xC3\xBB",
		"\xC3\x9C" => "\xC3\xBC",
		"\xC3\x9D" => "\xC3\xBD",
		"\xC3\x9E" => "\xC3\xBE",
		"\xC4\x80" => "\xC4\x81",
		"\xC4\x82" => "\xC4\x83",
		"\xC4\x84" => "\xC4\x85",
		"\xC4\x86" => "\xC4\x87",
		"\xC4\x88" => "\xC4\x89",
		"\xC4\x8A" => "\xC4\x8B",
		"\xC4\x8C" => "\xC4\x8D",
		"\xC4\x8E" => "\xC4\x8F",
		"\xC4\x90" => "\xC4\x91",
		"\xC4\x92" => "\xC4\x93",
		"\xC4\x94" => "\xC4\x95",
		"\xC4\x96" => "\xC4\x97",
		"\xC4\x98" => "\xC4\x99",
		"\xC4\x9A" => "\xC4\x9B",
		"\xC4\x9C" => "\xC4\x9D",
		"\xC4\x9E" => "\xC4\x9F",
		"\xC4\xA0" => "\xC4\xA1",
		"\xC4\xA2" => "\xC4\xA3",
		"\xC4\xA4" => "\xC4\xA5",
		"\xC4\xA6" => "\xC4\xA7",
		"\xC4\xA8" => "\xC4\xA9",
		"\xC4\xAA" => "\xC4\xAB",
		"\xC4\xAC" => "\xC4\xAD",
		"\xC4\xAE" => "\xC4\xAF",
		"\xC4\xB0" => "\x69\xCC\x87",
		"\xC4\xB2" => "\x69\x6A",
		"\xC4\xB3" => "\x69\x6A",
		"\xC4\xB4" => "\xC4\xB5",
		"\xC4\xB6" => "\xC4\xB7",
		"\xC4\xB9" => "\xC4\xBA",
		"\xC4\xBB" => "\xC4\xBC",
		"\xC4\xBD" => "\xC4\xBE",
		"\xC4\xBF" => "\x6C\xC2\xB7",
		"\xC5\x80" => "\x6C\xC2\xB7",
		"\xC5\x81" => "\xC5\x82",
		"\xC5\x83" => "\xC5\x84",
		"\xC5\x85" => "\xC5\x86",
		"\xC5\x87" => "\xC5\x88",
		"\xC5\x89" => "\xCA\xBC\x6E",
		"\xC5\x8A" => "\xC5\x8B",
		"\xC5\x8C" => "\xC5\x8D",
		"\xC5\x8E" => "\xC5\x8F",
		"\xC5\x90" => "\xC5\x91",
		"\xC5\x92" => "\xC5\x93",
		"\xC5\x94" => "\xC5\x95",
		"\xC5\x96" => "\xC5\x97",
		"\xC5\x98" => "\xC5\x99",
		"\xC5\x9A" => "\xC5\x9B",
		"\xC5\x9C" => "\xC5\x9D",
		"\xC5\x9E" => "\xC5\x9F",
		"\xC5\xA0" => "\xC5\xA1",
		"\xC5\xA2" => "\xC5\xA3",
		"\xC5\xA4" => "\xC5\xA5",
		"\xC5\xA6" => "\xC5\xA7",
		"\xC5\xA8" => "\xC5\xA9",
		"\xC5\xAA" => "\xC5\xAB",
		"\xC5\xAC" => "\xC5\xAD",
		"\xC5\xAE" => "\xC5\xAF",
		"\xC5\xB0" => "\xC5\xB1",
		"\xC5\xB2" => "\xC5\xB3",
		"\xC5\xB4" => "\xC5\xB5",
		"\xC5\xB6" => "\xC5\xB7",
		"\xC5\xB8" => "\xC3\xBF",
		"\xC5\xB9" => "\xC5\xBA",
		"\xC5\xBB" => "\xC5\xBC",
		"\xC5\xBD" => "\xC5\xBE",
		"\xC5\xBF" => "\x73",
		"\xC6\x81" => "\xC9\x93",
		"\xC6\x82" => "\xC6\x83",
		"\xC6\x84" => "\xC6\x85",
		"\xC6\x86" => "\xC9\x94",
		"\xC6\x87" => "\xC6\x88",
		"\xC6\x89" => "\xC9\x96",
		"\xC6\x8A" => "\xC9\x97",
		"\xC6\x8B" => "\xC6\x8C",
		"\xC6\x8E" => "\xC7\x9D",
		"\xC6\x8F" => "\xC9\x99",
		"\xC6\x90" => "\xC9\x9B",
		"\xC6\x91" => "\xC6\x92",
		"\xC6\x93" => "\xC9\xA0",
		"\xC6\x94" => "\xC9\xA3",
		"\xC6\x96" => "\xC9\xA9",
		"\xC6\x97" => "\xC9\xA8",
		"\xC6\x98" => "\xC6\x99",
		"\xC6\x9C" => "\xC9\xAF",
		"\xC6\x9D" => "\xC9\xB2",
		"\xC6\x9F" => "\xC9\xB5",
		"\xC6\xA0" => "\xC6\xA1",
		"\xC6\xA2" => "\xC6\xA3",
		"\xC6\xA4" => "\xC6\xA5",
		"\xC6\xA6" => "\xCA\x80",
		"\xC6\xA7" => "\xC6\xA8",
		"\xC6\xA9" => "\xCA\x83",
		"\xC6\xAC" => "\xC6\xAD",
		"\xC6\xAE" => "\xCA\x88",
		"\xC6\xAF" => "\xC6\xB0",
		"\xC6\xB1" => "\xCA\x8A",
		"\xC6\xB2" => "\xCA\x8B",
		"\xC6\xB3" => "\xC6\xB4",
		"\xC6\xB5" => "\xC6\xB6",
		"\xC6\xB7" => "\xCA\x92",
		"\xC6\xB8" => "\xC6\xB9",
		"\xC6\xBC" => "\xC6\xBD",
		"\xC7\x84" => "\x64\xC5\xBE",
		"\xC7\x85" => "\x64\xC5\xBE",
		"\xC7\x86" => "\x64\xC5\xBE",
		"\xC7\x87" => "\x6C\x6A",
		"\xC7\x88" => "\x6C\x6A",
		"\xC7\x89" => "\x6C\x6A",
		"\xC7\x8A" => "\x6E\x6A",
		"\xC7\x8B" => "\x6E\x6A",
		"\xC7\x8C" => "\x6E\x6A",
		"\xC7\x8D" => "\xC7\x8E",
		"\xC7\x8F" => "\xC7\x90",
		"\xC7\x91" => "\xC7\x92",
		"\xC7\x93" => "\xC7\x94",
		"\xC7\x95" => "\xC7\x96",
		"\xC7\x97" => "\xC7\x98",
		"\xC7\x99" => "\xC7\x9A",
		"\xC7\x9B" => "\xC7\x9C",
		"\xC7\x9E" => "\xC7\x9F",
		"\xC7\xA0" => "\xC7\xA1",
		"\xC7\xA2" => "\xC7\xA3",
		"\xC7\xA4" => "\xC7\xA5",
		"\xC7\xA6" => "\xC7\xA7",
		"\xC7\xA8" => "\xC7\xA9",
		"\xC7\xAA" => "\xC7\xAB",
		"\xC7\xAC" => "\xC7\xAD",
		"\xC7\xAE" => "\xC7\xAF",
		"\xC7\xB1" => "\x64\x7A",
		"\xC7\xB2" => "\x64\x7A",
		"\xC7\xB3" => "\x64\x7A",
		"\xC7\xB4" => "\xC7\xB5",
		"\xC7\xB6" => "\xC6\x95",
		"\xC7\xB7" => "\xC6\xBF",
		"\xC7\xB8" => "\xC7\xB9",
		"\xC7\xBA" => "\xC7\xBB",
		"\xC7\xBC" => "\xC7\xBD",
		"\xC7\xBE" => "\xC7\xBF",
		"\xC8\x80" => "\xC8\x81",
		"\xC8\x82" => "\xC8\x83",
		"\xC8\x84" => "\xC8\x85",
		"\xC8\x86" => "\xC8\x87",
		"\xC8\x88" => "\xC8\x89",
		"\xC8\x8A" => "\xC8\x8B",
		"\xC8\x8C" => "\xC8\x8D",
		"\xC8\x8E" => "\xC8\x8F",
		"\xC8\x90" => "\xC8\x91",
		"\xC8\x92" => "\xC8\x93",
		"\xC8\x94" => "\xC8\x95",
		"\xC8\x96" => "\xC8\x97",
		"\xC8\x98" => "\xC8\x99",
		"\xC8\x9A" => "\xC8\x9B",
		"\xC8\x9C" => "\xC8\x9D",
		"\xC8\x9E" => "\xC8\x9F",
		"\xC8\xA0" => "\xC6\x9E",
		"\xC8\xA2" => "\xC8\xA3",
		"\xC8\xA4" => "\xC8\xA5",
		"\xC8\xA6" => "\xC8\xA7",
		"\xC8\xA8" => "\xC8\xA9",
		"\xC8\xAA" => "\xC8\xAB",
		"\xC8\xAC" => "\xC8\xAD",
		"\xC8\xAE" => "\xC8\xAF",
		"\xC8\xB0" => "\xC8\xB1",
		"\xC8\xB2" => "\xC8\xB3",
		"\xC8\xBA" => "\xE2\xB1\xA5",
		"\xC8\xBB" => "\xC8\xBC",
		"\xC8\xBD" => "\xC6\x9A",
		"\xC8\xBE" => "\xE2\xB1\xA6",
		"\xC9\x81" => "\xC9\x82",
		"\xC9\x83" => "\xC6\x80",
		"\xC9\x84" => "\xCA\x89",
		"\xC9\x85" => "\xCA\x8C",
		"\xC9\x86" => "\xC9\x87",
		"\xC9\x88" => "\xC9\x89",
		"\xC9\x8A" => "\xC9\x8B",
		"\xC9\x8C" => "\xC9\x8D",
		"\xC9\x8E" => "\xC9\x8F",
		"\xCA\xB0" => "\x68",
		"\xCA\xB1" => "\xC9\xA6",
		"\xCA\xB2" => "\x6A",
		"\xCA\xB3" => "\x72",
		"\xCA\xB4" => "\xC9\xB9",
		"\xCA\xB5" => "\xC9\xBB",
		"\xCA\xB6" => "\xCA\x81",
		"\xCA\xB7" => "\x77",
		"\xCA\xB8" => "\x79",
		"\xCB\xA0" => "\xC9\xA3",
		"\xCB\xA1" => "\x6C",
		"\xCB\xA2" => "\x73",
		"\xCB\xA3" => "\x78",
		"\xCB\xA4" => "\xCA\x95",
		"\xCD\x80" => "\xCC\x80",
		"\xCD\x81" => "\xCC\x81",
		"\xCD\x83" => "\xCC\x93",
		"\xCD\x84" => "\xCC\x88\xCC\x81",
		"\xCD\x85" => "\xCE\xB9",
		"\xCD\xB0" => "\xCD\xB1",
		"\xCD\xB2" => "\xCD\xB3",
		"\xCD\xB4" => "\xCA\xB9",
		"\xCD\xB6" => "\xCD\xB7",
		"\xCD\xBF" => "\xCF\xB3",
		"\xCE\x86" => "\xCE\xAC",
		"\xCE\x87" => "\xC2\xB7",
		"\xCE\x88" => "\xCE\xAD",
		"\xCE\x89" => "\xCE\xAE",
		"\xCE\x8A" => "\xCE\xAF",
		"\xCE\x8C" => "\xCF\x8C",
		"\xCE\x8E" => "\xCF\x8D",
		"\xCE\x8F" => "\xCF\x8E",
		"\xCE\x91" => "\xCE\xB1",
		"\xCE\x92" => "\xCE\xB2",
		"\xCE\x93" => "\xCE\xB3",
		"\xCE\x94" => "\xCE\xB4",
		"\xCE\x95" => "\xCE\xB5",
		"\xCE\x96" => "\xCE\xB6",
		"\xCE\x97" => "\xCE\xB7",
		"\xCE\x98" => "\xCE\xB8",
		"\xCE\x99" => "\xCE\xB9",
		"\xCE\x9A" => "\xCE\xBA",
		"\xCE\x9B" => "\xCE\xBB",
		"\xCE\x9C" => "\xCE\xBC",
		"\xCE\x9D" => "\xCE\xBD",
		"\xCE\x9E" => "\xCE\xBE",
		"\xCE\x9F" => "\xCE\xBF",
		"\xCE\xA0" => "\xCF\x80",
		"\xCE\xA1" => "\xCF\x81",
		"\xCE\xA3" => "\xCF\x83",
		"\xCE\xA4" => "\xCF\x84",
		"\xCE\xA5" => "\xCF\x85",
		"\xCE\xA6" => "\xCF\x86",
		"\xCE\xA7" => "\xCF\x87",
		"\xCE\xA8" => "\xCF\x88",
		"\xCE\xA9" => "\xCF\x89",
		"\xCE\xAA" => "\xCF\x8A",
		"\xCE\xAB" => "\xCF\x8B",
		"\xCF\x8F" => "\xCF\x97",
		"\xCF\x90" => "\xCE\xB2",
		"\xCF\x91" => "\xCE\xB8",
		"\xCF\x92" => "\xCF\x85",
		"\xCF\x93" => "\xCF\x8D",
		"\xCF\x94" => "\xCF\x8B",
		"\xCF\x95" => "\xCF\x86",
		"\xCF\x96" => "\xCF\x80",
		"\xCF\x98" => "\xCF\x99",
		"\xCF\x9A" => "\xCF\x9B",
		"\xCF\x9C" => "\xCF\x9D",
		"\xCF\x9E" => "\xCF\x9F",
		"\xCF\xA0" => "\xCF\xA1",
		"\xCF\xA2" => "\xCF\xA3",
		"\xCF\xA4" => "\xCF\xA5",
		"\xCF\xA6" => "\xCF\xA7",
		"\xCF\xA8" => "\xCF\xA9",
		"\xCF\xAA" => "\xCF\xAB",
		"\xCF\xAC" => "\xCF\xAD",
		"\xCF\xAE" => "\xCF\xAF",
		"\xCF\xB0" => "\xCE\xBA",
		"\xCF\xB1" => "\xCF\x81",
		"\xCF\xB2" => "\xCF\x83",
		"\xCF\xB4" => "\xCE\xB8",
		"\xCF\xB5" => "\xCE\xB5",
		"\xCF\xB7" => "\xCF\xB8",
		"\xCF\xB9" => "\xCF\x83",
		"\xCF\xBA" => "\xCF\xBB",
		"\xCF\xBD" => "\xCD\xBB",
		"\xCF\xBE" => "\xCD\xBC",
		"\xCF\xBF" => "\xCD\xBD",
		"\xD0\x80" => "\xD1\x90",
		"\xD0\x81" => "\xD1\x91",
		"\xD0\x82" => "\xD1\x92",
		"\xD0\x83" => "\xD1\x93",
		"\xD0\x84" => "\xD1\x94",
		"\xD0\x85" => "\xD1\x95",
		"\xD0\x86" => "\xD1\x96",
		"\xD0\x87" => "\xD1\x97",
		"\xD0\x88" => "\xD1\x98",
		"\xD0\x89" => "\xD1\x99",
		"\xD0\x8A" => "\xD1\x9A",
		"\xD0\x8B" => "\xD1\x9B",
		"\xD0\x8C" => "\xD1\x9C",
		"\xD0\x8D" => "\xD1\x9D",
		"\xD0\x8E" => "\xD1\x9E",
		"\xD0\x8F" => "\xD1\x9F",
		"\xD0\x90" => "\xD0\xB0",
		"\xD0\x91" => "\xD0\xB1",
		"\xD0\x92" => "\xD0\xB2",
		"\xD0\x93" => "\xD0\xB3",
		"\xD0\x94" => "\xD0\xB4",
		"\xD0\x95" => "\xD0\xB5",
		"\xD0\x96" => "\xD0\xB6",
		"\xD0\x97" => "\xD0\xB7",
		"\xD0\x98" => "\xD0\xB8",
		"\xD0\x99" => "\xD0\xB9",
		"\xD0\x9A" => "\xD0\xBA",
		"\xD0\x9B" => "\xD0\xBB",
		"\xD0\x9C" => "\xD0\xBC",
		"\xD0\x9D" => "\xD0\xBD",
		"\xD0\x9E" => "\xD0\xBE",
		"\xD0\x9F" => "\xD0\xBF",
		"\xD0\xA0" => "\xD1\x80",
		"\xD0\xA1" => "\xD1\x81",
		"\xD0\xA2" => "\xD1\x82",
		"\xD0\xA3" => "\xD1\x83",
		"\xD0\xA4" => "\xD1\x84",
		"\xD0\xA5" => "\xD1\x85",
		"\xD0\xA6" => "\xD1\x86",
		"\xD0\xA7" => "\xD1\x87",
		"\xD0\xA8" => "\xD1\x88",
		"\xD0\xA9" => "\xD1\x89",
		"\xD0\xAA" => "\xD1\x8A",
		"\xD0\xAB" => "\xD1\x8B",
		"\xD0\xAC" => "\xD1\x8C",
		"\xD0\xAD" => "\xD1\x8D",
		"\xD0\xAE" => "\xD1\x8E",
		"\xD0\xAF" => "\xD1\x8F",
		"\xD1\xA0" => "\xD1\xA1",
		"\xD1\xA2" => "\xD1\xA3",
		"\xD1\xA4" => "\xD1\xA5",
		"\xD1\xA6" => "\xD1\xA7",
		"\xD1\xA8" => "\xD1\xA9",
		"\xD1\xAA" => "\xD1\xAB",
		"\xD1\xAC" => "\xD1\xAD",
		"\xD1\xAE" => "\xD1\xAF",
		"\xD1\xB0" => "\xD1\xB1",
		"\xD1\xB2" => "\xD1\xB3",
		"\xD1\xB4" => "\xD1\xB5",
		"\xD1\xB6" => "\xD1\xB7",
		"\xD1\xB8" => "\xD1\xB9",
		"\xD1\xBA" => "\xD1\xBB",
		"\xD1\xBC" => "\xD1\xBD",
		"\xD1\xBE" => "\xD1\xBF",
		"\xD2\x80" => "\xD2\x81",
		"\xD2\x8A" => "\xD2\x8B",
		"\xD2\x8C" => "\xD2\x8D",
		"\xD2\x8E" => "\xD2\x8F",
		"\xD2\x90" => "\xD2\x91",
		"\xD2\x92" => "\xD2\x93",
		"\xD2\x94" => "\xD2\x95",
		"\xD2\x96" => "\xD2\x97",
		"\xD2\x98" => "\xD2\x99",
		"\xD2\x9A" => "\xD2\x9B",
		"\xD2\x9C" => "\xD2\x9D",
		"\xD2\x9E" => "\xD2\x9F",
		"\xD2\xA0" => "\xD2\xA1",
		"\xD2\xA2" => "\xD2\xA3",
		"\xD2\xA4" => "\xD2\xA5",
		"\xD2\xA6" => "\xD2\xA7",
		"\xD2\xA8" => "\xD2\xA9",
		"\xD2\xAA" => "\xD2\xAB",
		"\xD2\xAC" => "\xD2\xAD",
		"\xD2\xAE" => "\xD2\xAF",
		"\xD2\xB0" => "\xD2\xB1",
		"\xD2\xB2" => "\xD2\xB3",
		"\xD2\xB4" => "\xD2\xB5",
		"\xD2\xB6" => "\xD2\xB7",
		"\xD2\xB8" => "\xD2\xB9",
		"\xD2\xBA" => "\xD2\xBB",
		"\xD2\xBC" => "\xD2\xBD",
		"\xD2\xBE" => "\xD2\xBF",
		"\xD3\x81" => "\xD3\x82",
		"\xD3\x83" => "\xD3\x84",
		"\xD3\x85" => "\xD3\x86",
		"\xD3\x87" => "\xD3\x88",
		"\xD3\x89" => "\xD3\x8A",
		"\xD3\x8B" => "\xD3\x8C",
		"\xD3\x8D" => "\xD3\x8E",
		"\xD3\x90" => "\xD3\x91",
		"\xD3\x92" => "\xD3\x93",
		"\xD3\x94" => "\xD3\x95",
		"\xD3\x96" => "\xD3\x97",
		"\xD3\x98" => "\xD3\x99",
		"\xD3\x9A" => "\xD3\x9B",
		"\xD3\x9C" => "\xD3\x9D",
		"\xD3\x9E" => "\xD3\x9F",
		"\xD3\xA0" => "\xD3\xA1",
		"\xD3\xA2" => "\xD3\xA3",
		"\xD3\xA4" => "\xD3\xA5",
		"\xD3\xA6" => "\xD3\xA7",
		"\xD3\xA8" => "\xD3\xA9",
		"\xD3\xAA" => "\xD3\xAB",
		"\xD3\xAC" => "\xD3\xAD",
		"\xD3\xAE" => "\xD3\xAF",
		"\xD3\xB0" => "\xD3\xB1",
		"\xD3\xB2" => "\xD3\xB3",
		"\xD3\xB4" => "\xD3\xB5",
		"\xD3\xB6" => "\xD3\xB7",
		"\xD3\xB8" => "\xD3\xB9",
		"\xD3\xBA" => "\xD3\xBB",
		"\xD3\xBC" => "\xD3\xBD",
		"\xD3\xBE" => "\xD3\xBF",
		"\xD4\x80" => "\xD4\x81",
		"\xD4\x82" => "\xD4\x83",
		"\xD4\x84" => "\xD4\x85",
		"\xD4\x86" => "\xD4\x87",
		"\xD4\x88" => "\xD4\x89",
		"\xD4\x8A" => "\xD4\x8B",
		"\xD4\x8C" => "\xD4\x8D",
		"\xD4\x8E" => "\xD4\x8F",
		"\xD4\x90" => "\xD4\x91",
		"\xD4\x92" => "\xD4\x93",
		"\xD4\x94" => "\xD4\x95",
		"\xD4\x96" => "\xD4\x97",
		"\xD4\x98" => "\xD4\x99",
		"\xD4\x9A" => "\xD4\x9B",
		"\xD4\x9C" => "\xD4\x9D",
		"\xD4\x9E" => "\xD4\x9F",
		"\xD4\xA0" => "\xD4\xA1",
		"\xD4\xA2" => "\xD4\xA3",
		"\xD4\xA4" => "\xD4\xA5",
		"\xD4\xA6" => "\xD4\xA7",
		"\xD4\xA8" => "\xD4\xA9",
		"\xD4\xAA" => "\xD4\xAB",
		"\xD4\xAC" => "\xD4\xAD",
		"\xD4\xAE" => "\xD4\xAF",
		"\xD4\xB1" => "\xD5\xA1",
		"\xD4\xB2" => "\xD5\xA2",
		"\xD4\xB3" => "\xD5\xA3",
		"\xD4\xB4" => "\xD5\xA4",
		"\xD4\xB5" => "\xD5\xA5",
		"\xD4\xB6" => "\xD5\xA6",
		"\xD4\xB7" => "\xD5\xA7",
		"\xD4\xB8" => "\xD5\xA8",
		"\xD4\xB9" => "\xD5\xA9",
		"\xD4\xBA" => "\xD5\xAA",
		"\xD4\xBB" => "\xD5\xAB",
		"\xD4\xBC" => "\xD5\xAC",
		"\xD4\xBD" => "\xD5\xAD",
		"\xD4\xBE" => "\xD5\xAE",
		"\xD4\xBF" => "\xD5\xAF",
		"\xD5\x80" => "\xD5\xB0",
		"\xD5\x81" => "\xD5\xB1",
		"\xD5\x82" => "\xD5\xB2",
		"\xD5\x83" => "\xD5\xB3",
		"\xD5\x84" => "\xD5\xB4",
		"\xD5\x85" => "\xD5\xB5",
		"\xD5\x86" => "\xD5\xB6",
		"\xD5\x87" => "\xD5\xB7",
		"\xD5\x88" => "\xD5\xB8",
		"\xD5\x89" => "\xD5\xB9",
		"\xD5\x8A" => "\xD5\xBA",
		"\xD5\x8B" => "\xD5\xBB",
		"\xD5\x8C" => "\xD5\xBC",
		"\xD5\x8D" => "\xD5\xBD",
		"\xD5\x8E" => "\xD5\xBE",
		"\xD5\x8F" => "\xD5\xBF",
		"\xD5\x90" => "\xD6\x80",
		"\xD5\x91" => "\xD6\x81",
		"\xD5\x92" => "\xD6\x82",
		"\xD5\x93" => "\xD6\x83",
		"\xD5\x94" => "\xD6\x84",
		"\xD5\x95" => "\xD6\x85",
		"\xD5\x96" => "\xD6\x86",
		"\xD6\x87" => "\xD5\xA5\xD6\x82",
		"\xD9\xB5" => "\xD8\xA7\xD9\xB4",
		"\xD9\xB6" => "\xD9\x88\xD9\xB4",
		"\xD9\xB7" => "\xDB\x87\xD9\xB4",
		"\xD9\xB8" => "\xD9\x8A\xD9\xB4",
		"\xE0\xA5\x98" => "\xE0\xA4\x95\xE0\xA4\xBC",
		"\xE0\xA5\x99" => "\xE0\xA4\x96\xE0\xA4\xBC",
		"\xE0\xA5\x9A" => "\xE0\xA4\x97\xE0\xA4\xBC",
		"\xE0\xA5\x9B" => "\xE0\xA4\x9C\xE0\xA4\xBC",
		"\xE0\xA5\x9C" => "\xE0\xA4\xA1\xE0\xA4\xBC",
		"\xE0\xA5\x9D" => "\xE0\xA4\xA2\xE0\xA4\xBC",
		"\xE0\xA5\x9E" => "\xE0\xA4\xAB\xE0\xA4\xBC",
		"\xE0\xA5\x9F" => "\xE0\xA4\xAF\xE0\xA4\xBC",
		"\xE0\xA7\x9C" => "\xE0\xA6\xA1\xE0\xA6\xBC",
		"\xE0\xA7\x9D" => "\xE0\xA6\xA2\xE0\xA6\xBC",
		"\xE0\xA7\x9F" => "\xE0\xA6\xAF\xE0\xA6\xBC",
		"\xE0\xA8\xB3" => "\xE0\xA8\xB2\xE0\xA8\xBC",
		"\xE0\xA8\xB6" => "\xE0\xA8\xB8\xE0\xA8\xBC",
		"\xE0\xA9\x99" => "\xE0\xA8\x96\xE0\xA8\xBC",
		"\xE0\xA9\x9A" => "\xE0\xA8\x97\xE0\xA8\xBC",
		"\xE0\xA9\x9B" => "\xE0\xA8\x9C\xE0\xA8\xBC",
		"\xE0\xA9\x9E" => "\xE0\xA8\xAB\xE0\xA8\xBC",
		"\xE0\xAD\x9C" => "\xE0\xAC\xA1\xE0\xAC\xBC",
		"\xE0\xAD\x9D" => "\xE0\xAC\xA2\xE0\xAC\xBC",
		"\xE0\xB8\xB3" => "\xE0\xB9\x8D\xE0\xB8\xB2",
		"\xE0\xBA\xB3" => "\xE0\xBB\x8D\xE0\xBA\xB2",
		"\xE0\xBB\x9C" => "\xE0\xBA\xAB\xE0\xBA\x99",
		"\xE0\xBB\x9D" => "\xE0\xBA\xAB\xE0\xBA\xA1",
		"\xE0\xBC\x8C" => "\xE0\xBC\x8B",
		"\xE0\xBD\x83" => "\xE0\xBD\x82\xE0\xBE\xB7",
		"\xE0\xBD\x8D" => "\xE0\xBD\x8C\xE0\xBE\xB7",
		"\xE0\xBD\x92" => "\xE0\xBD\x91\xE0\xBE\xB7",
		"\xE0\xBD\x97" => "\xE0\xBD\x96\xE0\xBE\xB7",
		"\xE0\xBD\x9C" => "\xE0\xBD\x9B\xE0\xBE\xB7",
		"\xE0\xBD\xA9" => "\xE0\xBD\x80\xE0\xBE\xB5",
		"\xE0\xBD\xB3" => "\xE0\xBD\xB1\xE0\xBD\xB2",
		"\xE0\xBD\xB5" => "\xE0\xBD\xB1\xE0\xBD\xB4",
		"\xE0\xBD\xB6" => "\xE0\xBE\xB2\xE0\xBE\x80",
		"\xE0\xBD\xB7" => "\xE0\xBE\xB2\xE0\xBD\xB1\xE0\xBE\x80",
		"\xE0\xBD\xB8" => "\xE0\xBE\xB3\xE0\xBE\x80",
		"\xE0\xBD\xB9" => "\xE0\xBE\xB3\xE0\xBD\xB1\xE0\xBE\x80",
		"\xE0\xBE\x81" => "\xE0\xBD\xB1\xE0\xBE\x80",
		"\xE0\xBE\x93" => "\xE0\xBE\x92\xE0\xBE\xB7",
		"\xE0\xBE\x9D" => "\xE0\xBE\x9C\xE0\xBE\xB7",
		"\xE0\xBE\xA2" => "\xE0\xBE\xA1\xE0\xBE\xB7",
		"\xE0\xBE\xA7" => "\xE0\xBE\xA6\xE0\xBE\xB7",
		"\xE0\xBE\xAC" => "\xE0\xBE\xAB\xE0\xBE\xB7",
		"\xE0\xBE\xB9" => "\xE0\xBE\x90\xE0\xBE\xB5",
		"\xE1\x83\x87" => "\xE2\xB4\xA7",
		"\xE1\x83\x8D" => "\xE2\xB4\xAD",
		"\xE1\x83\xBC" => "\xE1\x83\x9C",
		"\xE1\x8F\xB8" => "\xE1\x8F\xB0",
		"\xE1\x8F\xB9" => "\xE1\x8F\xB1",
		"\xE1\x8F\xBA" => "\xE1\x8F\xB2",
		"\xE1\x8F\xBB" => "\xE1\x8F\xB3",
		"\xE1\x8F\xBC" => "\xE1\x8F\xB4",
		"\xE1\x8F\xBD" => "\xE1\x8F\xB5",
		"\xE1\xB2\x80" => "\xD0\xB2",
		"\xE1\xB2\x81" => "\xD0\xB4",
		"\xE1\xB2\x82" => "\xD0\xBE",
		"\xE1\xB2\x83" => "\xD1\x81",
		"\xE1\xB2\x84" => "\xD1\x82",
		"\xE1\xB2\x85" => "\xD1\x82",
		"\xE1\xB2\x86" => "\xD1\x8A",
		"\xE1\xB2\x87" => "\xD1\xA3",
		"\xE1\xB2\x88" => "\xEA\x99\x8B",
		"\xE1\xB2\x90" => "\xE1\x83\x90",
		"\xE1\xB2\x91" => "\xE1\x83\x91",
		"\xE1\xB2\x92" => "\xE1\x83\x92",
		"\xE1\xB2\x93" => "\xE1\x83\x93",
		"\xE1\xB2\x94" => "\xE1\x83\x94",
		"\xE1\xB2\x95" => "\xE1\x83\x95",
		"\xE1\xB2\x96" => "\xE1\x83\x96",
		"\xE1\xB2\x97" => "\xE1\x83\x97",
		"\xE1\xB2\x98" => "\xE1\x83\x98",
		"\xE1\xB2\x99" => "\xE1\x83\x99",
		"\xE1\xB2\x9A" => "\xE1\x83\x9A",
		"\xE1\xB2\x9B" => "\xE1\x83\x9B",
		"\xE1\xB2\x9C" => "\xE1\x83\x9C",
		"\xE1\xB2\x9D" => "\xE1\x83\x9D",
		"\xE1\xB2\x9E" => "\xE1\x83\x9E",
		"\xE1\xB2\x9F" => "\xE1\x83\x9F",
		"\xE1\xB2\xA0" => "\xE1\x83\xA0",
		"\xE1\xB2\xA1" => "\xE1\x83\xA1",
		"\xE1\xB2\xA2" => "\xE1\x83\xA2",
		"\xE1\xB2\xA3" => "\xE1\x83\xA3",
		"\xE1\xB2\xA4" => "\xE1\x83\xA4",
		"\xE1\xB2\xA5" => "\xE1\x83\xA5",
		"\xE1\xB2\xA6" => "\xE1\x83\xA6",
		"\xE1\xB2\xA7" => "\xE1\x83\xA7",
		"\xE1\xB2\xA8" => "\xE1\x83\xA8",
		"\xE1\xB2\xA9" => "\xE1\x83\xA9",
		"\xE1\xB2\xAA" => "\xE1\x83\xAA",
		"\xE1\xB2\xAB" => "\xE1\x83\xAB",
		"\xE1\xB2\xAC" => "\xE1\x83\xAC",
		"\xE1\xB2\xAD" => "\xE1\x83\xAD",
		"\xE1\xB2\xAE" => "\xE1\x83\xAE",
		"\xE1\xB2\xAF" => "\xE1\x83\xAF",
		"\xE1\xB2\xB0" => "\xE1\x83\xB0",
		"\xE1\xB2\xB1" => "\xE1\x83\xB1",
		"\xE1\xB2\xB2" => "\xE1\x83\xB2",
		"\xE1\xB2\xB3" => "\xE1\x83\xB3",
		"\xE1\xB2\xB4" => "\xE1\x83\xB4",
		"\xE1\xB2\xB5" => "\xE1\x83\xB5",
		"\xE1\xB2\xB6" => "\xE1\x83\xB6",
		"\xE1\xB2\xB7" => "\xE1\x83\xB7",
		"\xE1\xB2\xB8" => "\xE1\x83\xB8",
		"\xE1\xB2\xB9" => "\xE1\x83\xB9",
		"\xE1\xB2\xBA" => "\xE1\x83\xBA",
		"\xE1\xB2\xBD" => "\xE1\x83\xBD",
		"\xE1\xB2\xBE" => "\xE1\x83\xBE",
		"\xE1\xB2\xBF" => "\xE1\x83\xBF",
		"\xE1\xB4\xAC" => "\x61",
		"\xE1\xB4\xAD" => "\xC3\xA6",
		"\xE1\xB4\xAE" => "\x62",
		"\xE1\xB4\xB0" => "\x64",
		"\xE1\xB4\xB1" => "\x65",
		"\xE1\xB4\xB2" => "\xC7\x9D",
		"\xE1\xB4\xB3" => "\x67",
		"\xE1\xB4\xB4" => "\x68",
		"\xE1\xB4\xB5" => "\x69",
		"\xE1\xB4\xB6" => "\x6A",
		"\xE1\xB4\xB7" => "\x6B",
		"\xE1\xB4\xB8" => "\x6C",
		"\xE1\xB4\xB9" => "\x6D",
		"\xE1\xB4\xBA" => "\x6E",
		"\xE1\xB4\xBC" => "\x6F",
		"\xE1\xB4\xBD" => "\xC8\xA3",
		"\xE1\xB4\xBE" => "\x70",
		"\xE1\xB4\xBF" => "\x72",
		"\xE1\xB5\x80" => "\x74",
		"\xE1\xB5\x81" => "\x75",
		"\xE1\xB5\x82" => "\x77",
		"\xE1\xB5\x83" => "\x61",
		"\xE1\xB5\x84" => "\xC9\x90",
		"\xE1\xB5\x85" => "\xC9\x91",
		"\xE1\xB5\x86" => "\xE1\xB4\x82",
		"\xE1\xB5\x87" => "\x62",
		"\xE1\xB5\x88" => "\x64",
		"\xE1\xB5\x89" => "\x65",
		"\xE1\xB5\x8A" => "\xC9\x99",
		"\xE1\xB5\x8B" => "\xC9\x9B",
		"\xE1\xB5\x8C" => "\xC9\x9C",
		"\xE1\xB5\x8D" => "\x67",
		"\xE1\xB5\x8F" => "\x6B",
		"\xE1\xB5\x90" => "\x6D",
		"\xE1\xB5\x91" => "\xC5\x8B",
		"\xE1\xB5\x92" => "\x6F",
		"\xE1\xB5\x93" => "\xC9\x94",
		"\xE1\xB5\x94" => "\xE1\xB4\x96",
		"\xE1\xB5\x95" => "\xE1\xB4\x97",
		"\xE1\xB5\x96" => "\x70",
		"\xE1\xB5\x97" => "\x74",
		"\xE1\xB5\x98" => "\x75",
		"\xE1\xB5\x99" => "\xE1\xB4\x9D",
		"\xE1\xB5\x9A" => "\xC9\xAF",
		"\xE1\xB5\x9B" => "\x76",
		"\xE1\xB5\x9C" => "\xE1\xB4\xA5",
		"\xE1\xB5\x9D" => "\xCE\xB2",
		"\xE1\xB5\x9E" => "\xCE\xB3",
		"\xE1\xB5\x9F" => "\xCE\xB4",
		"\xE1\xB5\xA0" => "\xCF\x86",
		"\xE1\xB5\xA1" => "\xCF\x87",
		"\xE1\xB5\xA2" => "\x69",
		"\xE1\xB5\xA3" => "\x72",
		"\xE1\xB5\xA4" => "\x75",
		"\xE1\xB5\xA5" => "\x76",
		"\xE1\xB5\xA6" => "\xCE\xB2",
		"\xE1\xB5\xA7" => "\xCE\xB3",
		"\xE1\xB5\xA8" => "\xCF\x81",
		"\xE1\xB5\xA9" => "\xCF\x86",
		"\xE1\xB5\xAA" => "\xCF\x87",
		"\xE1\xB5\xB8" => "\xD0\xBD",
		"\xE1\xB6\x9B" => "\xC9\x92",
		"\xE1\xB6\x9C" => "\x63",
		"\xE1\xB6\x9D" => "\xC9\x95",
		"\xE1\xB6\x9E" => "\xC3\xB0",
		"\xE1\xB6\x9F" => "\xC9\x9C",
		"\xE1\xB6\xA0" => "\x66",
		"\xE1\xB6\xA1" => "\xC9\x9F",
		"\xE1\xB6\xA2" => "\xC9\xA1",
		"\xE1\xB6\xA3" => "\xC9\xA5",
		"\xE1\xB6\xA4" => "\xC9\xA8",
		"\xE1\xB6\xA5" => "\xC9\xA9",
		"\xE1\xB6\xA6" => "\xC9\xAA",
		"\xE1\xB6\xA7" => "\xE1\xB5\xBB",
		"\xE1\xB6\xA8" => "\xCA\x9D",
		"\xE1\xB6\xA9" => "\xC9\xAD",
		"\xE1\xB6\xAA" => "\xE1\xB6\x85",
		"\xE1\xB6\xAB" => "\xCA\x9F",
		"\xE1\xB6\xAC" => "\xC9\xB1",
		"\xE1\xB6\xAD" => "\xC9\xB0",
		"\xE1\xB6\xAE" => "\xC9\xB2",
		"\xE1\xB6\xAF" => "\xC9\xB3",
		"\xE1\xB6\xB0" => "\xC9\xB4",
		"\xE1\xB6\xB1" => "\xC9\xB5",
		"\xE1\xB6\xB2" => "\xC9\xB8",
		"\xE1\xB6\xB3" => "\xCA\x82",
		"\xE1\xB6\xB4" => "\xCA\x83",
		"\xE1\xB6\xB5" => "\xC6\xAB",
		"\xE1\xB6\xB6" => "\xCA\x89",
		"\xE1\xB6\xB7" => "\xCA\x8A",
		"\xE1\xB6\xB8" => "\xE1\xB4\x9C",
		"\xE1\xB6\xB9" => "\xCA\x8B",
		"\xE1\xB6\xBA" => "\xCA\x8C",
		"\xE1\xB6\xBB" => "\x7A",
		"\xE1\xB6\xBC" => "\xCA\x90",
		"\xE1\xB6\xBD" => "\xCA\x91",
		"\xE1\xB6\xBE" => "\xCA\x92",
		"\xE1\xB6\xBF" => "\xCE\xB8",
		"\xE1\xB8\x80" => "\xE1\xB8\x81",
		"\xE1\xB8\x82" => "\xE1\xB8\x83",
		"\xE1\xB8\x84" => "\xE1\xB8\x85",
		"\xE1\xB8\x86" => "\xE1\xB8\x87",
		"\xE1\xB8\x88" => "\xE1\xB8\x89",
		"\xE1\xB8\x8A" => "\xE1\xB8\x8B",
		"\xE1\xB8\x8C" => "\xE1\xB8\x8D",
		"\xE1\xB8\x8E" => "\xE1\xB8\x8F",
		"\xE1\xB8\x90" => "\xE1\xB8\x91",
		"\xE1\xB8\x92" => "\xE1\xB8\x93",
		"\xE1\xB8\x94" => "\xE1\xB8\x95",
		"\xE1\xB8\x96" => "\xE1\xB8\x97",
		"\xE1\xB8\x98" => "\xE1\xB8\x99",
		"\xE1\xB8\x9A" => "\xE1\xB8\x9B",
		"\xE1\xB8\x9C" => "\xE1\xB8\x9D",
		"\xE1\xB8\x9E" => "\xE1\xB8\x9F",
		"\xE1\xB8\xA0" => "\xE1\xB8\xA1",
		"\xE1\xB8\xA2" => "\xE1\xB8\xA3",
		"\xE1\xB8\xA4" => "\xE1\xB8\xA5",
		"\xE1\xB8\xA6" => "\xE1\xB8\xA7",
		"\xE1\xB8\xA8" => "\xE1\xB8\xA9",
		"\xE1\xB8\xAA" => "\xE1\xB8\xAB",
		"\xE1\xB8\xAC" => "\xE1\xB8\xAD",
		"\xE1\xB8\xAE" => "\xE1\xB8\xAF",
		"\xE1\xB8\xB0" => "\xE1\xB8\xB1",
		"\xE1\xB8\xB2" => "\xE1\xB8\xB3",
		"\xE1\xB8\xB4" => "\xE1\xB8\xB5",
		"\xE1\xB8\xB6" => "\xE1\xB8\xB7",
		"\xE1\xB8\xB8" => "\xE1\xB8\xB9",
		"\xE1\xB8\xBA" => "\xE1\xB8\xBB",
		"\xE1\xB8\xBC" => "\xE1\xB8\xBD",
		"\xE1\xB8\xBE" => "\xE1\xB8\xBF",
		"\xE1\xB9\x80" => "\xE1\xB9\x81",
		"\xE1\xB9\x82" => "\xE1\xB9\x83",
		"\xE1\xB9\x84" => "\xE1\xB9\x85",
		"\xE1\xB9\x86" => "\xE1\xB9\x87",
		"\xE1\xB9\x88" => "\xE1\xB9\x89",
		"\xE1\xB9\x8A" => "\xE1\xB9\x8B",
		"\xE1\xB9\x8C" => "\xE1\xB9\x8D",
		"\xE1\xB9\x8E" => "\xE1\xB9\x8F",
		"\xE1\xB9\x90" => "\xE1\xB9\x91",
		"\xE1\xB9\x92" => "\xE1\xB9\x93",
		"\xE1\xB9\x94" => "\xE1\xB9\x95",
		"\xE1\xB9\x96" => "\xE1\xB9\x97",
		"\xE1\xB9\x98" => "\xE1\xB9\x99",
		"\xE1\xB9\x9A" => "\xE1\xB9\x9B",
		"\xE1\xB9\x9C" => "\xE1\xB9\x9D",
		"\xE1\xB9\x9E" => "\xE1\xB9\x9F",
		"\xE1\xB9\xA0" => "\xE1\xB9\xA1",
		"\xE1\xB9\xA2" => "\xE1\xB9\xA3",
		"\xE1\xB9\xA4" => "\xE1\xB9\xA5",
		"\xE1\xB9\xA6" => "\xE1\xB9\xA7",
		"\xE1\xB9\xA8" => "\xE1\xB9\xA9",
		"\xE1\xB9\xAA" => "\xE1\xB9\xAB",
		"\xE1\xB9\xAC" => "\xE1\xB9\xAD",
		"\xE1\xB9\xAE" => "\xE1\xB9\xAF",
		"\xE1\xB9\xB0" => "\xE1\xB9\xB1",
		"\xE1\xB9\xB2" => "\xE1\xB9\xB3",
		"\xE1\xB9\xB4" => "\xE1\xB9\xB5",
		"\xE1\xB9\xB6" => "\xE1\xB9\xB7",
		"\xE1\xB9\xB8" => "\xE1\xB9\xB9",
		"\xE1\xB9\xBA" => "\xE1\xB9\xBB",
		"\xE1\xB9\xBC" => "\xE1\xB9\xBD",
		"\xE1\xB9\xBE" => "\xE1\xB9\xBF",
		"\xE1\xBA\x80" => "\xE1\xBA\x81",
		"\xE1\xBA\x82" => "\xE1\xBA\x83",
		"\xE1\xBA\x84" => "\xE1\xBA\x85",
		"\xE1\xBA\x86" => "\xE1\xBA\x87",
		"\xE1\xBA\x88" => "\xE1\xBA\x89",
		"\xE1\xBA\x8A" => "\xE1\xBA\x8B",
		"\xE1\xBA\x8C" => "\xE1\xBA\x8D",
		"\xE1\xBA\x8E" => "\xE1\xBA\x8F",
		"\xE1\xBA\x90" => "\xE1\xBA\x91",
		"\xE1\xBA\x92" => "\xE1\xBA\x93",
		"\xE1\xBA\x94" => "\xE1\xBA\x95",
		"\xE1\xBA\x9A" => "\x61\xCA\xBE",
		"\xE1\xBA\x9B" => "\xE1\xB9\xA1",
		"\xE1\xBA\x9E" => "\x73\x73",
		"\xE1\xBA\xA0" => "\xE1\xBA\xA1",
		"\xE1\xBA\xA2" => "\xE1\xBA\xA3",
		"\xE1\xBA\xA4" => "\xE1\xBA\xA5",
		"\xE1\xBA\xA6" => "\xE1\xBA\xA7",
		"\xE1\xBA\xA8" => "\xE1\xBA\xA9",
		"\xE1\xBA\xAA" => "\xE1\xBA\xAB",
		"\xE1\xBA\xAC" => "\xE1\xBA\xAD",
		"\xE1\xBA\xAE" => "\xE1\xBA\xAF",
		"\xE1\xBA\xB0" => "\xE1\xBA\xB1",
		"\xE1\xBA\xB2" => "\xE1\xBA\xB3",
		"\xE1\xBA\xB4" => "\xE1\xBA\xB5",
		"\xE1\xBA\xB6" => "\xE1\xBA\xB7",
		"\xE1\xBA\xB8" => "\xE1\xBA\xB9",
		"\xE1\xBA\xBA" => "\xE1\xBA\xBB",
		"\xE1\xBA\xBC" => "\xE1\xBA\xBD",
		"\xE1\xBA\xBE" => "\xE1\xBA\xBF",
		"\xE1\xBB\x80" => "\xE1\xBB\x81",
		"\xE1\xBB\x82" => "\xE1\xBB\x83",
		"\xE1\xBB\x84" => "\xE1\xBB\x85",
		"\xE1\xBB\x86" => "\xE1\xBB\x87",
		"\xE1\xBB\x88" => "\xE1\xBB\x89",
		"\xE1\xBB\x8A" => "\xE1\xBB\x8B",
		"\xE1\xBB\x8C" => "\xE1\xBB\x8D",
		"\xE1\xBB\x8E" => "\xE1\xBB\x8F",
		"\xE1\xBB\x90" => "\xE1\xBB\x91",
		"\xE1\xBB\x92" => "\xE1\xBB\x93",
		"\xE1\xBB\x94" => "\xE1\xBB\x95",
		"\xE1\xBB\x96" => "\xE1\xBB\x97",
		"\xE1\xBB\x98" => "\xE1\xBB\x99",
		"\xE1\xBB\x9A" => "\xE1\xBB\x9B",
		"\xE1\xBB\x9C" => "\xE1\xBB\x9D",
		"\xE1\xBB\x9E" => "\xE1\xBB\x9F",
		"\xE1\xBB\xA0" => "\xE1\xBB\xA1",
		"\xE1\xBB\xA2" => "\xE1\xBB\xA3",
		"\xE1\xBB\xA4" => "\xE1\xBB\xA5",
		"\xE1\xBB\xA6" => "\xE1\xBB\xA7",
		"\xE1\xBB\xA8" => "\xE1\xBB\xA9",
		"\xE1\xBB\xAA" => "\xE1\xBB\xAB",
		"\xE1\xBB\xAC" => "\xE1\xBB\xAD",
		"\xE1\xBB\xAE" => "\xE1\xBB\xAF",
		"\xE1\xBB\xB0" => "\xE1\xBB\xB1",
		"\xE1\xBB\xB2" => "\xE1\xBB\xB3",
		"\xE1\xBB\xB4" => "\xE1\xBB\xB5",
		"\xE1\xBB\xB6" => "\xE1\xBB\xB7",
		"\xE1\xBB\xB8" => "\xE1\xBB\xB9",
		"\xE1\xBB\xBA" => "\xE1\xBB\xBB",
		"\xE1\xBB\xBC" => "\xE1\xBB\xBD",
		"\xE1\xBB\xBE" => "\xE1\xBB\xBF",
		"\xE1\xBC\x88" => "\xE1\xBC\x80",
		"\xE1\xBC\x89" => "\xE1\xBC\x81",
		"\xE1\xBC\x8A" => "\xE1\xBC\x82",
		"\xE1\xBC\x8B" => "\xE1\xBC\x83",
		"\xE1\xBC\x8C" => "\xE1\xBC\x84",
		"\xE1\xBC\x8D" => "\xE1\xBC\x85",
		"\xE1\xBC\x8E" => "\xE1\xBC\x86",
		"\xE1\xBC\x8F" => "\xE1\xBC\x87",
		"\xE1\xBC\x98" => "\xE1\xBC\x90",
		"\xE1\xBC\x99" => "\xE1\xBC\x91",
		"\xE1\xBC\x9A" => "\xE1\xBC\x92",
		"\xE1\xBC\x9B" => "\xE1\xBC\x93",
		"\xE1\xBC\x9C" => "\xE1\xBC\x94",
		"\xE1\xBC\x9D" => "\xE1\xBC\x95",
		"\xE1\xBC\xA8" => "\xE1\xBC\xA0",
		"\xE1\xBC\xA9" => "\xE1\xBC\xA1",
		"\xE1\xBC\xAA" => "\xE1\xBC\xA2",
		"\xE1\xBC\xAB" => "\xE1\xBC\xA3",
		"\xE1\xBC\xAC" => "\xE1\xBC\xA4",
		"\xE1\xBC\xAD" => "\xE1\xBC\xA5",
		"\xE1\xBC\xAE" => "\xE1\xBC\xA6",
		"\xE1\xBC\xAF" => "\xE1\xBC\xA7",
		"\xE1\xBC\xB8" => "\xE1\xBC\xB0",
		"\xE1\xBC\xB9" => "\xE1\xBC\xB1",
		"\xE1\xBC\xBA" => "\xE1\xBC\xB2",
		"\xE1\xBC\xBB" => "\xE1\xBC\xB3",
		"\xE1\xBC\xBC" => "\xE1\xBC\xB4",
		"\xE1\xBC\xBD" => "\xE1\xBC\xB5",
		"\xE1\xBC\xBE" => "\xE1\xBC\xB6",
		"\xE1\xBC\xBF" => "\xE1\xBC\xB7",
		"\xE1\xBD\x88" => "\xE1\xBD\x80",
		"\xE1\xBD\x89" => "\xE1\xBD\x81",
		"\xE1\xBD\x8A" => "\xE1\xBD\x82",
		"\xE1\xBD\x8B" => "\xE1\xBD\x83",
		"\xE1\xBD\x8C" => "\xE1\xBD\x84",
		"\xE1\xBD\x8D" => "\xE1\xBD\x85",
		"\xE1\xBD\x99" => "\xE1\xBD\x91",
		"\xE1\xBD\x9B" => "\xE1\xBD\x93",
		"\xE1\xBD\x9D" => "\xE1\xBD\x95",
		"\xE1\xBD\x9F" => "\xE1\xBD\x97",
		"\xE1\xBD\xA8" => "\xE1\xBD\xA0",
		"\xE1\xBD\xA9" => "\xE1\xBD\xA1",
		"\xE1\xBD\xAA" => "\xE1\xBD\xA2",
		"\xE1\xBD\xAB" => "\xE1\xBD\xA3",
		"\xE1\xBD\xAC" => "\xE1\xBD\xA4",
		"\xE1\xBD\xAD" => "\xE1\xBD\xA5",
		"\xE1\xBD\xAE" => "\xE1\xBD\xA6",
		"\xE1\xBD\xAF" => "\xE1\xBD\xA7",
		"\xE1\xBD\xB1" => "\xCE\xAC",
		"\xE1\xBD\xB3" => "\xCE\xAD",
		"\xE1\xBD\xB5" => "\xCE\xAE",
		"\xE1\xBD\xB7" => "\xCE\xAF",
		"\xE1\xBD\xB9" => "\xCF\x8C",
		"\xE1\xBD\xBB" => "\xCF\x8D",
		"\xE1\xBD\xBD" => "\xCF\x8E",
		"\xE1\xBE\x80" => "\xE1\xBC\x80\xCE\xB9",
		"\xE1\xBE\x81" => "\xE1\xBC\x81\xCE\xB9",
		"\xE1\xBE\x82" => "\xE1\xBC\x82\xCE\xB9",
		"\xE1\xBE\x83" => "\xE1\xBC\x83\xCE\xB9",
		"\xE1\xBE\x84" => "\xE1\xBC\x84\xCE\xB9",
		"\xE1\xBE\x85" => "\xE1\xBC\x85\xCE\xB9",
		"\xE1\xBE\x86" => "\xE1\xBC\x86\xCE\xB9",
		"\xE1\xBE\x87" => "\xE1\xBC\x87\xCE\xB9",
		"\xE1\xBE\x88" => "\xE1\xBC\x80\xCE\xB9",
		"\xE1\xBE\x89" => "\xE1\xBC\x81\xCE\xB9",
		"\xE1\xBE\x8A" => "\xE1\xBC\x82\xCE\xB9",
		"\xE1\xBE\x8B" => "\xE1\xBC\x83\xCE\xB9",
		"\xE1\xBE\x8C" => "\xE1\xBC\x84\xCE\xB9",
		"\xE1\xBE\x8D" => "\xE1\xBC\x85\xCE\xB9",
		"\xE1\xBE\x8E" => "\xE1\xBC\x86\xCE\xB9",
		"\xE1\xBE\x8F" => "\xE1\xBC\x87\xCE\xB9",
		"\xE1\xBE\x90" => "\xE1\xBC\xA0\xCE\xB9",
		"\xE1\xBE\x91" => "\xE1\xBC\xA1\xCE\xB9",
		"\xE1\xBE\x92" => "\xE1\xBC\xA2\xCE\xB9",
		"\xE1\xBE\x93" => "\xE1\xBC\xA3\xCE\xB9",
		"\xE1\xBE\x94" => "\xE1\xBC\xA4\xCE\xB9",
		"\xE1\xBE\x95" => "\xE1\xBC\xA5\xCE\xB9",
		"\xE1\xBE\x96" => "\xE1\xBC\xA6\xCE\xB9",
		"\xE1\xBE\x97" => "\xE1\xBC\xA7\xCE\xB9",
		"\xE1\xBE\x98" => "\xE1\xBC\xA0\xCE\xB9",
		"\xE1\xBE\x99" => "\xE1\xBC\xA1\xCE\xB9",
		"\xE1\xBE\x9A" => "\xE1\xBC\xA2\xCE\xB9",
		"\xE1\xBE\x9B" => "\xE1\xBC\xA3\xCE\xB9",
		"\xE1\xBE\x9C" => "\xE1\xBC\xA4\xCE\xB9",
		"\xE1\xBE\x9D" => "\xE1\xBC\xA5\xCE\xB9",
		"\xE1\xBE\x9E" => "\xE1\xBC\xA6\xCE\xB9",
		"\xE1\xBE\x9F" => "\xE1\xBC\xA7\xCE\xB9",
		"\xE1\xBE\xA0" => "\xE1\xBD\xA0\xCE\xB9",
		"\xE1\xBE\xA1" => "\xE1\xBD\xA1\xCE\xB9",
		"\xE1\xBE\xA2" => "\xE1\xBD\xA2\xCE\xB9",
		"\xE1\xBE\xA3" => "\xE1\xBD\xA3\xCE\xB9",
		"\xE1\xBE\xA4" => "\xE1\xBD\xA4\xCE\xB9",
		"\xE1\xBE\xA5" => "\xE1\xBD\xA5\xCE\xB9",
		"\xE1\xBE\xA6" => "\xE1\xBD\xA6\xCE\xB9",
		"\xE1\xBE\xA7" => "\xE1\xBD\xA7\xCE\xB9",
		"\xE1\xBE\xA8" => "\xE1\xBD\xA0\xCE\xB9",
		"\xE1\xBE\xA9" => "\xE1\xBD\xA1\xCE\xB9",
		"\xE1\xBE\xAA" => "\xE1\xBD\xA2\xCE\xB9",
		"\xE1\xBE\xAB" => "\xE1\xBD\xA3\xCE\xB9",
		"\xE1\xBE\xAC" => "\xE1\xBD\xA4\xCE\xB9",
		"\xE1\xBE\xAD" => "\xE1\xBD\xA5\xCE\xB9",
		"\xE1\xBE\xAE" => "\xE1\xBD\xA6\xCE\xB9",
		"\xE1\xBE\xAF" => "\xE1\xBD\xA7\xCE\xB9",
		"\xE1\xBE\xB2" => "\xE1\xBD\xB0\xCE\xB9",
		"\xE1\xBE\xB3" => "\xCE\xB1\xCE\xB9",
		"\xE1\xBE\xB4" => "\xCE\xAC\xCE\xB9",
		"\xE1\xBE\xB7" => "\xE1\xBE\xB6\xCE\xB9",
		"\xE1\xBE\xB8" => "\xE1\xBE\xB0",
		"\xE1\xBE\xB9" => "\xE1\xBE\xB1",
		"\xE1\xBE\xBA" => "\xE1\xBD\xB0",
		"\xE1\xBE\xBB" => "\xCE\xAC",
		"\xE1\xBE\xBC" => "\xCE\xB1\xCE\xB9",
		"\xE1\xBE\xBE" => "\xCE\xB9",
		"\xE1\xBF\x82" => "\xE1\xBD\xB4\xCE\xB9",
		"\xE1\xBF\x83" => "\xCE\xB7\xCE\xB9",
		"\xE1\xBF\x84" => "\xCE\xAE\xCE\xB9",
		"\xE1\xBF\x87" => "\xE1\xBF\x86\xCE\xB9",
		"\xE1\xBF\x88" => "\xE1\xBD\xB2",
		"\xE1\xBF\x89" => "\xCE\xAD",
		"\xE1\xBF\x8A" => "\xE1\xBD\xB4",
		"\xE1\xBF\x8B" => "\xCE\xAE",
		"\xE1\xBF\x8C" => "\xCE\xB7\xCE\xB9",
		"\xE1\xBF\x93" => "\xCE\x90",
		"\xE1\xBF\x98" => "\xE1\xBF\x90",
		"\xE1\xBF\x99" => "\xE1\xBF\x91",
		"\xE1\xBF\x9A" => "\xE1\xBD\xB6",
		"\xE1\xBF\x9B" => "\xCE\xAF",
		"\xE1\xBF\xA3" => "\xCE\xB0",
		"\xE1\xBF\xA8" => "\xE1\xBF\xA0",
		"\xE1\xBF\xA9" => "\xE1\xBF\xA1",
		"\xE1\xBF\xAA" => "\xE1\xBD\xBA",
		"\xE1\xBF\xAB" => "\xCF\x8D",
		"\xE1\xBF\xAC" => "\xE1\xBF\xA5",
		"\xE1\xBF\xB2" => "\xE1\xBD\xBC\xCE\xB9",
		"\xE1\xBF\xB3" => "\xCF\x89\xCE\xB9",
		"\xE1\xBF\xB4" => "\xCF\x8E\xCE\xB9",
		"\xE1\xBF\xB7" => "\xE1\xBF\xB6\xCE\xB9",
		"\xE1\xBF\xB8" => "\xE1\xBD\xB8",
		"\xE1\xBF\xB9" => "\xCF\x8C",
		"\xE1\xBF\xBA" => "\xE1\xBD\xBC",
		"\xE1\xBF\xBB" => "\xCF\x8E",
		"\xE1\xBF\xBC" => "\xCF\x89\xCE\xB9",
		"\xE2\x80\x91" => "\xE2\x80\x90",
		"\xE2\x80\xB3" => "\xE2\x80\xB2\xE2\x80\xB2",
		"\xE2\x80\xB4" => "\xE2\x80\xB2\xE2\x80\xB2\xE2\x80\xB2",
		"\xE2\x80\xB6" => "\xE2\x80\xB5\xE2\x80\xB5",
		"\xE2\x80\xB7" => "\xE2\x80\xB5\xE2\x80\xB5\xE2\x80\xB5",
		"\xE2\x81\x97" => "\xE2\x80\xB2\xE2\x80\xB2\xE2\x80\xB2\xE2\x80\xB2",
		"\xE2\x81\xB0" => "\x30",
		"\xE2\x81\xB1" => "\x69",
		"\xE2\x81\xB4" => "\x34",
		"\xE2\x81\xB5" => "\x35",
		"\xE2\x81\xB6" => "\x36",
		"\xE2\x81\xB7" => "\x37",
		"\xE2\x81\xB8" => "\x38",
		"\xE2\x81\xB9" => "\x39",
		"\xE2\x81\xBB" => "\xE2\x88\x92",
		"\xE2\x81\xBF" => "\x6E",
		"\xE2\x82\x80" => "\x30",
		"\xE2\x82\x81" => "\x31",
		"\xE2\x82\x82" => "\x32",
		"\xE2\x82\x83" => "\x33",
		"\xE2\x82\x84" => "\x34",
		"\xE2\x82\x85" => "\x35",
		"\xE2\x82\x86" => "\x36",
		"\xE2\x82\x87" => "\x37",
		"\xE2\x82\x88" => "\x38",
		"\xE2\x82\x89" => "\x39",
		"\xE2\x82\x8B" => "\xE2\x88\x92",
		"\xE2\x82\x90" => "\x61",
		"\xE2\x82\x91" => "\x65",
		"\xE2\x82\x92" => "\x6F",
		"\xE2\x82\x93" => "\x78",
		"\xE2\x82\x94" => "\xC9\x99",
		"\xE2\x82\x95" => "\x68",
		"\xE2\x82\x96" => "\x6B",
		"\xE2\x82\x97" => "\x6C",
		"\xE2\x82\x98" => "\x6D",
		"\xE2\x82\x99" => "\x6E",
		"\xE2\x82\x9A" => "\x70",
		"\xE2\x82\x9B" => "\x73",
		"\xE2\x82\x9C" => "\x74",
		"\xE2\x82\xA8" => "\x72\x73",
		"\xE2\x84\x82" => "\x63",
		"\xE2\x84\x83" => "\xC2\xB0\x63",
		"\xE2\x84\x87" => "\xC9\x9B",
		"\xE2\x84\x89" => "\xC2\xB0\x66",
		"\xE2\x84\x8A" => "\x67",
		"\xE2\x84\x8B" => "\x68",
		"\xE2\x84\x8C" => "\x68",
		"\xE2\x84\x8D" => "\x68",
		"\xE2\x84\x8E" => "\x68",
		"\xE2\x84\x8F" => "\xC4\xA7",
		"\xE2\x84\x90" => "\x69",
		"\xE2\x84\x91" => "\x69",
		"\xE2\x84\x92" => "\x6C",
		"\xE2\x84\x93" => "\x6C",
		"\xE2\x84\x95" => "\x6E",
		"\xE2\x84\x96" => "\x6E\x6F",
		"\xE2\x84\x99" => "\x70",
		"\xE2\x84\x9A" => "\x71",
		"\xE2\x84\x9B" => "\x72",
		"\xE2\x84\x9C" => "\x72",
		"\xE2\x84\x9D" => "\x72",
		"\xE2\x84\xA0" => "\x73\x6D",
		"\xE2\x84\xA1" => "\x74\x65\x6C",
		"\xE2\x84\xA2" => "\x74\x6D",
		"\xE2\x84\xA4" => "\x7A",
		"\xE2\x84\xA6" => "\xCF\x89",
		"\xE2\x84\xA8" => "\x7A",
		"\xE2\x84\xAA" => "\x6B",
		"\xE2\x84\xAB" => "\xC3\xA5",
		"\xE2\x84\xAC" => "\x62",
		"\xE2\x84\xAD" => "\x63",
		"\xE2\x84\xAF" => "\x65",
		"\xE2\x84\xB0" => "\x65",
		"\xE2\x84\xB1" => "\x66",
		"\xE2\x84\xB3" => "\x6D",
		"\xE2\x84\xB4" => "\x6F",
		"\xE2\x84\xB5" => "\xD7\x90",
		"\xE2\x84\xB6" => "\xD7\x91",
		"\xE2\x84\xB7" => "\xD7\x92",
		"\xE2\x84\xB8" => "\xD7\x93",
		"\xE2\x84\xB9" => "\x69",
		"\xE2\x84\xBB" => "\x66\x61\x78",
		"\xE2\x84\xBC" => "\xCF\x80",
		"\xE2\x84\xBD" => "\xCE\xB3",
		"\xE2\x84\xBE" => "\xCE\xB3",
		"\xE2\x84\xBF" => "\xCF\x80",
		"\xE2\x85\x80" => "\xE2\x88\x91",
		"\xE2\x85\x85" => "\x64",
		"\xE2\x85\x86" => "\x64",
		"\xE2\x85\x87" => "\x65",
		"\xE2\x85\x88" => "\x69",
		"\xE2\x85\x89" => "\x6A",
		"\xE2\x85\x90" => "\x31\xE2\x81\x84\x37",
		"\xE2\x85\x91" => "\x31\xE2\x81\x84\x39",
		"\xE2\x85\x92" => "\x31\xE2\x81\x84\x31\x30",
		"\xE2\x85\x93" => "\x31\xE2\x81\x84\x33",
		"\xE2\x85\x94" => "\x32\xE2\x81\x84\x33",
		"\xE2\x85\x95" => "\x31\xE2\x81\x84\x35",
		"\xE2\x85\x96" => "\x32\xE2\x81\x84\x35",
		"\xE2\x85\x97" => "\x33\xE2\x81\x84\x35",
		"\xE2\x85\x98" => "\x34\xE2\x81\x84\x35",
		"\xE2\x85\x99" => "\x31\xE2\x81\x84\x36",
		"\xE2\x85\x9A" => "\x35\xE2\x81\x84\x36",
		"\xE2\x85\x9B" => "\x31\xE2\x81\x84\x38",
		"\xE2\x85\x9C" => "\x33\xE2\x81\x84\x38",
		"\xE2\x85\x9D" => "\x35\xE2\x81\x84\x38",
		"\xE2\x85\x9E" => "\x37\xE2\x81\x84\x38",
		"\xE2\x85\x9F" => "\x31\xE2\x81\x84",
		"\xE2\x85\xA0" => "\x69",
		"\xE2\x85\xA1" => "\x69\x69",
		"\xE2\x85\xA2" => "\x69\x69\x69",
		"\xE2\x85\xA3" => "\x69\x76",
		"\xE2\x85\xA4" => "\x76",
		"\xE2\x85\xA5" => "\x76\x69",
		"\xE2\x85\xA6" => "\x76\x69\x69",
		"\xE2\x85\xA7" => "\x76\x69\x69\x69",
		"\xE2\x85\xA8" => "\x69\x78",
		"\xE2\x85\xA9" => "\x78",
		"\xE2\x85\xAA" => "\x78\x69",
		"\xE2\x85\xAB" => "\x78\x69\x69",
		"\xE2\x85\xAC" => "\x6C",
		"\xE2\x85\xAD" => "\x63",
		"\xE2\x85\xAE" => "\x64",
		"\xE2\x85\xAF" => "\x6D",
		"\xE2\x85\xB0" => "\x69",
		"\xE2\x85\xB1" => "\x69\x69",
		"\xE2\x85\xB2" => "\x69\x69\x69",
		"\xE2\x85\xB3" => "\x69\x76",
		"\xE2\x85\xB4" => "\x76",
		"\xE2\x85\xB5" => "\x76\x69",
		"\xE2\x85\xB6" => "\x76\x69\x69",
		"\xE2\x85\xB7" => "\x76\x69\x69\x69",
		"\xE2\x85\xB8" => "\x69\x78",
		"\xE2\x85\xB9" => "\x78",
		"\xE2\x85\xBA" => "\x78\x69",
		"\xE2\x85\xBB" => "\x78\x69\x69",
		"\xE2\x85\xBC" => "\x6C",
		"\xE2\x85\xBD" => "\x63",
		"\xE2\x85\xBE" => "\x64",
		"\xE2\x85\xBF" => "\x6D",
		"\xE2\x86\x89" => "\x30\xE2\x81\x84\x33",
		"\xE2\x88\xAC" => "\xE2\x88\xAB\xE2\x88\xAB",
		"\xE2\x88\xAD" => "\xE2\x88\xAB\xE2\x88\xAB\xE2\x88\xAB",
		"\xE2\x88\xAF" => "\xE2\x88\xAE\xE2\x88\xAE",
		"\xE2\x88\xB0" => "\xE2\x88\xAE\xE2\x88\xAE\xE2\x88\xAE",
		"\xE2\x8C\xA9" => "\xE3\x80\x88",
		"\xE2\x8C\xAA" => "\xE3\x80\x89",
		"\xE2\x91\xA0" => "\x31",
		"\xE2\x91\xA1" => "\x32",
		"\xE2\x91\xA2" => "\x33",
		"\xE2\x91\xA3" => "\x34",
		"\xE2\x91\xA4" => "\x35",
		"\xE2\x91\xA5" => "\x36",
		"\xE2\x91\xA6" => "\x37",
		"\xE2\x91\xA7" => "\x38",
		"\xE2\x91\xA8" => "\x39",
		"\xE2\x91\xA9" => "\x31\x30",
		"\xE2\x91\xAA" => "\x31\x31",
		"\xE2\x91\xAB" => "\x31\x32",
		"\xE2\x91\xAC" => "\x31\x33",
		"\xE2\x91\xAD" => "\x31\x34",
		"\xE2\x91\xAE" => "\x31\x35",
		"\xE2\x91\xAF" => "\x31\x36",
		"\xE2\x91\xB0" => "\x31\x37",
		"\xE2\x91\xB1" => "\x31\x38",
		"\xE2\x91\xB2" => "\x31\x39",
		"\xE2\x91\xB3" => "\x32\x30",
		"\xE2\x92\xB6" => "\x61",
		"\xE2\x92\xB7" => "\x62",
		"\xE2\x92\xB8" => "\x63",
		"\xE2\x92\xB9" => "\x64",
		"\xE2\x92\xBA" => "\x65",
		"\xE2\x92\xBB" => "\x66",
		"\xE2\x92\xBC" => "\x67",
		"\xE2\x92\xBD" => "\x68",
		"\xE2\x92\xBE" => "\x69",
		"\xE2\x92\xBF" => "\x6A",
		"\xE2\x93\x80" => "\x6B",
		"\xE2\x93\x81" => "\x6C",
		"\xE2\x93\x82" => "\x6D",
		"\xE2\x93\x83" => "\x6E",
		"\xE2\x93\x84" => "\x6F",
		"\xE2\x93\x85" => "\x70",
		"\xE2\x93\x86" => "\x71",
		"\xE2\x93\x87" => "\x72",
		"\xE2\x93\x88" => "\x73",
		"\xE2\x93\x89" => "\x74",
		"\xE2\x93\x8A" => "\x75",
		"\xE2\x93\x8B" => "\x76",
		"\xE2\x93\x8C" => "\x77",
		"\xE2\x93\x8D" => "\x78",
		"\xE2\x93\x8E" => "\x79",
		"\xE2\x93\x8F" => "\x7A",
		"\xE2\x93\x90" => "\x61",
		"\xE2\x93\x91" => "\x62",
		"\xE2\x93\x92" => "\x63",
		"\xE2\x93\x93" => "\x64",
		"\xE2\x93\x94" => "\x65",
		"\xE2\x93\x95" => "\x66",
		"\xE2\x93\x96" => "\x67",
		"\xE2\x93\x97" => "\x68",
		"\xE2\x93\x98" => "\x69",
		"\xE2\x93\x99" => "\x6A",
		"\xE2\x93\x9A" => "\x6B",
		"\xE2\x93\x9B" => "\x6C",
		"\xE2\x93\x9C" => "\x6D",
		"\xE2\x93\x9D" => "\x6E",
		"\xE2\x93\x9E" => "\x6F",
		"\xE2\x93\x9F" => "\x70",
		"\xE2\x93\xA0" => "\x71",
		"\xE2\x93\xA1" => "\x72",
		"\xE2\x93\xA2" => "\x73",
		"\xE2\x93\xA3" => "\x74",
		"\xE2\x93\xA4" => "\x75",
		"\xE2\x93\xA5" => "\x76",
		"\xE2\x93\xA6" => "\x77",
		"\xE2\x93\xA7" => "\x78",
		"\xE2\x93\xA8" => "\x79",
		"\xE2\x93\xA9" => "\x7A",
		"\xE2\x93\xAA" => "\x30",
		"\xE2\xA8\x8C" => "\xE2\x88\xAB\xE2\x88\xAB\xE2\x88\xAB\xE2\x88\xAB",
		"\xE2\xAB\x9C" => "\xE2\xAB\x9D\xCC\xB8",
		"\xE2\xB0\x80" => "\xE2\xB0\xB0",
		"\xE2\xB0\x81" => "\xE2\xB0\xB1",
		"\xE2\xB0\x82" => "\xE2\xB0\xB2",
		"\xE2\xB0\x83" => "\xE2\xB0\xB3",
		"\xE2\xB0\x84" => "\xE2\xB0\xB4",
		"\xE2\xB0\x85" => "\xE2\xB0\xB5",
		"\xE2\xB0\x86" => "\xE2\xB0\xB6",
		"\xE2\xB0\x87" => "\xE2\xB0\xB7",
		"\xE2\xB0\x88" => "\xE2\xB0\xB8",
		"\xE2\xB0\x89" => "\xE2\xB0\xB9",
		"\xE2\xB0\x8A" => "\xE2\xB0\xBA",
		"\xE2\xB0\x8B" => "\xE2\xB0\xBB",
		"\xE2\xB0\x8C" => "\xE2\xB0\xBC",
		"\xE2\xB0\x8D" => "\xE2\xB0\xBD",
		"\xE2\xB0\x8E" => "\xE2\xB0\xBE",
		"\xE2\xB0\x8F" => "\xE2\xB0\xBF",
		"\xE2\xB0\x90" => "\xE2\xB1\x80",
		"\xE2\xB0\x91" => "\xE2\xB1\x81",
		"\xE2\xB0\x92" => "\xE2\xB1\x82",
		"\xE2\xB0\x93" => "\xE2\xB1\x83",
		"\xE2\xB0\x94" => "\xE2\xB1\x84",
		"\xE2\xB0\x95" => "\xE2\xB1\x85",
		"\xE2\xB0\x96" => "\xE2\xB1\x86",
		"\xE2\xB0\x97" => "\xE2\xB1\x87",
		"\xE2\xB0\x98" => "\xE2\xB1\x88",
		"\xE2\xB0\x99" => "\xE2\xB1\x89",
		"\xE2\xB0\x9A" => "\xE2\xB1\x8A",
		"\xE2\xB0\x9B" => "\xE2\xB1\x8B",
		"\xE2\xB0\x9C" => "\xE2\xB1\x8C",
		"\xE2\xB0\x9D" => "\xE2\xB1\x8D",
		"\xE2\xB0\x9E" => "\xE2\xB1\x8E",
		"\xE2\xB0\x9F" => "\xE2\xB1\x8F",
		"\xE2\xB0\xA0" => "\xE2\xB1\x90",
		"\xE2\xB0\xA1" => "\xE2\xB1\x91",
		"\xE2\xB0\xA2" => "\xE2\xB1\x92",
		"\xE2\xB0\xA3" => "\xE2\xB1\x93",
		"\xE2\xB0\xA4" => "\xE2\xB1\x94",
		"\xE2\xB0\xA5" => "\xE2\xB1\x95",
		"\xE2\xB0\xA6" => "\xE2\xB1\x96",
		"\xE2\xB0\xA7" => "\xE2\xB1\x97",
		"\xE2\xB0\xA8" => "\xE2\xB1\x98",
		"\xE2\xB0\xA9" => "\xE2\xB1\x99",
		"\xE2\xB0\xAA" => "\xE2\xB1\x9A",
		"\xE2\xB0\xAB" => "\xE2\xB1\x9B",
		"\xE2\xB0\xAC" => "\xE2\xB1\x9C",
		"\xE2\xB0\xAD" => "\xE2\xB1\x9D",
		"\xE2\xB0\xAE" => "\xE2\xB1\x9E",
		"\xE2\xB0\xAF" => "\xE2\xB1\x9F",
		"\xE2\xB1\xA0" => "\xE2\xB1\xA1",
		"\xE2\xB1\xA2" => "\xC9\xAB",
		"\xE2\xB1\xA3" => "\xE1\xB5\xBD",
		"\xE2\xB1\xA4" => "\xC9\xBD",
		"\xE2\xB1\xA7" => "\xE2\xB1\xA8",
		"\xE2\xB1\xA9" => "\xE2\xB1\xAA",
		"\xE2\xB1\xAB" => "\xE2\xB1\xAC",
		"\xE2\xB1\xAD" => "\xC9\x91",
		"\xE2\xB1\xAE" => "\xC9\xB1",
		"\xE2\xB1\xAF" => "\xC9\x90",
		"\xE2\xB1\xB0" => "\xC9\x92",
		"\xE2\xB1\xB2" => "\xE2\xB1\xB3",
		"\xE2\xB1\xB5" => "\xE2\xB1\xB6",
		"\xE2\xB1\xBC" => "\x6A",
		"\xE2\xB1\xBD" => "\x76",
		"\xE2\xB1\xBE" => "\xC8\xBF",
		"\xE2\xB1\xBF" => "\xC9\x80",
		"\xE2\xB2\x80" => "\xE2\xB2\x81",
		"\xE2\xB2\x82" => "\xE2\xB2\x83",
		"\xE2\xB2\x84" => "\xE2\xB2\x85",
		"\xE2\xB2\x86" => "\xE2\xB2\x87",
		"\xE2\xB2\x88" => "\xE2\xB2\x89",
		"\xE2\xB2\x8A" => "\xE2\xB2\x8B",
		"\xE2\xB2\x8C" => "\xE2\xB2\x8D",
		"\xE2\xB2\x8E" => "\xE2\xB2\x8F",
		"\xE2\xB2\x90" => "\xE2\xB2\x91",
		"\xE2\xB2\x92" => "\xE2\xB2\x93",
		"\xE2\xB2\x94" => "\xE2\xB2\x95",
		"\xE2\xB2\x96" => "\xE2\xB2\x97",
		"\xE2\xB2\x98" => "\xE2\xB2\x99",
		"\xE2\xB2\x9A" => "\xE2\xB2\x9B",
		"\xE2\xB2\x9C" => "\xE2\xB2\x9D",
		"\xE2\xB2\x9E" => "\xE2\xB2\x9F",
		"\xE2\xB2\xA0" => "\xE2\xB2\xA1",
		"\xE2\xB2\xA2" => "\xE2\xB2\xA3",
		"\xE2\xB2\xA4" => "\xE2\xB2\xA5",
		"\xE2\xB2\xA6" => "\xE2\xB2\xA7",
		"\xE2\xB2\xA8" => "\xE2\xB2\xA9",
		"\xE2\xB2\xAA" => "\xE2\xB2\xAB",
		"\xE2\xB2\xAC" => "\xE2\xB2\xAD",
		"\xE2\xB2\xAE" => "\xE2\xB2\xAF",
		"\xE2\xB2\xB0" => "\xE2\xB2\xB1",
		"\xE2\xB2\xB2" => "\xE2\xB2\xB3",
		"\xE2\xB2\xB4" => "\xE2\xB2\xB5",
		"\xE2\xB2\xB6" => "\xE2\xB2\xB7",
		"\xE2\xB2\xB8" => "\xE2\xB2\xB9",
		"\xE2\xB2\xBA" => "\xE2\xB2\xBB",
		"\xE2\xB2\xBC" => "\xE2\xB2\xBD",
		"\xE2\xB2\xBE" => "\xE2\xB2\xBF",
		"\xE2\xB3\x80" => "\xE2\xB3\x81",
		"\xE2\xB3\x82" => "\xE2\xB3\x83",
		"\xE2\xB3\x84" => "\xE2\xB3\x85",
		"\xE2\xB3\x86" => "\xE2\xB3\x87",
		"\xE2\xB3\x88" => "\xE2\xB3\x89",
		"\xE2\xB3\x8A" => "\xE2\xB3\x8B",
		"\xE2\xB3\x8C" => "\xE2\xB3\x8D",
		"\xE2\xB3\x8E" => "\xE2\xB3\x8F",
		"\xE2\xB3\x90" => "\xE2\xB3\x91",
		"\xE2\xB3\x92" => "\xE2\xB3\x93",
		"\xE2\xB3\x94" => "\xE2\xB3\x95",
		"\xE2\xB3\x96" => "\xE2\xB3\x97",
		"\xE2\xB3\x98" => "\xE2\xB3\x99",
		"\xE2\xB3\x9A" => "\xE2\xB3\x9B",
		"\xE2\xB3\x9C" => "\xE2\xB3\x9D",
		"\xE2\xB3\x9E" => "\xE2\xB3\x9F",
		"\xE2\xB3\xA0" => "\xE2\xB3\xA1",
		"\xE2\xB3\xA2" => "\xE2\xB3\xA3",
		"\xE2\xB3\xAB" => "\xE2\xB3\xAC",
		"\xE2\xB3\xAD" => "\xE2\xB3\xAE",
		"\xE2\xB3\xB2" => "\xE2\xB3\xB3",
		"\xE2\xB5\xAF" => "\xE2\xB5\xA1",
		"\xE2\xBA\x9F" => "\xE6\xAF\x8D",
		"\xE2\xBB\xB3" => "\xE9\xBE\x9F",
		"\xE2\xBC\x80" => "\xE4\xB8\x80",
		"\xE2\xBC\x81" => "\xE4\xB8\xA8",
		"\xE2\xBC\x82" => "\xE4\xB8\xB6",
		"\xE2\xBC\x83" => "\xE4\xB8\xBF",
		"\xE2\xBC\x84" => "\xE4\xB9\x99",
		"\xE2\xBC\x85" => "\xE4\xBA\x85",
		"\xE2\xBC\x86" => "\xE4\xBA\x8C",
		"\xE2\xBC\x87" => "\xE4\xBA\xA0",
		"\xE2\xBC\x88" => "\xE4\xBA\xBA",
		"\xE2\xBC\x89" => "\xE5\x84\xBF",
		"\xE2\xBC\x8A" => "\xE5\x85\xA5",
		"\xE2\xBC\x8B" => "\xE5\x85\xAB",
		"\xE2\xBC\x8C" => "\xE5\x86\x82",
		"\xE2\xBC\x8D" => "\xE5\x86\x96",
		"\xE2\xBC\x8E" => "\xE5\x86\xAB",
		"\xE2\xBC\x8F" => "\xE5\x87\xA0",
		"\xE2\xBC\x90" => "\xE5\x87\xB5",
		"\xE2\xBC\x91" => "\xE5\x88\x80",
		"\xE2\xBC\x92" => "\xE5\x8A\x9B",
		"\xE2\xBC\x93" => "\xE5\x8B\xB9",
		"\xE2\xBC\x94" => "\xE5\x8C\x95",
		"\xE2\xBC\x95" => "\xE5\x8C\x9A",
		"\xE2\xBC\x96" => "\xE5\x8C\xB8",
		"\xE2\xBC\x97" => "\xE5\x8D\x81",
		"\xE2\xBC\x98" => "\xE5\x8D\x9C",
		"\xE2\xBC\x99" => "\xE5\x8D\xA9",
		"\xE2\xBC\x9A" => "\xE5\x8E\x82",
		"\xE2\xBC\x9B" => "\xE5\x8E\xB6",
		"\xE2\xBC\x9C" => "\xE5\x8F\x88",
		"\xE2\xBC\x9D" => "\xE5\x8F\xA3",
		"\xE2\xBC\x9E" => "\xE5\x9B\x97",
		"\xE2\xBC\x9F" => "\xE5\x9C\x9F",
		"\xE2\xBC\xA0" => "\xE5\xA3\xAB",
		"\xE2\xBC\xA1" => "\xE5\xA4\x82",
		"\xE2\xBC\xA2" => "\xE5\xA4\x8A",
		"\xE2\xBC\xA3" => "\xE5\xA4\x95",
		"\xE2\xBC\xA4" => "\xE5\xA4\xA7",
		"\xE2\xBC\xA5" => "\xE5\xA5\xB3",
		"\xE2\xBC\xA6" => "\xE5\xAD\x90",
		"\xE2\xBC\xA7" => "\xE5\xAE\x80",
		"\xE2\xBC\xA8" => "\xE5\xAF\xB8",
		"\xE2\xBC\xA9" => "\xE5\xB0\x8F",
		"\xE2\xBC\xAA" => "\xE5\xB0\xA2",
		"\xE2\xBC\xAB" => "\xE5\xB0\xB8",
		"\xE2\xBC\xAC" => "\xE5\xB1\xAE",
		"\xE2\xBC\xAD" => "\xE5\xB1\xB1",
		"\xE2\xBC\xAE" => "\xE5\xB7\x9B",
		"\xE2\xBC\xAF" => "\xE5\xB7\xA5",
		"\xE2\xBC\xB0" => "\xE5\xB7\xB1",
		"\xE2\xBC\xB1" => "\xE5\xB7\xBE",
		"\xE2\xBC\xB2" => "\xE5\xB9\xB2",
		"\xE2\xBC\xB3" => "\xE5\xB9\xBA",
		"\xE2\xBC\xB4" => "\xE5\xB9\xBF",
		"\xE2\xBC\xB5" => "\xE5\xBB\xB4",
		"\xE2\xBC\xB6" => "\xE5\xBB\xBE",
		"\xE2\xBC\xB7" => "\xE5\xBC\x8B",
		"\xE2\xBC\xB8" => "\xE5\xBC\x93",
		"\xE2\xBC\xB9" => "\xE5\xBD\x90",
		"\xE2\xBC\xBA" => "\xE5\xBD\xA1",
		"\xE2\xBC\xBB" => "\xE5\xBD\xB3",
		"\xE2\xBC\xBC" => "\xE5\xBF\x83",
		"\xE2\xBC\xBD" => "\xE6\x88\x88",
		"\xE2\xBC\xBE" => "\xE6\x88\xB6",
		"\xE2\xBC\xBF" => "\xE6\x89\x8B",
		"\xE2\xBD\x80" => "\xE6\x94\xAF",
		"\xE2\xBD\x81" => "\xE6\x94\xB4",
		"\xE2\xBD\x82" => "\xE6\x96\x87",
		"\xE2\xBD\x83" => "\xE6\x96\x97",
		"\xE2\xBD\x84" => "\xE6\x96\xA4",
		"\xE2\xBD\x85" => "\xE6\x96\xB9",
		"\xE2\xBD\x86" => "\xE6\x97\xA0",
		"\xE2\xBD\x87" => "\xE6\x97\xA5",
		"\xE2\xBD\x88" => "\xE6\x9B\xB0",
		"\xE2\xBD\x89" => "\xE6\x9C\x88",
		"\xE2\xBD\x8A" => "\xE6\x9C\xA8",
		"\xE2\xBD\x8B" => "\xE6\xAC\xA0",
		"\xE2\xBD\x8C" => "\xE6\xAD\xA2",
		"\xE2\xBD\x8D" => "\xE6\xAD\xB9",
		"\xE2\xBD\x8E" => "\xE6\xAE\xB3",
		"\xE2\xBD\x8F" => "\xE6\xAF\x8B",
		"\xE2\xBD\x90" => "\xE6\xAF\x94",
		"\xE2\xBD\x91" => "\xE6\xAF\x9B",
		"\xE2\xBD\x92" => "\xE6\xB0\x8F",
		"\xE2\xBD\x93" => "\xE6\xB0\x94",
		"\xE2\xBD\x94" => "\xE6\xB0\xB4",
		"\xE2\xBD\x95" => "\xE7\x81\xAB",
		"\xE2\xBD\x96" => "\xE7\x88\xAA",
		"\xE2\xBD\x97" => "\xE7\x88\xB6",
		"\xE2\xBD\x98" => "\xE7\x88\xBB",
		"\xE2\xBD\x99" => "\xE7\x88\xBF",
		"\xE2\xBD\x9A" => "\xE7\x89\x87",
		"\xE2\xBD\x9B" => "\xE7\x89\x99",
		"\xE2\xBD\x9C" => "\xE7\x89\x9B",
		"\xE2\xBD\x9D" => "\xE7\x8A\xAC",
		"\xE2\xBD\x9E" => "\xE7\x8E\x84",
		"\xE2\xBD\x9F" => "\xE7\x8E\x89",
		"\xE2\xBD\xA0" => "\xE7\x93\x9C",
		"\xE2\xBD\xA1" => "\xE7\x93\xA6",
		"\xE2\xBD\xA2" => "\xE7\x94\x98",
		"\xE2\xBD\xA3" => "\xE7\x94\x9F",
		"\xE2\xBD\xA4" => "\xE7\x94\xA8",
		"\xE2\xBD\xA5" => "\xE7\x94\xB0",
		"\xE2\xBD\xA6" => "\xE7\x96\x8B",
		"\xE2\xBD\xA7" => "\xE7\x96\x92",
		"\xE2\xBD\xA8" => "\xE7\x99\xB6",
		"\xE2\xBD\xA9" => "\xE7\x99\xBD",
		"\xE2\xBD\xAA" => "\xE7\x9A\xAE",
		"\xE2\xBD\xAB" => "\xE7\x9A\xBF",
		"\xE2\xBD\xAC" => "\xE7\x9B\xAE",
		"\xE2\xBD\xAD" => "\xE7\x9F\x9B",
		"\xE2\xBD\xAE" => "\xE7\x9F\xA2",
		"\xE2\xBD\xAF" => "\xE7\x9F\xB3",
		"\xE2\xBD\xB0" => "\xE7\xA4\xBA",
		"\xE2\xBD\xB1" => "\xE7\xA6\xB8",
		"\xE2\xBD\xB2" => "\xE7\xA6\xBE",
		"\xE2\xBD\xB3" => "\xE7\xA9\xB4",
		"\xE2\xBD\xB4" => "\xE7\xAB\x8B",
		"\xE2\xBD\xB5" => "\xE7\xAB\xB9",
		"\xE2\xBD\xB6" => "\xE7\xB1\xB3",
		"\xE2\xBD\xB7" => "\xE7\xB3\xB8",
		"\xE2\xBD\xB8" => "\xE7\xBC\xB6",
		"\xE2\xBD\xB9" => "\xE7\xBD\x91",
		"\xE2\xBD\xBA" => "\xE7\xBE\x8A",
		"\xE2\xBD\xBB" => "\xE7\xBE\xBD",
		"\xE2\xBD\xBC" => "\xE8\x80\x81",
		"\xE2\xBD\xBD" => "\xE8\x80\x8C",
		"\xE2\xBD\xBE" => "\xE8\x80\x92",
		"\xE2\xBD\xBF" => "\xE8\x80\xB3",
		"\xE2\xBE\x80" => "\xE8\x81\xBF",
		"\xE2\xBE\x81" => "\xE8\x82\x89",
		"\xE2\xBE\x82" => "\xE8\x87\xA3",
		"\xE2\xBE\x83" => "\xE8\x87\xAA",
		"\xE2\xBE\x84" => "\xE8\x87\xB3",
		"\xE2\xBE\x85" => "\xE8\x87\xBC",
		"\xE2\xBE\x86" => "\xE8\x88\x8C",
		"\xE2\xBE\x87" => "\xE8\x88\x9B",
		"\xE2\xBE\x88" => "\xE8\x88\x9F",
		"\xE2\xBE\x89" => "\xE8\x89\xAE",
		"\xE2\xBE\x8A" => "\xE8\x89\xB2",
		"\xE2\xBE\x8B" => "\xE8\x89\xB8",
		"\xE2\xBE\x8C" => "\xE8\x99\x8D",
		"\xE2\xBE\x8D" => "\xE8\x99\xAB",
		"\xE2\xBE\x8E" => "\xE8\xA1\x80",
		"\xE2\xBE\x8F" => "\xE8\xA1\x8C",
		"\xE2\xBE\x90" => "\xE8\xA1\xA3",
		"\xE2\xBE\x91" => "\xE8\xA5\xBE",
		"\xE2\xBE\x92" => "\xE8\xA6\x8B",
		"\xE2\xBE\x93" => "\xE8\xA7\x92",
		"\xE2\xBE\x94" => "\xE8\xA8\x80",
		"\xE2\xBE\x95" => "\xE8\xB0\xB7",
		"\xE2\xBE\x96" => "\xE8\xB1\x86",
		"\xE2\xBE\x97" => "\xE8\xB1\x95",
		"\xE2\xBE\x98" => "\xE8\xB1\xB8",
		"\xE2\xBE\x99" => "\xE8\xB2\x9D",
		"\xE2\xBE\x9A" => "\xE8\xB5\xA4",
		"\xE2\xBE\x9B" => "\xE8\xB5\xB0",
		"\xE2\xBE\x9C" => "\xE8\xB6\xB3",
		"\xE2\xBE\x9D" => "\xE8\xBA\xAB",
		"\xE2\xBE\x9E" => "\xE8\xBB\x8A",
		"\xE2\xBE\x9F" => "\xE8\xBE\x9B",
		"\xE2\xBE\xA0" => "\xE8\xBE\xB0",
		"\xE2\xBE\xA1" => "\xE8\xBE\xB5",
		"\xE2\xBE\xA2" => "\xE9\x82\x91",
		"\xE2\xBE\xA3" => "\xE9\x85\x89",
		"\xE2\xBE\xA4" => "\xE9\x87\x86",
		"\xE2\xBE\xA5" => "\xE9\x87\x8C",
		"\xE2\xBE\xA6" => "\xE9\x87\x91",
		"\xE2\xBE\xA7" => "\xE9\x95\xB7",
		"\xE2\xBE\xA8" => "\xE9\x96\x80",
		"\xE2\xBE\xA9" => "\xE9\x98\x9C",
		"\xE2\xBE\xAA" => "\xE9\x9A\xB6",
		"\xE2\xBE\xAB" => "\xE9\x9A\xB9",
		"\xE2\xBE\xAC" => "\xE9\x9B\xA8",
		"\xE2\xBE\xAD" => "\xE9\x9D\x91",
		"\xE2\xBE\xAE" => "\xE9\x9D\x9E",
		"\xE2\xBE\xAF" => "\xE9\x9D\xA2",
		"\xE2\xBE\xB0" => "\xE9\x9D\xA9",
		"\xE2\xBE\xB1" => "\xE9\x9F\x8B",
		"\xE2\xBE\xB2" => "\xE9\x9F\xAD",
		"\xE2\xBE\xB3" => "\xE9\x9F\xB3",
		"\xE2\xBE\xB4" => "\xE9\xA0\x81",
		"\xE2\xBE\xB5" => "\xE9\xA2\xA8",
		"\xE2\xBE\xB6" => "\xE9\xA3\x9B",
		"\xE2\xBE\xB7" => "\xE9\xA3\x9F",
		"\xE2\xBE\xB8" => "\xE9\xA6\x96",
		"\xE2\xBE\xB9" => "\xE9\xA6\x99",
		"\xE2\xBE\xBA" => "\xE9\xA6\xAC",
		"\xE2\xBE\xBB" => "\xE9\xAA\xA8",
		"\xE2\xBE\xBC" => "\xE9\xAB\x98",
		"\xE2\xBE\xBD" => "\xE9\xAB\x9F",
		"\xE2\xBE\xBE" => "\xE9\xAC\xA5",
		"\xE2\xBE\xBF" => "\xE9\xAC\xAF",
		"\xE2\xBF\x80" => "\xE9\xAC\xB2",
		"\xE2\xBF\x81" => "\xE9\xAC\xBC",
		"\xE2\xBF\x82" => "\xE9\xAD\x9A",
		"\xE2\xBF\x83" => "\xE9\xB3\xA5",
		"\xE2\xBF\x84" => "\xE9\xB9\xB5",
		"\xE2\xBF\x85" => "\xE9\xB9\xBF",
		"\xE2\xBF\x86" => "\xE9\xBA\xA5",
		"\xE2\xBF\x87" => "\xE9\xBA\xBB",
		"\xE2\xBF\x88" => "\xE9\xBB\x83",
		"\xE2\xBF\x89" => "\xE9\xBB\x8D",
		"\xE2\xBF\x8A" => "\xE9\xBB\x91",
		"\xE2\xBF\x8B" => "\xE9\xBB\xB9",
		"\xE2\xBF\x8C" => "\xE9\xBB\xBD",
		"\xE2\xBF\x8D" => "\xE9\xBC\x8E",
		"\xE2\xBF\x8E" => "\xE9\xBC\x93",
		"\xE2\xBF\x8F" => "\xE9\xBC\xA0",
		"\xE2\xBF\x90" => "\xE9\xBC\xBB",
		"\xE2\xBF\x91" => "\xE9\xBD\x8A",
		"\xE2\xBF\x92" => "\xE9\xBD\x92",
		"\xE2\xBF\x93" => "\xE9\xBE\x8D",
		"\xE2\xBF\x94" => "\xE9\xBE\x9C",
		"\xE2\xBF\x95" => "\xE9\xBE\xA0",
		"\xE3\x80\x82" => "\x2E",
		"\xE3\x80\xB6" => "\xE3\x80\x92",
		"\xE3\x80\xB8" => "\xE5\x8D\x81",
		"\xE3\x80\xB9" => "\xE5\x8D\x84",
		"\xE3\x80\xBA" => "\xE5\x8D\x85",
		"\xE3\x82\x9F" => "\xE3\x82\x88\xE3\x82\x8A",
		"\xE3\x83\xBF" => "\xE3\x82\xB3\xE3\x83\x88",
		"\xE3\x84\xB1" => "\xE1\x84\x80",
		"\xE3\x84\xB2" => "\xE1\x84\x81",
		"\xE3\x84\xB3" => "\xE1\x86\xAA",
		"\xE3\x84\xB4" => "\xE1\x84\x82",
		"\xE3\x84\xB5" => "\xE1\x86\xAC",
		"\xE3\x84\xB6" => "\xE1\x86\xAD",
		"\xE3\x84\xB7" => "\xE1\x84\x83",
		"\xE3\x84\xB8" => "\xE1\x84\x84",
		"\xE3\x84\xB9" => "\xE1\x84\x85",
		"\xE3\x84\xBA" => "\xE1\x86\xB0",
		"\xE3\x84\xBB" => "\xE1\x86\xB1",
		"\xE3\x84\xBC" => "\xE1\x86\xB2",
		"\xE3\x84\xBD" => "\xE1\x86\xB3",
		"\xE3\x84\xBE" => "\xE1\x86\xB4",
		"\xE3\x84\xBF" => "\xE1\x86\xB5",
		"\xE3\x85\x80" => "\xE1\x84\x9A",
		"\xE3\x85\x81" => "\xE1\x84\x86",
		"\xE3\x85\x82" => "\xE1\x84\x87",
		"\xE3\x85\x83" => "\xE1\x84\x88",
		"\xE3\x85\x84" => "\xE1\x84\xA1",
		"\xE3\x85\x85" => "\xE1\x84\x89",
		"\xE3\x85\x86" => "\xE1\x84\x8A",
		"\xE3\x85\x87" => "\xE1\x84\x8B",
		"\xE3\x85\x88" => "\xE1\x84\x8C",
		"\xE3\x85\x89" => "\xE1\x84\x8D",
		"\xE3\x85\x8A" => "\xE1\x84\x8E",
		"\xE3\x85\x8B" => "\xE1\x84\x8F",
		"\xE3\x85\x8C" => "\xE1\x84\x90",
		"\xE3\x85\x8D" => "\xE1\x84\x91",
		"\xE3\x85\x8E" => "\xE1\x84\x92",
		"\xE3\x85\x8F" => "\xE1\x85\xA1",
		"\xE3\x85\x90" => "\xE1\x85\xA2",
		"\xE3\x85\x91" => "\xE1\x85\xA3",
		"\xE3\x85\x92" => "\xE1\x85\xA4",
		"\xE3\x85\x93" => "\xE1\x85\xA5",
		"\xE3\x85\x94" => "\xE1\x85\xA6",
		"\xE3\x85\x95" => "\xE1\x85\xA7",
		"\xE3\x85\x96" => "\xE1\x85\xA8",
		"\xE3\x85\x97" => "\xE1\x85\xA9",
		"\xE3\x85\x98" => "\xE1\x85\xAA",
		"\xE3\x85\x99" => "\xE1\x85\xAB",
		"\xE3\x85\x9A" => "\xE1\x85\xAC",
		"\xE3\x85\x9B" => "\xE1\x85\xAD",
		"\xE3\x85\x9C" => "\xE1\x85\xAE",
		"\xE3\x85\x9D" => "\xE1\x85\xAF",
		"\xE3\x85\x9E" => "\xE1\x85\xB0",
		"\xE3\x85\x9F" => "\xE1\x85\xB1",
		"\xE3\x85\xA0" => "\xE1\x85\xB2",
		"\xE3\x85\xA1" => "\xE1\x85\xB3",
		"\xE3\x85\xA2" => "\xE1\x85\xB4",
		"\xE3\x85\xA3" => "\xE1\x85\xB5",
		"\xE3\x85\xA5" => "\xE1\x84\x94",
		"\xE3\x85\xA6" => "\xE1\x84\x95",
		"\xE3\x85\xA7" => "\xE1\x87\x87",
		"\xE3\x85\xA8" => "\xE1\x87\x88",
		"\xE3\x85\xA9" => "\xE1\x87\x8C",
		"\xE3\x85\xAA" => "\xE1\x87\x8E",
		"\xE3\x85\xAB" => "\xE1\x87\x93",
		"\xE3\x85\xAC" => "\xE1\x87\x97",
		"\xE3\x85\xAD" => "\xE1\x87\x99",
		"\xE3\x85\xAE" => "\xE1\x84\x9C",
		"\xE3\x85\xAF" => "\xE1\x87\x9D",
		"\xE3\x85\xB0" => "\xE1\x87\x9F",
		"\xE3\x85\xB1" => "\xE1\x84\x9D",
		"\xE3\x85\xB2" => "\xE1\x84\x9E",
		"\xE3\x85\xB3" => "\xE1\x84\xA0",
		"\xE3\x85\xB4" => "\xE1\x84\xA2",
		"\xE3\x85\xB5" => "\xE1\x84\xA3",
		"\xE3\x85\xB6" => "\xE1\x84\xA7",
		"\xE3\x85\xB7" => "\xE1\x84\xA9",
		"\xE3\x85\xB8" => "\xE1\x84\xAB",
		"\xE3\x85\xB9" => "\xE1\x84\xAC",
		"\xE3\x85\xBA" => "\xE1\x84\xAD",
		"\xE3\x85\xBB" => "\xE1\x84\xAE",
		"\xE3\x85\xBC" => "\xE1\x84\xAF",
		"\xE3\x85\xBD" => "\xE1\x84\xB2",
		"\xE3\x85\xBE" => "\xE1\x84\xB6",
		"\xE3\x85\xBF" => "\xE1\x85\x80",
		"\xE3\x86\x80" => "\xE1\x85\x87",
		"\xE3\x86\x81" => "\xE1\x85\x8C",
		"\xE3\x86\x82" => "\xE1\x87\xB1",
		"\xE3\x86\x83" => "\xE1\x87\xB2",
		"\xE3\x86\x84" => "\xE1\x85\x97",
		"\xE3\x86\x85" => "\xE1\x85\x98",
		"\xE3\x86\x86" => "\xE1\x85\x99",
		"\xE3\x86\x87" => "\xE1\x86\x84",
		"\xE3\x86\x88" => "\xE1\x86\x85",
		"\xE3\x86\x89" => "\xE1\x86\x88",
		"\xE3\x86\x8A" => "\xE1\x86\x91",
		"\xE3\x86\x8B" => "\xE1\x86\x92",
		"\xE3\x86\x8C" => "\xE1\x86\x94",
		"\xE3\x86\x8D" => "\xE1\x86\x9E",
		"\xE3\x86\x8E" => "\xE1\x86\xA1",
		"\xE3\x86\x92" => "\xE4\xB8\x80",
		"\xE3\x86\x93" => "\xE4\xBA\x8C",
		"\xE3\x86\x94" => "\xE4\xB8\x89",
		"\xE3\x86\x95" => "\xE5\x9B\x9B",
		"\xE3\x86\x96" => "\xE4\xB8\x8A",
		"\xE3\x86\x97" => "\xE4\xB8\xAD",
		"\xE3\x86\x98" => "\xE4\xB8\x8B",
		"\xE3\x86\x99" => "\xE7\x94\xB2",
		"\xE3\x86\x9A" => "\xE4\xB9\x99",
		"\xE3\x86\x9B" => "\xE4\xB8\x99",
		"\xE3\x86\x9C" => "\xE4\xB8\x81",
		"\xE3\x86\x9D" => "\xE5\xA4\xA9",
		"\xE3\x86\x9E" => "\xE5\x9C\xB0",
		"\xE3\x86\x9F" => "\xE4\xBA\xBA",
		"\xE3\x89\x84" => "\xE5\x95\x8F",
		"\xE3\x89\x85" => "\xE5\xB9\xBC",
		"\xE3\x89\x86" => "\xE6\x96\x87",
		"\xE3\x89\x87" => "\xE7\xAE\x8F",
		"\xE3\x89\x90" => "\x70\x74\x65",
		"\xE3\x89\x91" => "\x32\x31",
		"\xE3\x89\x92" => "\x32\x32",
		"\xE3\x89\x93" => "\x32\x33",
		"\xE3\x89\x94" => "\x32\x34",
		"\xE3\x89\x95" => "\x32\x35",
		"\xE3\x89\x96" => "\x32\x36",
		"\xE3\x89\x97" => "\x32\x37",
		"\xE3\x89\x98" => "\x32\x38",
		"\xE3\x89\x99" => "\x32\x39",
		"\xE3\x89\x9A" => "\x33\x30",
		"\xE3\x89\x9B" => "\x33\x31",
		"\xE3\x89\x9C" => "\x33\x32",
		"\xE3\x89\x9D" => "\x33\x33",
		"\xE3\x89\x9E" => "\x33\x34",
		"\xE3\x89\x9F" => "\x33\x35",
		"\xE3\x89\xA0" => "\xE1\x84\x80",
		"\xE3\x89\xA1" => "\xE1\x84\x82",
		"\xE3\x89\xA2" => "\xE1\x84\x83",
		"\xE3\x89\xA3" => "\xE1\x84\x85",
		"\xE3\x89\xA4" => "\xE1\x84\x86",
		"\xE3\x89\xA5" => "\xE1\x84\x87",
		"\xE3\x89\xA6" => "\xE1\x84\x89",
		"\xE3\x89\xA7" => "\xE1\x84\x8B",
		"\xE3\x89\xA8" => "\xE1\x84\x8C",
		"\xE3\x89\xA9" => "\xE1\x84\x8E",
		"\xE3\x89\xAA" => "\xE1\x84\x8F",
		"\xE3\x89\xAB" => "\xE1\x84\x90",
		"\xE3\x89\xAC" => "\xE1\x84\x91",
		"\xE3\x89\xAD" => "\xE1\x84\x92",
		"\xE3\x89\xAE" => "\xEA\xB0\x80",
		"\xE3\x89\xAF" => "\xEB\x82\x98",
		"\xE3\x89\xB0" => "\xEB\x8B\xA4",
		"\xE3\x89\xB1" => "\xEB\x9D\xBC",
		"\xE3\x89\xB2" => "\xEB\xA7\x88",
		"\xE3\x89\xB3" => "\xEB\xB0\x94",
		"\xE3\x89\xB4" => "\xEC\x82\xAC",
		"\xE3\x89\xB5" => "\xEC\x95\x84",
		"\xE3\x89\xB6" => "\xEC\x9E\x90",
		"\xE3\x89\xB7" => "\xEC\xB0\xA8",
		"\xE3\x89\xB8" => "\xEC\xB9\xB4",
		"\xE3\x89\xB9" => "\xED\x83\x80",
		"\xE3\x89\xBA" => "\xED\x8C\x8C",
		"\xE3\x89\xBB" => "\xED\x95\x98",
		"\xE3\x89\xBC" => "\xEC\xB0\xB8\xEA\xB3\xA0",
		"\xE3\x89\xBD" => "\xEC\xA3\xBC\xEC\x9D\x98",
		"\xE3\x89\xBE" => "\xEC\x9A\xB0",
		"\xE3\x8A\x80" => "\xE4\xB8\x80",
		"\xE3\x8A\x81" => "\xE4\xBA\x8C",
		"\xE3\x8A\x82" => "\xE4\xB8\x89",
		"\xE3\x8A\x83" => "\xE5\x9B\x9B",
		"\xE3\x8A\x84" => "\xE4\xBA\x94",
		"\xE3\x8A\x85" => "\xE5\x85\xAD",
		"\xE3\x8A\x86" => "\xE4\xB8\x83",
		"\xE3\x8A\x87" => "\xE5\x85\xAB",
		"\xE3\x8A\x88" => "\xE4\xB9\x9D",
		"\xE3\x8A\x89" => "\xE5\x8D\x81",
		"\xE3\x8A\x8A" => "\xE6\x9C\x88",
		"\xE3\x8A\x8B" => "\xE7\x81\xAB",
		"\xE3\x8A\x8C" => "\xE6\xB0\xB4",
		"\xE3\x8A\x8D" => "\xE6\x9C\xA8",
		"\xE3\x8A\x8E" => "\xE9\x87\x91",
		"\xE3\x8A\x8F" => "\xE5\x9C\x9F",
		"\xE3\x8A\x90" => "\xE6\x97\xA5",
		"\xE3\x8A\x91" => "\xE6\xA0\xAA",
		"\xE3\x8A\x92" => "\xE6\x9C\x89",
		"\xE3\x8A\x93" => "\xE7\xA4\xBE",
		"\xE3\x8A\x94" => "\xE5\x90\x8D",
		"\xE3\x8A\x95" => "\xE7\x89\xB9",
		"\xE3\x8A\x96" => "\xE8\xB2\xA1",
		"\xE3\x8A\x97" => "\xE7\xA5\x9D",
		"\xE3\x8A\x98" => "\xE5\x8A\xB4",
		"\xE3\x8A\x99" => "\xE7\xA7\x98",
		"\xE3\x8A\x9A" => "\xE7\x94\xB7",
		"\xE3\x8A\x9B" => "\xE5\xA5\xB3",
		"\xE3\x8A\x9C" => "\xE9\x81\xA9",
		"\xE3\x8A\x9D" => "\xE5\x84\xAA",
		"\xE3\x8A\x9E" => "\xE5\x8D\xB0",
		"\xE3\x8A\x9F" => "\xE6\xB3\xA8",
		"\xE3\x8A\xA0" => "\xE9\xA0\x85",
		"\xE3\x8A\xA1" => "\xE4\xBC\x91",
		"\xE3\x8A\xA2" => "\xE5\x86\x99",
		"\xE3\x8A\xA3" => "\xE6\xAD\xA3",
		"\xE3\x8A\xA4" => "\xE4\xB8\x8A",
		"\xE3\x8A\xA5" => "\xE4\xB8\xAD",
		"\xE3\x8A\xA6" => "\xE4\xB8\x8B",
		"\xE3\x8A\xA7" => "\xE5\xB7\xA6",
		"\xE3\x8A\xA8" => "\xE5\x8F\xB3",
		"\xE3\x8A\xA9" => "\xE5\x8C\xBB",
		"\xE3\x8A\xAA" => "\xE5\xAE\x97",
		"\xE3\x8A\xAB" => "\xE5\xAD\xA6",
		"\xE3\x8A\xAC" => "\xE7\x9B\xA3",
		"\xE3\x8A\xAD" => "\xE4\xBC\x81",
		"\xE3\x8A\xAE" => "\xE8\xB3\x87",
		"\xE3\x8A\xAF" => "\xE5\x8D\x94",
		"\xE3\x8A\xB0" => "\xE5\xA4\x9C",
		"\xE3\x8A\xB1" => "\x33\x36",
		"\xE3\x8A\xB2" => "\x33\x37",
		"\xE3\x8A\xB3" => "\x33\x38",
		"\xE3\x8A\xB4" => "\x33\x39",
		"\xE3\x8A\xB5" => "\x34\x30",
		"\xE3\x8A\xB6" => "\x34\x31",
		"\xE3\x8A\xB7" => "\x34\x32",
		"\xE3\x8A\xB8" => "\x34\x33",
		"\xE3\x8A\xB9" => "\x34\x34",
		"\xE3\x8A\xBA" => "\x34\x35",
		"\xE3\x8A\xBB" => "\x34\x36",
		"\xE3\x8A\xBC" => "\x34\x37",
		"\xE3\x8A\xBD" => "\x34\x38",
		"\xE3\x8A\xBE" => "\x34\x39",
		"\xE3\x8A\xBF" => "\x35\x30",
		"\xE3\x8B\x80" => "\x31\xE6\x9C\x88",
		"\xE3\x8B\x81" => "\x32\xE6\x9C\x88",
		"\xE3\x8B\x82" => "\x33\xE6\x9C\x88",
		"\xE3\x8B\x83" => "\x34\xE6\x9C\x88",
		"\xE3\x8B\x84" => "\x35\xE6\x9C\x88",
		"\xE3\x8B\x85" => "\x36\xE6\x9C\x88",
		"\xE3\x8B\x86" => "\x37\xE6\x9C\x88",
		"\xE3\x8B\x87" => "\x38\xE6\x9C\x88",
		"\xE3\x8B\x88" => "\x39\xE6\x9C\x88",
		"\xE3\x8B\x89" => "\x31\x30\xE6\x9C\x88",
		"\xE3\x8B\x8A" => "\x31\x31\xE6\x9C\x88",
		"\xE3\x8B\x8B" => "\x31\x32\xE6\x9C\x88",
		"\xE3\x8B\x8C" => "\x68\x67",
		"\xE3\x8B\x8D" => "\x65\x72\x67",
		"\xE3\x8B\x8E" => "\x65\x76",
		"\xE3\x8B\x8F" => "\x6C\x74\x64",
		"\xE3\x8B\x90" => "\xE3\x82\xA2",
		"\xE3\x8B\x91" => "\xE3\x82\xA4",
		"\xE3\x8B\x92" => "\xE3\x82\xA6",
		"\xE3\x8B\x93" => "\xE3\x82\xA8",
		"\xE3\x8B\x94" => "\xE3\x82\xAA",
		"\xE3\x8B\x95" => "\xE3\x82\xAB",
		"\xE3\x8B\x96" => "\xE3\x82\xAD",
		"\xE3\x8B\x97" => "\xE3\x82\xAF",
		"\xE3\x8B\x98" => "\xE3\x82\xB1",
		"\xE3\x8B\x99" => "\xE3\x82\xB3",
		"\xE3\x8B\x9A" => "\xE3\x82\xB5",
		"\xE3\x8B\x9B" => "\xE3\x82\xB7",
		"\xE3\x8B\x9C" => "\xE3\x82\xB9",
		"\xE3\x8B\x9D" => "\xE3\x82\xBB",
		"\xE3\x8B\x9E" => "\xE3\x82\xBD",
		"\xE3\x8B\x9F" => "\xE3\x82\xBF",
		"\xE3\x8B\xA0" => "\xE3\x83\x81",
		"\xE3\x8B\xA1" => "\xE3\x83\x84",
		"\xE3\x8B\xA2" => "\xE3\x83\x86",
		"\xE3\x8B\xA3" => "\xE3\x83\x88",
		"\xE3\x8B\xA4" => "\xE3\x83\x8A",
		"\xE3\x8B\xA5" => "\xE3\x83\x8B",
		"\xE3\x8B\xA6" => "\xE3\x83\x8C",
		"\xE3\x8B\xA7" => "\xE3\x83\x8D",
		"\xE3\x8B\xA8" => "\xE3\x83\x8E",
		"\xE3\x8B\xA9" => "\xE3\x83\x8F",
		"\xE3\x8B\xAA" => "\xE3\x83\x92",
		"\xE3\x8B\xAB" => "\xE3\x83\x95",
		"\xE3\x8B\xAC" => "\xE3\x83\x98",
		"\xE3\x8B\xAD" => "\xE3\x83\x9B",
		"\xE3\x8B\xAE" => "\xE3\x83\x9E",
		"\xE3\x8B\xAF" => "\xE3\x83\x9F",
		"\xE3\x8B\xB0" => "\xE3\x83\xA0",
		"\xE3\x8B\xB1" => "\xE3\x83\xA1",
		"\xE3\x8B\xB2" => "\xE3\x83\xA2",
		"\xE3\x8B\xB3" => "\xE3\x83\xA4",
		"\xE3\x8B\xB4" => "\xE3\x83\xA6",
		"\xE3\x8B\xB5" => "\xE3\x83\xA8",
		"\xE3\x8B\xB6" => "\xE3\x83\xA9",
		"\xE3\x8B\xB7" => "\xE3\x83\xAA",
		"\xE3\x8B\xB8" => "\xE3\x83\xAB",
		"\xE3\x8B\xB9" => "\xE3\x83\xAC",
		"\xE3\x8B\xBA" => "\xE3\x83\xAD",
		"\xE3\x8B\xBB" => "\xE3\x83\xAF",
		"\xE3\x8B\xBC" => "\xE3\x83\xB0",
		"\xE3\x8B\xBD" => "\xE3\x83\xB1",
		"\xE3\x8B\xBE" => "\xE3\x83\xB2",
		"\xE3\x8B\xBF" => "\xE4\xBB\xA4\xE5\x92\x8C",
		"\xE3\x8C\x80" => "\xE3\x82\xA2\xE3\x83\x91\xE3\x83\xBC\xE3\x83\x88",
		"\xE3\x8C\x81" => "\xE3\x82\xA2\xE3\x83\xAB\xE3\x83\x95\xE3\x82\xA1",
		"\xE3\x8C\x82" => "\xE3\x82\xA2\xE3\x83\xB3\xE3\x83\x9A\xE3\x82\xA2",
		"\xE3\x8C\x83" => "\xE3\x82\xA2\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8C\x84" => "\xE3\x82\xA4\xE3\x83\x8B\xE3\x83\xB3\xE3\x82\xB0",
		"\xE3\x8C\x85" => "\xE3\x82\xA4\xE3\x83\xB3\xE3\x83\x81",
		"\xE3\x8C\x86" => "\xE3\x82\xA6\xE3\x82\xA9\xE3\x83\xB3",
		"\xE3\x8C\x87" => "\xE3\x82\xA8\xE3\x82\xB9\xE3\x82\xAF\xE3\x83\xBC\xE3\x83\x89",
		"\xE3\x8C\x88" => "\xE3\x82\xA8\xE3\x83\xBC\xE3\x82\xAB\xE3\x83\xBC",
		"\xE3\x8C\x89" => "\xE3\x82\xAA\xE3\x83\xB3\xE3\x82\xB9",
		"\xE3\x8C\x8A" => "\xE3\x82\xAA\xE3\x83\xBC\xE3\x83\xA0",
		"\xE3\x8C\x8B" => "\xE3\x82\xAB\xE3\x82\xA4\xE3\x83\xAA",
		"\xE3\x8C\x8C" => "\xE3\x82\xAB\xE3\x83\xA9\xE3\x83\x83\xE3\x83\x88",
		"\xE3\x8C\x8D" => "\xE3\x82\xAB\xE3\x83\xAD\xE3\x83\xAA\xE3\x83\xBC",
		"\xE3\x8C\x8E" => "\xE3\x82\xAC\xE3\x83\xAD\xE3\x83\xB3",
		"\xE3\x8C\x8F" => "\xE3\x82\xAC\xE3\x83\xB3\xE3\x83\x9E",
		"\xE3\x8C\x90" => "\xE3\x82\xAE\xE3\x82\xAC",
		"\xE3\x8C\x91" => "\xE3\x82\xAE\xE3\x83\x8B\xE3\x83\xBC",
		"\xE3\x8C\x92" => "\xE3\x82\xAD\xE3\x83\xA5\xE3\x83\xAA\xE3\x83\xBC",
		"\xE3\x8C\x93" => "\xE3\x82\xAE\xE3\x83\xAB\xE3\x83\x80\xE3\x83\xBC",
		"\xE3\x8C\x94" => "\xE3\x82\xAD\xE3\x83\xAD",
		"\xE3\x8C\x95" => "\xE3\x82\xAD\xE3\x83\xAD\xE3\x82\xB0\xE3\x83\xA9\xE3\x83\xA0",
		"\xE3\x8C\x96" => "\xE3\x82\xAD\xE3\x83\xAD\xE3\x83\xA1\xE3\x83\xBC\xE3\x83\x88\xE3\x83\xAB",
		"\xE3\x8C\x97" => "\xE3\x82\xAD\xE3\x83\xAD\xE3\x83\xAF\xE3\x83\x83\xE3\x83\x88",
		"\xE3\x8C\x98" => "\xE3\x82\xB0\xE3\x83\xA9\xE3\x83\xA0",
		"\xE3\x8C\x99" => "\xE3\x82\xB0\xE3\x83\xA9\xE3\x83\xA0\xE3\x83\x88\xE3\x83\xB3",
		"\xE3\x8C\x9A" => "\xE3\x82\xAF\xE3\x83\xAB\xE3\x82\xBC\xE3\x82\xA4\xE3\x83\xAD",
		"\xE3\x8C\x9B" => "\xE3\x82\xAF\xE3\x83\xAD\xE3\x83\xBC\xE3\x83\x8D",
		"\xE3\x8C\x9C" => "\xE3\x82\xB1\xE3\x83\xBC\xE3\x82\xB9",
		"\xE3\x8C\x9D" => "\xE3\x82\xB3\xE3\x83\xAB\xE3\x83\x8A",
		"\xE3\x8C\x9E" => "\xE3\x82\xB3\xE3\x83\xBC\xE3\x83\x9D",
		"\xE3\x8C\x9F" => "\xE3\x82\xB5\xE3\x82\xA4\xE3\x82\xAF\xE3\x83\xAB",
		"\xE3\x8C\xA0" => "\xE3\x82\xB5\xE3\x83\xB3\xE3\x83\x81\xE3\x83\xBC\xE3\x83\xA0",
		"\xE3\x8C\xA1" => "\xE3\x82\xB7\xE3\x83\xAA\xE3\x83\xB3\xE3\x82\xB0",
		"\xE3\x8C\xA2" => "\xE3\x82\xBB\xE3\x83\xB3\xE3\x83\x81",
		"\xE3\x8C\xA3" => "\xE3\x82\xBB\xE3\x83\xB3\xE3\x83\x88",
		"\xE3\x8C\xA4" => "\xE3\x83\x80\xE3\x83\xBC\xE3\x82\xB9",
		"\xE3\x8C\xA5" => "\xE3\x83\x87\xE3\x82\xB7",
		"\xE3\x8C\xA6" => "\xE3\x83\x89\xE3\x83\xAB",
		"\xE3\x8C\xA7" => "\xE3\x83\x88\xE3\x83\xB3",
		"\xE3\x8C\xA8" => "\xE3\x83\x8A\xE3\x83\x8E",
		"\xE3\x8C\xA9" => "\xE3\x83\x8E\xE3\x83\x83\xE3\x83\x88",
		"\xE3\x8C\xAA" => "\xE3\x83\x8F\xE3\x82\xA4\xE3\x83\x84",
		"\xE3\x8C\xAB" => "\xE3\x83\x91\xE3\x83\xBC\xE3\x82\xBB\xE3\x83\xB3\xE3\x83\x88",
		"\xE3\x8C\xAC" => "\xE3\x83\x91\xE3\x83\xBC\xE3\x83\x84",
		"\xE3\x8C\xAD" => "\xE3\x83\x90\xE3\x83\xBC\xE3\x83\xAC\xE3\x83\xAB",
		"\xE3\x8C\xAE" => "\xE3\x83\x94\xE3\x82\xA2\xE3\x82\xB9\xE3\x83\x88\xE3\x83\xAB",
		"\xE3\x8C\xAF" => "\xE3\x83\x94\xE3\x82\xAF\xE3\x83\xAB",
		"\xE3\x8C\xB0" => "\xE3\x83\x94\xE3\x82\xB3",
		"\xE3\x8C\xB1" => "\xE3\x83\x93\xE3\x83\xAB",
		"\xE3\x8C\xB2" => "\xE3\x83\x95\xE3\x82\xA1\xE3\x83\xA9\xE3\x83\x83\xE3\x83\x89",
		"\xE3\x8C\xB3" => "\xE3\x83\x95\xE3\x82\xA3\xE3\x83\xBC\xE3\x83\x88",
		"\xE3\x8C\xB4" => "\xE3\x83\x96\xE3\x83\x83\xE3\x82\xB7\xE3\x82\xA7\xE3\x83\xAB",
		"\xE3\x8C\xB5" => "\xE3\x83\x95\xE3\x83\xA9\xE3\x83\xB3",
		"\xE3\x8C\xB6" => "\xE3\x83\x98\xE3\x82\xAF\xE3\x82\xBF\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8C\xB7" => "\xE3\x83\x9A\xE3\x82\xBD",
		"\xE3\x8C\xB8" => "\xE3\x83\x9A\xE3\x83\x8B\xE3\x83\x92",
		"\xE3\x8C\xB9" => "\xE3\x83\x98\xE3\x83\xAB\xE3\x83\x84",
		"\xE3\x8C\xBA" => "\xE3\x83\x9A\xE3\x83\xB3\xE3\x82\xB9",
		"\xE3\x8C\xBB" => "\xE3\x83\x9A\xE3\x83\xBC\xE3\x82\xB8",
		"\xE3\x8C\xBC" => "\xE3\x83\x99\xE3\x83\xBC\xE3\x82\xBF",
		"\xE3\x8C\xBD" => "\xE3\x83\x9D\xE3\x82\xA4\xE3\x83\xB3\xE3\x83\x88",
		"\xE3\x8C\xBE" => "\xE3\x83\x9C\xE3\x83\xAB\xE3\x83\x88",
		"\xE3\x8C\xBF" => "\xE3\x83\x9B\xE3\x83\xB3",
		"\xE3\x8D\x80" => "\xE3\x83\x9D\xE3\x83\xB3\xE3\x83\x89",
		"\xE3\x8D\x81" => "\xE3\x83\x9B\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8D\x82" => "\xE3\x83\x9B\xE3\x83\xBC\xE3\x83\xB3",
		"\xE3\x8D\x83" => "\xE3\x83\x9E\xE3\x82\xA4\xE3\x82\xAF\xE3\x83\xAD",
		"\xE3\x8D\x84" => "\xE3\x83\x9E\xE3\x82\xA4\xE3\x83\xAB",
		"\xE3\x8D\x85" => "\xE3\x83\x9E\xE3\x83\x83\xE3\x83\x8F",
		"\xE3\x8D\x86" => "\xE3\x83\x9E\xE3\x83\xAB\xE3\x82\xAF",
		"\xE3\x8D\x87" => "\xE3\x83\x9E\xE3\x83\xB3\xE3\x82\xB7\xE3\x83\xA7\xE3\x83\xB3",
		"\xE3\x8D\x88" => "\xE3\x83\x9F\xE3\x82\xAF\xE3\x83\xAD\xE3\x83\xB3",
		"\xE3\x8D\x89" => "\xE3\x83\x9F\xE3\x83\xAA",
		"\xE3\x8D\x8A" => "\xE3\x83\x9F\xE3\x83\xAA\xE3\x83\x90\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8D\x8B" => "\xE3\x83\xA1\xE3\x82\xAC",
		"\xE3\x8D\x8C" => "\xE3\x83\xA1\xE3\x82\xAC\xE3\x83\x88\xE3\x83\xB3",
		"\xE3\x8D\x8D" => "\xE3\x83\xA1\xE3\x83\xBC\xE3\x83\x88\xE3\x83\xAB",
		"\xE3\x8D\x8E" => "\xE3\x83\xA4\xE3\x83\xBC\xE3\x83\x89",
		"\xE3\x8D\x8F" => "\xE3\x83\xA4\xE3\x83\xBC\xE3\x83\xAB",
		"\xE3\x8D\x90" => "\xE3\x83\xA6\xE3\x82\xA2\xE3\x83\xB3",
		"\xE3\x8D\x91" => "\xE3\x83\xAA\xE3\x83\x83\xE3\x83\x88\xE3\x83\xAB",
		"\xE3\x8D\x92" => "\xE3\x83\xAA\xE3\x83\xA9",
		"\xE3\x8D\x93" => "\xE3\x83\xAB\xE3\x83\x94\xE3\x83\xBC",
		"\xE3\x8D\x94" => "\xE3\x83\xAB\xE3\x83\xBC\xE3\x83\x96\xE3\x83\xAB",
		"\xE3\x8D\x95" => "\xE3\x83\xAC\xE3\x83\xA0",
		"\xE3\x8D\x96" => "\xE3\x83\xAC\xE3\x83\xB3\xE3\x83\x88\xE3\x82\xB2\xE3\x83\xB3",
		"\xE3\x8D\x97" => "\xE3\x83\xAF\xE3\x83\x83\xE3\x83\x88",
		"\xE3\x8D\x98" => "\x30\xE7\x82\xB9",
		"\xE3\x8D\x99" => "\x31\xE7\x82\xB9",
		"\xE3\x8D\x9A" => "\x32\xE7\x82\xB9",
		"\xE3\x8D\x9B" => "\x33\xE7\x82\xB9",
		"\xE3\x8D\x9C" => "\x34\xE7\x82\xB9",
		"\xE3\x8D\x9D" => "\x35\xE7\x82\xB9",
		"\xE3\x8D\x9E" => "\x36\xE7\x82\xB9",
		"\xE3\x8D\x9F" => "\x37\xE7\x82\xB9",
		"\xE3\x8D\xA0" => "\x38\xE7\x82\xB9",
		"\xE3\x8D\xA1" => "\x39\xE7\x82\xB9",
		"\xE3\x8D\xA2" => "\x31\x30\xE7\x82\xB9",
		"\xE3\x8D\xA3" => "\x31\x31\xE7\x82\xB9",
		"\xE3\x8D\xA4" => "\x31\x32\xE7\x82\xB9",
		"\xE3\x8D\xA5" => "\x31\x33\xE7\x82\xB9",
		"\xE3\x8D\xA6" => "\x31\x34\xE7\x82\xB9",
		"\xE3\x8D\xA7" => "\x31\x35\xE7\x82\xB9",
		"\xE3\x8D\xA8" => "\x31\x36\xE7\x82\xB9",
		"\xE3\x8D\xA9" => "\x31\x37\xE7\x82\xB9",
		"\xE3\x8D\xAA" => "\x31\x38\xE7\x82\xB9",
		"\xE3\x8D\xAB" => "\x31\x39\xE7\x82\xB9",
		"\xE3\x8D\xAC" => "\x32\x30\xE7\x82\xB9",
		"\xE3\x8D\xAD" => "\x32\x31\xE7\x82\xB9",
		"\xE3\x8D\xAE" => "\x32\x32\xE7\x82\xB9",
		"\xE3\x8D\xAF" => "\x32\x33\xE7\x82\xB9",
		"\xE3\x8D\xB0" => "\x32\x34\xE7\x82\xB9",
		"\xE3\x8D\xB1" => "\x68\x70\x61",
		"\xE3\x8D\xB2" => "\x64\x61",
		"\xE3\x8D\xB3" => "\x61\x75",
		"\xE3\x8D\xB4" => "\x62\x61\x72",
		"\xE3\x8D\xB5" => "\x6F\x76",
		"\xE3\x8D\xB6" => "\x70\x63",
		"\xE3\x8D\xB7" => "\x64\x6D",
		"\xE3\x8D\xB8" => "\x64\x6D\x32",
		"\xE3\x8D\xB9" => "\x64\x6D\x33",
		"\xE3\x8D\xBA" => "\x69\x75",
		"\xE3\x8D\xBB" => "\xE5\xB9\xB3\xE6\x88\x90",
		"\xE3\x8D\xBC" => "\xE6\x98\xAD\xE5\x92\x8C",
		"\xE3\x8D\xBD" => "\xE5\xA4\xA7\xE6\xAD\xA3",
		"\xE3\x8D\xBE" => "\xE6\x98\x8E\xE6\xB2\xBB",
		"\xE3\x8D\xBF" => "\xE6\xA0\xAA\xE5\xBC\x8F\xE4\xBC\x9A\xE7\xA4\xBE",
		"\xE3\x8E\x80" => "\x70\x61",
		"\xE3\x8E\x81" => "\x6E\x61",
		"\xE3\x8E\x82" => "\xCE\xBC\x61",
		"\xE3\x8E\x83" => "\x6D\x61",
		"\xE3\x8E\x84" => "\x6B\x61",
		"\xE3\x8E\x85" => "\x6B\x62",
		"\xE3\x8E\x86" => "\x6D\x62",
		"\xE3\x8E\x87" => "\x67\x62",
		"\xE3\x8E\x88" => "\x63\x61\x6C",
		"\xE3\x8E\x89" => "\x6B\x63\x61\x6C",
		"\xE3\x8E\x8A" => "\x70\x66",
		"\xE3\x8E\x8B" => "\x6E\x66",
		"\xE3\x8E\x8C" => "\xCE\xBC\x66",
		"\xE3\x8E\x8D" => "\xCE\xBC\x67",
		"\xE3\x8E\x8E" => "\x6D\x67",
		"\xE3\x8E\x8F" => "\x6B\x67",
		"\xE3\x8E\x90" => "\x68\x7A",
		"\xE3\x8E\x91" => "\x6B\x68\x7A",
		"\xE3\x8E\x92" => "\x6D\x68\x7A",
		"\xE3\x8E\x93" => "\x67\x68\x7A",
		"\xE3\x8E\x94" => "\x74\x68\x7A",
		"\xE3\x8E\x95" => "\xCE\xBC\x6C",
		"\xE3\x8E\x96" => "\x6D\x6C",
		"\xE3\x8E\x97" => "\x64\x6C",
		"\xE3\x8E\x98" => "\x6B\x6C",
		"\xE3\x8E\x99" => "\x66\x6D",
		"\xE3\x8E\x9A" => "\x6E\x6D",
		"\xE3\x8E\x9B" => "\xCE\xBC\x6D",
		"\xE3\x8E\x9C" => "\x6D\x6D",
		"\xE3\x8E\x9D" => "\x63\x6D",
		"\xE3\x8E\x9E" => "\x6B\x6D",
		"\xE3\x8E\x9F" => "\x6D\x6D\x32",
		"\xE3\x8E\xA0" => "\x63\x6D\x32",
		"\xE3\x8E\xA1" => "\x6D\x32",
		"\xE3\x8E\xA2" => "\x6B\x6D\x32",
		"\xE3\x8E\xA3" => "\x6D\x6D\x33",
		"\xE3\x8E\xA4" => "\x63\x6D\x33",
		"\xE3\x8E\xA5" => "\x6D\x33",
		"\xE3\x8E\xA6" => "\x6B\x6D\x33",
		"\xE3\x8E\xA7" => "\x6D\xE2\x88\x95\x73",
		"\xE3\x8E\xA8" => "\x6D\xE2\x88\x95\x73\x32",
		"\xE3\x8E\xA9" => "\x70\x61",
		"\xE3\x8E\xAA" => "\x6B\x70\x61",
		"\xE3\x8E\xAB" => "\x6D\x70\x61",
		"\xE3\x8E\xAC" => "\x67\x70\x61",
		"\xE3\x8E\xAD" => "\x72\x61\x64",
		"\xE3\x8E\xAE" => "\x72\x61\x64\xE2\x88\x95\x73",
		"\xE3\x8E\xAF" => "\x72\x61\x64\xE2\x88\x95\x73\x32",
		"\xE3\x8E\xB0" => "\x70\x73",
		"\xE3\x8E\xB1" => "\x6E\x73",
		"\xE3\x8E\xB2" => "\xCE\xBC\x73",
		"\xE3\x8E\xB3" => "\x6D\x73",
		"\xE3\x8E\xB4" => "\x70\x76",
		"\xE3\x8E\xB5" => "\x6E\x76",
		"\xE3\x8E\xB6" => "\xCE\xBC\x76",
		"\xE3\x8E\xB7" => "\x6D\x76",
		"\xE3\x8E\xB8" => "\x6B\x76",
		"\xE3\x8E\xB9" => "\x6D\x76",
		"\xE3\x8E\xBA" => "\x70\x77",
		"\xE3\x8E\xBB" => "\x6E\x77",
		"\xE3\x8E\xBC" => "\xCE\xBC\x77",
		"\xE3\x8E\xBD" => "\x6D\x77",
		"\xE3\x8E\xBE" => "\x6B\x77",
		"\xE3\x8E\xBF" => "\x6D\x77",
		"\xE3\x8F\x80" => "\x6B\xCF\x89",
		"\xE3\x8F\x81" => "\x6D\xCF\x89",
		"\xE3\x8F\x83" => "\x62\x71",
		"\xE3\x8F\x84" => "\x63\x63",
		"\xE3\x8F\x85" => "\x63\x64",
		"\xE3\x8F\x86" => "\x63\xE2\x88\x95\x6B\x67",
		"\xE3\x8F\x88" => "\x64\x62",
		"\xE3\x8F\x89" => "\x67\x79",
		"\xE3\x8F\x8A" => "\x68\x61",
		"\xE3\x8F\x8B" => "\x68\x70",
		"\xE3\x8F\x8C" => "\x69\x6E",
		"\xE3\x8F\x8D" => "\x6B\x6B",
		"\xE3\x8F\x8E" => "\x6B\x6D",
		"\xE3\x8F\x8F" => "\x6B\x74",
		"\xE3\x8F\x90" => "\x6C\x6D",
		"\xE3\x8F\x91" => "\x6C\x6E",
		"\xE3\x8F\x92" => "\x6C\x6F\x67",
		"\xE3\x8F\x93" => "\x6C\x78",
		"\xE3\x8F\x94" => "\x6D\x62",
		"\xE3\x8F\x95" => "\x6D\x69\x6C",
		"\xE3\x8F\x96" => "\x6D\x6F\x6C",
		"\xE3\x8F\x97" => "\x70\x68",
		"\xE3\x8F\x99" => "\x70\x70\x6D",
		"\xE3\x8F\x9A" => "\x70\x72",
		"\xE3\x8F\x9B" => "\x73\x72",
		"\xE3\x8F\x9C" => "\x73\x76",
		"\xE3\x8F\x9D" => "\x77\x62",
		"\xE3\x8F\x9E" => "\x76\xE2\x88\x95\x6D",
		"\xE3\x8F\x9F" => "\x61\xE2\x88\x95\x6D",
		"\xE3\x8F\xA0" => "\x31\xE6\x97\xA5",
		"\xE3\x8F\xA1" => "\x32\xE6\x97\xA5",
		"\xE3\x8F\xA2" => "\x33\xE6\x97\xA5",
		"\xE3\x8F\xA3" => "\x34\xE6\x97\xA5",
		"\xE3\x8F\xA4" => "\x35\xE6\x97\xA5",
		"\xE3\x8F\xA5" => "\x36\xE6\x97\xA5",
		"\xE3\x8F\xA6" => "\x37\xE6\x97\xA5",
		"\xE3\x8F\xA7" => "\x38\xE6\x97\xA5",
		"\xE3\x8F\xA8" => "\x39\xE6\x97\xA5",
		"\xE3\x8F\xA9" => "\x31\x30\xE6\x97\xA5",
		"\xE3\x8F\xAA" => "\x31\x31\xE6\x97\xA5",
		"\xE3\x8F\xAB" => "\x31\x32\xE6\x97\xA5",
		"\xE3\x8F\xAC" => "\x31\x33\xE6\x97\xA5",
		"\xE3\x8F\xAD" => "\x31\x34\xE6\x97\xA5",
		"\xE3\x8F\xAE" => "\x31\x35\xE6\x97\xA5",
		"\xE3\x8F\xAF" => "\x31\x36\xE6\x97\xA5",
		"\xE3\x8F\xB0" => "\x31\x37\xE6\x97\xA5",
		"\xE3\x8F\xB1" => "\x31\x38\xE6\x97\xA5",
		"\xE3\x8F\xB2" => "\x31\x39\xE6\x97\xA5",
		"\xE3\x8F\xB3" => "\x32\x30\xE6\x97\xA5",
		"\xE3\x8F\xB4" => "\x32\x31\xE6\x97\xA5",
		"\xE3\x8F\xB5" => "\x32\x32\xE6\x97\xA5",
		"\xE3\x8F\xB6" => "\x32\x33\xE6\x97\xA5",
		"\xE3\x8F\xB7" => "\x32\x34\xE6\x97\xA5",
		"\xE3\x8F\xB8" => "\x32\x35\xE6\x97\xA5",
		"\xE3\x8F\xB9" => "\x32\x36\xE6\x97\xA5",
		"\xE3\x8F\xBA" => "\x32\x37\xE6\x97\xA5",
		"\xE3\x8F\xBB" => "\x32\x38\xE6\x97\xA5",
		"\xE3\x8F\xBC" => "\x32\x39\xE6\x97\xA5",
		"\xE3\x8F\xBD" => "\x33\x30\xE6\x97\xA5",
		"\xE3\x8F\xBE" => "\x33\x31\xE6\x97\xA5",
		"\xE3\x8F\xBF" => "\x67\x61\x6C",
		"\xEA\x99\x80" => "\xEA\x99\x81",
		"\xEA\x99\x82" => "\xEA\x99\x83",
		"\xEA\x99\x84" => "\xEA\x99\x85",
		"\xEA\x99\x86" => "\xEA\x99\x87",
		"\xEA\x99\x88" => "\xEA\x99\x89",
		"\xEA\x99\x8A" => "\xEA\x99\x8B",
		"\xEA\x99\x8C" => "\xEA\x99\x8D",
		"\xEA\x99\x8E" => "\xEA\x99\x8F",
		"\xEA\x99\x90" => "\xEA\x99\x91",
		"\xEA\x99\x92" => "\xEA\x99\x93",
		"\xEA\x99\x94" => "\xEA\x99\x95",
		"\xEA\x99\x96" => "\xEA\x99\x97",
		"\xEA\x99\x98" => "\xEA\x99\x99",
		"\xEA\x99\x9A" => "\xEA\x99\x9B",
		"\xEA\x99\x9C" => "\xEA\x99\x9D",
		"\xEA\x99\x9E" => "\xEA\x99\x9F",
		"\xEA\x99\xA0" => "\xEA\x99\xA1",
		"\xEA\x99\xA2" => "\xEA\x99\xA3",
		"\xEA\x99\xA4" => "\xEA\x99\xA5",
		"\xEA\x99\xA6" => "\xEA\x99\xA7",
		"\xEA\x99\xA8" => "\xEA\x99\xA9",
		"\xEA\x99\xAA" => "\xEA\x99\xAB",
		"\xEA\x99\xAC" => "\xEA\x99\xAD",
		"\xEA\x9A\x80" => "\xEA\x9A\x81",
		"\xEA\x9A\x82" => "\xEA\x9A\x83",
		"\xEA\x9A\x84" => "\xEA\x9A\x85",
		"\xEA\x9A\x86" => "\xEA\x9A\x87",
		"\xEA\x9A\x88" => "\xEA\x9A\x89",
		"\xEA\x9A\x8A" => "\xEA\x9A\x8B",
		"\xEA\x9A\x8C" => "\xEA\x9A\x8D",
		"\xEA\x9A\x8E" => "\xEA\x9A\x8F",
		"\xEA\x9A\x90" => "\xEA\x9A\x91",
		"\xEA\x9A\x92" => "\xEA\x9A\x93",
		"\xEA\x9A\x94" => "\xEA\x9A\x95",
		"\xEA\x9A\x96" => "\xEA\x9A\x97",
		"\xEA\x9A\x98" => "\xEA\x9A\x99",
		"\xEA\x9A\x9A" => "\xEA\x9A\x9B",
		"\xEA\x9A\x9C" => "\xD1\x8A",
		"\xEA\x9A\x9D" => "\xD1\x8C",
		"\xEA\x9C\xA2" => "\xEA\x9C\xA3",
		"\xEA\x9C\xA4" => "\xEA\x9C\xA5",
		"\xEA\x9C\xA6" => "\xEA\x9C\xA7",
		"\xEA\x9C\xA8" => "\xEA\x9C\xA9",
		"\xEA\x9C\xAA" => "\xEA\x9C\xAB",
		"\xEA\x9C\xAC" => "\xEA\x9C\xAD",
		"\xEA\x9C\xAE" => "\xEA\x9C\xAF",
		"\xEA\x9C\xB2" => "\xEA\x9C\xB3",
		"\xEA\x9C\xB4" => "\xEA\x9C\xB5",
		"\xEA\x9C\xB6" => "\xEA\x9C\xB7",
		"\xEA\x9C\xB8" => "\xEA\x9C\xB9",
		"\xEA\x9C\xBA" => "\xEA\x9C\xBB",
		"\xEA\x9C\xBC" => "\xEA\x9C\xBD",
		"\xEA\x9C\xBE" => "\xEA\x9C\xBF",
		"\xEA\x9D\x80" => "\xEA\x9D\x81",
		"\xEA\x9D\x82" => "\xEA\x9D\x83",
		"\xEA\x9D\x84" => "\xEA\x9D\x85",
		"\xEA\x9D\x86" => "\xEA\x9D\x87",
		"\xEA\x9D\x88" => "\xEA\x9D\x89",
		"\xEA\x9D\x8A" => "\xEA\x9D\x8B",
		"\xEA\x9D\x8C" => "\xEA\x9D\x8D",
		"\xEA\x9D\x8E" => "\xEA\x9D\x8F",
		"\xEA\x9D\x90" => "\xEA\x9D\x91",
		"\xEA\x9D\x92" => "\xEA\x9D\x93",
		"\xEA\x9D\x94" => "\xEA\x9D\x95",
		"\xEA\x9D\x96" => "\xEA\x9D\x97",
		"\xEA\x9D\x98" => "\xEA\x9D\x99",
		"\xEA\x9D\x9A" => "\xEA\x9D\x9B",
		"\xEA\x9D\x9C" => "\xEA\x9D\x9D",
		"\xEA\x9D\x9E" => "\xEA\x9D\x9F",
		"\xEA\x9D\xA0" => "\xEA\x9D\xA1",
		"\xEA\x9D\xA2" => "\xEA\x9D\xA3",
		"\xEA\x9D\xA4" => "\xEA\x9D\xA5",
		"\xEA\x9D\xA6" => "\xEA\x9D\xA7",
		"\xEA\x9D\xA8" => "\xEA\x9D\xA9",
		"\xEA\x9D\xAA" => "\xEA\x9D\xAB",
		"\xEA\x9D\xAC" => "\xEA\x9D\xAD",
		"\xEA\x9D\xAE" => "\xEA\x9D\xAF",
		"\xEA\x9D\xB0" => "\xEA\x9D\xAF",
		"\xEA\x9D\xB9" => "\xEA\x9D\xBA",
		"\xEA\x9D\xBB" => "\xEA\x9D\xBC",
		"\xEA\x9D\xBD" => "\xE1\xB5\xB9",
		"\xEA\x9D\xBE" => "\xEA\x9D\xBF",
		"\xEA\x9E\x80" => "\xEA\x9E\x81",
		"\xEA\x9E\x82" => "\xEA\x9E\x83",
		"\xEA\x9E\x84" => "\xEA\x9E\x85",
		"\xEA\x9E\x86" => "\xEA\x9E\x87",
		"\xEA\x9E\x8B" => "\xEA\x9E\x8C",
		"\xEA\x9E\x8D" => "\xC9\xA5",
		"\xEA\x9E\x90" => "\xEA\x9E\x91",
		"\xEA\x9E\x92" => "\xEA\x9E\x93",
		"\xEA\x9E\x96" => "\xEA\x9E\x97",
		"\xEA\x9E\x98" => "\xEA\x9E\x99",
		"\xEA\x9E\x9A" => "\xEA\x9E\x9B",
		"\xEA\x9E\x9C" => "\xEA\x9E\x9D",
		"\xEA\x9E\x9E" => "\xEA\x9E\x9F",
		"\xEA\x9E\xA0" => "\xEA\x9E\xA1",
		"\xEA\x9E\xA2" => "\xEA\x9E\xA3",
		"\xEA\x9E\xA4" => "\xEA\x9E\xA5",
		"\xEA\x9E\xA6" => "\xEA\x9E\xA7",
		"\xEA\x9E\xA8" => "\xEA\x9E\xA9",
		"\xEA\x9E\xAA" => "\xC9\xA6",
		"\xEA\x9E\xAB" => "\xC9\x9C",
		"\xEA\x9E\xAC" => "\xC9\xA1",
		"\xEA\x9E\xAD" => "\xC9\xAC",
		"\xEA\x9E\xAE" => "\xC9\xAA",
		"\xEA\x9E\xB0" => "\xCA\x9E",
		"\xEA\x9E\xB1" => "\xCA\x87",
		"\xEA\x9E\xB2" => "\xCA\x9D",
		"\xEA\x9E\xB3" => "\xEA\xAD\x93",
		"\xEA\x9E\xB4" => "\xEA\x9E\xB5",
		"\xEA\x9E\xB6" => "\xEA\x9E\xB7",
		"\xEA\x9E\xB8" => "\xEA\x9E\xB9",
		"\xEA\x9E\xBA" => "\xEA\x9E\xBB",
		"\xEA\x9E\xBC" => "\xEA\x9E\xBD",
		"\xEA\x9E\xBE" => "\xEA\x9E\xBF",
		"\xEA\x9F\x80" => "\xEA\x9F\x81",
		"\xEA\x9F\x82" => "\xEA\x9F\x83",
		"\xEA\x9F\x84" => "\xEA\x9E\x94",
		"\xEA\x9F\x85" => "\xCA\x82",
		"\xEA\x9F\x86" => "\xE1\xB6\x8E",
		"\xEA\x9F\x87" => "\xEA\x9F\x88",
		"\xEA\x9F\x89" => "\xEA\x9F\x8A",
		"\xEA\x9F\x90" => "\xEA\x9F\x91",
		"\xEA\x9F\x96" => "\xEA\x9F\x97",
		"\xEA\x9F\x98" => "\xEA\x9F\x99",
		"\xEA\x9F\xB2" => "\x63",
		"\xEA\x9F\xB3" => "\x66",
		"\xEA\x9F\xB4" => "\x71",
		"\xEA\x9F\xB5" => "\xEA\x9F\xB6",
		"\xEA\x9F\xB8" => "\xC4\xA7",
		"\xEA\x9F\xB9" => "\xC5\x93",
		"\xEA\xAD\x9C" => "\xEA\x9C\xA7",
		"\xEA\xAD\x9D" => "\xEA\xAC\xB7",
		"\xEA\xAD\x9E" => "\xC9\xAB",
		"\xEA\xAD\x9F" => "\xEA\xAD\x92",
		"\xEA\xAD\xA9" => "\xCA\x8D",
		"\xEA\xAD\xB0" => "\xE1\x8E\xA0",
		"\xEA\xAD\xB1" => "\xE1\x8E\xA1",
		"\xEA\xAD\xB2" => "\xE1\x8E\xA2",
		"\xEA\xAD\xB3" => "\xE1\x8E\xA3",
		"\xEA\xAD\xB4" => "\xE1\x8E\xA4",
		"\xEA\xAD\xB5" => "\xE1\x8E\xA5",
		"\xEA\xAD\xB6" => "\xE1\x8E\xA6",
		"\xEA\xAD\xB7" => "\xE1\x8E\xA7",
		"\xEA\xAD\xB8" => "\xE1\x8E\xA8",
		"\xEA\xAD\xB9" => "\xE1\x8E\xA9",
		"\xEA\xAD\xBA" => "\xE1\x8E\xAA",
		"\xEA\xAD\xBB" => "\xE1\x8E\xAB",
		"\xEA\xAD\xBC" => "\xE1\x8E\xAC",
		"\xEA\xAD\xBD" => "\xE1\x8E\xAD",
		"\xEA\xAD\xBE" => "\xE1\x8E\xAE",
		"\xEA\xAD\xBF" => "\xE1\x8E\xAF",
		"\xEA\xAE\x80" => "\xE1\x8E\xB0",
		"\xEA\xAE\x81" => "\xE1\x8E\xB1",
		"\xEA\xAE\x82" => "\xE1\x8E\xB2",
		"\xEA\xAE\x83" => "\xE1\x8E\xB3",
		"\xEA\xAE\x84" => "\xE1\x8E\xB4",
		"\xEA\xAE\x85" => "\xE1\x8E\xB5",
		"\xEA\xAE\x86" => "\xE1\x8E\xB6",
		"\xEA\xAE\x87" => "\xE1\x8E\xB7",
		"\xEA\xAE\x88" => "\xE1\x8E\xB8",
		"\xEA\xAE\x89" => "\xE1\x8E\xB9",
		"\xEA\xAE\x8A" => "\xE1\x8E\xBA",
		"\xEA\xAE\x8B" => "\xE1\x8E\xBB",
		"\xEA\xAE\x8C" => "\xE1\x8E\xBC",
		"\xEA\xAE\x8D" => "\xE1\x8E\xBD",
		"\xEA\xAE\x8E" => "\xE1\x8E\xBE",
		"\xEA\xAE\x8F" => "\xE1\x8E\xBF",
		"\xEA\xAE\x90" => "\xE1\x8F\x80",
		"\xEA\xAE\x91" => "\xE1\x8F\x81",
		"\xEA\xAE\x92" => "\xE1\x8F\x82",
		"\xEA\xAE\x93" => "\xE1\x8F\x83",
		"\xEA\xAE\x94" => "\xE1\x8F\x84",
		"\xEA\xAE\x95" => "\xE1\x8F\x85",
		"\xEA\xAE\x96" => "\xE1\x8F\x86",
		"\xEA\xAE\x97" => "\xE1\x8F\x87",
		"\xEA\xAE\x98" => "\xE1\x8F\x88",
		"\xEA\xAE\x99" => "\xE1\x8F\x89",
		"\xEA\xAE\x9A" => "\xE1\x8F\x8A",
		"\xEA\xAE\x9B" => "\xE1\x8F\x8B",
		"\xEA\xAE\x9C" => "\xE1\x8F\x8C",
		"\xEA\xAE\x9D" => "\xE1\x8F\x8D",
		"\xEA\xAE\x9E" => "\xE1\x8F\x8E",
		"\xEA\xAE\x9F" => "\xE1\x8F\x8F",
		"\xEA\xAE\xA0" => "\xE1\x8F\x90",
		"\xEA\xAE\xA1" => "\xE1\x8F\x91",
		"\xEA\xAE\xA2" => "\xE1\x8F\x92",
		"\xEA\xAE\xA3" => "\xE1\x8F\x93",
		"\xEA\xAE\xA4" => "\xE1\x8F\x94",
		"\xEA\xAE\xA5" => "\xE1\x8F\x95",
		"\xEA\xAE\xA6" => "\xE1\x8F\x96",
		"\xEA\xAE\xA7" => "\xE1\x8F\x97",
		"\xEA\xAE\xA8" => "\xE1\x8F\x98",
		"\xEA\xAE\xA9" => "\xE1\x8F\x99",
		"\xEA\xAE\xAA" => "\xE1\x8F\x9A",
		"\xEA\xAE\xAB" => "\xE1\x8F\x9B",
		"\xEA\xAE\xAC" => "\xE1\x8F\x9C",
		"\xEA\xAE\xAD" => "\xE1\x8F\x9D",
		"\xEA\xAE\xAE" => "\xE1\x8F\x9E",
		"\xEA\xAE\xAF" => "\xE1\x8F\x9F",
		"\xEA\xAE\xB0" => "\xE1\x8F\xA0",
		"\xEA\xAE\xB1" => "\xE1\x8F\xA1",
		"\xEA\xAE\xB2" => "\xE1\x8F\xA2",
		"\xEA\xAE\xB3" => "\xE1\x8F\xA3",
		"\xEA\xAE\xB4" => "\xE1\x8F\xA4",
		"\xEA\xAE\xB5" => "\xE1\x8F\xA5",
		"\xEA\xAE\xB6" => "\xE1\x8F\xA6",
		"\xEA\xAE\xB7" => "\xE1\x8F\xA7",
		"\xEA\xAE\xB8" => "\xE1\x8F\xA8",
		"\xEA\xAE\xB9" => "\xE1\x8F\xA9",
		"\xEA\xAE\xBA" => "\xE1\x8F\xAA",
		"\xEA\xAE\xBB" => "\xE1\x8F\xAB",
		"\xEA\xAE\xBC" => "\xE1\x8F\xAC",
		"\xEA\xAE\xBD" => "\xE1\x8F\xAD",
		"\xEA\xAE\xBE" => "\xE1\x8F\xAE",
		"\xEA\xAE\xBF" => "\xE1\x8F\xAF",
		"\xEF\xA4\x80" => "\xE8\xB1\x88",
		"\xEF\xA4\x81" => "\xE6\x9B\xB4",
		"\xEF\xA4\x82" => "\xE8\xBB\x8A",
		"\xEF\xA4\x83" => "\xE8\xB3\x88",
		"\xEF\xA4\x84" => "\xE6\xBB\x91",
		"\xEF\xA4\x85" => "\xE4\xB8\xB2",
		"\xEF\xA4\x86" => "\xE5\x8F\xA5",
		"\xEF\xA4\x87" => "\xE9\xBE\x9C",
		"\xEF\xA4\x88" => "\xE9\xBE\x9C",
		"\xEF\xA4\x89" => "\xE5\xA5\x91",
		"\xEF\xA4\x8A" => "\xE9\x87\x91",
		"\xEF\xA4\x8B" => "\xE5\x96\x87",
		"\xEF\xA4\x8C" => "\xE5\xA5\x88",
		"\xEF\xA4\x8D" => "\xE6\x87\xB6",
		"\xEF\xA4\x8E" => "\xE7\x99\xA9",
		"\xEF\xA4\x8F" => "\xE7\xBE\x85",
		"\xEF\xA4\x90" => "\xE8\x98\xBF",
		"\xEF\xA4\x91" => "\xE8\x9E\xBA",
		"\xEF\xA4\x92" => "\xE8\xA3\xB8",
		"\xEF\xA4\x93" => "\xE9\x82\x8F",
		"\xEF\xA4\x94" => "\xE6\xA8\x82",
		"\xEF\xA4\x95" => "\xE6\xB4\x9B",
		"\xEF\xA4\x96" => "\xE7\x83\x99",
		"\xEF\xA4\x97" => "\xE7\x8F\x9E",
		"\xEF\xA4\x98" => "\xE8\x90\xBD",
		"\xEF\xA4\x99" => "\xE9\x85\xAA",
		"\xEF\xA4\x9A" => "\xE9\xA7\xB1",
		"\xEF\xA4\x9B" => "\xE4\xBA\x82",
		"\xEF\xA4\x9C" => "\xE5\x8D\xB5",
		"\xEF\xA4\x9D" => "\xE6\xAC\x84",
		"\xEF\xA4\x9E" => "\xE7\x88\x9B",
		"\xEF\xA4\x9F" => "\xE8\x98\xAD",
		"\xEF\xA4\xA0" => "\xE9\xB8\x9E",
		"\xEF\xA4\xA1" => "\xE5\xB5\x90",
		"\xEF\xA4\xA2" => "\xE6\xBF\xAB",
		"\xEF\xA4\xA3" => "\xE8\x97\x8D",
		"\xEF\xA4\xA4" => "\xE8\xA5\xA4",
		"\xEF\xA4\xA5" => "\xE6\x8B\x89",
		"\xEF\xA4\xA6" => "\xE8\x87\x98",
		"\xEF\xA4\xA7" => "\xE8\xA0\x9F",
		"\xEF\xA4\xA8" => "\xE5\xBB\x8A",
		"\xEF\xA4\xA9" => "\xE6\x9C\x97",
		"\xEF\xA4\xAA" => "\xE6\xB5\xAA",
		"\xEF\xA4\xAB" => "\xE7\x8B\xBC",
		"\xEF\xA4\xAC" => "\xE9\x83\x8E",
		"\xEF\xA4\xAD" => "\xE4\xBE\x86",
		"\xEF\xA4\xAE" => "\xE5\x86\xB7",
		"\xEF\xA4\xAF" => "\xE5\x8B\x9E",
		"\xEF\xA4\xB0" => "\xE6\x93\x84",
		"\xEF\xA4\xB1" => "\xE6\xAB\x93",
		"\xEF\xA4\xB2" => "\xE7\x88\x90",
		"\xEF\xA4\xB3" => "\xE7\x9B\xA7",
		"\xEF\xA4\xB4" => "\xE8\x80\x81",
		"\xEF\xA4\xB5" => "\xE8\x98\x86",
		"\xEF\xA4\xB6" => "\xE8\x99\x9C",
		"\xEF\xA4\xB7" => "\xE8\xB7\xAF",
		"\xEF\xA4\xB8" => "\xE9\x9C\xB2",
		"\xEF\xA4\xB9" => "\xE9\xAD\xAF",
		"\xEF\xA4\xBA" => "\xE9\xB7\xBA",
		"\xEF\xA4\xBB" => "\xE7\xA2\x8C",
		"\xEF\xA4\xBC" => "\xE7\xA5\xBF",
		"\xEF\xA4\xBD" => "\xE7\xB6\xA0",
		"\xEF\xA4\xBE" => "\xE8\x8F\x89",
		"\xEF\xA4\xBF" => "\xE9\x8C\x84",
		"\xEF\xA5\x80" => "\xE9\xB9\xBF",
		"\xEF\xA5\x81" => "\xE8\xAB\x96",
		"\xEF\xA5\x82" => "\xE5\xA3\x9F",
		"\xEF\xA5\x83" => "\xE5\xBC\x84",
		"\xEF\xA5\x84" => "\xE7\xB1\xA0",
		"\xEF\xA5\x85" => "\xE8\x81\xBE",
		"\xEF\xA5\x86" => "\xE7\x89\xA2",
		"\xEF\xA5\x87" => "\xE7\xA3\x8A",
		"\xEF\xA5\x88" => "\xE8\xB3\x82",
		"\xEF\xA5\x89" => "\xE9\x9B\xB7",
		"\xEF\xA5\x8A" => "\xE5\xA3\x98",
		"\xEF\xA5\x8B" => "\xE5\xB1\xA2",
		"\xEF\xA5\x8C" => "\xE6\xA8\x93",
		"\xEF\xA5\x8D" => "\xE6\xB7\x9A",
		"\xEF\xA5\x8E" => "\xE6\xBC\x8F",
		"\xEF\xA5\x8F" => "\xE7\xB4\xAF",
		"\xEF\xA5\x90" => "\xE7\xB8\xB7",
		"\xEF\xA5\x91" => "\xE9\x99\x8B",
		"\xEF\xA5\x92" => "\xE5\x8B\x92",
		"\xEF\xA5\x93" => "\xE8\x82\x8B",
		"\xEF\xA5\x94" => "\xE5\x87\x9C",
		"\xEF\xA5\x95" => "\xE5\x87\x8C",
		"\xEF\xA5\x96" => "\xE7\xA8\x9C",
		"\xEF\xA5\x97" => "\xE7\xB6\xBE",
		"\xEF\xA5\x98" => "\xE8\x8F\xB1",
		"\xEF\xA5\x99" => "\xE9\x99\xB5",
		"\xEF\xA5\x9A" => "\xE8\xAE\x80",
		"\xEF\xA5\x9B" => "\xE6\x8B\x8F",
		"\xEF\xA5\x9C" => "\xE6\xA8\x82",
		"\xEF\xA5\x9D" => "\xE8\xAB\xBE",
		"\xEF\xA5\x9E" => "\xE4\xB8\xB9",
		"\xEF\xA5\x9F" => "\xE5\xAF\xA7",
		"\xEF\xA5\xA0" => "\xE6\x80\x92",
		"\xEF\xA5\xA1" => "\xE7\x8E\x87",
		"\xEF\xA5\xA2" => "\xE7\x95\xB0",
		"\xEF\xA5\xA3" => "\xE5\x8C\x97",
		"\xEF\xA5\xA4" => "\xE7\xA3\xBB",
		"\xEF\xA5\xA5" => "\xE4\xBE\xBF",
		"\xEF\xA5\xA6" => "\xE5\xBE\xA9",
		"\xEF\xA5\xA7" => "\xE4\xB8\x8D",
		"\xEF\xA5\xA8" => "\xE6\xB3\x8C",
		"\xEF\xA5\xA9" => "\xE6\x95\xB8",
		"\xEF\xA5\xAA" => "\xE7\xB4\xA2",
		"\xEF\xA5\xAB" => "\xE5\x8F\x83",
		"\xEF\xA5\xAC" => "\xE5\xA1\x9E",
		"\xEF\xA5\xAD" => "\xE7\x9C\x81",
		"\xEF\xA5\xAE" => "\xE8\x91\x89",
		"\xEF\xA5\xAF" => "\xE8\xAA\xAA",
		"\xEF\xA5\xB0" => "\xE6\xAE\xBA",
		"\xEF\xA5\xB1" => "\xE8\xBE\xB0",
		"\xEF\xA5\xB2" => "\xE6\xB2\x88",
		"\xEF\xA5\xB3" => "\xE6\x8B\xBE",
		"\xEF\xA5\xB4" => "\xE8\x8B\xA5",
		"\xEF\xA5\xB5" => "\xE6\x8E\xA0",
		"\xEF\xA5\xB6" => "\xE7\x95\xA5",
		"\xEF\xA5\xB7" => "\xE4\xBA\xAE",
		"\xEF\xA5\xB8" => "\xE5\x85\xA9",
		"\xEF\xA5\xB9" => "\xE5\x87\x89",
		"\xEF\xA5\xBA" => "\xE6\xA2\x81",
		"\xEF\xA5\xBB" => "\xE7\xB3\xA7",
		"\xEF\xA5\xBC" => "\xE8\x89\xAF",
		"\xEF\xA5\xBD" => "\xE8\xAB\x92",
		"\xEF\xA5\xBE" => "\xE9\x87\x8F",
		"\xEF\xA5\xBF" => "\xE5\x8B\xB5",
		"\xEF\xA6\x80" => "\xE5\x91\x82",
		"\xEF\xA6\x81" => "\xE5\xA5\xB3",
		"\xEF\xA6\x82" => "\xE5\xBB\xAC",
		"\xEF\xA6\x83" => "\xE6\x97\x85",
		"\xEF\xA6\x84" => "\xE6\xBF\xBE",
		"\xEF\xA6\x85" => "\xE7\xA4\xAA",
		"\xEF\xA6\x86" => "\xE9\x96\xAD",
		"\xEF\xA6\x87" => "\xE9\xA9\xAA",
		"\xEF\xA6\x88" => "\xE9\xBA\x97",
		"\xEF\xA6\x89" => "\xE9\xBB\x8E",
		"\xEF\xA6\x8A" => "\xE5\x8A\x9B",
		"\xEF\xA6\x8B" => "\xE6\x9B\x86",
		"\xEF\xA6\x8C" => "\xE6\xAD\xB7",
		"\xEF\xA6\x8D" => "\xE8\xBD\xA2",
		"\xEF\xA6\x8E" => "\xE5\xB9\xB4",
		"\xEF\xA6\x8F" => "\xE6\x86\x90",
		"\xEF\xA6\x90" => "\xE6\x88\x80",
		"\xEF\xA6\x91" => "\xE6\x92\x9A",
		"\xEF\xA6\x92" => "\xE6\xBC\xA3",
		"\xEF\xA6\x93" => "\xE7\x85\x89",
		"\xEF\xA6\x94" => "\xE7\x92\x89",
		"\xEF\xA6\x95" => "\xE7\xA7\x8A",
		"\xEF\xA6\x96" => "\xE7\xB7\xB4",
		"\xEF\xA6\x97" => "\xE8\x81\xAF",
		"\xEF\xA6\x98" => "\xE8\xBC\xA6",
		"\xEF\xA6\x99" => "\xE8\x93\xAE",
		"\xEF\xA6\x9A" => "\xE9\x80\xA3",
		"\xEF\xA6\x9B" => "\xE9\x8D\x8A",
		"\xEF\xA6\x9C" => "\xE5\x88\x97",
		"\xEF\xA6\x9D" => "\xE5\x8A\xA3",
		"\xEF\xA6\x9E" => "\xE5\x92\xBD",
		"\xEF\xA6\x9F" => "\xE7\x83\x88",
		"\xEF\xA6\xA0" => "\xE8\xA3\x82",
		"\xEF\xA6\xA1" => "\xE8\xAA\xAA",
		"\xEF\xA6\xA2" => "\xE5\xBB\x89",
		"\xEF\xA6\xA3" => "\xE5\xBF\xB5",
		"\xEF\xA6\xA4" => "\xE6\x8D\xBB",
		"\xEF\xA6\xA5" => "\xE6\xAE\xAE",
		"\xEF\xA6\xA6" => "\xE7\xB0\xBE",
		"\xEF\xA6\xA7" => "\xE7\x8D\xB5",
		"\xEF\xA6\xA8" => "\xE4\xBB\xA4",
		"\xEF\xA6\xA9" => "\xE5\x9B\xB9",
		"\xEF\xA6\xAA" => "\xE5\xAF\xA7",
		"\xEF\xA6\xAB" => "\xE5\xB6\xBA",
		"\xEF\xA6\xAC" => "\xE6\x80\x9C",
		"\xEF\xA6\xAD" => "\xE7\x8E\xB2",
		"\xEF\xA6\xAE" => "\xE7\x91\xA9",
		"\xEF\xA6\xAF" => "\xE7\xBE\x9A",
		"\xEF\xA6\xB0" => "\xE8\x81\x86",
		"\xEF\xA6\xB1" => "\xE9\x88\xB4",
		"\xEF\xA6\xB2" => "\xE9\x9B\xB6",
		"\xEF\xA6\xB3" => "\xE9\x9D\x88",
		"\xEF\xA6\xB4" => "\xE9\xA0\x98",
		"\xEF\xA6\xB5" => "\xE4\xBE\x8B",
		"\xEF\xA6\xB6" => "\xE7\xA6\xAE",
		"\xEF\xA6\xB7" => "\xE9\x86\xB4",
		"\xEF\xA6\xB8" => "\xE9\x9A\xB8",
		"\xEF\xA6\xB9" => "\xE6\x83\xA1",
		"\xEF\xA6\xBA" => "\xE4\xBA\x86",
		"\xEF\xA6\xBB" => "\xE5\x83\x9A",
		"\xEF\xA6\xBC" => "\xE5\xAF\xAE",
		"\xEF\xA6\xBD" => "\xE5\xB0\xBF",
		"\xEF\xA6\xBE" => "\xE6\x96\x99",
		"\xEF\xA6\xBF" => "\xE6\xA8\x82",
		"\xEF\xA7\x80" => "\xE7\x87\x8E",
		"\xEF\xA7\x81" => "\xE7\x99\x82",
		"\xEF\xA7\x82" => "\xE8\x93\xBC",
		"\xEF\xA7\x83" => "\xE9\x81\xBC",
		"\xEF\xA7\x84" => "\xE9\xBE\x8D",
		"\xEF\xA7\x85" => "\xE6\x9A\x88",
		"\xEF\xA7\x86" => "\xE9\x98\xAE",
		"\xEF\xA7\x87" => "\xE5\x8A\x89",
		"\xEF\xA7\x88" => "\xE6\x9D\xBB",
		"\xEF\xA7\x89" => "\xE6\x9F\xB3",
		"\xEF\xA7\x8A" => "\xE6\xB5\x81",
		"\xEF\xA7\x8B" => "\xE6\xBA\x9C",
		"\xEF\xA7\x8C" => "\xE7\x90\x89",
		"\xEF\xA7\x8D" => "\xE7\x95\x99",
		"\xEF\xA7\x8E" => "\xE7\xA1\xAB",
		"\xEF\xA7\x8F" => "\xE7\xB4\x90",
		"\xEF\xA7\x90" => "\xE9\xA1\x9E",
		"\xEF\xA7\x91" => "\xE5\x85\xAD",
		"\xEF\xA7\x92" => "\xE6\x88\xAE",
		"\xEF\xA7\x93" => "\xE9\x99\xB8",
		"\xEF\xA7\x94" => "\xE5\x80\xAB",
		"\xEF\xA7\x95" => "\xE5\xB4\x99",
		"\xEF\xA7\x96" => "\xE6\xB7\xAA",
		"\xEF\xA7\x97" => "\xE8\xBC\xAA",
		"\xEF\xA7\x98" => "\xE5\xBE\x8B",
		"\xEF\xA7\x99" => "\xE6\x85\x84",
		"\xEF\xA7\x9A" => "\xE6\xA0\x97",
		"\xEF\xA7\x9B" => "\xE7\x8E\x87",
		"\xEF\xA7\x9C" => "\xE9\x9A\x86",
		"\xEF\xA7\x9D" => "\xE5\x88\xA9",
		"\xEF\xA7\x9E" => "\xE5\x90\x8F",
		"\xEF\xA7\x9F" => "\xE5\xB1\xA5",
		"\xEF\xA7\xA0" => "\xE6\x98\x93",
		"\xEF\xA7\xA1" => "\xE6\x9D\x8E",
		"\xEF\xA7\xA2" => "\xE6\xA2\xA8",
		"\xEF\xA7\xA3" => "\xE6\xB3\xA5",
		"\xEF\xA7\xA4" => "\xE7\x90\x86",
		"\xEF\xA7\xA5" => "\xE7\x97\xA2",
		"\xEF\xA7\xA6" => "\xE7\xBD\xB9",
		"\xEF\xA7\xA7" => "\xE8\xA3\x8F",
		"\xEF\xA7\xA8" => "\xE8\xA3\xA1",
		"\xEF\xA7\xA9" => "\xE9\x87\x8C",
		"\xEF\xA7\xAA" => "\xE9\x9B\xA2",
		"\xEF\xA7\xAB" => "\xE5\x8C\xBF",
		"\xEF\xA7\xAC" => "\xE6\xBA\xBA",
		"\xEF\xA7\xAD" => "\xE5\x90\x9D",
		"\xEF\xA7\xAE" => "\xE7\x87\x90",
		"\xEF\xA7\xAF" => "\xE7\x92\x98",
		"\xEF\xA7\xB0" => "\xE8\x97\xBA",
		"\xEF\xA7\xB1" => "\xE9\x9A\xA3",
		"\xEF\xA7\xB2" => "\xE9\xB1\x97",
		"\xEF\xA7\xB3" => "\xE9\xBA\x9F",
		"\xEF\xA7\xB4" => "\xE6\x9E\x97",
		"\xEF\xA7\xB5" => "\xE6\xB7\x8B",
		"\xEF\xA7\xB6" => "\xE8\x87\xA8",
		"\xEF\xA7\xB7" => "\xE7\xAB\x8B",
		"\xEF\xA7\xB8" => "\xE7\xAC\xA0",
		"\xEF\xA7\xB9" => "\xE7\xB2\x92",
		"\xEF\xA7\xBA" => "\xE7\x8B\x80",
		"\xEF\xA7\xBB" => "\xE7\x82\x99",
		"\xEF\xA7\xBC" => "\xE8\xAD\x98",
		"\xEF\xA7\xBD" => "\xE4\xBB\x80",
		"\xEF\xA7\xBE" => "\xE8\x8C\xB6",
		"\xEF\xA7\xBF" => "\xE5\x88\xBA",
		"\xEF\xA8\x80" => "\xE5\x88\x87",
		"\xEF\xA8\x81" => "\xE5\xBA\xA6",
		"\xEF\xA8\x82" => "\xE6\x8B\x93",
		"\xEF\xA8\x83" => "\xE7\xB3\x96",
		"\xEF\xA8\x84" => "\xE5\xAE\x85",
		"\xEF\xA8\x85" => "\xE6\xB4\x9E",
		"\xEF\xA8\x86" => "\xE6\x9A\xB4",
		"\xEF\xA8\x87" => "\xE8\xBC\xBB",
		"\xEF\xA8\x88" => "\xE8\xA1\x8C",
		"\xEF\xA8\x89" => "\xE9\x99\x8D",
		"\xEF\xA8\x8A" => "\xE8\xA6\x8B",
		"\xEF\xA8\x8B" => "\xE5\xBB\x93",
		"\xEF\xA8\x8C" => "\xE5\x85\x80",
		"\xEF\xA8\x8D" => "\xE5\x97\x80",
		"\xEF\xA8\x90" => "\xE5\xA1\x9A",
		"\xEF\xA8\x92" => "\xE6\x99\xB4",
		"\xEF\xA8\x95" => "\xE5\x87\x9E",
		"\xEF\xA8\x96" => "\xE7\x8C\xAA",
		"\xEF\xA8\x97" => "\xE7\x9B\x8A",
		"\xEF\xA8\x98" => "\xE7\xA4\xBC",
		"\xEF\xA8\x99" => "\xE7\xA5\x9E",
		"\xEF\xA8\x9A" => "\xE7\xA5\xA5",
		"\xEF\xA8\x9B" => "\xE7\xA6\x8F",
		"\xEF\xA8\x9C" => "\xE9\x9D\x96",
		"\xEF\xA8\x9D" => "\xE7\xB2\xBE",
		"\xEF\xA8\x9E" => "\xE7\xBE\xBD",
		"\xEF\xA8\xA0" => "\xE8\x98\x92",
		"\xEF\xA8\xA2" => "\xE8\xAB\xB8",
		"\xEF\xA8\xA5" => "\xE9\x80\xB8",
		"\xEF\xA8\xA6" => "\xE9\x83\xBD",
		"\xEF\xA8\xAA" => "\xE9\xA3\xAF",
		"\xEF\xA8\xAB" => "\xE9\xA3\xBC",
		"\xEF\xA8\xAC" => "\xE9\xA4\xA8",
		"\xEF\xA8\xAD" => "\xE9\xB6\xB4",
		"\xEF\xA8\xAE" => "\xE9\x83\x9E",
		"\xEF\xA8\xAF" => "\xE9\x9A\xB7",
		"\xEF\xA8\xB0" => "\xE4\xBE\xAE",
		"\xEF\xA8\xB1" => "\xE5\x83\xA7",
		"\xEF\xA8\xB2" => "\xE5\x85\x8D",
		"\xEF\xA8\xB3" => "\xE5\x8B\x89",
		"\xEF\xA8\xB4" => "\xE5\x8B\xA4",
		"\xEF\xA8\xB5" => "\xE5\x8D\x91",
		"\xEF\xA8\xB6" => "\xE5\x96\x9D",
		"\xEF\xA8\xB7" => "\xE5\x98\x86",
		"\xEF\xA8\xB8" => "\xE5\x99\xA8",
		"\xEF\xA8\xB9" => "\xE5\xA1\x80",
		"\xEF\xA8\xBA" => "\xE5\xA2\xA8",
		"\xEF\xA8\xBB" => "\xE5\xB1\xA4",
		"\xEF\xA8\xBC" => "\xE5\xB1\xAE",
		"\xEF\xA8\xBD" => "\xE6\x82\x94",
		"\xEF\xA8\xBE" => "\xE6\x85\xA8",
		"\xEF\xA8\xBF" => "\xE6\x86\x8E",
		"\xEF\xA9\x80" => "\xE6\x87\xB2",
		"\xEF\xA9\x81" => "\xE6\x95\x8F",
		"\xEF\xA9\x82" => "\xE6\x97\xA2",
		"\xEF\xA9\x83" => "\xE6\x9A\x91",
		"\xEF\xA9\x84" => "\xE6\xA2\x85",
		"\xEF\xA9\x85" => "\xE6\xB5\xB7",
		"\xEF\xA9\x86" => "\xE6\xB8\x9A",
		"\xEF\xA9\x87" => "\xE6\xBC\xA2",
		"\xEF\xA9\x88" => "\xE7\x85\xAE",
		"\xEF\xA9\x89" => "\xE7\x88\xAB",
		"\xEF\xA9\x8A" => "\xE7\x90\xA2",
		"\xEF\xA9\x8B" => "\xE7\xA2\x91",
		"\xEF\xA9\x8C" => "\xE7\xA4\xBE",
		"\xEF\xA9\x8D" => "\xE7\xA5\x89",
		"\xEF\xA9\x8E" => "\xE7\xA5\x88",
		"\xEF\xA9\x8F" => "\xE7\xA5\x90",
		"\xEF\xA9\x90" => "\xE7\xA5\x96",
		"\xEF\xA9\x91" => "\xE7\xA5\x9D",
		"\xEF\xA9\x92" => "\xE7\xA6\x8D",
		"\xEF\xA9\x93" => "\xE7\xA6\x8E",
		"\xEF\xA9\x94" => "\xE7\xA9\x80",
		"\xEF\xA9\x95" => "\xE7\xAA\x81",
		"\xEF\xA9\x96" => "\xE7\xAF\x80",
		"\xEF\xA9\x97" => "\xE7\xB7\xB4",
		"\xEF\xA9\x98" => "\xE7\xB8\x89",
		"\xEF\xA9\x99" => "\xE7\xB9\x81",
		"\xEF\xA9\x9A" => "\xE7\xBD\xB2",
		"\xEF\xA9\x9B" => "\xE8\x80\x85",
		"\xEF\xA9\x9C" => "\xE8\x87\xAD",
		"\xEF\xA9\x9D" => "\xE8\x89\xB9",
		"\xEF\xA9\x9E" => "\xE8\x89\xB9",
		"\xEF\xA9\x9F" => "\xE8\x91\x97",
		"\xEF\xA9\xA0" => "\xE8\xA4\x90",
		"\xEF\xA9\xA1" => "\xE8\xA6\x96",
		"\xEF\xA9\xA2" => "\xE8\xAC\x81",
		"\xEF\xA9\xA3" => "\xE8\xAC\xB9",
		"\xEF\xA9\xA4" => "\xE8\xB3\x93",
		"\xEF\xA9\xA5" => "\xE8\xB4\x88",
		"\xEF\xA9\xA6" => "\xE8\xBE\xB6",
		"\xEF\xA9\xA7" => "\xE9\x80\xB8",
		"\xEF\xA9\xA8" => "\xE9\x9B\xA3",
		"\xEF\xA9\xA9" => "\xE9\x9F\xBF",
		"\xEF\xA9\xAA" => "\xE9\xA0\xBB",
		"\xEF\xA9\xAB" => "\xE6\x81\xB5",
		"\xEF\xA9\xAC" => "\xF0\xA4\x8B\xAE",
		"\xEF\xA9\xAD" => "\xE8\x88\x98",
		"\xEF\xA9\xB0" => "\xE4\xB8\xA6",
		"\xEF\xA9\xB1" => "\xE5\x86\xB5",
		"\xEF\xA9\xB2" => "\xE5\x85\xA8",
		"\xEF\xA9\xB3" => "\xE4\xBE\x80",
		"\xEF\xA9\xB4" => "\xE5\x85\x85",
		"\xEF\xA9\xB5" => "\xE5\x86\x80",
		"\xEF\xA9\xB6" => "\xE5\x8B\x87",
		"\xEF\xA9\xB7" => "\xE5\x8B\xBA",
		"\xEF\xA9\xB8" => "\xE5\x96\x9D",
		"\xEF\xA9\xB9" => "\xE5\x95\x95",
		"\xEF\xA9\xBA" => "\xE5\x96\x99",
		"\xEF\xA9\xBB" => "\xE5\x97\xA2",
		"\xEF\xA9\xBC" => "\xE5\xA1\x9A",
		"\xEF\xA9\xBD" => "\xE5\xA2\xB3",
		"\xEF\xA9\xBE" => "\xE5\xA5\x84",
		"\xEF\xA9\xBF" => "\xE5\xA5\x94",
		"\xEF\xAA\x80" => "\xE5\xA9\xA2",
		"\xEF\xAA\x81" => "\xE5\xAC\xA8",
		"\xEF\xAA\x82" => "\xE5\xBB\x92",
		"\xEF\xAA\x83" => "\xE5\xBB\x99",
		"\xEF\xAA\x84" => "\xE5\xBD\xA9",
		"\xEF\xAA\x85" => "\xE5\xBE\xAD",
		"\xEF\xAA\x86" => "\xE6\x83\x98",
		"\xEF\xAA\x87" => "\xE6\x85\x8E",
		"\xEF\xAA\x88" => "\xE6\x84\x88",
		"\xEF\xAA\x89" => "\xE6\x86\x8E",
		"\xEF\xAA\x8A" => "\xE6\x85\xA0",
		"\xEF\xAA\x8B" => "\xE6\x87\xB2",
		"\xEF\xAA\x8C" => "\xE6\x88\xB4",
		"\xEF\xAA\x8D" => "\xE6\x8F\x84",
		"\xEF\xAA\x8E" => "\xE6\x90\x9C",
		"\xEF\xAA\x8F" => "\xE6\x91\x92",
		"\xEF\xAA\x90" => "\xE6\x95\x96",
		"\xEF\xAA\x91" => "\xE6\x99\xB4",
		"\xEF\xAA\x92" => "\xE6\x9C\x97",
		"\xEF\xAA\x93" => "\xE6\x9C\x9B",
		"\xEF\xAA\x94" => "\xE6\x9D\x96",
		"\xEF\xAA\x95" => "\xE6\xAD\xB9",
		"\xEF\xAA\x96" => "\xE6\xAE\xBA",
		"\xEF\xAA\x97" => "\xE6\xB5\x81",
		"\xEF\xAA\x98" => "\xE6\xBB\x9B",
		"\xEF\xAA\x99" => "\xE6\xBB\x8B",
		"\xEF\xAA\x9A" => "\xE6\xBC\xA2",
		"\xEF\xAA\x9B" => "\xE7\x80\x9E",
		"\xEF\xAA\x9C" => "\xE7\x85\xAE",
		"\xEF\xAA\x9D" => "\xE7\x9E\xA7",
		"\xEF\xAA\x9E" => "\xE7\x88\xB5",
		"\xEF\xAA\x9F" => "\xE7\x8A\xAF",
		"\xEF\xAA\xA0" => "\xE7\x8C\xAA",
		"\xEF\xAA\xA1" => "\xE7\x91\xB1",
		"\xEF\xAA\xA2" => "\xE7\x94\x86",
		"\xEF\xAA\xA3" => "\xE7\x94\xBB",
		"\xEF\xAA\xA4" => "\xE7\x98\x9D",
		"\xEF\xAA\xA5" => "\xE7\x98\x9F",
		"\xEF\xAA\xA6" => "\xE7\x9B\x8A",
		"\xEF\xAA\xA7" => "\xE7\x9B\x9B",
		"\xEF\xAA\xA8" => "\xE7\x9B\xB4",
		"\xEF\xAA\xA9" => "\xE7\x9D\x8A",
		"\xEF\xAA\xAA" => "\xE7\x9D\x80",
		"\xEF\xAA\xAB" => "\xE7\xA3\x8C",
		"\xEF\xAA\xAC" => "\xE7\xAA\xB1",
		"\xEF\xAA\xAD" => "\xE7\xAF\x80",
		"\xEF\xAA\xAE" => "\xE7\xB1\xBB",
		"\xEF\xAA\xAF" => "\xE7\xB5\x9B",
		"\xEF\xAA\xB0" => "\xE7\xB7\xB4",
		"\xEF\xAA\xB1" => "\xE7\xBC\xBE",
		"\xEF\xAA\xB2" => "\xE8\x80\x85",
		"\xEF\xAA\xB3" => "\xE8\x8D\x92",
		"\xEF\xAA\xB4" => "\xE8\x8F\xAF",
		"\xEF\xAA\xB5" => "\xE8\x9D\xB9",
		"\xEF\xAA\xB6" => "\xE8\xA5\x81",
		"\xEF\xAA\xB7" => "\xE8\xA6\x86",
		"\xEF\xAA\xB8" => "\xE8\xA6\x96",
		"\xEF\xAA\xB9" => "\xE8\xAA\xBF",
		"\xEF\xAA\xBA" => "\xE8\xAB\xB8",
		"\xEF\xAA\xBB" => "\xE8\xAB\x8B",
		"\xEF\xAA\xBC" => "\xE8\xAC\x81",
		"\xEF\xAA\xBD" => "\xE8\xAB\xBE",
		"\xEF\xAA\xBE" => "\xE8\xAB\xAD",
		"\xEF\xAA\xBF" => "\xE8\xAC\xB9",
		"\xEF\xAB\x80" => "\xE8\xAE\x8A",
		"\xEF\xAB\x81" => "\xE8\xB4\x88",
		"\xEF\xAB\x82" => "\xE8\xBC\xB8",
		"\xEF\xAB\x83" => "\xE9\x81\xB2",
		"\xEF\xAB\x84" => "\xE9\x86\x99",
		"\xEF\xAB\x85" => "\xE9\x89\xB6",
		"\xEF\xAB\x86" => "\xE9\x99\xBC",
		"\xEF\xAB\x87" => "\xE9\x9B\xA3",
		"\xEF\xAB\x88" => "\xE9\x9D\x96",
		"\xEF\xAB\x89" => "\xE9\x9F\x9B",
		"\xEF\xAB\x8A" => "\xE9\x9F\xBF",
		"\xEF\xAB\x8B" => "\xE9\xA0\x8B",
		"\xEF\xAB\x8C" => "\xE9\xA0\xBB",
		"\xEF\xAB\x8D" => "\xE9\xAC\x92",
		"\xEF\xAB\x8E" => "\xE9\xBE\x9C",
		"\xEF\xAB\x8F" => "\xF0\xA2\xA1\x8A",
		"\xEF\xAB\x90" => "\xF0\xA2\xA1\x84",
		"\xEF\xAB\x91" => "\xF0\xA3\x8F\x95",
		"\xEF\xAB\x92" => "\xE3\xAE\x9D",
		"\xEF\xAB\x93" => "\xE4\x80\x98",
		"\xEF\xAB\x94" => "\xE4\x80\xB9",
		"\xEF\xAB\x95" => "\xF0\xA5\x89\x89",
		"\xEF\xAB\x96" => "\xF0\xA5\xB3\x90",
		"\xEF\xAB\x97" => "\xF0\xA7\xBB\x93",
		"\xEF\xAB\x98" => "\xE9\xBD\x83",
		"\xEF\xAB\x99" => "\xE9\xBE\x8E",
		"\xEF\xAC\x80" => "\x66\x66",
		"\xEF\xAC\x81" => "\x66\x69",
		"\xEF\xAC\x82" => "\x66\x6C",
		"\xEF\xAC\x83" => "\x66\x66\x69",
		"\xEF\xAC\x84" => "\x66\x66\x6C",
		"\xEF\xAC\x85" => "\x73\x74",
		"\xEF\xAC\x86" => "\x73\x74",
		"\xEF\xAC\x93" => "\xD5\xB4\xD5\xB6",
		"\xEF\xAC\x94" => "\xD5\xB4\xD5\xA5",
		"\xEF\xAC\x95" => "\xD5\xB4\xD5\xAB",
		"\xEF\xAC\x96" => "\xD5\xBE\xD5\xB6",
		"\xEF\xAC\x97" => "\xD5\xB4\xD5\xAD",
		"\xEF\xAC\x9D" => "\xD7\x99\xD6\xB4",
		"\xEF\xAC\x9F" => "\xD7\xB2\xD6\xB7",
		"\xEF\xAC\xA0" => "\xD7\xA2",
		"\xEF\xAC\xA1" => "\xD7\x90",
		"\xEF\xAC\xA2" => "\xD7\x93",
		"\xEF\xAC\xA3" => "\xD7\x94",
		"\xEF\xAC\xA4" => "\xD7\x9B",
		"\xEF\xAC\xA5" => "\xD7\x9C",
		"\xEF\xAC\xA6" => "\xD7\x9D",
		"\xEF\xAC\xA7" => "\xD7\xA8",
		"\xEF\xAC\xA8" => "\xD7\xAA",
		"\xEF\xAC\xAA" => "\xD7\xA9\xD7\x81",
		"\xEF\xAC\xAB" => "\xD7\xA9\xD7\x82",
		"\xEF\xAC\xAC" => "\xD7\xA9\xD6\xBC\xD7\x81",
		"\xEF\xAC\xAD" => "\xD7\xA9\xD6\xBC\xD7\x82",
		"\xEF\xAC\xAE" => "\xD7\x90\xD6\xB7",
		"\xEF\xAC\xAF" => "\xD7\x90\xD6\xB8",
		"\xEF\xAC\xB0" => "\xD7\x90\xD6\xBC",
		"\xEF\xAC\xB1" => "\xD7\x91\xD6\xBC",
		"\xEF\xAC\xB2" => "\xD7\x92\xD6\xBC",
		"\xEF\xAC\xB3" => "\xD7\x93\xD6\xBC",
		"\xEF\xAC\xB4" => "\xD7\x94\xD6\xBC",
		"\xEF\xAC\xB5" => "\xD7\x95\xD6\xBC",
		"\xEF\xAC\xB6" => "\xD7\x96\xD6\xBC",
		"\xEF\xAC\xB8" => "\xD7\x98\xD6\xBC",
		"\xEF\xAC\xB9" => "\xD7\x99\xD6\xBC",
		"\xEF\xAC\xBA" => "\xD7\x9A\xD6\xBC",
		"\xEF\xAC\xBB" => "\xD7\x9B\xD6\xBC",
		"\xEF\xAC\xBC" => "\xD7\x9C\xD6\xBC",
		"\xEF\xAC\xBE" => "\xD7\x9E\xD6\xBC",
		"\xEF\xAD\x80" => "\xD7\xA0\xD6\xBC",
		"\xEF\xAD\x81" => "\xD7\xA1\xD6\xBC",
		"\xEF\xAD\x83" => "\xD7\xA3\xD6\xBC",
		"\xEF\xAD\x84" => "\xD7\xA4\xD6\xBC",
		"\xEF\xAD\x86" => "\xD7\xA6\xD6\xBC",
		"\xEF\xAD\x87" => "\xD7\xA7\xD6\xBC",
		"\xEF\xAD\x88" => "\xD7\xA8\xD6\xBC",
		"\xEF\xAD\x89" => "\xD7\xA9\xD6\xBC",
		"\xEF\xAD\x8A" => "\xD7\xAA\xD6\xBC",
		"\xEF\xAD\x8B" => "\xD7\x95\xD6\xB9",
		"\xEF\xAD\x8C" => "\xD7\x91\xD6\xBF",
		"\xEF\xAD\x8D" => "\xD7\x9B\xD6\xBF",
		"\xEF\xAD\x8E" => "\xD7\xA4\xD6\xBF",
		"\xEF\xAD\x8F" => "\xD7\x90\xD7\x9C",
		"\xEF\xAD\x90" => "\xD9\xB1",
		"\xEF\xAD\x91" => "\xD9\xB1",
		"\xEF\xAD\x92" => "\xD9\xBB",
		"\xEF\xAD\x93" => "\xD9\xBB",
		"\xEF\xAD\x94" => "\xD9\xBB",
		"\xEF\xAD\x95" => "\xD9\xBB",
		"\xEF\xAD\x96" => "\xD9\xBE",
		"\xEF\xAD\x97" => "\xD9\xBE",
		"\xEF\xAD\x98" => "\xD9\xBE",
		"\xEF\xAD\x99" => "\xD9\xBE",
		"\xEF\xAD\x9A" => "\xDA\x80",
		"\xEF\xAD\x9B" => "\xDA\x80",
		"\xEF\xAD\x9C" => "\xDA\x80",
		"\xEF\xAD\x9D" => "\xDA\x80",
		"\xEF\xAD\x9E" => "\xD9\xBA",
		"\xEF\xAD\x9F" => "\xD9\xBA",
		"\xEF\xAD\xA0" => "\xD9\xBA",
		"\xEF\xAD\xA1" => "\xD9\xBA",
		"\xEF\xAD\xA2" => "\xD9\xBF",
		"\xEF\xAD\xA3" => "\xD9\xBF",
		"\xEF\xAD\xA4" => "\xD9\xBF",
		"\xEF\xAD\xA5" => "\xD9\xBF",
		"\xEF\xAD\xA6" => "\xD9\xB9",
		"\xEF\xAD\xA7" => "\xD9\xB9",
		"\xEF\xAD\xA8" => "\xD9\xB9",
		"\xEF\xAD\xA9" => "\xD9\xB9",
		"\xEF\xAD\xAA" => "\xDA\xA4",
		"\xEF\xAD\xAB" => "\xDA\xA4",
		"\xEF\xAD\xAC" => "\xDA\xA4",
		"\xEF\xAD\xAD" => "\xDA\xA4",
		"\xEF\xAD\xAE" => "\xDA\xA6",
		"\xEF\xAD\xAF" => "\xDA\xA6",
		"\xEF\xAD\xB0" => "\xDA\xA6",
		"\xEF\xAD\xB1" => "\xDA\xA6",
		"\xEF\xAD\xB2" => "\xDA\x84",
		"\xEF\xAD\xB3" => "\xDA\x84",
		"\xEF\xAD\xB4" => "\xDA\x84",
		"\xEF\xAD\xB5" => "\xDA\x84",
		"\xEF\xAD\xB6" => "\xDA\x83",
		"\xEF\xAD\xB7" => "\xDA\x83",
		"\xEF\xAD\xB8" => "\xDA\x83",
		"\xEF\xAD\xB9" => "\xDA\x83",
		"\xEF\xAD\xBA" => "\xDA\x86",
		"\xEF\xAD\xBB" => "\xDA\x86",
		"\xEF\xAD\xBC" => "\xDA\x86",
		"\xEF\xAD\xBD" => "\xDA\x86",
		"\xEF\xAD\xBE" => "\xDA\x87",
		"\xEF\xAD\xBF" => "\xDA\x87",
		"\xEF\xAE\x80" => "\xDA\x87",
		"\xEF\xAE\x81" => "\xDA\x87",
		"\xEF\xAE\x82" => "\xDA\x8D",
		"\xEF\xAE\x83" => "\xDA\x8D",
		"\xEF\xAE\x84" => "\xDA\x8C",
		"\xEF\xAE\x85" => "\xDA\x8C",
		"\xEF\xAE\x86" => "\xDA\x8E",
		"\xEF\xAE\x87" => "\xDA\x8E",
		"\xEF\xAE\x88" => "\xDA\x88",
		"\xEF\xAE\x89" => "\xDA\x88",
		"\xEF\xAE\x8A" => "\xDA\x98",
		"\xEF\xAE\x8B" => "\xDA\x98",
		"\xEF\xAE\x8C" => "\xDA\x91",
		"\xEF\xAE\x8D" => "\xDA\x91",
		"\xEF\xAE\x8E" => "\xDA\xA9",
		"\xEF\xAE\x8F" => "\xDA\xA9",
		"\xEF\xAE\x90" => "\xDA\xA9",
		"\xEF\xAE\x91" => "\xDA\xA9",
		"\xEF\xAE\x92" => "\xDA\xAF",
		"\xEF\xAE\x93" => "\xDA\xAF",
		"\xEF\xAE\x94" => "\xDA\xAF",
		"\xEF\xAE\x95" => "\xDA\xAF",
		"\xEF\xAE\x96" => "\xDA\xB3",
		"\xEF\xAE\x97" => "\xDA\xB3",
		"\xEF\xAE\x98" => "\xDA\xB3",
		"\xEF\xAE\x99" => "\xDA\xB3",
		"\xEF\xAE\x9A" => "\xDA\xB1",
		"\xEF\xAE\x9B" => "\xDA\xB1",
		"\xEF\xAE\x9C" => "\xDA\xB1",
		"\xEF\xAE\x9D" => "\xDA\xB1",
		"\xEF\xAE\x9E" => "\xDA\xBA",
		"\xEF\xAE\x9F" => "\xDA\xBA",
		"\xEF\xAE\xA0" => "\xDA\xBB",
		"\xEF\xAE\xA1" => "\xDA\xBB",
		"\xEF\xAE\xA2" => "\xDA\xBB",
		"\xEF\xAE\xA3" => "\xDA\xBB",
		"\xEF\xAE\xA4" => "\xDB\x80",
		"\xEF\xAE\xA5" => "\xDB\x80",
		"\xEF\xAE\xA6" => "\xDB\x81",
		"\xEF\xAE\xA7" => "\xDB\x81",
		"\xEF\xAE\xA8" => "\xDB\x81",
		"\xEF\xAE\xA9" => "\xDB\x81",
		"\xEF\xAE\xAA" => "\xDA\xBE",
		"\xEF\xAE\xAB" => "\xDA\xBE",
		"\xEF\xAE\xAC" => "\xDA\xBE",
		"\xEF\xAE\xAD" => "\xDA\xBE",
		"\xEF\xAE\xAE" => "\xDB\x92",
		"\xEF\xAE\xAF" => "\xDB\x92",
		"\xEF\xAE\xB0" => "\xDB\x93",
		"\xEF\xAE\xB1" => "\xDB\x93",
		"\xEF\xAF\x93" => "\xDA\xAD",
		"\xEF\xAF\x94" => "\xDA\xAD",
		"\xEF\xAF\x95" => "\xDA\xAD",
		"\xEF\xAF\x96" => "\xDA\xAD",
		"\xEF\xAF\x97" => "\xDB\x87",
		"\xEF\xAF\x98" => "\xDB\x87",
		"\xEF\xAF\x99" => "\xDB\x86",
		"\xEF\xAF\x9A" => "\xDB\x86",
		"\xEF\xAF\x9B" => "\xDB\x88",
		"\xEF\xAF\x9C" => "\xDB\x88",
		"\xEF\xAF\x9D" => "\xDB\x87\xD9\xB4",
		"\xEF\xAF\x9E" => "\xDB\x8B",
		"\xEF\xAF\x9F" => "\xDB\x8B",
		"\xEF\xAF\xA0" => "\xDB\x85",
		"\xEF\xAF\xA1" => "\xDB\x85",
		"\xEF\xAF\xA2" => "\xDB\x89",
		"\xEF\xAF\xA3" => "\xDB\x89",
		"\xEF\xAF\xA4" => "\xDB\x90",
		"\xEF\xAF\xA5" => "\xDB\x90",
		"\xEF\xAF\xA6" => "\xDB\x90",
		"\xEF\xAF\xA7" => "\xDB\x90",
		"\xEF\xAF\xA8" => "\xD9\x89",
		"\xEF\xAF\xA9" => "\xD9\x89",
		"\xEF\xAF\xAA" => "\xD8\xA6\xD8\xA7",
		"\xEF\xAF\xAB" => "\xD8\xA6\xD8\xA7",
		"\xEF\xAF\xAC" => "\xD8\xA6\xDB\x95",
		"\xEF\xAF\xAD" => "\xD8\xA6\xDB\x95",
		"\xEF\xAF\xAE" => "\xD8\xA6\xD9\x88",
		"\xEF\xAF\xAF" => "\xD8\xA6\xD9\x88",
		"\xEF\xAF\xB0" => "\xD8\xA6\xDB\x87",
		"\xEF\xAF\xB1" => "\xD8\xA6\xDB\x87",
		"\xEF\xAF\xB2" => "\xD8\xA6\xDB\x86",
		"\xEF\xAF\xB3" => "\xD8\xA6\xDB\x86",
		"\xEF\xAF\xB4" => "\xD8\xA6\xDB\x88",
		"\xEF\xAF\xB5" => "\xD8\xA6\xDB\x88",
		"\xEF\xAF\xB6" => "\xD8\xA6\xDB\x90",
		"\xEF\xAF\xB7" => "\xD8\xA6\xDB\x90",
		"\xEF\xAF\xB8" => "\xD8\xA6\xDB\x90",
		"\xEF\xAF\xB9" => "\xD8\xA6\xD9\x89",
		"\xEF\xAF\xBA" => "\xD8\xA6\xD9\x89",
		"\xEF\xAF\xBB" => "\xD8\xA6\xD9\x89",
		"\xEF\xAF\xBC" => "\xDB\x8C",
		"\xEF\xAF\xBD" => "\xDB\x8C",
		"\xEF\xAF\xBE" => "\xDB\x8C",
		"\xEF\xAF\xBF" => "\xDB\x8C",
		"\xEF\xB0\x80" => "\xD8\xA6\xD8\xAC",
		"\xEF\xB0\x81" => "\xD8\xA6\xD8\xAD",
		"\xEF\xB0\x82" => "\xD8\xA6\xD9\x85",
		"\xEF\xB0\x83" => "\xD8\xA6\xD9\x89",
		"\xEF\xB0\x84" => "\xD8\xA6\xD9\x8A",
		"\xEF\xB0\x85" => "\xD8\xA8\xD8\xAC",
		"\xEF\xB0\x86" => "\xD8\xA8\xD8\xAD",
		"\xEF\xB0\x87" => "\xD8\xA8\xD8\xAE",
		"\xEF\xB0\x88" => "\xD8\xA8\xD9\x85",
		"\xEF\xB0\x89" => "\xD8\xA8\xD9\x89",
		"\xEF\xB0\x8A" => "\xD8\xA8\xD9\x8A",
		"\xEF\xB0\x8B" => "\xD8\xAA\xD8\xAC",
		"\xEF\xB0\x8C" => "\xD8\xAA\xD8\xAD",
		"\xEF\xB0\x8D" => "\xD8\xAA\xD8\xAE",
		"\xEF\xB0\x8E" => "\xD8\xAA\xD9\x85",
		"\xEF\xB0\x8F" => "\xD8\xAA\xD9\x89",
		"\xEF\xB0\x90" => "\xD8\xAA\xD9\x8A",
		"\xEF\xB0\x91" => "\xD8\xAB\xD8\xAC",
		"\xEF\xB0\x92" => "\xD8\xAB\xD9\x85",
		"\xEF\xB0\x93" => "\xD8\xAB\xD9\x89",
		"\xEF\xB0\x94" => "\xD8\xAB\xD9\x8A",
		"\xEF\xB0\x95" => "\xD8\xAC\xD8\xAD",
		"\xEF\xB0\x96" => "\xD8\xAC\xD9\x85",
		"\xEF\xB0\x97" => "\xD8\xAD\xD8\xAC",
		"\xEF\xB0\x98" => "\xD8\xAD\xD9\x85",
		"\xEF\xB0\x99" => "\xD8\xAE\xD8\xAC",
		"\xEF\xB0\x9A" => "\xD8\xAE\xD8\xAD",
		"\xEF\xB0\x9B" => "\xD8\xAE\xD9\x85",
		"\xEF\xB0\x9C" => "\xD8\xB3\xD8\xAC",
		"\xEF\xB0\x9D" => "\xD8\xB3\xD8\xAD",
		"\xEF\xB0\x9E" => "\xD8\xB3\xD8\xAE",
		"\xEF\xB0\x9F" => "\xD8\xB3\xD9\x85",
		"\xEF\xB0\xA0" => "\xD8\xB5\xD8\xAD",
		"\xEF\xB0\xA1" => "\xD8\xB5\xD9\x85",
		"\xEF\xB0\xA2" => "\xD8\xB6\xD8\xAC",
		"\xEF\xB0\xA3" => "\xD8\xB6\xD8\xAD",
		"\xEF\xB0\xA4" => "\xD8\xB6\xD8\xAE",
		"\xEF\xB0\xA5" => "\xD8\xB6\xD9\x85",
		"\xEF\xB0\xA6" => "\xD8\xB7\xD8\xAD",
		"\xEF\xB0\xA7" => "\xD8\xB7\xD9\x85",
		"\xEF\xB0\xA8" => "\xD8\xB8\xD9\x85",
		"\xEF\xB0\xA9" => "\xD8\xB9\xD8\xAC",
		"\xEF\xB0\xAA" => "\xD8\xB9\xD9\x85",
		"\xEF\xB0\xAB" => "\xD8\xBA\xD8\xAC",
		"\xEF\xB0\xAC" => "\xD8\xBA\xD9\x85",
		"\xEF\xB0\xAD" => "\xD9\x81\xD8\xAC",
		"\xEF\xB0\xAE" => "\xD9\x81\xD8\xAD",
		"\xEF\xB0\xAF" => "\xD9\x81\xD8\xAE",
		"\xEF\xB0\xB0" => "\xD9\x81\xD9\x85",
		"\xEF\xB0\xB1" => "\xD9\x81\xD9\x89",
		"\xEF\xB0\xB2" => "\xD9\x81\xD9\x8A",
		"\xEF\xB0\xB3" => "\xD9\x82\xD8\xAD",
		"\xEF\xB0\xB4" => "\xD9\x82\xD9\x85",
		"\xEF\xB0\xB5" => "\xD9\x82\xD9\x89",
		"\xEF\xB0\xB6" => "\xD9\x82\xD9\x8A",
		"\xEF\xB0\xB7" => "\xD9\x83\xD8\xA7",
		"\xEF\xB0\xB8" => "\xD9\x83\xD8\xAC",
		"\xEF\xB0\xB9" => "\xD9\x83\xD8\xAD",
		"\xEF\xB0\xBA" => "\xD9\x83\xD8\xAE",
		"\xEF\xB0\xBB" => "\xD9\x83\xD9\x84",
		"\xEF\xB0\xBC" => "\xD9\x83\xD9\x85",
		"\xEF\xB0\xBD" => "\xD9\x83\xD9\x89",
		"\xEF\xB0\xBE" => "\xD9\x83\xD9\x8A",
		"\xEF\xB0\xBF" => "\xD9\x84\xD8\xAC",
		"\xEF\xB1\x80" => "\xD9\x84\xD8\xAD",
		"\xEF\xB1\x81" => "\xD9\x84\xD8\xAE",
		"\xEF\xB1\x82" => "\xD9\x84\xD9\x85",
		"\xEF\xB1\x83" => "\xD9\x84\xD9\x89",
		"\xEF\xB1\x84" => "\xD9\x84\xD9\x8A",
		"\xEF\xB1\x85" => "\xD9\x85\xD8\xAC",
		"\xEF\xB1\x86" => "\xD9\x85\xD8\xAD",
		"\xEF\xB1\x87" => "\xD9\x85\xD8\xAE",
		"\xEF\xB1\x88" => "\xD9\x85\xD9\x85",
		"\xEF\xB1\x89" => "\xD9\x85\xD9\x89",
		"\xEF\xB1\x8A" => "\xD9\x85\xD9\x8A",
		"\xEF\xB1\x8B" => "\xD9\x86\xD8\xAC",
		"\xEF\xB1\x8C" => "\xD9\x86\xD8\xAD",
		"\xEF\xB1\x8D" => "\xD9\x86\xD8\xAE",
		"\xEF\xB1\x8E" => "\xD9\x86\xD9\x85",
		"\xEF\xB1\x8F" => "\xD9\x86\xD9\x89",
		"\xEF\xB1\x90" => "\xD9\x86\xD9\x8A",
		"\xEF\xB1\x91" => "\xD9\x87\xD8\xAC",
		"\xEF\xB1\x92" => "\xD9\x87\xD9\x85",
		"\xEF\xB1\x93" => "\xD9\x87\xD9\x89",
		"\xEF\xB1\x94" => "\xD9\x87\xD9\x8A",
		"\xEF\xB1\x95" => "\xD9\x8A\xD8\xAC",
		"\xEF\xB1\x96" => "\xD9\x8A\xD8\xAD",
		"\xEF\xB1\x97" => "\xD9\x8A\xD8\xAE",
		"\xEF\xB1\x98" => "\xD9\x8A\xD9\x85",
		"\xEF\xB1\x99" => "\xD9\x8A\xD9\x89",
		"\xEF\xB1\x9A" => "\xD9\x8A\xD9\x8A",
		"\xEF\xB1\x9B" => "\xD8\xB0\xD9\xB0",
		"\xEF\xB1\x9C" => "\xD8\xB1\xD9\xB0",
		"\xEF\xB1\x9D" => "\xD9\x89\xD9\xB0",
		"\xEF\xB1\xA4" => "\xD8\xA6\xD8\xB1",
		"\xEF\xB1\xA5" => "\xD8\xA6\xD8\xB2",
		"\xEF\xB1\xA6" => "\xD8\xA6\xD9\x85",
		"\xEF\xB1\xA7" => "\xD8\xA6\xD9\x86",
		"\xEF\xB1\xA8" => "\xD8\xA6\xD9\x89",
		"\xEF\xB1\xA9" => "\xD8\xA6\xD9\x8A",
		"\xEF\xB1\xAA" => "\xD8\xA8\xD8\xB1",
		"\xEF\xB1\xAB" => "\xD8\xA8\xD8\xB2",
		"\xEF\xB1\xAC" => "\xD8\xA8\xD9\x85",
		"\xEF\xB1\xAD" => "\xD8\xA8\xD9\x86",
		"\xEF\xB1\xAE" => "\xD8\xA8\xD9\x89",
		"\xEF\xB1\xAF" => "\xD8\xA8\xD9\x8A",
		"\xEF\xB1\xB0" => "\xD8\xAA\xD8\xB1",
		"\xEF\xB1\xB1" => "\xD8\xAA\xD8\xB2",
		"\xEF\xB1\xB2" => "\xD8\xAA\xD9\x85",
		"\xEF\xB1\xB3" => "\xD8\xAA\xD9\x86",
		"\xEF\xB1\xB4" => "\xD8\xAA\xD9\x89",
		"\xEF\xB1\xB5" => "\xD8\xAA\xD9\x8A",
		"\xEF\xB1\xB6" => "\xD8\xAB\xD8\xB1",
		"\xEF\xB1\xB7" => "\xD8\xAB\xD8\xB2",
		"\xEF\xB1\xB8" => "\xD8\xAB\xD9\x85",
		"\xEF\xB1\xB9" => "\xD8\xAB\xD9\x86",
		"\xEF\xB1\xBA" => "\xD8\xAB\xD9\x89",
		"\xEF\xB1\xBB" => "\xD8\xAB\xD9\x8A",
		"\xEF\xB1\xBC" => "\xD9\x81\xD9\x89",
		"\xEF\xB1\xBD" => "\xD9\x81\xD9\x8A",
		"\xEF\xB1\xBE" => "\xD9\x82\xD9\x89",
		"\xEF\xB1\xBF" => "\xD9\x82\xD9\x8A",
		"\xEF\xB2\x80" => "\xD9\x83\xD8\xA7",
		"\xEF\xB2\x81" => "\xD9\x83\xD9\x84",
		"\xEF\xB2\x82" => "\xD9\x83\xD9\x85",
		"\xEF\xB2\x83" => "\xD9\x83\xD9\x89",
		"\xEF\xB2\x84" => "\xD9\x83\xD9\x8A",
		"\xEF\xB2\x85" => "\xD9\x84\xD9\x85",
		"\xEF\xB2\x86" => "\xD9\x84\xD9\x89",
		"\xEF\xB2\x87" => "\xD9\x84\xD9\x8A",
		"\xEF\xB2\x88" => "\xD9\x85\xD8\xA7",
		"\xEF\xB2\x89" => "\xD9\x85\xD9\x85",
		"\xEF\xB2\x8A" => "\xD9\x86\xD8\xB1",
		"\xEF\xB2\x8B" => "\xD9\x86\xD8\xB2",
		"\xEF\xB2\x8C" => "\xD9\x86\xD9\x85",
		"\xEF\xB2\x8D" => "\xD9\x86\xD9\x86",
		"\xEF\xB2\x8E" => "\xD9\x86\xD9\x89",
		"\xEF\xB2\x8F" => "\xD9\x86\xD9\x8A",
		"\xEF\xB2\x90" => "\xD9\x89\xD9\xB0",
		"\xEF\xB2\x91" => "\xD9\x8A\xD8\xB1",
		"\xEF\xB2\x92" => "\xD9\x8A\xD8\xB2",
		"\xEF\xB2\x93" => "\xD9\x8A\xD9\x85",
		"\xEF\xB2\x94" => "\xD9\x8A\xD9\x86",
		"\xEF\xB2\x95" => "\xD9\x8A\xD9\x89",
		"\xEF\xB2\x96" => "\xD9\x8A\xD9\x8A",
		"\xEF\xB2\x97" => "\xD8\xA6\xD8\xAC",
		"\xEF\xB2\x98" => "\xD8\xA6\xD8\xAD",
		"\xEF\xB2\x99" => "\xD8\xA6\xD8\xAE",
		"\xEF\xB2\x9A" => "\xD8\xA6\xD9\x85",
		"\xEF\xB2\x9B" => "\xD8\xA6\xD9\x87",
		"\xEF\xB2\x9C" => "\xD8\xA8\xD8\xAC",
		"\xEF\xB2\x9D" => "\xD8\xA8\xD8\xAD",
		"\xEF\xB2\x9E" => "\xD8\xA8\xD8\xAE",
		"\xEF\xB2\x9F" => "\xD8\xA8\xD9\x85",
		"\xEF\xB2\xA0" => "\xD8\xA8\xD9\x87",
		"\xEF\xB2\xA1" => "\xD8\xAA\xD8\xAC",
		"\xEF\xB2\xA2" => "\xD8\xAA\xD8\xAD",
		"\xEF\xB2\xA3" => "\xD8\xAA\xD8\xAE",
		"\xEF\xB2\xA4" => "\xD8\xAA\xD9\x85",
		"\xEF\xB2\xA5" => "\xD8\xAA\xD9\x87",
		"\xEF\xB2\xA6" => "\xD8\xAB\xD9\x85",
		"\xEF\xB2\xA7" => "\xD8\xAC\xD8\xAD",
		"\xEF\xB2\xA8" => "\xD8\xAC\xD9\x85",
		"\xEF\xB2\xA9" => "\xD8\xAD\xD8\xAC",
		"\xEF\xB2\xAA" => "\xD8\xAD\xD9\x85",
		"\xEF\xB2\xAB" => "\xD8\xAE\xD8\xAC",
		"\xEF\xB2\xAC" => "\xD8\xAE\xD9\x85",
		"\xEF\xB2\xAD" => "\xD8\xB3\xD8\xAC",
		"\xEF\xB2\xAE" => "\xD8\xB3\xD8\xAD",
		"\xEF\xB2\xAF" => "\xD8\xB3\xD8\xAE",
		"\xEF\xB2\xB0" => "\xD8\xB3\xD9\x85",
		"\xEF\xB2\xB1" => "\xD8\xB5\xD8\xAD",
		"\xEF\xB2\xB2" => "\xD8\xB5\xD8\xAE",
		"\xEF\xB2\xB3" => "\xD8\xB5\xD9\x85",
		"\xEF\xB2\xB4" => "\xD8\xB6\xD8\xAC",
		"\xEF\xB2\xB5" => "\xD8\xB6\xD8\xAD",
		"\xEF\xB2\xB6" => "\xD8\xB6\xD8\xAE",
		"\xEF\xB2\xB7" => "\xD8\xB6\xD9\x85",
		"\xEF\xB2\xB8" => "\xD8\xB7\xD8\xAD",
		"\xEF\xB2\xB9" => "\xD8\xB8\xD9\x85",
		"\xEF\xB2\xBA" => "\xD8\xB9\xD8\xAC",
		"\xEF\xB2\xBB" => "\xD8\xB9\xD9\x85",
		"\xEF\xB2\xBC" => "\xD8\xBA\xD8\xAC",
		"\xEF\xB2\xBD" => "\xD8\xBA\xD9\x85",
		"\xEF\xB2\xBE" => "\xD9\x81\xD8\xAC",
		"\xEF\xB2\xBF" => "\xD9\x81\xD8\xAD",
		"\xEF\xB3\x80" => "\xD9\x81\xD8\xAE",
		"\xEF\xB3\x81" => "\xD9\x81\xD9\x85",
		"\xEF\xB3\x82" => "\xD9\x82\xD8\xAD",
		"\xEF\xB3\x83" => "\xD9\x82\xD9\x85",
		"\xEF\xB3\x84" => "\xD9\x83\xD8\xAC",
		"\xEF\xB3\x85" => "\xD9\x83\xD8\xAD",
		"\xEF\xB3\x86" => "\xD9\x83\xD8\xAE",
		"\xEF\xB3\x87" => "\xD9\x83\xD9\x84",
		"\xEF\xB3\x88" => "\xD9\x83\xD9\x85",
		"\xEF\xB3\x89" => "\xD9\x84\xD8\xAC",
		"\xEF\xB3\x8A" => "\xD9\x84\xD8\xAD",
		"\xEF\xB3\x8B" => "\xD9\x84\xD8\xAE",
		"\xEF\xB3\x8C" => "\xD9\x84\xD9\x85",
		"\xEF\xB3\x8D" => "\xD9\x84\xD9\x87",
		"\xEF\xB3\x8E" => "\xD9\x85\xD8\xAC",
		"\xEF\xB3\x8F" => "\xD9\x85\xD8\xAD",
		"\xEF\xB3\x90" => "\xD9\x85\xD8\xAE",
		"\xEF\xB3\x91" => "\xD9\x85\xD9\x85",
		"\xEF\xB3\x92" => "\xD9\x86\xD8\xAC",
		"\xEF\xB3\x93" => "\xD9\x86\xD8\xAD",
		"\xEF\xB3\x94" => "\xD9\x86\xD8\xAE",
		"\xEF\xB3\x95" => "\xD9\x86\xD9\x85",
		"\xEF\xB3\x96" => "\xD9\x86\xD9\x87",
		"\xEF\xB3\x97" => "\xD9\x87\xD8\xAC",
		"\xEF\xB3\x98" => "\xD9\x87\xD9\x85",
		"\xEF\xB3\x99" => "\xD9\x87\xD9\xB0",
		"\xEF\xB3\x9A" => "\xD9\x8A\xD8\xAC",
		"\xEF\xB3\x9B" => "\xD9\x8A\xD8\xAD",
		"\xEF\xB3\x9C" => "\xD9\x8A\xD8\xAE",
		"\xEF\xB3\x9D" => "\xD9\x8A\xD9\x85",
		"\xEF\xB3\x9E" => "\xD9\x8A\xD9\x87",
		"\xEF\xB3\x9F" => "\xD8\xA6\xD9\x85",
		"\xEF\xB3\xA0" => "\xD8\xA6\xD9\x87",
		"\xEF\xB3\xA1" => "\xD8\xA8\xD9\x85",
		"\xEF\xB3\xA2" => "\xD8\xA8\xD9\x87",
		"\xEF\xB3\xA3" => "\xD8\xAA\xD9\x85",
		"\xEF\xB3\xA4" => "\xD8\xAA\xD9\x87",
		"\xEF\xB3\xA5" => "\xD8\xAB\xD9\x85",
		"\xEF\xB3\xA6" => "\xD8\xAB\xD9\x87",
		"\xEF\xB3\xA7" => "\xD8\xB3\xD9\x85",
		"\xEF\xB3\xA8" => "\xD8\xB3\xD9\x87",
		"\xEF\xB3\xA9" => "\xD8\xB4\xD9\x85",
		"\xEF\xB3\xAA" => "\xD8\xB4\xD9\x87",
		"\xEF\xB3\xAB" => "\xD9\x83\xD9\x84",
		"\xEF\xB3\xAC" => "\xD9\x83\xD9\x85",
		"\xEF\xB3\xAD" => "\xD9\x84\xD9\x85",
		"\xEF\xB3\xAE" => "\xD9\x86\xD9\x85",
		"\xEF\xB3\xAF" => "\xD9\x86\xD9\x87",
		"\xEF\xB3\xB0" => "\xD9\x8A\xD9\x85",
		"\xEF\xB3\xB1" => "\xD9\x8A\xD9\x87",
		"\xEF\xB3\xB2" => "\xD9\x80\xD9\x8E\xD9\x91",
		"\xEF\xB3\xB3" => "\xD9\x80\xD9\x8F\xD9\x91",
		"\xEF\xB3\xB4" => "\xD9\x80\xD9\x90\xD9\x91",
		"\xEF\xB3\xB5" => "\xD8\xB7\xD9\x89",
		"\xEF\xB3\xB6" => "\xD8\xB7\xD9\x8A",
		"\xEF\xB3\xB7" => "\xD8\xB9\xD9\x89",
		"\xEF\xB3\xB8" => "\xD8\xB9\xD9\x8A",
		"\xEF\xB3\xB9" => "\xD8\xBA\xD9\x89",
		"\xEF\xB3\xBA" => "\xD8\xBA\xD9\x8A",
		"\xEF\xB3\xBB" => "\xD8\xB3\xD9\x89",
		"\xEF\xB3\xBC" => "\xD8\xB3\xD9\x8A",
		"\xEF\xB3\xBD" => "\xD8\xB4\xD9\x89",
		"\xEF\xB3\xBE" => "\xD8\xB4\xD9\x8A",
		"\xEF\xB3\xBF" => "\xD8\xAD\xD9\x89",
		"\xEF\xB4\x80" => "\xD8\xAD\xD9\x8A",
		"\xEF\xB4\x81" => "\xD8\xAC\xD9\x89",
		"\xEF\xB4\x82" => "\xD8\xAC\xD9\x8A",
		"\xEF\xB4\x83" => "\xD8\xAE\xD9\x89",
		"\xEF\xB4\x84" => "\xD8\xAE\xD9\x8A",
		"\xEF\xB4\x85" => "\xD8\xB5\xD9\x89",
		"\xEF\xB4\x86" => "\xD8\xB5\xD9\x8A",
		"\xEF\xB4\x87" => "\xD8\xB6\xD9\x89",
		"\xEF\xB4\x88" => "\xD8\xB6\xD9\x8A",
		"\xEF\xB4\x89" => "\xD8\xB4\xD8\xAC",
		"\xEF\xB4\x8A" => "\xD8\xB4\xD8\xAD",
		"\xEF\xB4\x8B" => "\xD8\xB4\xD8\xAE",
		"\xEF\xB4\x8C" => "\xD8\xB4\xD9\x85",
		"\xEF\xB4\x8D" => "\xD8\xB4\xD8\xB1",
		"\xEF\xB4\x8E" => "\xD8\xB3\xD8\xB1",
		"\xEF\xB4\x8F" => "\xD8\xB5\xD8\xB1",
		"\xEF\xB4\x90" => "\xD8\xB6\xD8\xB1",
		"\xEF\xB4\x91" => "\xD8\xB7\xD9\x89",
		"\xEF\xB4\x92" => "\xD8\xB7\xD9\x8A",
		"\xEF\xB4\x93" => "\xD8\xB9\xD9\x89",
		"\xEF\xB4\x94" => "\xD8\xB9\xD9\x8A",
		"\xEF\xB4\x95" => "\xD8\xBA\xD9\x89",
		"\xEF\xB4\x96" => "\xD8\xBA\xD9\x8A",
		"\xEF\xB4\x97" => "\xD8\xB3\xD9\x89",
		"\xEF\xB4\x98" => "\xD8\xB3\xD9\x8A",
		"\xEF\xB4\x99" => "\xD8\xB4\xD9\x89",
		"\xEF\xB4\x9A" => "\xD8\xB4\xD9\x8A",
		"\xEF\xB4\x9B" => "\xD8\xAD\xD9\x89",
		"\xEF\xB4\x9C" => "\xD8\xAD\xD9\x8A",
		"\xEF\xB4\x9D" => "\xD8\xAC\xD9\x89",
		"\xEF\xB4\x9E" => "\xD8\xAC\xD9\x8A",
		"\xEF\xB4\x9F" => "\xD8\xAE\xD9\x89",
		"\xEF\xB4\xA0" => "\xD8\xAE\xD9\x8A",
		"\xEF\xB4\xA1" => "\xD8\xB5\xD9\x89",
		"\xEF\xB4\xA2" => "\xD8\xB5\xD9\x8A",
		"\xEF\xB4\xA3" => "\xD8\xB6\xD9\x89",
		"\xEF\xB4\xA4" => "\xD8\xB6\xD9\x8A",
		"\xEF\xB4\xA5" => "\xD8\xB4\xD8\xAC",
		"\xEF\xB4\xA6" => "\xD8\xB4\xD8\xAD",
		"\xEF\xB4\xA7" => "\xD8\xB4\xD8\xAE",
		"\xEF\xB4\xA8" => "\xD8\xB4\xD9\x85",
		"\xEF\xB4\xA9" => "\xD8\xB4\xD8\xB1",
		"\xEF\xB4\xAA" => "\xD8\xB3\xD8\xB1",
		"\xEF\xB4\xAB" => "\xD8\xB5\xD8\xB1",
		"\xEF\xB4\xAC" => "\xD8\xB6\xD8\xB1",
		"\xEF\xB4\xAD" => "\xD8\xB4\xD8\xAC",
		"\xEF\xB4\xAE" => "\xD8\xB4\xD8\xAD",
		"\xEF\xB4\xAF" => "\xD8\xB4\xD8\xAE",
		"\xEF\xB4\xB0" => "\xD8\xB4\xD9\x85",
		"\xEF\xB4\xB1" => "\xD8\xB3\xD9\x87",
		"\xEF\xB4\xB2" => "\xD8\xB4\xD9\x87",
		"\xEF\xB4\xB3" => "\xD8\xB7\xD9\x85",
		"\xEF\xB4\xB4" => "\xD8\xB3\xD8\xAC",
		"\xEF\xB4\xB5" => "\xD8\xB3\xD8\xAD",
		"\xEF\xB4\xB6" => "\xD8\xB3\xD8\xAE",
		"\xEF\xB4\xB7" => "\xD8\xB4\xD8\xAC",
		"\xEF\xB4\xB8" => "\xD8\xB4\xD8\xAD",
		"\xEF\xB4\xB9" => "\xD8\xB4\xD8\xAE",
		"\xEF\xB4\xBA" => "\xD8\xB7\xD9\x85",
		"\xEF\xB4\xBB" => "\xD8\xB8\xD9\x85",
		"\xEF\xB4\xBC" => "\xD8\xA7\xD9\x8B",
		"\xEF\xB4\xBD" => "\xD8\xA7\xD9\x8B",
		"\xEF\xB5\x90" => "\xD8\xAA\xD8\xAC\xD9\x85",
		"\xEF\xB5\x91" => "\xD8\xAA\xD8\xAD\xD8\xAC",
		"\xEF\xB5\x92" => "\xD8\xAA\xD8\xAD\xD8\xAC",
		"\xEF\xB5\x93" => "\xD8\xAA\xD8\xAD\xD9\x85",
		"\xEF\xB5\x94" => "\xD8\xAA\xD8\xAE\xD9\x85",
		"\xEF\xB5\x95" => "\xD8\xAA\xD9\x85\xD8\xAC",
		"\xEF\xB5\x96" => "\xD8\xAA\xD9\x85\xD8\xAD",
		"\xEF\xB5\x97" => "\xD8\xAA\xD9\x85\xD8\xAE",
		"\xEF\xB5\x98" => "\xD8\xAC\xD9\x85\xD8\xAD",
		"\xEF\xB5\x99" => "\xD8\xAC\xD9\x85\xD8\xAD",
		"\xEF\xB5\x9A" => "\xD8\xAD\xD9\x85\xD9\x8A",
		"\xEF\xB5\x9B" => "\xD8\xAD\xD9\x85\xD9\x89",
		"\xEF\xB5\x9C" => "\xD8\xB3\xD8\xAD\xD8\xAC",
		"\xEF\xB5\x9D" => "\xD8\xB3\xD8\xAC\xD8\xAD",
		"\xEF\xB5\x9E" => "\xD8\xB3\xD8\xAC\xD9\x89",
		"\xEF\xB5\x9F" => "\xD8\xB3\xD9\x85\xD8\xAD",
		"\xEF\xB5\xA0" => "\xD8\xB3\xD9\x85\xD8\xAD",
		"\xEF\xB5\xA1" => "\xD8\xB3\xD9\x85\xD8\xAC",
		"\xEF\xB5\xA2" => "\xD8\xB3\xD9\x85\xD9\x85",
		"\xEF\xB5\xA3" => "\xD8\xB3\xD9\x85\xD9\x85",
		"\xEF\xB5\xA4" => "\xD8\xB5\xD8\xAD\xD8\xAD",
		"\xEF\xB5\xA5" => "\xD8\xB5\xD8\xAD\xD8\xAD",
		"\xEF\xB5\xA6" => "\xD8\xB5\xD9\x85\xD9\x85",
		"\xEF\xB5\xA7" => "\xD8\xB4\xD8\xAD\xD9\x85",
		"\xEF\xB5\xA8" => "\xD8\xB4\xD8\xAD\xD9\x85",
		"\xEF\xB5\xA9" => "\xD8\xB4\xD8\xAC\xD9\x8A",
		"\xEF\xB5\xAA" => "\xD8\xB4\xD9\x85\xD8\xAE",
		"\xEF\xB5\xAB" => "\xD8\xB4\xD9\x85\xD8\xAE",
		"\xEF\xB5\xAC" => "\xD8\xB4\xD9\x85\xD9\x85",
		"\xEF\xB5\xAD" => "\xD8\xB4\xD9\x85\xD9\x85",
		"\xEF\xB5\xAE" => "\xD8\xB6\xD8\xAD\xD9\x89",
		"\xEF\xB5\xAF" => "\xD8\xB6\xD8\xAE\xD9\x85",
		"\xEF\xB5\xB0" => "\xD8\xB6\xD8\xAE\xD9\x85",
		"\xEF\xB5\xB1" => "\xD8\xB7\xD9\x85\xD8\xAD",
		"\xEF\xB5\xB2" => "\xD8\xB7\xD9\x85\xD8\xAD",
		"\xEF\xB5\xB3" => "\xD8\xB7\xD9\x85\xD9\x85",
		"\xEF\xB5\xB4" => "\xD8\xB7\xD9\x85\xD9\x8A",
		"\xEF\xB5\xB5" => "\xD8\xB9\xD8\xAC\xD9\x85",
		"\xEF\xB5\xB6" => "\xD8\xB9\xD9\x85\xD9\x85",
		"\xEF\xB5\xB7" => "\xD8\xB9\xD9\x85\xD9\x85",
		"\xEF\xB5\xB8" => "\xD8\xB9\xD9\x85\xD9\x89",
		"\xEF\xB5\xB9" => "\xD8\xBA\xD9\x85\xD9\x85",
		"\xEF\xB5\xBA" => "\xD8\xBA\xD9\x85\xD9\x8A",
		"\xEF\xB5\xBB" => "\xD8\xBA\xD9\x85\xD9\x89",
		"\xEF\xB5\xBC" => "\xD9\x81\xD8\xAE\xD9\x85",
		"\xEF\xB5\xBD" => "\xD9\x81\xD8\xAE\xD9\x85",
		"\xEF\xB5\xBE" => "\xD9\x82\xD9\x85\xD8\xAD",
		"\xEF\xB5\xBF" => "\xD9\x82\xD9\x85\xD9\x85",
		"\xEF\xB6\x80" => "\xD9\x84\xD8\xAD\xD9\x85",
		"\xEF\xB6\x81" => "\xD9\x84\xD8\xAD\xD9\x8A",
		"\xEF\xB6\x82" => "\xD9\x84\xD8\xAD\xD9\x89",
		"\xEF\xB6\x83" => "\xD9\x84\xD8\xAC\xD8\xAC",
		"\xEF\xB6\x84" => "\xD9\x84\xD8\xAC\xD8\xAC",
		"\xEF\xB6\x85" => "\xD9\x84\xD8\xAE\xD9\x85",
		"\xEF\xB6\x86" => "\xD9\x84\xD8\xAE\xD9\x85",
		"\xEF\xB6\x87" => "\xD9\x84\xD9\x85\xD8\xAD",
		"\xEF\xB6\x88" => "\xD9\x84\xD9\x85\xD8\xAD",
		"\xEF\xB6\x89" => "\xD9\x85\xD8\xAD\xD8\xAC",
		"\xEF\xB6\x8A" => "\xD9\x85\xD8\xAD\xD9\x85",
		"\xEF\xB6\x8B" => "\xD9\x85\xD8\xAD\xD9\x8A",
		"\xEF\xB6\x8C" => "\xD9\x85\xD8\xAC\xD8\xAD",
		"\xEF\xB6\x8D" => "\xD9\x85\xD8\xAC\xD9\x85",
		"\xEF\xB6\x8E" => "\xD9\x85\xD8\xAE\xD8\xAC",
		"\xEF\xB6\x8F" => "\xD9\x85\xD8\xAE\xD9\x85",
		"\xEF\xB6\x92" => "\xD9\x85\xD8\xAC\xD8\xAE",
		"\xEF\xB6\x93" => "\xD9\x87\xD9\x85\xD8\xAC",
		"\xEF\xB6\x94" => "\xD9\x87\xD9\x85\xD9\x85",
		"\xEF\xB6\x95" => "\xD9\x86\xD8\xAD\xD9\x85",
		"\xEF\xB6\x96" => "\xD9\x86\xD8\xAD\xD9\x89",
		"\xEF\xB6\x97" => "\xD9\x86\xD8\xAC\xD9\x85",
		"\xEF\xB6\x98" => "\xD9\x86\xD8\xAC\xD9\x85",
		"\xEF\xB6\x99" => "\xD9\x86\xD8\xAC\xD9\x89",
		"\xEF\xB6\x9A" => "\xD9\x86\xD9\x85\xD9\x8A",
		"\xEF\xB6\x9B" => "\xD9\x86\xD9\x85\xD9\x89",
		"\xEF\xB6\x9C" => "\xD9\x8A\xD9\x85\xD9\x85",
		"\xEF\xB6\x9D" => "\xD9\x8A\xD9\x85\xD9\x85",
		"\xEF\xB6\x9E" => "\xD8\xA8\xD8\xAE\xD9\x8A",
		"\xEF\xB6\x9F" => "\xD8\xAA\xD8\xAC\xD9\x8A",
		"\xEF\xB6\xA0" => "\xD8\xAA\xD8\xAC\xD9\x89",
		"\xEF\xB6\xA1" => "\xD8\xAA\xD8\xAE\xD9\x8A",
		"\xEF\xB6\xA2" => "\xD8\xAA\xD8\xAE\xD9\x89",
		"\xEF\xB6\xA3" => "\xD8\xAA\xD9\x85\xD9\x8A",
		"\xEF\xB6\xA4" => "\xD8\xAA\xD9\x85\xD9\x89",
		"\xEF\xB6\xA5" => "\xD8\xAC\xD9\x85\xD9\x8A",
		"\xEF\xB6\xA6" => "\xD8\xAC\xD8\xAD\xD9\x89",
		"\xEF\xB6\xA7" => "\xD8\xAC\xD9\x85\xD9\x89",
		"\xEF\xB6\xA8" => "\xD8\xB3\xD8\xAE\xD9\x89",
		"\xEF\xB6\xA9" => "\xD8\xB5\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xAA" => "\xD8\xB4\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xAB" => "\xD8\xB6\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xAC" => "\xD9\x84\xD8\xAC\xD9\x8A",
		"\xEF\xB6\xAD" => "\xD9\x84\xD9\x85\xD9\x8A",
		"\xEF\xB6\xAE" => "\xD9\x8A\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xAF" => "\xD9\x8A\xD8\xAC\xD9\x8A",
		"\xEF\xB6\xB0" => "\xD9\x8A\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB1" => "\xD9\x85\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB2" => "\xD9\x82\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB3" => "\xD9\x86\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xB4" => "\xD9\x82\xD9\x85\xD8\xAD",
		"\xEF\xB6\xB5" => "\xD9\x84\xD8\xAD\xD9\x85",
		"\xEF\xB6\xB6" => "\xD8\xB9\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB7" => "\xD9\x83\xD9\x85\xD9\x8A",
		"\xEF\xB6\xB8" => "\xD9\x86\xD8\xAC\xD8\xAD",
		"\xEF\xB6\xB9" => "\xD9\x85\xD8\xAE\xD9\x8A",
		"\xEF\xB6\xBA" => "\xD9\x84\xD8\xAC\xD9\x85",
		"\xEF\xB6\xBB" => "\xD9\x83\xD9\x85\xD9\x85",
		"\xEF\xB6\xBC" => "\xD9\x84\xD8\xAC\xD9\x85",
		"\xEF\xB6\xBD" => "\xD9\x86\xD8\xAC\xD8\xAD",
		"\xEF\xB6\xBE" => "\xD8\xAC\xD8\xAD\xD9\x8A",
		"\xEF\xB6\xBF" => "\xD8\xAD\xD8\xAC\xD9\x8A",
		"\xEF\xB7\x80" => "\xD9\x85\xD8\xAC\xD9\x8A",
		"\xEF\xB7\x81" => "\xD9\x81\xD9\x85\xD9\x8A",
		"\xEF\xB7\x82" => "\xD8\xA8\xD8\xAD\xD9\x8A",
		"\xEF\xB7\x83" => "\xD9\x83\xD9\x85\xD9\x85",
		"\xEF\xB7\x84" => "\xD8\xB9\xD8\xAC\xD9\x85",
		"\xEF\xB7\x85" => "\xD8\xB5\xD9\x85\xD9\x85",
		"\xEF\xB7\x86" => "\xD8\xB3\xD8\xAE\xD9\x8A",
		"\xEF\xB7\x87" => "\xD9\x86\xD8\xAC\xD9\x8A",
		"\xEF\xB7\xB0" => "\xD8\xB5\xD9\x84\xDB\x92",
		"\xEF\xB7\xB1" => "\xD9\x82\xD9\x84\xDB\x92",
		"\xEF\xB7\xB2" => "\xD8\xA7\xD9\x84\xD9\x84\xD9\x87",
		"\xEF\xB7\xB3" => "\xD8\xA7\xD9\x83\xD8\xA8\xD8\xB1",
		"\xEF\xB7\xB4" => "\xD9\x85\xD8\xAD\xD9\x85\xD8\xAF",
		"\xEF\xB7\xB5" => "\xD8\xB5\xD9\x84\xD8\xB9\xD9\x85",
		"\xEF\xB7\xB6" => "\xD8\xB1\xD8\xB3\xD9\x88\xD9\x84",
		"\xEF\xB7\xB7" => "\xD8\xB9\xD9\x84\xD9\x8A\xD9\x87",
		"\xEF\xB7\xB8" => "\xD9\x88\xD8\xB3\xD9\x84\xD9\x85",
		"\xEF\xB7\xB9" => "\xD8\xB5\xD9\x84\xD9\x89",
		"\xEF\xB7\xBC" => "\xD8\xB1\xDB\x8C\xD8\xA7\xD9\x84",
		"\xEF\xB8\x91" => "\xE3\x80\x81",
		"\xEF\xB8\x97" => "\xE3\x80\x96",
		"\xEF\xB8\x98" => "\xE3\x80\x97",
		"\xEF\xB8\xB1" => "\xE2\x80\x94",
		"\xEF\xB8\xB2" => "\xE2\x80\x93",
		"\xEF\xB8\xB9" => "\xE3\x80\x94",
		"\xEF\xB8\xBA" => "\xE3\x80\x95",
		"\xEF\xB8\xBB" => "\xE3\x80\x90",
		"\xEF\xB8\xBC" => "\xE3\x80\x91",
		"\xEF\xB8\xBD" => "\xE3\x80\x8A",
		"\xEF\xB8\xBE" => "\xE3\x80\x8B",
		"\xEF\xB8\xBF" => "\xE3\x80\x88",
		"\xEF\xB9\x80" => "\xE3\x80\x89",
		"\xEF\xB9\x81" => "\xE3\x80\x8C",
		"\xEF\xB9\x82" => "\xE3\x80\x8D",
		"\xEF\xB9\x83" => "\xE3\x80\x8E",
		"\xEF\xB9\x84" => "\xE3\x80\x8F",
		"\xEF\xB9\x91" => "\xE3\x80\x81",
		"\xEF\xB9\x98" => "\xE2\x80\x94",
		"\xEF\xB9\x9D" => "\xE3\x80\x94",
		"\xEF\xB9\x9E" => "\xE3\x80\x95",
		"\xEF\xB9\xA3" => "\x2D",
		"\xEF\xB9\xB1" => "\xD9\x80\xD9\x8B",
		"\xEF\xB9\xB7" => "\xD9\x80\xD9\x8E",
		"\xEF\xB9\xB9" => "\xD9\x80\xD9\x8F",
		"\xEF\xB9\xBB" => "\xD9\x80\xD9\x90",
		"\xEF\xB9\xBD" => "\xD9\x80\xD9\x91",
		"\xEF\xB9\xBF" => "\xD9\x80\xD9\x92",
		"\xEF\xBA\x80" => "\xD8\xA1",
		"\xEF\xBA\x81" => "\xD8\xA2",
		"\xEF\xBA\x82" => "\xD8\xA2",
		"\xEF\xBA\x83" => "\xD8\xA3",
		"\xEF\xBA\x84" => "\xD8\xA3",
		"\xEF\xBA\x85" => "\xD8\xA4",
		"\xEF\xBA\x86" => "\xD8\xA4",
		"\xEF\xBA\x87" => "\xD8\xA5",
		"\xEF\xBA\x88" => "\xD8\xA5",
		"\xEF\xBA\x89" => "\xD8\xA6",
		"\xEF\xBA\x8A" => "\xD8\xA6",
		"\xEF\xBA\x8B" => "\xD8\xA6",
		"\xEF\xBA\x8C" => "\xD8\xA6",
		"\xEF\xBA\x8D" => "\xD8\xA7",
		"\xEF\xBA\x8E" => "\xD8\xA7",
		"\xEF\xBA\x8F" => "\xD8\xA8",
		"\xEF\xBA\x90" => "\xD8\xA8",
		"\xEF\xBA\x91" => "\xD8\xA8",
		"\xEF\xBA\x92" => "\xD8\xA8",
		"\xEF\xBA\x93" => "\xD8\xA9",
		"\xEF\xBA\x94" => "\xD8\xA9",
		"\xEF\xBA\x95" => "\xD8\xAA",
		"\xEF\xBA\x96" => "\xD8\xAA",
		"\xEF\xBA\x97" => "\xD8\xAA",
		"\xEF\xBA\x98" => "\xD8\xAA",
		"\xEF\xBA\x99" => "\xD8\xAB",
		"\xEF\xBA\x9A" => "\xD8\xAB",
		"\xEF\xBA\x9B" => "\xD8\xAB",
		"\xEF\xBA\x9C" => "\xD8\xAB",
		"\xEF\xBA\x9D" => "\xD8\xAC",
		"\xEF\xBA\x9E" => "\xD8\xAC",
		"\xEF\xBA\x9F" => "\xD8\xAC",
		"\xEF\xBA\xA0" => "\xD8\xAC",
		"\xEF\xBA\xA1" => "\xD8\xAD",
		"\xEF\xBA\xA2" => "\xD8\xAD",
		"\xEF\xBA\xA3" => "\xD8\xAD",
		"\xEF\xBA\xA4" => "\xD8\xAD",
		"\xEF\xBA\xA5" => "\xD8\xAE",
		"\xEF\xBA\xA6" => "\xD8\xAE",
		"\xEF\xBA\xA7" => "\xD8\xAE",
		"\xEF\xBA\xA8" => "\xD8\xAE",
		"\xEF\xBA\xA9" => "\xD8\xAF",
		"\xEF\xBA\xAA" => "\xD8\xAF",
		"\xEF\xBA\xAB" => "\xD8\xB0",
		"\xEF\xBA\xAC" => "\xD8\xB0",
		"\xEF\xBA\xAD" => "\xD8\xB1",
		"\xEF\xBA\xAE" => "\xD8\xB1",
		"\xEF\xBA\xAF" => "\xD8\xB2",
		"\xEF\xBA\xB0" => "\xD8\xB2",
		"\xEF\xBA\xB1" => "\xD8\xB3",
		"\xEF\xBA\xB2" => "\xD8\xB3",
		"\xEF\xBA\xB3" => "\xD8\xB3",
		"\xEF\xBA\xB4" => "\xD8\xB3",
		"\xEF\xBA\xB5" => "\xD8\xB4",
		"\xEF\xBA\xB6" => "\xD8\xB4",
		"\xEF\xBA\xB7" => "\xD8\xB4",
		"\xEF\xBA\xB8" => "\xD8\xB4",
		"\xEF\xBA\xB9" => "\xD8\xB5",
		"\xEF\xBA\xBA" => "\xD8\xB5",
		"\xEF\xBA\xBB" => "\xD8\xB5",
		"\xEF\xBA\xBC" => "\xD8\xB5",
		"\xEF\xBA\xBD" => "\xD8\xB6",
		"\xEF\xBA\xBE" => "\xD8\xB6",
		"\xEF\xBA\xBF" => "\xD8\xB6",
		"\xEF\xBB\x80" => "\xD8\xB6",
		"\xEF\xBB\x81" => "\xD8\xB7",
		"\xEF\xBB\x82" => "\xD8\xB7",
		"\xEF\xBB\x83" => "\xD8\xB7",
		"\xEF\xBB\x84" => "\xD8\xB7",
		"\xEF\xBB\x85" => "\xD8\xB8",
		"\xEF\xBB\x86" => "\xD8\xB8",
		"\xEF\xBB\x87" => "\xD8\xB8",
		"\xEF\xBB\x88" => "\xD8\xB8",
		"\xEF\xBB\x89" => "\xD8\xB9",
		"\xEF\xBB\x8A" => "\xD8\xB9",
		"\xEF\xBB\x8B" => "\xD8\xB9",
		"\xEF\xBB\x8C" => "\xD8\xB9",
		"\xEF\xBB\x8D" => "\xD8\xBA",
		"\xEF\xBB\x8E" => "\xD8\xBA",
		"\xEF\xBB\x8F" => "\xD8\xBA",
		"\xEF\xBB\x90" => "\xD8\xBA",
		"\xEF\xBB\x91" => "\xD9\x81",
		"\xEF\xBB\x92" => "\xD9\x81",
		"\xEF\xBB\x93" => "\xD9\x81",
		"\xEF\xBB\x94" => "\xD9\x81",
		"\xEF\xBB\x95" => "\xD9\x82",
		"\xEF\xBB\x96" => "\xD9\x82",
		"\xEF\xBB\x97" => "\xD9\x82",
		"\xEF\xBB\x98" => "\xD9\x82",
		"\xEF\xBB\x99" => "\xD9\x83",
		"\xEF\xBB\x9A" => "\xD9\x83",
		"\xEF\xBB\x9B" => "\xD9\x83",
		"\xEF\xBB\x9C" => "\xD9\x83",
		"\xEF\xBB\x9D" => "\xD9\x84",
		"\xEF\xBB\x9E" => "\xD9\x84",
		"\xEF\xBB\x9F" => "\xD9\x84",
		"\xEF\xBB\xA0" => "\xD9\x84",
		"\xEF\xBB\xA1" => "\xD9\x85",
		"\xEF\xBB\xA2" => "\xD9\x85",
		"\xEF\xBB\xA3" => "\xD9\x85",
		"\xEF\xBB\xA4" => "\xD9\x85",
		"\xEF\xBB\xA5" => "\xD9\x86",
		"\xEF\xBB\xA6" => "\xD9\x86",
		"\xEF\xBB\xA7" => "\xD9\x86",
		"\xEF\xBB\xA8" => "\xD9\x86",
		"\xEF\xBB\xA9" => "\xD9\x87",
		"\xEF\xBB\xAA" => "\xD9\x87",
		"\xEF\xBB\xAB" => "\xD9\x87",
		"\xEF\xBB\xAC" => "\xD9\x87",
		"\xEF\xBB\xAD" => "\xD9\x88",
		"\xEF\xBB\xAE" => "\xD9\x88",
		"\xEF\xBB\xAF" => "\xD9\x89",
		"\xEF\xBB\xB0" => "\xD9\x89",
		"\xEF\xBB\xB1" => "\xD9\x8A",
		"\xEF\xBB\xB2" => "\xD9\x8A",
		"\xEF\xBB\xB3" => "\xD9\x8A",
		"\xEF\xBB\xB4" => "\xD9\x8A",
		"\xEF\xBB\xB5" => "\xD9\x84\xD8\xA2",
		"\xEF\xBB\xB6" => "\xD9\x84\xD8\xA2",
		"\xEF\xBB\xB7" => "\xD9\x84\xD8\xA3",
		"\xEF\xBB\xB8" => "\xD9\x84\xD8\xA3",
		"\xEF\xBB\xB9" => "\xD9\x84\xD8\xA5",
		"\xEF\xBB\xBA" => "\xD9\x84\xD8\xA5",
		"\xEF\xBB\xBB" => "\xD9\x84\xD8\xA7",
		"\xEF\xBB\xBC" => "\xD9\x84\xD8\xA7",
		"\xEF\xBC\x8D" => "\x2D",
		"\xEF\xBC\x8E" => "\x2E",
		"\xEF\xBC\x90" => "\x30",
		"\xEF\xBC\x91" => "\x31",
		"\xEF\xBC\x92" => "\x32",
		"\xEF\xBC\x93" => "\x33",
		"\xEF\xBC\x94" => "\x34",
		"\xEF\xBC\x95" => "\x35",
		"\xEF\xBC\x96" => "\x36",
		"\xEF\xBC\x97" => "\x37",
		"\xEF\xBC\x98" => "\x38",
		"\xEF\xBC\x99" => "\x39",
		"\xEF\xBC\xA1" => "\x61",
		"\xEF\xBC\xA2" => "\x62",
		"\xEF\xBC\xA3" => "\x63",
		"\xEF\xBC\xA4" => "\x64",
		"\xEF\xBC\xA5" => "\x65",
		"\xEF\xBC\xA6" => "\x66",
		"\xEF\xBC\xA7" => "\x67",
		"\xEF\xBC\xA8" => "\x68",
		"\xEF\xBC\xA9" => "\x69",
		"\xEF\xBC\xAA" => "\x6A",
		"\xEF\xBC\xAB" => "\x6B",
		"\xEF\xBC\xAC" => "\x6C",
		"\xEF\xBC\xAD" => "\x6D",
		"\xEF\xBC\xAE" => "\x6E",
		"\xEF\xBC\xAF" => "\x6F",
		"\xEF\xBC\xB0" => "\x70",
		"\xEF\xBC\xB1" => "\x71",
		"\xEF\xBC\xB2" => "\x72",
		"\xEF\xBC\xB3" => "\x73",
		"\xEF\xBC\xB4" => "\x74",
		"\xEF\xBC\xB5" => "\x75",
		"\xEF\xBC\xB6" => "\x76",
		"\xEF\xBC\xB7" => "\x77",
		"\xEF\xBC\xB8" => "\x78",
		"\xEF\xBC\xB9" => "\x79",
		"\xEF\xBC\xBA" => "\x7A",
		"\xEF\xBD\x81" => "\x61",
		"\xEF\xBD\x82" => "\x62",
		"\xEF\xBD\x83" => "\x63",
		"\xEF\xBD\x84" => "\x64",
		"\xEF\xBD\x85" => "\x65",
		"\xEF\xBD\x86" => "\x66",
		"\xEF\xBD\x87" => "\x67",
		"\xEF\xBD\x88" => "\x68",
		"\xEF\xBD\x89" => "\x69",
		"\xEF\xBD\x8A" => "\x6A",
		"\xEF\xBD\x8B" => "\x6B",
		"\xEF\xBD\x8C" => "\x6C",
		"\xEF\xBD\x8D" => "\x6D",
		"\xEF\xBD\x8E" => "\x6E",
		"\xEF\xBD\x8F" => "\x6F",
		"\xEF\xBD\x90" => "\x70",
		"\xEF\xBD\x91" => "\x71",
		"\xEF\xBD\x92" => "\x72",
		"\xEF\xBD\x93" => "\x73",
		"\xEF\xBD\x94" => "\x74",
		"\xEF\xBD\x95" => "\x75",
		"\xEF\xBD\x96" => "\x76",
		"\xEF\xBD\x97" => "\x77",
		"\xEF\xBD\x98" => "\x78",
		"\xEF\xBD\x99" => "\x79",
		"\xEF\xBD\x9A" => "\x7A",
		"\xEF\xBD\x9F" => "\xE2\xA6\x85",
		"\xEF\xBD\xA0" => "\xE2\xA6\x86",
		"\xEF\xBD\xA1" => "\x2E",
		"\xEF\xBD\xA2" => "\xE3\x80\x8C",
		"\xEF\xBD\xA3" => "\xE3\x80\x8D",
		"\xEF\xBD\xA4" => "\xE3\x80\x81",
		"\xEF\xBD\xA5" => "\xE3\x83\xBB",
		"\xEF\xBD\xA6" => "\xE3\x83\xB2",
		"\xEF\xBD\xA7" => "\xE3\x82\xA1",
		"\xEF\xBD\xA8" => "\xE3\x82\xA3",
		"\xEF\xBD\xA9" => "\xE3\x82\xA5",
		"\xEF\xBD\xAA" => "\xE3\x82\xA7",
		"\xEF\xBD\xAB" => "\xE3\x82\xA9",
		"\xEF\xBD\xAC" => "\xE3\x83\xA3",
		"\xEF\xBD\xAD" => "\xE3\x83\xA5",
		"\xEF\xBD\xAE" => "\xE3\x83\xA7",
		"\xEF\xBD\xAF" => "\xE3\x83\x83",
		"\xEF\xBD\xB0" => "\xE3\x83\xBC",
		"\xEF\xBD\xB1" => "\xE3\x82\xA2",
		"\xEF\xBD\xB2" => "\xE3\x82\xA4",
		"\xEF\xBD\xB3" => "\xE3\x82\xA6",
		"\xEF\xBD\xB4" => "\xE3\x82\xA8",
		"\xEF\xBD\xB5" => "\xE3\x82\xAA",
		"\xEF\xBD\xB6" => "\xE3\x82\xAB",
		"\xEF\xBD\xB7" => "\xE3\x82\xAD",
		"\xEF\xBD\xB8" => "\xE3\x82\xAF",
		"\xEF\xBD\xB9" => "\xE3\x82\xB1",
		"\xEF\xBD\xBA" => "\xE3\x82\xB3",
		"\xEF\xBD\xBB" => "\xE3\x82\xB5",
		"\xEF\xBD\xBC" => "\xE3\x82\xB7",
		"\xEF\xBD\xBD" => "\xE3\x82\xB9",
		"\xEF\xBD\xBE" => "\xE3\x82\xBB",
		"\xEF\xBD\xBF" => "\xE3\x82\xBD",
		"\xEF\xBE\x80" => "\xE3\x82\xBF",
		"\xEF\xBE\x81" => "\xE3\x83\x81",
		"\xEF\xBE\x82" => "\xE3\x83\x84",
		"\xEF\xBE\x83" => "\xE3\x83\x86",
		"\xEF\xBE\x84" => "\xE3\x83\x88",
		"\xEF\xBE\x85" => "\xE3\x83\x8A",
		"\xEF\xBE\x86" => "\xE3\x83\x8B",
		"\xEF\xBE\x87" => "\xE3\x83\x8C",
		"\xEF\xBE\x88" => "\xE3\x83\x8D",
		"\xEF\xBE\x89" => "\xE3\x83\x8E",
		"\xEF\xBE\x8A" => "\xE3\x83\x8F",
		"\xEF\xBE\x8B" => "\xE3\x83\x92",
		"\xEF\xBE\x8C" => "\xE3\x83\x95",
		"\xEF\xBE\x8D" => "\xE3\x83\x98",
		"\xEF\xBE\x8E" => "\xE3\x83\x9B",
		"\xEF\xBE\x8F" => "\xE3\x83\x9E",
		"\xEF\xBE\x90" => "\xE3\x83\x9F",
		"\xEF\xBE\x91" => "\xE3\x83\xA0",
		"\xEF\xBE\x92" => "\xE3\x83\xA1",
		"\xEF\xBE\x93" => "\xE3\x83\xA2",
		"\xEF\xBE\x94" => "\xE3\x83\xA4",
		"\xEF\xBE\x95" => "\xE3\x83\xA6",
		"\xEF\xBE\x96" => "\xE3\x83\xA8",
		"\xEF\xBE\x97" => "\xE3\x83\xA9",
		"\xEF\xBE\x98" => "\xE3\x83\xAA",
		"\xEF\xBE\x99" => "\xE3\x83\xAB",
		"\xEF\xBE\x9A" => "\xE3\x83\xAC",
		"\xEF\xBE\x9B" => "\xE3\x83\xAD",
		"\xEF\xBE\x9C" => "\xE3\x83\xAF",
		"\xEF\xBE\x9D" => "\xE3\x83\xB3",
		"\xEF\xBE\x9E" => "\xE3\x82\x99",
		"\xEF\xBE\x9F" => "\xE3\x82\x9A",
		"\xEF\xBE\xA1" => "\xE1\x84\x80",
		"\xEF\xBE\xA2" => "\xE1\x84\x81",
		"\xEF\xBE\xA3" => "\xE1\x86\xAA",
		"\xEF\xBE\xA4" => "\xE1\x84\x82",
		"\xEF\xBE\xA5" => "\xE1\x86\xAC",
		"\xEF\xBE\xA6" => "\xE1\x86\xAD",
		"\xEF\xBE\xA7" => "\xE1\x84\x83",
		"\xEF\xBE\xA8" => "\xE1\x84\x84",
		"\xEF\xBE\xA9" => "\xE1\x84\x85",
		"\xEF\xBE\xAA" => "\xE1\x86\xB0",
		"\xEF\xBE\xAB" => "\xE1\x86\xB1",
		"\xEF\xBE\xAC" => "\xE1\x86\xB2",
		"\xEF\xBE\xAD" => "\xE1\x86\xB3",
		"\xEF\xBE\xAE" => "\xE1\x86\xB4",
		"\xEF\xBE\xAF" => "\xE1\x86\xB5",
		"\xEF\xBE\xB0" => "\xE1\x84\x9A",
		"\xEF\xBE\xB1" => "\xE1\x84\x86",
		"\xEF\xBE\xB2" => "\xE1\x84\x87",
		"\xEF\xBE\xB3" => "\xE1\x84\x88",
		"\xEF\xBE\xB4" => "\xE1\x84\xA1",
		"\xEF\xBE\xB5" => "\xE1\x84\x89",
		"\xEF\xBE\xB6" => "\xE1\x84\x8A",
		"\xEF\xBE\xB7" => "\xE1\x84\x8B",
		"\xEF\xBE\xB8" => "\xE1\x84\x8C",
		"\xEF\xBE\xB9" => "\xE1\x84\x8D",
		"\xEF\xBE\xBA" => "\xE1\x84\x8E",
		"\xEF\xBE\xBB" => "\xE1\x84\x8F",
		"\xEF\xBE\xBC" => "\xE1\x84\x90",
		"\xEF\xBE\xBD" => "\xE1\x84\x91",
		"\xEF\xBE\xBE" => "\xE1\x84\x92",
		"\xEF\xBF\x82" => "\xE1\x85\xA1",
		"\xEF\xBF\x83" => "\xE1\x85\xA2",
		"\xEF\xBF\x84" => "\xE1\x85\xA3",
		"\xEF\xBF\x85" => "\xE1\x85\xA4",
		"\xEF\xBF\x86" => "\xE1\x85\xA5",
		"\xEF\xBF\x87" => "\xE1\x85\xA6",
		"\xEF\xBF\x8A" => "\xE1\x85\xA7",
		"\xEF\xBF\x8B" => "\xE1\x85\xA8",
		"\xEF\xBF\x8C" => "\xE1\x85\xA9",
		"\xEF\xBF\x8D" => "\xE1\x85\xAA",
		"\xEF\xBF\x8E" => "\xE1\x85\xAB",
		"\xEF\xBF\x8F" => "\xE1\x85\xAC",
		"\xEF\xBF\x92" => "\xE1\x85\xAD",
		"\xEF\xBF\x93" => "\xE1\x85\xAE",
		"\xEF\xBF\x94" => "\xE1\x85\xAF",
		"\xEF\xBF\x95" => "\xE1\x85\xB0",
		"\xEF\xBF\x96" => "\xE1\x85\xB1",
		"\xEF\xBF\x97" => "\xE1\x85\xB2",
		"\xEF\xBF\x9A" => "\xE1\x85\xB3",
		"\xEF\xBF\x9B" => "\xE1\x85\xB4",
		"\xEF\xBF\x9C" => "\xE1\x85\xB5",
		"\xEF\xBF\xA0" => "\xC2\xA2",
		"\xEF\xBF\xA1" => "\xC2\xA3",
		"\xEF\xBF\xA2" => "\xC2\xAC",
		"\xEF\xBF\xA4" => "\xC2\xA6",
		"\xEF\xBF\xA5" => "\xC2\xA5",
		"\xEF\xBF\xA6" => "\xE2\x82\xA9",
		"\xEF\xBF\xA8" => "\xE2\x94\x82",
		"\xEF\xBF\xA9" => "\xE2\x86\x90",
		"\xEF\xBF\xAA" => "\xE2\x86\x91",
		"\xEF\xBF\xAB" => "\xE2\x86\x92",
		"\xEF\xBF\xAC" => "\xE2\x86\x93",
		"\xEF\xBF\xAD" => "\xE2\x96\xA0",
		"\xEF\xBF\xAE" => "\xE2\x97\x8B",
		"\xF0\x90\x90\x80" => "\xF0\x90\x90\xA8",
		"\xF0\x90\x90\x81" => "\xF0\x90\x90\xA9",
		"\xF0\x90\x90\x82" => "\xF0\x90\x90\xAA",
		"\xF0\x90\x90\x83" => "\xF0\x90\x90\xAB",
		"\xF0\x90\x90\x84" => "\xF0\x90\x90\xAC",
		"\xF0\x90\x90\x85" => "\xF0\x90\x90\xAD",
		"\xF0\x90\x90\x86" => "\xF0\x90\x90\xAE",
		"\xF0\x90\x90\x87" => "\xF0\x90\x90\xAF",
		"\xF0\x90\x90\x88" => "\xF0\x90\x90\xB0",
		"\xF0\x90\x90\x89" => "\xF0\x90\x90\xB1",
		"\xF0\x90\x90\x8A" => "\xF0\x90\x90\xB2",
		"\xF0\x90\x90\x8B" => "\xF0\x90\x90\xB3",
		"\xF0\x90\x90\x8C" => "\xF0\x90\x90\xB4",
		"\xF0\x90\x90\x8D" => "\xF0\x90\x90\xB5",
		"\xF0\x90\x90\x8E" => "\xF0\x90\x90\xB6",
		"\xF0\x90\x90\x8F" => "\xF0\x90\x90\xB7",
		"\xF0\x90\x90\x90" => "\xF0\x90\x90\xB8",
		"\xF0\x90\x90\x91" => "\xF0\x90\x90\xB9",
		"\xF0\x90\x90\x92" => "\xF0\x90\x90\xBA",
		"\xF0\x90\x90\x93" => "\xF0\x90\x90\xBB",
		"\xF0\x90\x90\x94" => "\xF0\x90\x90\xBC",
		"\xF0\x90\x90\x95" => "\xF0\x90\x90\xBD",
		"\xF0\x90\x90\x96" => "\xF0\x90\x90\xBE",
		"\xF0\x90\x90\x97" => "\xF0\x90\x90\xBF",
		"\xF0\x90\x90\x98" => "\xF0\x90\x91\x80",
		"\xF0\x90\x90\x99" => "\xF0\x90\x91\x81",
		"\xF0\x90\x90\x9A" => "\xF0\x90\x91\x82",
		"\xF0\x90\x90\x9B" => "\xF0\x90\x91\x83",
		"\xF0\x90\x90\x9C" => "\xF0\x90\x91\x84",
		"\xF0\x90\x90\x9D" => "\xF0\x90\x91\x85",
		"\xF0\x90\x90\x9E" => "\xF0\x90\x91\x86",
		"\xF0\x90\x90\x9F" => "\xF0\x90\x91\x87",
		"\xF0\x90\x90\xA0" => "\xF0\x90\x91\x88",
		"\xF0\x90\x90\xA1" => "\xF0\x90\x91\x89",
		"\xF0\x90\x90\xA2" => "\xF0\x90\x91\x8A",
		"\xF0\x90\x90\xA3" => "\xF0\x90\x91\x8B",
		"\xF0\x90\x90\xA4" => "\xF0\x90\x91\x8C",
		"\xF0\x90\x90\xA5" => "\xF0\x90\x91\x8D",
		"\xF0\x90\x90\xA6" => "\xF0\x90\x91\x8E",
		"\xF0\x90\x90\xA7" => "\xF0\x90\x91\x8F",
		"\xF0\x90\x92\xB0" => "\xF0\x90\x93\x98",
		"\xF0\x90\x92\xB1" => "\xF0\x90\x93\x99",
		"\xF0\x90\x92\xB2" => "\xF0\x90\x93\x9A",
		"\xF0\x90\x92\xB3" => "\xF0\x90\x93\x9B",
		"\xF0\x90\x92\xB4" => "\xF0\x90\x93\x9C",
		"\xF0\x90\x92\xB5" => "\xF0\x90\x93\x9D",
		"\xF0\x90\x92\xB6" => "\xF0\x90\x93\x9E",
		"\xF0\x90\x92\xB7" => "\xF0\x90\x93\x9F",
		"\xF0\x90\x92\xB8" => "\xF0\x90\x93\xA0",
		"\xF0\x90\x92\xB9" => "\xF0\x90\x93\xA1",
		"\xF0\x90\x92\xBA" => "\xF0\x90\x93\xA2",
		"\xF0\x90\x92\xBB" => "\xF0\x90\x93\xA3",
		"\xF0\x90\x92\xBC" => "\xF0\x90\x93\xA4",
		"\xF0\x90\x92\xBD" => "\xF0\x90\x93\xA5",
		"\xF0\x90\x92\xBE" => "\xF0\x90\x93\xA6",
		"\xF0\x90\x92\xBF" => "\xF0\x90\x93\xA7",
		"\xF0\x90\x93\x80" => "\xF0\x90\x93\xA8",
		"\xF0\x90\x93\x81" => "\xF0\x90\x93\xA9",
		"\xF0\x90\x93\x82" => "\xF0\x90\x93\xAA",
		"\xF0\x90\x93\x83" => "\xF0\x90\x93\xAB",
		"\xF0\x90\x93\x84" => "\xF0\x90\x93\xAC",
		"\xF0\x90\x93\x85" => "\xF0\x90\x93\xAD",
		"\xF0\x90\x93\x86" => "\xF0\x90\x93\xAE",
		"\xF0\x90\x93\x87" => "\xF0\x90\x93\xAF",
		"\xF0\x90\x93\x88" => "\xF0\x90\x93\xB0",
		"\xF0\x90\x93\x89" => "\xF0\x90\x93\xB1",
		"\xF0\x90\x93\x8A" => "\xF0\x90\x93\xB2",
		"\xF0\x90\x93\x8B" => "\xF0\x90\x93\xB3",
		"\xF0\x90\x93\x8C" => "\xF0\x90\x93\xB4",
		"\xF0\x90\x93\x8D" => "\xF0\x90\x93\xB5",
		"\xF0\x90\x93\x8E" => "\xF0\x90\x93\xB6",
		"\xF0\x90\x93\x8F" => "\xF0\x90\x93\xB7",
		"\xF0\x90\x93\x90" => "\xF0\x90\x93\xB8",
		"\xF0\x90\x93\x91" => "\xF0\x90\x93\xB9",
		"\xF0\x90\x93\x92" => "\xF0\x90\x93\xBA",
		"\xF0\x90\x93\x93" => "\xF0\x90\x93\xBB",
		"\xF0\x90\x95\xB0" => "\xF0\x90\x96\x97",
		"\xF0\x90\x95\xB1" => "\xF0\x90\x96\x98",
		"\xF0\x90\x95\xB2" => "\xF0\x90\x96\x99",
		"\xF0\x90\x95\xB3" => "\xF0\x90\x96\x9A",
		"\xF0\x90\x95\xB4" => "\xF0\x90\x96\x9B",
		"\xF0\x90\x95\xB5" => "\xF0\x90\x96\x9C",
		"\xF0\x90\x95\xB6" => "\xF0\x90\x96\x9D",
		"\xF0\x90\x95\xB7" => "\xF0\x90\x96\x9E",
		"\xF0\x90\x95\xB8" => "\xF0\x90\x96\x9F",
		"\xF0\x90\x95\xB9" => "\xF0\x90\x96\xA0",
		"\xF0\x90\x95\xBA" => "\xF0\x90\x96\xA1",
		"\xF0\x90\x95\xBC" => "\xF0\x90\x96\xA3",
		"\xF0\x90\x95\xBD" => "\xF0\x90\x96\xA4",
		"\xF0\x90\x95\xBE" => "\xF0\x90\x96\xA5",
		"\xF0\x90\x95\xBF" => "\xF0\x90\x96\xA6",
		"\xF0\x90\x96\x80" => "\xF0\x90\x96\xA7",
		"\xF0\x90\x96\x81" => "\xF0\x90\x96\xA8",
		"\xF0\x90\x96\x82" => "\xF0\x90\x96\xA9",
		"\xF0\x90\x96\x83" => "\xF0\x90\x96\xAA",
		"\xF0\x90\x96\x84" => "\xF0\x90\x96\xAB",
		"\xF0\x90\x96\x85" => "\xF0\x90\x96\xAC",
		"\xF0\x90\x96\x86" => "\xF0\x90\x96\xAD",
		"\xF0\x90\x96\x87" => "\xF0\x90\x96\xAE",
		"\xF0\x90\x96\x88" => "\xF0\x90\x96\xAF",
		"\xF0\x90\x96\x89" => "\xF0\x90\x96\xB0",
		"\xF0\x90\x96\x8A" => "\xF0\x90\x96\xB1",
		"\xF0\x90\x96\x8C" => "\xF0\x90\x96\xB3",
		"\xF0\x90\x96\x8D" => "\xF0\x90\x96\xB4",
		"\xF0\x90\x96\x8E" => "\xF0\x90\x96\xB5",
		"\xF0\x90\x96\x8F" => "\xF0\x90\x96\xB6",
		"\xF0\x90\x96\x90" => "\xF0\x90\x96\xB7",
		"\xF0\x90\x96\x91" => "\xF0\x90\x96\xB8",
		"\xF0\x90\x96\x92" => "\xF0\x90\x96\xB9",
		"\xF0\x90\x96\x94" => "\xF0\x90\x96\xBB",
		"\xF0\x90\x96\x95" => "\xF0\x90\x96\xBC",
		"\xF0\x90\x9E\x81" => "\xCB\x90",
		"\xF0\x90\x9E\x82" => "\xCB\x91",
		"\xF0\x90\x9E\x83" => "\xC3\xA6",
		"\xF0\x90\x9E\x84" => "\xCA\x99",
		"\xF0\x90\x9E\x85" => "\xC9\x93",
		"\xF0\x90\x9E\x87" => "\xCA\xA3",
		"\xF0\x90\x9E\x88" => "\xEA\xAD\xA6",
		"\xF0\x90\x9E\x89" => "\xCA\xA5",
		"\xF0\x90\x9E\x8A" => "\xCA\xA4",
		"\xF0\x90\x9E\x8B" => "\xC9\x96",
		"\xF0\x90\x9E\x8C" => "\xC9\x97",
		"\xF0\x90\x9E\x8D" => "\xE1\xB6\x91",
		"\xF0\x90\x9E\x8E" => "\xC9\x98",
		"\xF0\x90\x9E\x8F" => "\xC9\x9E",
		"\xF0\x90\x9E\x90" => "\xCA\xA9",
		"\xF0\x90\x9E\x91" => "\xC9\xA4",
		"\xF0\x90\x9E\x92" => "\xC9\xA2",
		"\xF0\x90\x9E\x93" => "\xC9\xA0",
		"\xF0\x90\x9E\x94" => "\xCA\x9B",
		"\xF0\x90\x9E\x95" => "\xC4\xA7",
		"\xF0\x90\x9E\x96" => "\xCA\x9C",
		"\xF0\x90\x9E\x97" => "\xC9\xA7",
		"\xF0\x90\x9E\x98" => "\xCA\x84",
		"\xF0\x90\x9E\x99" => "\xCA\xAA",
		"\xF0\x90\x9E\x9A" => "\xCA\xAB",
		"\xF0\x90\x9E\x9B" => "\xC9\xAC",
		"\xF0\x90\x9E\x9C" => "\xF0\x9D\xBC\x84",
		"\xF0\x90\x9E\x9D" => "\xEA\x9E\x8E",
		"\xF0\x90\x9E\x9E" => "\xC9\xAE",
		"\xF0\x90\x9E\x9F" => "\xF0\x9D\xBC\x85",
		"\xF0\x90\x9E\xA0" => "\xCA\x8E",
		"\xF0\x90\x9E\xA1" => "\xF0\x9D\xBC\x86",
		"\xF0\x90\x9E\xA2" => "\xC3\xB8",
		"\xF0\x90\x9E\xA3" => "\xC9\xB6",
		"\xF0\x90\x9E\xA4" => "\xC9\xB7",
		"\xF0\x90\x9E\xA5" => "\x71",
		"\xF0\x90\x9E\xA6" => "\xC9\xBA",
		"\xF0\x90\x9E\xA7" => "\xF0\x9D\xBC\x88",
		"\xF0\x90\x9E\xA8" => "\xC9\xBD",
		"\xF0\x90\x9E\xA9" => "\xC9\xBE",
		"\xF0\x90\x9E\xAA" => "\xCA\x80",
		"\xF0\x90\x9E\xAB" => "\xCA\xA8",
		"\xF0\x90\x9E\xAC" => "\xCA\xA6",
		"\xF0\x90\x9E\xAD" => "\xEA\xAD\xA7",
		"\xF0\x90\x9E\xAE" => "\xCA\xA7",
		"\xF0\x90\x9E\xAF" => "\xCA\x88",
		"\xF0\x90\x9E\xB0" => "\xE2\xB1\xB1",
		"\xF0\x90\x9E\xB2" => "\xCA\x8F",
		"\xF0\x90\x9E\xB3" => "\xCA\xA1",
		"\xF0\x90\x9E\xB4" => "\xCA\xA2",
		"\xF0\x90\x9E\xB5" => "\xCA\x98",
		"\xF0\x90\x9E\xB6" => "\xC7\x80",
		"\xF0\x90\x9E\xB7" => "\xC7\x81",
		"\xF0\x90\x9E\xB8" => "\xC7\x82",
		"\xF0\x90\x9E\xB9" => "\xF0\x9D\xBC\x8A",
		"\xF0\x90\x9E\xBA" => "\xF0\x9D\xBC\x9E",
		"\xF0\x90\xB2\x80" => "\xF0\x90\xB3\x80",
		"\xF0\x90\xB2\x81" => "\xF0\x90\xB3\x81",
		"\xF0\x90\xB2\x82" => "\xF0\x90\xB3\x82",
		"\xF0\x90\xB2\x83" => "\xF0\x90\xB3\x83",
		"\xF0\x90\xB2\x84" => "\xF0\x90\xB3\x84",
		"\xF0\x90\xB2\x85" => "\xF0\x90\xB3\x85",
		"\xF0\x90\xB2\x86" => "\xF0\x90\xB3\x86",
		"\xF0\x90\xB2\x87" => "\xF0\x90\xB3\x87",
		"\xF0\x90\xB2\x88" => "\xF0\x90\xB3\x88",
		"\xF0\x90\xB2\x89" => "\xF0\x90\xB3\x89",
		"\xF0\x90\xB2\x8A" => "\xF0\x90\xB3\x8A",
		"\xF0\x90\xB2\x8B" => "\xF0\x90\xB3\x8B",
		"\xF0\x90\xB2\x8C" => "\xF0\x90\xB3\x8C",
		"\xF0\x90\xB2\x8D" => "\xF0\x90\xB3\x8D",
		"\xF0\x90\xB2\x8E" => "\xF0\x90\xB3\x8E",
		"\xF0\x90\xB2\x8F" => "\xF0\x90\xB3\x8F",
		"\xF0\x90\xB2\x90" => "\xF0\x90\xB3\x90",
		"\xF0\x90\xB2\x91" => "\xF0\x90\xB3\x91",
		"\xF0\x90\xB2\x92" => "\xF0\x90\xB3\x92",
		"\xF0\x90\xB2\x93" => "\xF0\x90\xB3\x93",
		"\xF0\x90\xB2\x94" => "\xF0\x90\xB3\x94",
		"\xF0\x90\xB2\x95" => "\xF0\x90\xB3\x95",
		"\xF0\x90\xB2\x96" => "\xF0\x90\xB3\x96",
		"\xF0\x90\xB2\x97" => "\xF0\x90\xB3\x97",
		"\xF0\x90\xB2\x98" => "\xF0\x90\xB3\x98",
		"\xF0\x90\xB2\x99" => "\xF0\x90\xB3\x99",
		"\xF0\x90\xB2\x9A" => "\xF0\x90\xB3\x9A",
		"\xF0\x90\xB2\x9B" => "\xF0\x90\xB3\x9B",
		"\xF0\x90\xB2\x9C" => "\xF0\x90\xB3\x9C",
		"\xF0\x90\xB2\x9D" => "\xF0\x90\xB3\x9D",
		"\xF0\x90\xB2\x9E" => "\xF0\x90\xB3\x9E",
		"\xF0\x90\xB2\x9F" => "\xF0\x90\xB3\x9F",
		"\xF0\x90\xB2\xA0" => "\xF0\x90\xB3\xA0",
		"\xF0\x90\xB2\xA1" => "\xF0\x90\xB3\xA1",
		"\xF0\x90\xB2\xA2" => "\xF0\x90\xB3\xA2",
		"\xF0\x90\xB2\xA3" => "\xF0\x90\xB3\xA3",
		"\xF0\x90\xB2\xA4" => "\xF0\x90\xB3\xA4",
		"\xF0\x90\xB2\xA5" => "\xF0\x90\xB3\xA5",
		"\xF0\x90\xB2\xA6" => "\xF0\x90\xB3\xA6",
		"\xF0\x90\xB2\xA7" => "\xF0\x90\xB3\xA7",
		"\xF0\x90\xB2\xA8" => "\xF0\x90\xB3\xA8",
		"\xF0\x90\xB2\xA9" => "\xF0\x90\xB3\xA9",
		"\xF0\x90\xB2\xAA" => "\xF0\x90\xB3\xAA",
		"\xF0\x90\xB2\xAB" => "\xF0\x90\xB3\xAB",
		"\xF0\x90\xB2\xAC" => "\xF0\x90\xB3\xAC",
		"\xF0\x90\xB2\xAD" => "\xF0\x90\xB3\xAD",
		"\xF0\x90\xB2\xAE" => "\xF0\x90\xB3\xAE",
		"\xF0\x90\xB2\xAF" => "\xF0\x90\xB3\xAF",
		"\xF0\x90\xB2\xB0" => "\xF0\x90\xB3\xB0",
		"\xF0\x90\xB2\xB1" => "\xF0\x90\xB3\xB1",
		"\xF0\x90\xB2\xB2" => "\xF0\x90\xB3\xB2",
		"\xF0\x91\xA2\xA0" => "\xF0\x91\xA3\x80",
		"\xF0\x91\xA2\xA1" => "\xF0\x91\xA3\x81",
		"\xF0\x91\xA2\xA2" => "\xF0\x91\xA3\x82",
		"\xF0\x91\xA2\xA3" => "\xF0\x91\xA3\x83",
		"\xF0\x91\xA2\xA4" => "\xF0\x91\xA3\x84",
		"\xF0\x91\xA2\xA5" => "\xF0\x91\xA3\x85",
		"\xF0\x91\xA2\xA6" => "\xF0\x91\xA3\x86",
		"\xF0\x91\xA2\xA7" => "\xF0\x91\xA3\x87",
		"\xF0\x91\xA2\xA8" => "\xF0\x91\xA3\x88",
		"\xF0\x91\xA2\xA9" => "\xF0\x91\xA3\x89",
		"\xF0\x91\xA2\xAA" => "\xF0\x91\xA3\x8A",
		"\xF0\x91\xA2\xAB" => "\xF0\x91\xA3\x8B",
		"\xF0\x91\xA2\xAC" => "\xF0\x91\xA3\x8C",
		"\xF0\x91\xA2\xAD" => "\xF0\x91\xA3\x8D",
		"\xF0\x91\xA2\xAE" => "\xF0\x91\xA3\x8E",
		"\xF0\x91\xA2\xAF" => "\xF0\x91\xA3\x8F",
		"\xF0\x91\xA2\xB0" => "\xF0\x91\xA3\x90",
		"\xF0\x91\xA2\xB1" => "\xF0\x91\xA3\x91",
		"\xF0\x91\xA2\xB2" => "\xF0\x91\xA3\x92",
		"\xF0\x91\xA2\xB3" => "\xF0\x91\xA3\x93",
		"\xF0\x91\xA2\xB4" => "\xF0\x91\xA3\x94",
		"\xF0\x91\xA2\xB5" => "\xF0\x91\xA3\x95",
		"\xF0\x91\xA2\xB6" => "\xF0\x91\xA3\x96",
		"\xF0\x91\xA2\xB7" => "\xF0\x91\xA3\x97",
		"\xF0\x91\xA2\xB8" => "\xF0\x91\xA3\x98",
		"\xF0\x91\xA2\xB9" => "\xF0\x91\xA3\x99",
		"\xF0\x91\xA2\xBA" => "\xF0\x91\xA3\x9A",
		"\xF0\x91\xA2\xBB" => "\xF0\x91\xA3\x9B",
		"\xF0\x91\xA2\xBC" => "\xF0\x91\xA3\x9C",
		"\xF0\x91\xA2\xBD" => "\xF0\x91\xA3\x9D",
		"\xF0\x91\xA2\xBE" => "\xF0\x91\xA3\x9E",
		"\xF0\x91\xA2\xBF" => "\xF0\x91\xA3\x9F",
		"\xF0\x96\xB9\x80" => "\xF0\x96\xB9\xA0",
		"\xF0\x96\xB9\x81" => "\xF0\x96\xB9\xA1",
		"\xF0\x96\xB9\x82" => "\xF0\x96\xB9\xA2",
		"\xF0\x96\xB9\x83" => "\xF0\x96\xB9\xA3",
		"\xF0\x96\xB9\x84" => "\xF0\x96\xB9\xA4",
		"\xF0\x96\xB9\x85" => "\xF0\x96\xB9\xA5",
		"\xF0\x96\xB9\x86" => "\xF0\x96\xB9\xA6",
		"\xF0\x96\xB9\x87" => "\xF0\x96\xB9\xA7",
		"\xF0\x96\xB9\x88" => "\xF0\x96\xB9\xA8",
		"\xF0\x96\xB9\x89" => "\xF0\x96\xB9\xA9",
		"\xF0\x96\xB9\x8A" => "\xF0\x96\xB9\xAA",
		"\xF0\x96\xB9\x8B" => "\xF0\x96\xB9\xAB",
		"\xF0\x96\xB9\x8C" => "\xF0\x96\xB9\xAC",
		"\xF0\x96\xB9\x8D" => "\xF0\x96\xB9\xAD",
		"\xF0\x96\xB9\x8E" => "\xF0\x96\xB9\xAE",
		"\xF0\x96\xB9\x8F" => "\xF0\x96\xB9\xAF",
		"\xF0\x96\xB9\x90" => "\xF0\x96\xB9\xB0",
		"\xF0\x96\xB9\x91" => "\xF0\x96\xB9\xB1",
		"\xF0\x96\xB9\x92" => "\xF0\x96\xB9\xB2",
		"\xF0\x96\xB9\x93" => "\xF0\x96\xB9\xB3",
		"\xF0\x96\xB9\x94" => "\xF0\x96\xB9\xB4",
		"\xF0\x96\xB9\x95" => "\xF0\x96\xB9\xB5",
		"\xF0\x96\xB9\x96" => "\xF0\x96\xB9\xB6",
		"\xF0\x96\xB9\x97" => "\xF0\x96\xB9\xB7",
		"\xF0\x96\xB9\x98" => "\xF0\x96\xB9\xB8",
		"\xF0\x96\xB9\x99" => "\xF0\x96\xB9\xB9",
		"\xF0\x96\xB9\x9A" => "\xF0\x96\xB9\xBA",
		"\xF0\x96\xB9\x9B" => "\xF0\x96\xB9\xBB",
		"\xF0\x96\xB9\x9C" => "\xF0\x96\xB9\xBC",
		"\xF0\x96\xB9\x9D" => "\xF0\x96\xB9\xBD",
		"\xF0\x96\xB9\x9E" => "\xF0\x96\xB9\xBE",
		"\xF0\x96\xB9\x9F" => "\xF0\x96\xB9\xBF",
		"\xF0\x9D\x85\x9E" => "\xF0\x9D\x85\x97\xF0\x9D\x85\xA5",
		"\xF0\x9D\x85\x9F" => "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5",
		"\xF0\x9D\x85\xA0" => "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xAE",
		"\xF0\x9D\x85\xA1" => "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xAF",
		"\xF0\x9D\x85\xA2" => "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xB0",
		"\xF0\x9D\x85\xA3" => "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xB1",
		"\xF0\x9D\x85\xA4" => "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xB2",
		"\xF0\x9D\x86\xBB" => "\xF0\x9D\x86\xB9\xF0\x9D\x85\xA5",
		"\xF0\x9D\x86\xBC" => "\xF0\x9D\x86\xBA\xF0\x9D\x85\xA5",
		"\xF0\x9D\x86\xBD" => "\xF0\x9D\x86\xB9\xF0\x9D\x85\xA5\xF0\x9D\x85\xAE",
		"\xF0\x9D\x86\xBE" => "\xF0\x9D\x86\xBA\xF0\x9D\x85\xA5\xF0\x9D\x85\xAE",
		"\xF0\x9D\x86\xBF" => "\xF0\x9D\x86\xB9\xF0\x9D\x85\xA5\xF0\x9D\x85\xAF",
		"\xF0\x9D\x87\x80" => "\xF0\x9D\x86\xBA\xF0\x9D\x85\xA5\xF0\x9D\x85\xAF",
		"\xF0\x9D\x90\x80" => "\x61",
		"\xF0\x9D\x90\x81" => "\x62",
		"\xF0\x9D\x90\x82" => "\x63",
		"\xF0\x9D\x90\x83" => "\x64",
		"\xF0\x9D\x90\x84" => "\x65",
		"\xF0\x9D\x90\x85" => "\x66",
		"\xF0\x9D\x90\x86" => "\x67",
		"\xF0\x9D\x90\x87" => "\x68",
		"\xF0\x9D\x90\x88" => "\x69",
		"\xF0\x9D\x90\x89" => "\x6A",
		"\xF0\x9D\x90\x8A" => "\x6B",
		"\xF0\x9D\x90\x8B" => "\x6C",
		"\xF0\x9D\x90\x8C" => "\x6D",
		"\xF0\x9D\x90\x8D" => "\x6E",
		"\xF0\x9D\x90\x8E" => "\x6F",
		"\xF0\x9D\x90\x8F" => "\x70",
		"\xF0\x9D\x90\x90" => "\x71",
		"\xF0\x9D\x90\x91" => "\x72",
		"\xF0\x9D\x90\x92" => "\x73",
		"\xF0\x9D\x90\x93" => "\x74",
		"\xF0\x9D\x90\x94" => "\x75",
		"\xF0\x9D\x90\x95" => "\x76",
		"\xF0\x9D\x90\x96" => "\x77",
		"\xF0\x9D\x90\x97" => "\x78",
		"\xF0\x9D\x90\x98" => "\x79",
		"\xF0\x9D\x90\x99" => "\x7A",
		"\xF0\x9D\x90\x9A" => "\x61",
		"\xF0\x9D\x90\x9B" => "\x62",
		"\xF0\x9D\x90\x9C" => "\x63",
		"\xF0\x9D\x90\x9D" => "\x64",
		"\xF0\x9D\x90\x9E" => "\x65",
		"\xF0\x9D\x90\x9F" => "\x66",
		"\xF0\x9D\x90\xA0" => "\x67",
		"\xF0\x9D\x90\xA1" => "\x68",
		"\xF0\x9D\x90\xA2" => "\x69",
		"\xF0\x9D\x90\xA3" => "\x6A",
		"\xF0\x9D\x90\xA4" => "\x6B",
		"\xF0\x9D\x90\xA5" => "\x6C",
		"\xF0\x9D\x90\xA6" => "\x6D",
		"\xF0\x9D\x90\xA7" => "\x6E",
		"\xF0\x9D\x90\xA8" => "\x6F",
		"\xF0\x9D\x90\xA9" => "\x70",
		"\xF0\x9D\x90\xAA" => "\x71",
		"\xF0\x9D\x90\xAB" => "\x72",
		"\xF0\x9D\x90\xAC" => "\x73",
		"\xF0\x9D\x90\xAD" => "\x74",
		"\xF0\x9D\x90\xAE" => "\x75",
		"\xF0\x9D\x90\xAF" => "\x76",
		"\xF0\x9D\x90\xB0" => "\x77",
		"\xF0\x9D\x90\xB1" => "\x78",
		"\xF0\x9D\x90\xB2" => "\x79",
		"\xF0\x9D\x90\xB3" => "\x7A",
		"\xF0\x9D\x90\xB4" => "\x61",
		"\xF0\x9D\x90\xB5" => "\x62",
		"\xF0\x9D\x90\xB6" => "\x63",
		"\xF0\x9D\x90\xB7" => "\x64",
		"\xF0\x9D\x90\xB8" => "\x65",
		"\xF0\x9D\x90\xB9" => "\x66",
		"\xF0\x9D\x90\xBA" => "\x67",
		"\xF0\x9D\x90\xBB" => "\x68",
		"\xF0\x9D\x90\xBC" => "\x69",
		"\xF0\x9D\x90\xBD" => "\x6A",
		"\xF0\x9D\x90\xBE" => "\x6B",
		"\xF0\x9D\x90\xBF" => "\x6C",
		"\xF0\x9D\x91\x80" => "\x6D",
		"\xF0\x9D\x91\x81" => "\x6E",
		"\xF0\x9D\x91\x82" => "\x6F",
		"\xF0\x9D\x91\x83" => "\x70",
		"\xF0\x9D\x91\x84" => "\x71",
		"\xF0\x9D\x91\x85" => "\x72",
		"\xF0\x9D\x91\x86" => "\x73",
		"\xF0\x9D\x91\x87" => "\x74",
		"\xF0\x9D\x91\x88" => "\x75",
		"\xF0\x9D\x91\x89" => "\x76",
		"\xF0\x9D\x91\x8A" => "\x77",
		"\xF0\x9D\x91\x8B" => "\x78",
		"\xF0\x9D\x91\x8C" => "\x79",
		"\xF0\x9D\x91\x8D" => "\x7A",
		"\xF0\x9D\x91\x8E" => "\x61",
		"\xF0\x9D\x91\x8F" => "\x62",
		"\xF0\x9D\x91\x90" => "\x63",
		"\xF0\x9D\x91\x91" => "\x64",
		"\xF0\x9D\x91\x92" => "\x65",
		"\xF0\x9D\x91\x93" => "\x66",
		"\xF0\x9D\x91\x94" => "\x67",
		"\xF0\x9D\x91\x96" => "\x69",
		"\xF0\x9D\x91\x97" => "\x6A",
		"\xF0\x9D\x91\x98" => "\x6B",
		"\xF0\x9D\x91\x99" => "\x6C",
		"\xF0\x9D\x91\x9A" => "\x6D",
		"\xF0\x9D\x91\x9B" => "\x6E",
		"\xF0\x9D\x91\x9C" => "\x6F",
		"\xF0\x9D\x91\x9D" => "\x70",
		"\xF0\x9D\x91\x9E" => "\x71",
		"\xF0\x9D\x91\x9F" => "\x72",
		"\xF0\x9D\x91\xA0" => "\x73",
		"\xF0\x9D\x91\xA1" => "\x74",
		"\xF0\x9D\x91\xA2" => "\x75",
		"\xF0\x9D\x91\xA3" => "\x76",
		"\xF0\x9D\x91\xA4" => "\x77",
		"\xF0\x9D\x91\xA5" => "\x78",
		"\xF0\x9D\x91\xA6" => "\x79",
		"\xF0\x9D\x91\xA7" => "\x7A",
		"\xF0\x9D\x91\xA8" => "\x61",
		"\xF0\x9D\x91\xA9" => "\x62",
		"\xF0\x9D\x91\xAA" => "\x63",
		"\xF0\x9D\x91\xAB" => "\x64",
		"\xF0\x9D\x91\xAC" => "\x65",
		"\xF0\x9D\x91\xAD" => "\x66",
		"\xF0\x9D\x91\xAE" => "\x67",
		"\xF0\x9D\x91\xAF" => "\x68",
		"\xF0\x9D\x91\xB0" => "\x69",
		"\xF0\x9D\x91\xB1" => "\x6A",
		"\xF0\x9D\x91\xB2" => "\x6B",
		"\xF0\x9D\x91\xB3" => "\x6C",
		"\xF0\x9D\x91\xB4" => "\x6D",
		"\xF0\x9D\x91\xB5" => "\x6E",
		"\xF0\x9D\x91\xB6" => "\x6F",
		"\xF0\x9D\x91\xB7" => "\x70",
		"\xF0\x9D\x91\xB8" => "\x71",
		"\xF0\x9D\x91\xB9" => "\x72",
		"\xF0\x9D\x91\xBA" => "\x73",
		"\xF0\x9D\x91\xBB" => "\x74",
		"\xF0\x9D\x91\xBC" => "\x75",
		"\xF0\x9D\x91\xBD" => "\x76",
		"\xF0\x9D\x91\xBE" => "\x77",
		"\xF0\x9D\x91\xBF" => "\x78",
		"\xF0\x9D\x92\x80" => "\x79",
		"\xF0\x9D\x92\x81" => "\x7A",
		"\xF0\x9D\x92\x82" => "\x61",
		"\xF0\x9D\x92\x83" => "\x62",
		"\xF0\x9D\x92\x84" => "\x63",
		"\xF0\x9D\x92\x85" => "\x64",
		"\xF0\x9D\x92\x86" => "\x65",
		"\xF0\x9D\x92\x87" => "\x66",
		"\xF0\x9D\x92\x88" => "\x67",
		"\xF0\x9D\x92\x89" => "\x68",
		"\xF0\x9D\x92\x8A" => "\x69",
		"\xF0\x9D\x92\x8B" => "\x6A",
		"\xF0\x9D\x92\x8C" => "\x6B",
		"\xF0\x9D\x92\x8D" => "\x6C",
		"\xF0\x9D\x92\x8E" => "\x6D",
		"\xF0\x9D\x92\x8F" => "\x6E",
		"\xF0\x9D\x92\x90" => "\x6F",
		"\xF0\x9D\x92\x91" => "\x70",
		"\xF0\x9D\x92\x92" => "\x71",
		"\xF0\x9D\x92\x93" => "\x72",
		"\xF0\x9D\x92\x94" => "\x73",
		"\xF0\x9D\x92\x95" => "\x74",
		"\xF0\x9D\x92\x96" => "\x75",
		"\xF0\x9D\x92\x97" => "\x76",
		"\xF0\x9D\x92\x98" => "\x77",
		"\xF0\x9D\x92\x99" => "\x78",
		"\xF0\x9D\x92\x9A" => "\x79",
		"\xF0\x9D\x92\x9B" => "\x7A",
		"\xF0\x9D\x92\x9C" => "\x61",
		"\xF0\x9D\x92\x9E" => "\x63",
		"\xF0\x9D\x92\x9F" => "\x64",
		"\xF0\x9D\x92\xA2" => "\x67",
		"\xF0\x9D\x92\xA5" => "\x6A",
		"\xF0\x9D\x92\xA6" => "\x6B",
		"\xF0\x9D\x92\xA9" => "\x6E",
		"\xF0\x9D\x92\xAA" => "\x6F",
		"\xF0\x9D\x92\xAB" => "\x70",
		"\xF0\x9D\x92\xAC" => "\x71",
		"\xF0\x9D\x92\xAE" => "\x73",
		"\xF0\x9D\x92\xAF" => "\x74",
		"\xF0\x9D\x92\xB0" => "\x75",
		"\xF0\x9D\x92\xB1" => "\x76",
		"\xF0\x9D\x92\xB2" => "\x77",
		"\xF0\x9D\x92\xB3" => "\x78",
		"\xF0\x9D\x92\xB4" => "\x79",
		"\xF0\x9D\x92\xB5" => "\x7A",
		"\xF0\x9D\x92\xB6" => "\x61",
		"\xF0\x9D\x92\xB7" => "\x62",
		"\xF0\x9D\x92\xB8" => "\x63",
		"\xF0\x9D\x92\xB9" => "\x64",
		"\xF0\x9D\x92\xBB" => "\x66",
		"\xF0\x9D\x92\xBD" => "\x68",
		"\xF0\x9D\x92\xBE" => "\x69",
		"\xF0\x9D\x92\xBF" => "\x6A",
		"\xF0\x9D\x93\x80" => "\x6B",
		"\xF0\x9D\x93\x81" => "\x6C",
		"\xF0\x9D\x93\x82" => "\x6D",
		"\xF0\x9D\x93\x83" => "\x6E",
		"\xF0\x9D\x93\x85" => "\x70",
		"\xF0\x9D\x93\x86" => "\x71",
		"\xF0\x9D\x93\x87" => "\x72",
		"\xF0\x9D\x93\x88" => "\x73",
		"\xF0\x9D\x93\x89" => "\x74",
		"\xF0\x9D\x93\x8A" => "\x75",
		"\xF0\x9D\x93\x8B" => "\x76",
		"\xF0\x9D\x93\x8C" => "\x77",
		"\xF0\x9D\x93\x8D" => "\x78",
		"\xF0\x9D\x93\x8E" => "\x79",
		"\xF0\x9D\x93\x8F" => "\x7A",
		"\xF0\x9D\x93\x90" => "\x61",
		"\xF0\x9D\x93\x91" => "\x62",
		"\xF0\x9D\x93\x92" => "\x63",
		"\xF0\x9D\x93\x93" => "\x64",
		"\xF0\x9D\x93\x94" => "\x65",
		"\xF0\x9D\x93\x95" => "\x66",
		"\xF0\x9D\x93\x96" => "\x67",
		"\xF0\x9D\x93\x97" => "\x68",
		"\xF0\x9D\x93\x98" => "\x69",
		"\xF0\x9D\x93\x99" => "\x6A",
		"\xF0\x9D\x93\x9A" => "\x6B",
		"\xF0\x9D\x93\x9B" => "\x6C",
		"\xF0\x9D\x93\x9C" => "\x6D",
		"\xF0\x9D\x93\x9D" => "\x6E",
		"\xF0\x9D\x93\x9E" => "\x6F",
		"\xF0\x9D\x93\x9F" => "\x70",
		"\xF0\x9D\x93\xA0" => "\x71",
		"\xF0\x9D\x93\xA1" => "\x72",
		"\xF0\x9D\x93\xA2" => "\x73",
		"\xF0\x9D\x93\xA3" => "\x74",
		"\xF0\x9D\x93\xA4" => "\x75",
		"\xF0\x9D\x93\xA5" => "\x76",
		"\xF0\x9D\x93\xA6" => "\x77",
		"\xF0\x9D\x93\xA7" => "\x78",
		"\xF0\x9D\x93\xA8" => "\x79",
		"\xF0\x9D\x93\xA9" => "\x7A",
		"\xF0\x9D\x93\xAA" => "\x61",
		"\xF0\x9D\x93\xAB" => "\x62",
		"\xF0\x9D\x93\xAC" => "\x63",
		"\xF0\x9D\x93\xAD" => "\x64",
		"\xF0\x9D\x93\xAE" => "\x65",
		"\xF0\x9D\x93\xAF" => "\x66",
		"\xF0\x9D\x93\xB0" => "\x67",
		"\xF0\x9D\x93\xB1" => "\x68",
		"\xF0\x9D\x93\xB2" => "\x69",
		"\xF0\x9D\x93\xB3" => "\x6A",
		"\xF0\x9D\x93\xB4" => "\x6B",
		"\xF0\x9D\x93\xB5" => "\x6C",
		"\xF0\x9D\x93\xB6" => "\x6D",
		"\xF0\x9D\x93\xB7" => "\x6E",
		"\xF0\x9D\x93\xB8" => "\x6F",
		"\xF0\x9D\x93\xB9" => "\x70",
		"\xF0\x9D\x93\xBA" => "\x71",
		"\xF0\x9D\x93\xBB" => "\x72",
		"\xF0\x9D\x93\xBC" => "\x73",
		"\xF0\x9D\x93\xBD" => "\x74",
		"\xF0\x9D\x93\xBE" => "\x75",
		"\xF0\x9D\x93\xBF" => "\x76",
		"\xF0\x9D\x94\x80" => "\x77",
		"\xF0\x9D\x94\x81" => "\x78",
		"\xF0\x9D\x94\x82" => "\x79",
		"\xF0\x9D\x94\x83" => "\x7A",
		"\xF0\x9D\x94\x84" => "\x61",
		"\xF0\x9D\x94\x85" => "\x62",
		"\xF0\x9D\x94\x87" => "\x64",
		"\xF0\x9D\x94\x88" => "\x65",
		"\xF0\x9D\x94\x89" => "\x66",
		"\xF0\x9D\x94\x8A" => "\x67",
		"\xF0\x9D\x94\x8D" => "\x6A",
		"\xF0\x9D\x94\x8E" => "\x6B",
		"\xF0\x9D\x94\x8F" => "\x6C",
		"\xF0\x9D\x94\x90" => "\x6D",
		"\xF0\x9D\x94\x91" => "\x6E",
		"\xF0\x9D\x94\x92" => "\x6F",
		"\xF0\x9D\x94\x93" => "\x70",
		"\xF0\x9D\x94\x94" => "\x71",
		"\xF0\x9D\x94\x96" => "\x73",
		"\xF0\x9D\x94\x97" => "\x74",
		"\xF0\x9D\x94\x98" => "\x75",
		"\xF0\x9D\x94\x99" => "\x76",
		"\xF0\x9D\x94\x9A" => "\x77",
		"\xF0\x9D\x94\x9B" => "\x78",
		"\xF0\x9D\x94\x9C" => "\x79",
		"\xF0\x9D\x94\x9E" => "\x61",
		"\xF0\x9D\x94\x9F" => "\x62",
		"\xF0\x9D\x94\xA0" => "\x63",
		"\xF0\x9D\x94\xA1" => "\x64",
		"\xF0\x9D\x94\xA2" => "\x65",
		"\xF0\x9D\x94\xA3" => "\x66",
		"\xF0\x9D\x94\xA4" => "\x67",
		"\xF0\x9D\x94\xA5" => "\x68",
		"\xF0\x9D\x94\xA6" => "\x69",
		"\xF0\x9D\x94\xA7" => "\x6A",
		"\xF0\x9D\x94\xA8" => "\x6B",
		"\xF0\x9D\x94\xA9" => "\x6C",
		"\xF0\x9D\x94\xAA" => "\x6D",
		"\xF0\x9D\x94\xAB" => "\x6E",
		"\xF0\x9D\x94\xAC" => "\x6F",
		"\xF0\x9D\x94\xAD" => "\x70",
		"\xF0\x9D\x94\xAE" => "\x71",
		"\xF0\x9D\x94\xAF" => "\x72",
		"\xF0\x9D\x94\xB0" => "\x73",
		"\xF0\x9D\x94\xB1" => "\x74",
		"\xF0\x9D\x94\xB2" => "\x75",
		"\xF0\x9D\x94\xB3" => "\x76",
		"\xF0\x9D\x94\xB4" => "\x77",
		"\xF0\x9D\x94\xB5" => "\x78",
		"\xF0\x9D\x94\xB6" => "\x79",
		"\xF0\x9D\x94\xB7" => "\x7A",
		"\xF0\x9D\x94\xB8" => "\x61",
		"\xF0\x9D\x94\xB9" => "\x62",
		"\xF0\x9D\x94\xBB" => "\x64",
		"\xF0\x9D\x94\xBC" => "\x65",
		"\xF0\x9D\x94\xBD" => "\x66",
		"\xF0\x9D\x94\xBE" => "\x67",
		"\xF0\x9D\x95\x80" => "\x69",
		"\xF0\x9D\x95\x81" => "\x6A",
		"\xF0\x9D\x95\x82" => "\x6B",
		"\xF0\x9D\x95\x83" => "\x6C",
		"\xF0\x9D\x95\x84" => "\x6D",
		"\xF0\x9D\x95\x86" => "\x6F",
		"\xF0\x9D\x95\x8A" => "\x73",
		"\xF0\x9D\x95\x8B" => "\x74",
		"\xF0\x9D\x95\x8C" => "\x75",
		"\xF0\x9D\x95\x8D" => "\x76",
		"\xF0\x9D\x95\x8E" => "\x77",
		"\xF0\x9D\x95\x8F" => "\x78",
		"\xF0\x9D\x95\x90" => "\x79",
		"\xF0\x9D\x95\x92" => "\x61",
		"\xF0\x9D\x95\x93" => "\x62",
		"\xF0\x9D\x95\x94" => "\x63",
		"\xF0\x9D\x95\x95" => "\x64",
		"\xF0\x9D\x95\x96" => "\x65",
		"\xF0\x9D\x95\x97" => "\x66",
		"\xF0\x9D\x95\x98" => "\x67",
		"\xF0\x9D\x95\x99" => "\x68",
		"\xF0\x9D\x95\x9A" => "\x69",
		"\xF0\x9D\x95\x9B" => "\x6A",
		"\xF0\x9D\x95\x9C" => "\x6B",
		"\xF0\x9D\x95\x9D" => "\x6C",
		"\xF0\x9D\x95\x9E" => "\x6D",
		"\xF0\x9D\x95\x9F" => "\x6E",
		"\xF0\x9D\x95\xA0" => "\x6F",
		"\xF0\x9D\x95\xA1" => "\x70",
		"\xF0\x9D\x95\xA2" => "\x71",
		"\xF0\x9D\x95\xA3" => "\x72",
		"\xF0\x9D\x95\xA4" => "\x73",
		"\xF0\x9D\x95\xA5" => "\x74",
		"\xF0\x9D\x95\xA6" => "\x75",
		"\xF0\x9D\x95\xA7" => "\x76",
		"\xF0\x9D\x95\xA8" => "\x77",
		"\xF0\x9D\x95\xA9" => "\x78",
		"\xF0\x9D\x95\xAA" => "\x79",
		"\xF0\x9D\x95\xAB" => "\x7A",
		"\xF0\x9D\x95\xAC" => "\x61",
		"\xF0\x9D\x95\xAD" => "\x62",
		"\xF0\x9D\x95\xAE" => "\x63",
		"\xF0\x9D\x95\xAF" => "\x64",
		"\xF0\x9D\x95\xB0" => "\x65",
		"\xF0\x9D\x95\xB1" => "\x66",
		"\xF0\x9D\x95\xB2" => "\x67",
		"\xF0\x9D\x95\xB3" => "\x68",
		"\xF0\x9D\x95\xB4" => "\x69",
		"\xF0\x9D\x95\xB5" => "\x6A",
		"\xF0\x9D\x95\xB6" => "\x6B",
		"\xF0\x9D\x95\xB7" => "\x6C",
		"\xF0\x9D\x95\xB8" => "\x6D",
		"\xF0\x9D\x95\xB9" => "\x6E",
		"\xF0\x9D\x95\xBA" => "\x6F",
		"\xF0\x9D\x95\xBB" => "\x70",
		"\xF0\x9D\x95\xBC" => "\x71",
		"\xF0\x9D\x95\xBD" => "\x72",
		"\xF0\x9D\x95\xBE" => "\x73",
		"\xF0\x9D\x95\xBF" => "\x74",
		"\xF0\x9D\x96\x80" => "\x75",
		"\xF0\x9D\x96\x81" => "\x76",
		"\xF0\x9D\x96\x82" => "\x77",
		"\xF0\x9D\x96\x83" => "\x78",
		"\xF0\x9D\x96\x84" => "\x79",
		"\xF0\x9D\x96\x85" => "\x7A",
		"\xF0\x9D\x96\x86" => "\x61",
		"\xF0\x9D\x96\x87" => "\x62",
		"\xF0\x9D\x96\x88" => "\x63",
		"\xF0\x9D\x96\x89" => "\x64",
		"\xF0\x9D\x96\x8A" => "\x65",
		"\xF0\x9D\x96\x8B" => "\x66",
		"\xF0\x9D\x96\x8C" => "\x67",
		"\xF0\x9D\x96\x8D" => "\x68",
		"\xF0\x9D\x96\x8E" => "\x69",
		"\xF0\x9D\x96\x8F" => "\x6A",
		"\xF0\x9D\x96\x90" => "\x6B",
		"\xF0\x9D\x96\x91" => "\x6C",
		"\xF0\x9D\x96\x92" => "\x6D",
		"\xF0\x9D\x96\x93" => "\x6E",
		"\xF0\x9D\x96\x94" => "\x6F",
		"\xF0\x9D\x96\x95" => "\x70",
		"\xF0\x9D\x96\x96" => "\x71",
		"\xF0\x9D\x96\x97" => "\x72",
		"\xF0\x9D\x96\x98" => "\x73",
		"\xF0\x9D\x96\x99" => "\x74",
		"\xF0\x9D\x96\x9A" => "\x75",
		"\xF0\x9D\x96\x9B" => "\x76",
		"\xF0\x9D\x96\x9C" => "\x77",
		"\xF0\x9D\x96\x9D" => "\x78",
		"\xF0\x9D\x96\x9E" => "\x79",
		"\xF0\x9D\x96\x9F" => "\x7A",
		"\xF0\x9D\x96\xA0" => "\x61",
		"\xF0\x9D\x96\xA1" => "\x62",
		"\xF0\x9D\x96\xA2" => "\x63",
		"\xF0\x9D\x96\xA3" => "\x64",
		"\xF0\x9D\x96\xA4" => "\x65",
		"\xF0\x9D\x96\xA5" => "\x66",
		"\xF0\x9D\x96\xA6" => "\x67",
		"\xF0\x9D\x96\xA7" => "\x68",
		"\xF0\x9D\x96\xA8" => "\x69",
		"\xF0\x9D\x96\xA9" => "\x6A",
		"\xF0\x9D\x96\xAA" => "\x6B",
		"\xF0\x9D\x96\xAB" => "\x6C",
		"\xF0\x9D\x96\xAC" => "\x6D",
		"\xF0\x9D\x96\xAD" => "\x6E",
		"\xF0\x9D\x96\xAE" => "\x6F",
		"\xF0\x9D\x96\xAF" => "\x70",
		"\xF0\x9D\x96\xB0" => "\x71",
		"\xF0\x9D\x96\xB1" => "\x72",
		"\xF0\x9D\x96\xB2" => "\x73",
		"\xF0\x9D\x96\xB3" => "\x74",
		"\xF0\x9D\x96\xB4" => "\x75",
		"\xF0\x9D\x96\xB5" => "\x76",
		"\xF0\x9D\x96\xB6" => "\x77",
		"\xF0\x9D\x96\xB7" => "\x78",
		"\xF0\x9D\x96\xB8" => "\x79",
		"\xF0\x9D\x96\xB9" => "\x7A",
		"\xF0\x9D\x96\xBA" => "\x61",
		"\xF0\x9D\x96\xBB" => "\x62",
		"\xF0\x9D\x96\xBC" => "\x63",
		"\xF0\x9D\x96\xBD" => "\x64",
		"\xF0\x9D\x96\xBE" => "\x65",
		"\xF0\x9D\x96\xBF" => "\x66",
		"\xF0\x9D\x97\x80" => "\x67",
		"\xF0\x9D\x97\x81" => "\x68",
		"\xF0\x9D\x97\x82" => "\x69",
		"\xF0\x9D\x97\x83" => "\x6A",
		"\xF0\x9D\x97\x84" => "\x6B",
		"\xF0\x9D\x97\x85" => "\x6C",
		"\xF0\x9D\x97\x86" => "\x6D",
		"\xF0\x9D\x97\x87" => "\x6E",
		"\xF0\x9D\x97\x88" => "\x6F",
		"\xF0\x9D\x97\x89" => "\x70",
		"\xF0\x9D\x97\x8A" => "\x71",
		"\xF0\x9D\x97\x8B" => "\x72",
		"\xF0\x9D\x97\x8C" => "\x73",
		"\xF0\x9D\x97\x8D" => "\x74",
		"\xF0\x9D\x97\x8E" => "\x75",
		"\xF0\x9D\x97\x8F" => "\x76",
		"\xF0\x9D\x97\x90" => "\x77",
		"\xF0\x9D\x97\x91" => "\x78",
		"\xF0\x9D\x97\x92" => "\x79",
		"\xF0\x9D\x97\x93" => "\x7A",
		"\xF0\x9D\x97\x94" => "\x61",
		"\xF0\x9D\x97\x95" => "\x62",
		"\xF0\x9D\x97\x96" => "\x63",
		"\xF0\x9D\x97\x97" => "\x64",
		"\xF0\x9D\x97\x98" => "\x65",
		"\xF0\x9D\x97\x99" => "\x66",
		"\xF0\x9D\x97\x9A" => "\x67",
		"\xF0\x9D\x97\x9B" => "\x68",
		"\xF0\x9D\x97\x9C" => "\x69",
		"\xF0\x9D\x97\x9D" => "\x6A",
		"\xF0\x9D\x97\x9E" => "\x6B",
		"\xF0\x9D\x97\x9F" => "\x6C",
		"\xF0\x9D\x97\xA0" => "\x6D",
		"\xF0\x9D\x97\xA1" => "\x6E",
		"\xF0\x9D\x97\xA2" => "\x6F",
		"\xF0\x9D\x97\xA3" => "\x70",
		"\xF0\x9D\x97\xA4" => "\x71",
		"\xF0\x9D\x97\xA5" => "\x72",
		"\xF0\x9D\x97\xA6" => "\x73",
		"\xF0\x9D\x97\xA7" => "\x74",
		"\xF0\x9D\x97\xA8" => "\x75",
		"\xF0\x9D\x97\xA9" => "\x76",
		"\xF0\x9D\x97\xAA" => "\x77",
		"\xF0\x9D\x97\xAB" => "\x78",
		"\xF0\x9D\x97\xAC" => "\x79",
		"\xF0\x9D\x97\xAD" => "\x7A",
		"\xF0\x9D\x97\xAE" => "\x61",
		"\xF0\x9D\x97\xAF" => "\x62",
		"\xF0\x9D\x97\xB0" => "\x63",
		"\xF0\x9D\x97\xB1" => "\x64",
		"\xF0\x9D\x97\xB2" => "\x65",
		"\xF0\x9D\x97\xB3" => "\x66",
		"\xF0\x9D\x97\xB4" => "\x67",
		"\xF0\x9D\x97\xB5" => "\x68",
		"\xF0\x9D\x97\xB6" => "\x69",
		"\xF0\x9D\x97\xB7" => "\x6A",
		"\xF0\x9D\x97\xB8" => "\x6B",
		"\xF0\x9D\x97\xB9" => "\x6C",
		"\xF0\x9D\x97\xBA" => "\x6D",
		"\xF0\x9D\x97\xBB" => "\x6E",
		"\xF0\x9D\x97\xBC" => "\x6F",
		"\xF0\x9D\x97\xBD" => "\x70",
		"\xF0\x9D\x97\xBE" => "\x71",
		"\xF0\x9D\x97\xBF" => "\x72",
		"\xF0\x9D\x98\x80" => "\x73",
		"\xF0\x9D\x98\x81" => "\x74",
		"\xF0\x9D\x98\x82" => "\x75",
		"\xF0\x9D\x98\x83" => "\x76",
		"\xF0\x9D\x98\x84" => "\x77",
		"\xF0\x9D\x98\x85" => "\x78",
		"\xF0\x9D\x98\x86" => "\x79",
		"\xF0\x9D\x98\x87" => "\x7A",
		"\xF0\x9D\x98\x88" => "\x61",
		"\xF0\x9D\x98\x89" => "\x62",
		"\xF0\x9D\x98\x8A" => "\x63",
		"\xF0\x9D\x98\x8B" => "\x64",
		"\xF0\x9D\x98\x8C" => "\x65",
		"\xF0\x9D\x98\x8D" => "\x66",
		"\xF0\x9D\x98\x8E" => "\x67",
		"\xF0\x9D\x98\x8F" => "\x68",
		"\xF0\x9D\x98\x90" => "\x69",
		"\xF0\x9D\x98\x91" => "\x6A",
		"\xF0\x9D\x98\x92" => "\x6B",
		"\xF0\x9D\x98\x93" => "\x6C",
		"\xF0\x9D\x98\x94" => "\x6D",
		"\xF0\x9D\x98\x95" => "\x6E",
		"\xF0\x9D\x98\x96" => "\x6F",
		"\xF0\x9D\x98\x97" => "\x70",
		"\xF0\x9D\x98\x98" => "\x71",
		"\xF0\x9D\x98\x99" => "\x72",
		"\xF0\x9D\x98\x9A" => "\x73",
		"\xF0\x9D\x98\x9B" => "\x74",
		"\xF0\x9D\x98\x9C" => "\x75",
		"\xF0\x9D\x98\x9D" => "\x76",
		"\xF0\x9D\x98\x9E" => "\x77",
		"\xF0\x9D\x98\x9F" => "\x78",
		"\xF0\x9D\x98\xA0" => "\x79",
		"\xF0\x9D\x98\xA1" => "\x7A",
		"\xF0\x9D\x98\xA2" => "\x61",
		"\xF0\x9D\x98\xA3" => "\x62",
		"\xF0\x9D\x98\xA4" => "\x63",
		"\xF0\x9D\x98\xA5" => "\x64",
		"\xF0\x9D\x98\xA6" => "\x65",
		"\xF0\x9D\x98\xA7" => "\x66",
		"\xF0\x9D\x98\xA8" => "\x67",
		"\xF0\x9D\x98\xA9" => "\x68",
		"\xF0\x9D\x98\xAA" => "\x69",
		"\xF0\x9D\x98\xAB" => "\x6A",
		"\xF0\x9D\x98\xAC" => "\x6B",
		"\xF0\x9D\x98\xAD" => "\x6C",
		"\xF0\x9D\x98\xAE" => "\x6D",
		"\xF0\x9D\x98\xAF" => "\x6E",
		"\xF0\x9D\x98\xB0" => "\x6F",
		"\xF0\x9D\x98\xB1" => "\x70",
		"\xF0\x9D\x98\xB2" => "\x71",
		"\xF0\x9D\x98\xB3" => "\x72",
		"\xF0\x9D\x98\xB4" => "\x73",
		"\xF0\x9D\x98\xB5" => "\x74",
		"\xF0\x9D\x98\xB6" => "\x75",
		"\xF0\x9D\x98\xB7" => "\x76",
		"\xF0\x9D\x98\xB8" => "\x77",
		"\xF0\x9D\x98\xB9" => "\x78",
		"\xF0\x9D\x98\xBA" => "\x79",
		"\xF0\x9D\x98\xBB" => "\x7A",
		"\xF0\x9D\x98\xBC" => "\x61",
		"\xF0\x9D\x98\xBD" => "\x62",
		"\xF0\x9D\x98\xBE" => "\x63",
		"\xF0\x9D\x98\xBF" => "\x64",
		"\xF0\x9D\x99\x80" => "\x65",
		"\xF0\x9D\x99\x81" => "\x66",
		"\xF0\x9D\x99\x82" => "\x67",
		"\xF0\x9D\x99\x83" => "\x68",
		"\xF0\x9D\x99\x84" => "\x69",
		"\xF0\x9D\x99\x85" => "\x6A",
		"\xF0\x9D\x99\x86" => "\x6B",
		"\xF0\x9D\x99\x87" => "\x6C",
		"\xF0\x9D\x99\x88" => "\x6D",
		"\xF0\x9D\x99\x89" => "\x6E",
		"\xF0\x9D\x99\x8A" => "\x6F",
		"\xF0\x9D\x99\x8B" => "\x70",
		"\xF0\x9D\x99\x8C" => "\x71",
		"\xF0\x9D\x99\x8D" => "\x72",
		"\xF0\x9D\x99\x8E" => "\x73",
		"\xF0\x9D\x99\x8F" => "\x74",
		"\xF0\x9D\x99\x90" => "\x75",
		"\xF0\x9D\x99\x91" => "\x76",
		"\xF0\x9D\x99\x92" => "\x77",
		"\xF0\x9D\x99\x93" => "\x78",
		"\xF0\x9D\x99\x94" => "\x79",
		"\xF0\x9D\x99\x95" => "\x7A",
		"\xF0\x9D\x99\x96" => "\x61",
		"\xF0\x9D\x99\x97" => "\x62",
		"\xF0\x9D\x99\x98" => "\x63",
		"\xF0\x9D\x99\x99" => "\x64",
		"\xF0\x9D\x99\x9A" => "\x65",
		"\xF0\x9D\x99\x9B" => "\x66",
		"\xF0\x9D\x99\x9C" => "\x67",
		"\xF0\x9D\x99\x9D" => "\x68",
		"\xF0\x9D\x99\x9E" => "\x69",
		"\xF0\x9D\x99\x9F" => "\x6A",
		"\xF0\x9D\x99\xA0" => "\x6B",
		"\xF0\x9D\x99\xA1" => "\x6C",
		"\xF0\x9D\x99\xA2" => "\x6D",
		"\xF0\x9D\x99\xA3" => "\x6E",
		"\xF0\x9D\x99\xA4" => "\x6F",
		"\xF0\x9D\x99\xA5" => "\x70",
		"\xF0\x9D\x99\xA6" => "\x71",
		"\xF0\x9D\x99\xA7" => "\x72",
		"\xF0\x9D\x99\xA8" => "\x73",
		"\xF0\x9D\x99\xA9" => "\x74",
		"\xF0\x9D\x99\xAA" => "\x75",
		"\xF0\x9D\x99\xAB" => "\x76",
		"\xF0\x9D\x99\xAC" => "\x77",
		"\xF0\x9D\x99\xAD" => "\x78",
		"\xF0\x9D\x99\xAE" => "\x79",
		"\xF0\x9D\x99\xAF" => "\x7A",
		"\xF0\x9D\x99\xB0" => "\x61",
		"\xF0\x9D\x99\xB1" => "\x62",
		"\xF0\x9D\x99\xB2" => "\x63",
		"\xF0\x9D\x99\xB3" => "\x64",
		"\xF0\x9D\x99\xB4" => "\x65",
		"\xF0\x9D\x99\xB5" => "\x66",
		"\xF0\x9D\x99\xB6" => "\x67",
		"\xF0\x9D\x99\xB7" => "\x68",
		"\xF0\x9D\x99\xB8" => "\x69",
		"\xF0\x9D\x99\xB9" => "\x6A",
		"\xF0\x9D\x99\xBA" => "\x6B",
		"\xF0\x9D\x99\xBB" => "\x6C",
		"\xF0\x9D\x99\xBC" => "\x6D",
		"\xF0\x9D\x99\xBD" => "\x6E",
		"\xF0\x9D\x99\xBE" => "\x6F",
		"\xF0\x9D\x99\xBF" => "\x70",
		"\xF0\x9D\x9A\x80" => "\x71",
		"\xF0\x9D\x9A\x81" => "\x72",
		"\xF0\x9D\x9A\x82" => "\x73",
		"\xF0\x9D\x9A\x83" => "\x74",
		"\xF0\x9D\x9A\x84" => "\x75",
		"\xF0\x9D\x9A\x85" => "\x76",
		"\xF0\x9D\x9A\x86" => "\x77",
		"\xF0\x9D\x9A\x87" => "\x78",
		"\xF0\x9D\x9A\x88" => "\x79",
		"\xF0\x9D\x9A\x89" => "\x7A",
		"\xF0\x9D\x9A\x8A" => "\x61",
		"\xF0\x9D\x9A\x8B" => "\x62",
		"\xF0\x9D\x9A\x8C" => "\x63",
		"\xF0\x9D\x9A\x8D" => "\x64",
		"\xF0\x9D\x9A\x8E" => "\x65",
		"\xF0\x9D\x9A\x8F" => "\x66",
		"\xF0\x9D\x9A\x90" => "\x67",
		"\xF0\x9D\x9A\x91" => "\x68",
		"\xF0\x9D\x9A\x92" => "\x69",
		"\xF0\x9D\x9A\x93" => "\x6A",
		"\xF0\x9D\x9A\x94" => "\x6B",
		"\xF0\x9D\x9A\x95" => "\x6C",
		"\xF0\x9D\x9A\x96" => "\x6D",
		"\xF0\x9D\x9A\x97" => "\x6E",
		"\xF0\x9D\x9A\x98" => "\x6F",
		"\xF0\x9D\x9A\x99" => "\x70",
		"\xF0\x9D\x9A\x9A" => "\x71",
		"\xF0\x9D\x9A\x9B" => "\x72",
		"\xF0\x9D\x9A\x9C" => "\x73",
		"\xF0\x9D\x9A\x9D" => "\x74",
		"\xF0\x9D\x9A\x9E" => "\x75",
		"\xF0\x9D\x9A\x9F" => "\x76",
		"\xF0\x9D\x9A\xA0" => "\x77",
		"\xF0\x9D\x9A\xA1" => "\x78",
		"\xF0\x9D\x9A\xA2" => "\x79",
		"\xF0\x9D\x9A\xA3" => "\x7A",
		"\xF0\x9D\x9A\xA4" => "\xC4\xB1",
		"\xF0\x9D\x9A\xA5" => "\xC8\xB7",
		"\xF0\x9D\x9A\xA8" => "\xCE\xB1",
		"\xF0\x9D\x9A\xA9" => "\xCE\xB2",
		"\xF0\x9D\x9A\xAA" => "\xCE\xB3",
		"\xF0\x9D\x9A\xAB" => "\xCE\xB4",
		"\xF0\x9D\x9A\xAC" => "\xCE\xB5",
		"\xF0\x9D\x9A\xAD" => "\xCE\xB6",
		"\xF0\x9D\x9A\xAE" => "\xCE\xB7",
		"\xF0\x9D\x9A\xAF" => "\xCE\xB8",
		"\xF0\x9D\x9A\xB0" => "\xCE\xB9",
		"\xF0\x9D\x9A\xB1" => "\xCE\xBA",
		"\xF0\x9D\x9A\xB2" => "\xCE\xBB",
		"\xF0\x9D\x9A\xB3" => "\xCE\xBC",
		"\xF0\x9D\x9A\xB4" => "\xCE\xBD",
		"\xF0\x9D\x9A\xB5" => "\xCE\xBE",
		"\xF0\x9D\x9A\xB6" => "\xCE\xBF",
		"\xF0\x9D\x9A\xB7" => "\xCF\x80",
		"\xF0\x9D\x9A\xB8" => "\xCF\x81",
		"\xF0\x9D\x9A\xB9" => "\xCE\xB8",
		"\xF0\x9D\x9A\xBA" => "\xCF\x83",
		"\xF0\x9D\x9A\xBB" => "\xCF\x84",
		"\xF0\x9D\x9A\xBC" => "\xCF\x85",
		"\xF0\x9D\x9A\xBD" => "\xCF\x86",
		"\xF0\x9D\x9A\xBE" => "\xCF\x87",
		"\xF0\x9D\x9A\xBF" => "\xCF\x88",
		"\xF0\x9D\x9B\x80" => "\xCF\x89",
		"\xF0\x9D\x9B\x81" => "\xE2\x88\x87",
		"\xF0\x9D\x9B\x82" => "\xCE\xB1",
		"\xF0\x9D\x9B\x83" => "\xCE\xB2",
		"\xF0\x9D\x9B\x84" => "\xCE\xB3",
		"\xF0\x9D\x9B\x85" => "\xCE\xB4",
		"\xF0\x9D\x9B\x86" => "\xCE\xB5",
		"\xF0\x9D\x9B\x87" => "\xCE\xB6",
		"\xF0\x9D\x9B\x88" => "\xCE\xB7",
		"\xF0\x9D\x9B\x89" => "\xCE\xB8",
		"\xF0\x9D\x9B\x8A" => "\xCE\xB9",
		"\xF0\x9D\x9B\x8B" => "\xCE\xBA",
		"\xF0\x9D\x9B\x8C" => "\xCE\xBB",
		"\xF0\x9D\x9B\x8D" => "\xCE\xBC",
		"\xF0\x9D\x9B\x8E" => "\xCE\xBD",
		"\xF0\x9D\x9B\x8F" => "\xCE\xBE",
		"\xF0\x9D\x9B\x90" => "\xCE\xBF",
		"\xF0\x9D\x9B\x91" => "\xCF\x80",
		"\xF0\x9D\x9B\x92" => "\xCF\x81",
		"\xF0\x9D\x9B\x93" => "\xCF\x83",
		"\xF0\x9D\x9B\x94" => "\xCF\x83",
		"\xF0\x9D\x9B\x95" => "\xCF\x84",
		"\xF0\x9D\x9B\x96" => "\xCF\x85",
		"\xF0\x9D\x9B\x97" => "\xCF\x86",
		"\xF0\x9D\x9B\x98" => "\xCF\x87",
		"\xF0\x9D\x9B\x99" => "\xCF\x88",
		"\xF0\x9D\x9B\x9A" => "\xCF\x89",
		"\xF0\x9D\x9B\x9B" => "\xE2\x88\x82",
		"\xF0\x9D\x9B\x9C" => "\xCE\xB5",
		"\xF0\x9D\x9B\x9D" => "\xCE\xB8",
		"\xF0\x9D\x9B\x9E" => "\xCE\xBA",
		"\xF0\x9D\x9B\x9F" => "\xCF\x86",
		"\xF0\x9D\x9B\xA0" => "\xCF\x81",
		"\xF0\x9D\x9B\xA1" => "\xCF\x80",
		"\xF0\x9D\x9B\xA2" => "\xCE\xB1",
		"\xF0\x9D\x9B\xA3" => "\xCE\xB2",
		"\xF0\x9D\x9B\xA4" => "\xCE\xB3",
		"\xF0\x9D\x9B\xA5" => "\xCE\xB4",
		"\xF0\x9D\x9B\xA6" => "\xCE\xB5",
		"\xF0\x9D\x9B\xA7" => "\xCE\xB6",
		"\xF0\x9D\x9B\xA8" => "\xCE\xB7",
		"\xF0\x9D\x9B\xA9" => "\xCE\xB8",
		"\xF0\x9D\x9B\xAA" => "\xCE\xB9",
		"\xF0\x9D\x9B\xAB" => "\xCE\xBA",
		"\xF0\x9D\x9B\xAC" => "\xCE\xBB",
		"\xF0\x9D\x9B\xAD" => "\xCE\xBC",
		"\xF0\x9D\x9B\xAE" => "\xCE\xBD",
		"\xF0\x9D\x9B\xAF" => "\xCE\xBE",
		"\xF0\x9D\x9B\xB0" => "\xCE\xBF",
		"\xF0\x9D\x9B\xB1" => "\xCF\x80",
		"\xF0\x9D\x9B\xB2" => "\xCF\x81",
		"\xF0\x9D\x9B\xB3" => "\xCE\xB8",
		"\xF0\x9D\x9B\xB4" => "\xCF\x83",
		"\xF0\x9D\x9B\xB5" => "\xCF\x84",
		"\xF0\x9D\x9B\xB6" => "\xCF\x85",
		"\xF0\x9D\x9B\xB7" => "\xCF\x86",
		"\xF0\x9D\x9B\xB8" => "\xCF\x87",
		"\xF0\x9D\x9B\xB9" => "\xCF\x88",
		"\xF0\x9D\x9B\xBA" => "\xCF\x89",
		"\xF0\x9D\x9B\xBB" => "\xE2\x88\x87",
		"\xF0\x9D\x9B\xBC" => "\xCE\xB1",
		"\xF0\x9D\x9B\xBD" => "\xCE\xB2",
		"\xF0\x9D\x9B\xBE" => "\xCE\xB3",
		"\xF0\x9D\x9B\xBF" => "\xCE\xB4",
		"\xF0\x9D\x9C\x80" => "\xCE\xB5",
		"\xF0\x9D\x9C\x81" => "\xCE\xB6",
		"\xF0\x9D\x9C\x82" => "\xCE\xB7",
		"\xF0\x9D\x9C\x83" => "\xCE\xB8",
		"\xF0\x9D\x9C\x84" => "\xCE\xB9",
		"\xF0\x9D\x9C\x85" => "\xCE\xBA",
		"\xF0\x9D\x9C\x86" => "\xCE\xBB",
		"\xF0\x9D\x9C\x87" => "\xCE\xBC",
		"\xF0\x9D\x9C\x88" => "\xCE\xBD",
		"\xF0\x9D\x9C\x89" => "\xCE\xBE",
		"\xF0\x9D\x9C\x8A" => "\xCE\xBF",
		"\xF0\x9D\x9C\x8B" => "\xCF\x80",
		"\xF0\x9D\x9C\x8C" => "\xCF\x81",
		"\xF0\x9D\x9C\x8D" => "\xCF\x83",
		"\xF0\x9D\x9C\x8E" => "\xCF\x83",
		"\xF0\x9D\x9C\x8F" => "\xCF\x84",
		"\xF0\x9D\x9C\x90" => "\xCF\x85",
		"\xF0\x9D\x9C\x91" => "\xCF\x86",
		"\xF0\x9D\x9C\x92" => "\xCF\x87",
		"\xF0\x9D\x9C\x93" => "\xCF\x88",
		"\xF0\x9D\x9C\x94" => "\xCF\x89",
		"\xF0\x9D\x9C\x95" => "\xE2\x88\x82",
		"\xF0\x9D\x9C\x96" => "\xCE\xB5",
		"\xF0\x9D\x9C\x97" => "\xCE\xB8",
		"\xF0\x9D\x9C\x98" => "\xCE\xBA",
		"\xF0\x9D\x9C\x99" => "\xCF\x86",
		"\xF0\x9D\x9C\x9A" => "\xCF\x81",
		"\xF0\x9D\x9C\x9B" => "\xCF\x80",
		"\xF0\x9D\x9C\x9C" => "\xCE\xB1",
		"\xF0\x9D\x9C\x9D" => "\xCE\xB2",
		"\xF0\x9D\x9C\x9E" => "\xCE\xB3",
		"\xF0\x9D\x9C\x9F" => "\xCE\xB4",
		"\xF0\x9D\x9C\xA0" => "\xCE\xB5",
		"\xF0\x9D\x9C\xA1" => "\xCE\xB6",
		"\xF0\x9D\x9C\xA2" => "\xCE\xB7",
		"\xF0\x9D\x9C\xA3" => "\xCE\xB8",
		"\xF0\x9D\x9C\xA4" => "\xCE\xB9",
		"\xF0\x9D\x9C\xA5" => "\xCE\xBA",
		"\xF0\x9D\x9C\xA6" => "\xCE\xBB",
		"\xF0\x9D\x9C\xA7" => "\xCE\xBC",
		"\xF0\x9D\x9C\xA8" => "\xCE\xBD",
		"\xF0\x9D\x9C\xA9" => "\xCE\xBE",
		"\xF0\x9D\x9C\xAA" => "\xCE\xBF",
		"\xF0\x9D\x9C\xAB" => "\xCF\x80",
		"\xF0\x9D\x9C\xAC" => "\xCF\x81",
		"\xF0\x9D\x9C\xAD" => "\xCE\xB8",
		"\xF0\x9D\x9C\xAE" => "\xCF\x83",
		"\xF0\x9D\x9C\xAF" => "\xCF\x84",
		"\xF0\x9D\x9C\xB0" => "\xCF\x85",
		"\xF0\x9D\x9C\xB1" => "\xCF\x86",
		"\xF0\x9D\x9C\xB2" => "\xCF\x87",
		"\xF0\x9D\x9C\xB3" => "\xCF\x88",
		"\xF0\x9D\x9C\xB4" => "\xCF\x89",
		"\xF0\x9D\x9C\xB5" => "\xE2\x88\x87",
		"\xF0\x9D\x9C\xB6" => "\xCE\xB1",
		"\xF0\x9D\x9C\xB7" => "\xCE\xB2",
		"\xF0\x9D\x9C\xB8" => "\xCE\xB3",
		"\xF0\x9D\x9C\xB9" => "\xCE\xB4",
		"\xF0\x9D\x9C\xBA" => "\xCE\xB5",
		"\xF0\x9D\x9C\xBB" => "\xCE\xB6",
		"\xF0\x9D\x9C\xBC" => "\xCE\xB7",
		"\xF0\x9D\x9C\xBD" => "\xCE\xB8",
		"\xF0\x9D\x9C\xBE" => "\xCE\xB9",
		"\xF0\x9D\x9C\xBF" => "\xCE\xBA",
		"\xF0\x9D\x9D\x80" => "\xCE\xBB",
		"\xF0\x9D\x9D\x81" => "\xCE\xBC",
		"\xF0\x9D\x9D\x82" => "\xCE\xBD",
		"\xF0\x9D\x9D\x83" => "\xCE\xBE",
		"\xF0\x9D\x9D\x84" => "\xCE\xBF",
		"\xF0\x9D\x9D\x85" => "\xCF\x80",
		"\xF0\x9D\x9D\x86" => "\xCF\x81",
		"\xF0\x9D\x9D\x87" => "\xCF\x83",
		"\xF0\x9D\x9D\x88" => "\xCF\x83",
		"\xF0\x9D\x9D\x89" => "\xCF\x84",
		"\xF0\x9D\x9D\x8A" => "\xCF\x85",
		"\xF0\x9D\x9D\x8B" => "\xCF\x86",
		"\xF0\x9D\x9D\x8C" => "\xCF\x87",
		"\xF0\x9D\x9D\x8D" => "\xCF\x88",
		"\xF0\x9D\x9D\x8E" => "\xCF\x89",
		"\xF0\x9D\x9D\x8F" => "\xE2\x88\x82",
		"\xF0\x9D\x9D\x90" => "\xCE\xB5",
		"\xF0\x9D\x9D\x91" => "\xCE\xB8",
		"\xF0\x9D\x9D\x92" => "\xCE\xBA",
		"\xF0\x9D\x9D\x93" => "\xCF\x86",
		"\xF0\x9D\x9D\x94" => "\xCF\x81",
		"\xF0\x9D\x9D\x95" => "\xCF\x80",
		"\xF0\x9D\x9D\x96" => "\xCE\xB1",
		"\xF0\x9D\x9D\x97" => "\xCE\xB2",
		"\xF0\x9D\x9D\x98" => "\xCE\xB3",
		"\xF0\x9D\x9D\x99" => "\xCE\xB4",
		"\xF0\x9D\x9D\x9A" => "\xCE\xB5",
		"\xF0\x9D\x9D\x9B" => "\xCE\xB6",
		"\xF0\x9D\x9D\x9C" => "\xCE\xB7",
		"\xF0\x9D\x9D\x9D" => "\xCE\xB8",
		"\xF0\x9D\x9D\x9E" => "\xCE\xB9",
		"\xF0\x9D\x9D\x9F" => "\xCE\xBA",
		"\xF0\x9D\x9D\xA0" => "\xCE\xBB",
		"\xF0\x9D\x9D\xA1" => "\xCE\xBC",
		"\xF0\x9D\x9D\xA2" => "\xCE\xBD",
		"\xF0\x9D\x9D\xA3" => "\xCE\xBE",
		"\xF0\x9D\x9D\xA4" => "\xCE\xBF",
		"\xF0\x9D\x9D\xA5" => "\xCF\x80",
		"\xF0\x9D\x9D\xA6" => "\xCF\x81",
		"\xF0\x9D\x9D\xA7" => "\xCE\xB8",
		"\xF0\x9D\x9D\xA8" => "\xCF\x83",
		"\xF0\x9D\x9D\xA9" => "\xCF\x84",
		"\xF0\x9D\x9D\xAA" => "\xCF\x85",
		"\xF0\x9D\x9D\xAB" => "\xCF\x86",
		"\xF0\x9D\x9D\xAC" => "\xCF\x87",
		"\xF0\x9D\x9D\xAD" => "\xCF\x88",
		"\xF0\x9D\x9D\xAE" => "\xCF\x89",
		"\xF0\x9D\x9D\xAF" => "\xE2\x88\x87",
		"\xF0\x9D\x9D\xB0" => "\xCE\xB1",
		"\xF0\x9D\x9D\xB1" => "\xCE\xB2",
		"\xF0\x9D\x9D\xB2" => "\xCE\xB3",
		"\xF0\x9D\x9D\xB3" => "\xCE\xB4",
		"\xF0\x9D\x9D\xB4" => "\xCE\xB5",
		"\xF0\x9D\x9D\xB5" => "\xCE\xB6",
		"\xF0\x9D\x9D\xB6" => "\xCE\xB7",
		"\xF0\x9D\x9D\xB7" => "\xCE\xB8",
		"\xF0\x9D\x9D\xB8" => "\xCE\xB9",
		"\xF0\x9D\x9D\xB9" => "\xCE\xBA",
		"\xF0\x9D\x9D\xBA" => "\xCE\xBB",
		"\xF0\x9D\x9D\xBB" => "\xCE\xBC",
		"\xF0\x9D\x9D\xBC" => "\xCE\xBD",
		"\xF0\x9D\x9D\xBD" => "\xCE\xBE",
		"\xF0\x9D\x9D\xBE" => "\xCE\xBF",
		"\xF0\x9D\x9D\xBF" => "\xCF\x80",
		"\xF0\x9D\x9E\x80" => "\xCF\x81",
		"\xF0\x9D\x9E\x81" => "\xCF\x83",
		"\xF0\x9D\x9E\x82" => "\xCF\x83",
		"\xF0\x9D\x9E\x83" => "\xCF\x84",
		"\xF0\x9D\x9E\x84" => "\xCF\x85",
		"\xF0\x9D\x9E\x85" => "\xCF\x86",
		"\xF0\x9D\x9E\x86" => "\xCF\x87",
		"\xF0\x9D\x9E\x87" => "\xCF\x88",
		"\xF0\x9D\x9E\x88" => "\xCF\x89",
		"\xF0\x9D\x9E\x89" => "\xE2\x88\x82",
		"\xF0\x9D\x9E\x8A" => "\xCE\xB5",
		"\xF0\x9D\x9E\x8B" => "\xCE\xB8",
		"\xF0\x9D\x9E\x8C" => "\xCE\xBA",
		"\xF0\x9D\x9E\x8D" => "\xCF\x86",
		"\xF0\x9D\x9E\x8E" => "\xCF\x81",
		"\xF0\x9D\x9E\x8F" => "\xCF\x80",
		"\xF0\x9D\x9E\x90" => "\xCE\xB1",
		"\xF0\x9D\x9E\x91" => "\xCE\xB2",
		"\xF0\x9D\x9E\x92" => "\xCE\xB3",
		"\xF0\x9D\x9E\x93" => "\xCE\xB4",
		"\xF0\x9D\x9E\x94" => "\xCE\xB5",
		"\xF0\x9D\x9E\x95" => "\xCE\xB6",
		"\xF0\x9D\x9E\x96" => "\xCE\xB7",
		"\xF0\x9D\x9E\x97" => "\xCE\xB8",
		"\xF0\x9D\x9E\x98" => "\xCE\xB9",
		"\xF0\x9D\x9E\x99" => "\xCE\xBA",
		"\xF0\x9D\x9E\x9A" => "\xCE\xBB",
		"\xF0\x9D\x9E\x9B" => "\xCE\xBC",
		"\xF0\x9D\x9E\x9C" => "\xCE\xBD",
		"\xF0\x9D\x9E\x9D" => "\xCE\xBE",
		"\xF0\x9D\x9E\x9E" => "\xCE\xBF",
		"\xF0\x9D\x9E\x9F" => "\xCF\x80",
		"\xF0\x9D\x9E\xA0" => "\xCF\x81",
		"\xF0\x9D\x9E\xA1" => "\xCE\xB8",
		"\xF0\x9D\x9E\xA2" => "\xCF\x83",
		"\xF0\x9D\x9E\xA3" => "\xCF\x84",
		"\xF0\x9D\x9E\xA4" => "\xCF\x85",
		"\xF0\x9D\x9E\xA5" => "\xCF\x86",
		"\xF0\x9D\x9E\xA6" => "\xCF\x87",
		"\xF0\x9D\x9E\xA7" => "\xCF\x88",
		"\xF0\x9D\x9E\xA8" => "\xCF\x89",
		"\xF0\x9D\x9E\xA9" => "\xE2\x88\x87",
		"\xF0\x9D\x9E\xAA" => "\xCE\xB1",
		"\xF0\x9D\x9E\xAB" => "\xCE\xB2",
		"\xF0\x9D\x9E\xAC" => "\xCE\xB3",
		"\xF0\x9D\x9E\xAD" => "\xCE\xB4",
		"\xF0\x9D\x9E\xAE" => "\xCE\xB5",
		"\xF0\x9D\x9E\xAF" => "\xCE\xB6",
		"\xF0\x9D\x9E\xB0" => "\xCE\xB7",
		"\xF0\x9D\x9E\xB1" => "\xCE\xB8",
		"\xF0\x9D\x9E\xB2" => "\xCE\xB9",
		"\xF0\x9D\x9E\xB3" => "\xCE\xBA",
		"\xF0\x9D\x9E\xB4" => "\xCE\xBB",
		"\xF0\x9D\x9E\xB5" => "\xCE\xBC",
		"\xF0\x9D\x9E\xB6" => "\xCE\xBD",
		"\xF0\x9D\x9E\xB7" => "\xCE\xBE",
		"\xF0\x9D\x9E\xB8" => "\xCE\xBF",
		"\xF0\x9D\x9E\xB9" => "\xCF\x80",
		"\xF0\x9D\x9E\xBA" => "\xCF\x81",
		"\xF0\x9D\x9E\xBB" => "\xCF\x83",
		"\xF0\x9D\x9E\xBC" => "\xCF\x83",
		"\xF0\x9D\x9E\xBD" => "\xCF\x84",
		"\xF0\x9D\x9E\xBE" => "\xCF\x85",
		"\xF0\x9D\x9E\xBF" => "\xCF\x86",
		"\xF0\x9D\x9F\x80" => "\xCF\x87",
		"\xF0\x9D\x9F\x81" => "\xCF\x88",
		"\xF0\x9D\x9F\x82" => "\xCF\x89",
		"\xF0\x9D\x9F\x83" => "\xE2\x88\x82",
		"\xF0\x9D\x9F\x84" => "\xCE\xB5",
		"\xF0\x9D\x9F\x85" => "\xCE\xB8",
		"\xF0\x9D\x9F\x86" => "\xCE\xBA",
		"\xF0\x9D\x9F\x87" => "\xCF\x86",
		"\xF0\x9D\x9F\x88" => "\xCF\x81",
		"\xF0\x9D\x9F\x89" => "\xCF\x80",
		"\xF0\x9D\x9F\x8A" => "\xCF\x9D",
		"\xF0\x9D\x9F\x8B" => "\xCF\x9D",
		"\xF0\x9D\x9F\x8E" => "\x30",
		"\xF0\x9D\x9F\x8F" => "\x31",
		"\xF0\x9D\x9F\x90" => "\x32",
		"\xF0\x9D\x9F\x91" => "\x33",
		"\xF0\x9D\x9F\x92" => "\x34",
		"\xF0\x9D\x9F\x93" => "\x35",
		"\xF0\x9D\x9F\x94" => "\x36",
		"\xF0\x9D\x9F\x95" => "\x37",
		"\xF0\x9D\x9F\x96" => "\x38",
		"\xF0\x9D\x9F\x97" => "\x39",
		"\xF0\x9D\x9F\x98" => "\x30",
		"\xF0\x9D\x9F\x99" => "\x31",
		"\xF0\x9D\x9F\x9A" => "\x32",
		"\xF0\x9D\x9F\x9B" => "\x33",
		"\xF0\x9D\x9F\x9C" => "\x34",
		"\xF0\x9D\x9F\x9D" => "\x35",
		"\xF0\x9D\x9F\x9E" => "\x36",
		"\xF0\x9D\x9F\x9F" => "\x37",
		"\xF0\x9D\x9F\xA0" => "\x38",
		"\xF0\x9D\x9F\xA1" => "\x39",
		"\xF0\x9D\x9F\xA2" => "\x30",
		"\xF0\x9D\x9F\xA3" => "\x31",
		"\xF0\x9D\x9F\xA4" => "\x32",
		"\xF0\x9D\x9F\xA5" => "\x33",
		"\xF0\x9D\x9F\xA6" => "\x34",
		"\xF0\x9D\x9F\xA7" => "\x35",
		"\xF0\x9D\x9F\xA8" => "\x36",
		"\xF0\x9D\x9F\xA9" => "\x37",
		"\xF0\x9D\x9F\xAA" => "\x38",
		"\xF0\x9D\x9F\xAB" => "\x39",
		"\xF0\x9D\x9F\xAC" => "\x30",
		"\xF0\x9D\x9F\xAD" => "\x31",
		"\xF0\x9D\x9F\xAE" => "\x32",
		"\xF0\x9D\x9F\xAF" => "\x33",
		"\xF0\x9D\x9F\xB0" => "\x34",
		"\xF0\x9D\x9F\xB1" => "\x35",
		"\xF0\x9D\x9F\xB2" => "\x36",
		"\xF0\x9D\x9F\xB3" => "\x37",
		"\xF0\x9D\x9F\xB4" => "\x38",
		"\xF0\x9D\x9F\xB5" => "\x39",
		"\xF0\x9D\x9F\xB6" => "\x30",
		"\xF0\x9D\x9F\xB7" => "\x31",
		"\xF0\x9D\x9F\xB8" => "\x32",
		"\xF0\x9D\x9F\xB9" => "\x33",
		"\xF0\x9D\x9F\xBA" => "\x34",
		"\xF0\x9D\x9F\xBB" => "\x35",
		"\xF0\x9D\x9F\xBC" => "\x36",
		"\xF0\x9D\x9F\xBD" => "\x37",
		"\xF0\x9D\x9F\xBE" => "\x38",
		"\xF0\x9D\x9F\xBF" => "\x39",
		"\xF0\x9E\x80\xB0" => "\xD0\xB0",
		"\xF0\x9E\x80\xB1" => "\xD0\xB1",
		"\xF0\x9E\x80\xB2" => "\xD0\xB2",
		"\xF0\x9E\x80\xB3" => "\xD0\xB3",
		"\xF0\x9E\x80\xB4" => "\xD0\xB4",
		"\xF0\x9E\x80\xB5" => "\xD0\xB5",
		"\xF0\x9E\x80\xB6" => "\xD0\xB6",
		"\xF0\x9E\x80\xB7" => "\xD0\xB7",
		"\xF0\x9E\x80\xB8" => "\xD0\xB8",
		"\xF0\x9E\x80\xB9" => "\xD0\xBA",
		"\xF0\x9E\x80\xBA" => "\xD0\xBB",
		"\xF0\x9E\x80\xBB" => "\xD0\xBC",
		"\xF0\x9E\x80\xBC" => "\xD0\xBE",
		"\xF0\x9E\x80\xBD" => "\xD0\xBF",
		"\xF0\x9E\x80\xBE" => "\xD1\x80",
		"\xF0\x9E\x80\xBF" => "\xD1\x81",
		"\xF0\x9E\x81\x80" => "\xD1\x82",
		"\xF0\x9E\x81\x81" => "\xD1\x83",
		"\xF0\x9E\x81\x82" => "\xD1\x84",
		"\xF0\x9E\x81\x83" => "\xD1\x85",
		"\xF0\x9E\x81\x84" => "\xD1\x86",
		"\xF0\x9E\x81\x85" => "\xD1\x87",
		"\xF0\x9E\x81\x86" => "\xD1\x88",
		"\xF0\x9E\x81\x87" => "\xD1\x8B",
		"\xF0\x9E\x81\x88" => "\xD1\x8D",
		"\xF0\x9E\x81\x89" => "\xD1\x8E",
		"\xF0\x9E\x81\x8A" => "\xEA\x9A\x89",
		"\xF0\x9E\x81\x8B" => "\xD3\x99",
		"\xF0\x9E\x81\x8C" => "\xD1\x96",
		"\xF0\x9E\x81\x8D" => "\xD1\x98",
		"\xF0\x9E\x81\x8E" => "\xD3\xA9",
		"\xF0\x9E\x81\x8F" => "\xD2\xAF",
		"\xF0\x9E\x81\x90" => "\xD3\x8F",
		"\xF0\x9E\x81\x91" => "\xD0\xB0",
		"\xF0\x9E\x81\x92" => "\xD0\xB1",
		"\xF0\x9E\x81\x93" => "\xD0\xB2",
		"\xF0\x9E\x81\x94" => "\xD0\xB3",
		"\xF0\x9E\x81\x95" => "\xD0\xB4",
		"\xF0\x9E\x81\x96" => "\xD0\xB5",
		"\xF0\x9E\x81\x97" => "\xD0\xB6",
		"\xF0\x9E\x81\x98" => "\xD0\xB7",
		"\xF0\x9E\x81\x99" => "\xD0\xB8",
		"\xF0\x9E\x81\x9A" => "\xD0\xBA",
		"\xF0\x9E\x81\x9B" => "\xD0\xBB",
		"\xF0\x9E\x81\x9C" => "\xD0\xBE",
		"\xF0\x9E\x81\x9D" => "\xD0\xBF",
		"\xF0\x9E\x81\x9E" => "\xD1\x81",
		"\xF0\x9E\x81\x9F" => "\xD1\x83",
		"\xF0\x9E\x81\xA0" => "\xD1\x84",
		"\xF0\x9E\x81\xA1" => "\xD1\x85",
		"\xF0\x9E\x81\xA2" => "\xD1\x86",
		"\xF0\x9E\x81\xA3" => "\xD1\x87",
		"\xF0\x9E\x81\xA4" => "\xD1\x88",
		"\xF0\x9E\x81\xA5" => "\xD1\x8A",
		"\xF0\x9E\x81\xA6" => "\xD1\x8B",
		"\xF0\x9E\x81\xA7" => "\xD2\x91",
		"\xF0\x9E\x81\xA8" => "\xD1\x96",
		"\xF0\x9E\x81\xA9" => "\xD1\x95",
		"\xF0\x9E\x81\xAA" => "\xD1\x9F",
		"\xF0\x9E\x81\xAB" => "\xD2\xAB",
		"\xF0\x9E\x81\xAC" => "\xEA\x99\x91",
		"\xF0\x9E\x81\xAD" => "\xD2\xB1",
		"\xF0\x9E\xA4\x80" => "\xF0\x9E\xA4\xA2",
		"\xF0\x9E\xA4\x81" => "\xF0\x9E\xA4\xA3",
		"\xF0\x9E\xA4\x82" => "\xF0\x9E\xA4\xA4",
		"\xF0\x9E\xA4\x83" => "\xF0\x9E\xA4\xA5",
		"\xF0\x9E\xA4\x84" => "\xF0\x9E\xA4\xA6",
		"\xF0\x9E\xA4\x85" => "\xF0\x9E\xA4\xA7",
		"\xF0\x9E\xA4\x86" => "\xF0\x9E\xA4\xA8",
		"\xF0\x9E\xA4\x87" => "\xF0\x9E\xA4\xA9",
		"\xF0\x9E\xA4\x88" => "\xF0\x9E\xA4\xAA",
		"\xF0\x9E\xA4\x89" => "\xF0\x9E\xA4\xAB",
		"\xF0\x9E\xA4\x8A" => "\xF0\x9E\xA4\xAC",
		"\xF0\x9E\xA4\x8B" => "\xF0\x9E\xA4\xAD",
		"\xF0\x9E\xA4\x8C" => "\xF0\x9E\xA4\xAE",
		"\xF0\x9E\xA4\x8D" => "\xF0\x9E\xA4\xAF",
		"\xF0\x9E\xA4\x8E" => "\xF0\x9E\xA4\xB0",
		"\xF0\x9E\xA4\x8F" => "\xF0\x9E\xA4\xB1",
		"\xF0\x9E\xA4\x90" => "\xF0\x9E\xA4\xB2",
		"\xF0\x9E\xA4\x91" => "\xF0\x9E\xA4\xB3",
		"\xF0\x9E\xA4\x92" => "\xF0\x9E\xA4\xB4",
		"\xF0\x9E\xA4\x93" => "\xF0\x9E\xA4\xB5",
		"\xF0\x9E\xA4\x94" => "\xF0\x9E\xA4\xB6",
		"\xF0\x9E\xA4\x95" => "\xF0\x9E\xA4\xB7",
		"\xF0\x9E\xA4\x96" => "\xF0\x9E\xA4\xB8",
		"\xF0\x9E\xA4\x97" => "\xF0\x9E\xA4\xB9",
		"\xF0\x9E\xA4\x98" => "\xF0\x9E\xA4\xBA",
		"\xF0\x9E\xA4\x99" => "\xF0\x9E\xA4\xBB",
		"\xF0\x9E\xA4\x9A" => "\xF0\x9E\xA4\xBC",
		"\xF0\x9E\xA4\x9B" => "\xF0\x9E\xA4\xBD",
		"\xF0\x9E\xA4\x9C" => "\xF0\x9E\xA4\xBE",
		"\xF0\x9E\xA4\x9D" => "\xF0\x9E\xA4\xBF",
		"\xF0\x9E\xA4\x9E" => "\xF0\x9E\xA5\x80",
		"\xF0\x9E\xA4\x9F" => "\xF0\x9E\xA5\x81",
		"\xF0\x9E\xA4\xA0" => "\xF0\x9E\xA5\x82",
		"\xF0\x9E\xA4\xA1" => "\xF0\x9E\xA5\x83",
		"\xF0\x9E\xB8\x80" => "\xD8\xA7",
		"\xF0\x9E\xB8\x81" => "\xD8\xA8",
		"\xF0\x9E\xB8\x82" => "\xD8\xAC",
		"\xF0\x9E\xB8\x83" => "\xD8\xAF",
		"\xF0\x9E\xB8\x85" => "\xD9\x88",
		"\xF0\x9E\xB8\x86" => "\xD8\xB2",
		"\xF0\x9E\xB8\x87" => "\xD8\xAD",
		"\xF0\x9E\xB8\x88" => "\xD8\xB7",
		"\xF0\x9E\xB8\x89" => "\xD9\x8A",
		"\xF0\x9E\xB8\x8A" => "\xD9\x83",
		"\xF0\x9E\xB8\x8B" => "\xD9\x84",
		"\xF0\x9E\xB8\x8C" => "\xD9\x85",
		"\xF0\x9E\xB8\x8D" => "\xD9\x86",
		"\xF0\x9E\xB8\x8E" => "\xD8\xB3",
		"\xF0\x9E\xB8\x8F" => "\xD8\xB9",
		"\xF0\x9E\xB8\x90" => "\xD9\x81",
		"\xF0\x9E\xB8\x91" => "\xD8\xB5",
		"\xF0\x9E\xB8\x92" => "\xD9\x82",
		"\xF0\x9E\xB8\x93" => "\xD8\xB1",
		"\xF0\x9E\xB8\x94" => "\xD8\xB4",
		"\xF0\x9E\xB8\x95" => "\xD8\xAA",
		"\xF0\x9E\xB8\x96" => "\xD8\xAB",
		"\xF0\x9E\xB8\x97" => "\xD8\xAE",
		"\xF0\x9E\xB8\x98" => "\xD8\xB0",
		"\xF0\x9E\xB8\x99" => "\xD8\xB6",
		"\xF0\x9E\xB8\x9A" => "\xD8\xB8",
		"\xF0\x9E\xB8\x9B" => "\xD8\xBA",
		"\xF0\x9E\xB8\x9C" => "\xD9\xAE",
		"\xF0\x9E\xB8\x9D" => "\xDA\xBA",
		"\xF0\x9E\xB8\x9E" => "\xDA\xA1",
		"\xF0\x9E\xB8\x9F" => "\xD9\xAF",
		"\xF0\x9E\xB8\xA1" => "\xD8\xA8",
		"\xF0\x9E\xB8\xA2" => "\xD8\xAC",
		"\xF0\x9E\xB8\xA4" => "\xD9\x87",
		"\xF0\x9E\xB8\xA7" => "\xD8\xAD",
		"\xF0\x9E\xB8\xA9" => "\xD9\x8A",
		"\xF0\x9E\xB8\xAA" => "\xD9\x83",
		"\xF0\x9E\xB8\xAB" => "\xD9\x84",
		"\xF0\x9E\xB8\xAC" => "\xD9\x85",
		"\xF0\x9E\xB8\xAD" => "\xD9\x86",
		"\xF0\x9E\xB8\xAE" => "\xD8\xB3",
		"\xF0\x9E\xB8\xAF" => "\xD8\xB9",
		"\xF0\x9E\xB8\xB0" => "\xD9\x81",
		"\xF0\x9E\xB8\xB1" => "\xD8\xB5",
		"\xF0\x9E\xB8\xB2" => "\xD9\x82",
		"\xF0\x9E\xB8\xB4" => "\xD8\xB4",
		"\xF0\x9E\xB8\xB5" => "\xD8\xAA",
		"\xF0\x9E\xB8\xB6" => "\xD8\xAB",
		"\xF0\x9E\xB8\xB7" => "\xD8\xAE",
		"\xF0\x9E\xB8\xB9" => "\xD8\xB6",
		"\xF0\x9E\xB8\xBB" => "\xD8\xBA",
		"\xF0\x9E\xB9\x82" => "\xD8\xAC",
		"\xF0\x9E\xB9\x87" => "\xD8\xAD",
		"\xF0\x9E\xB9\x89" => "\xD9\x8A",
		"\xF0\x9E\xB9\x8B" => "\xD9\x84",
		"\xF0\x9E\xB9\x8D" => "\xD9\x86",
		"\xF0\x9E\xB9\x8E" => "\xD8\xB3",
		"\xF0\x9E\xB9\x8F" => "\xD8\xB9",
		"\xF0\x9E\xB9\x91" => "\xD8\xB5",
		"\xF0\x9E\xB9\x92" => "\xD9\x82",
		"\xF0\x9E\xB9\x94" => "\xD8\xB4",
		"\xF0\x9E\xB9\x97" => "\xD8\xAE",
		"\xF0\x9E\xB9\x99" => "\xD8\xB6",
		"\xF0\x9E\xB9\x9B" => "\xD8\xBA",
		"\xF0\x9E\xB9\x9D" => "\xDA\xBA",
		"\xF0\x9E\xB9\x9F" => "\xD9\xAF",
		"\xF0\x9E\xB9\xA1" => "\xD8\xA8",
		"\xF0\x9E\xB9\xA2" => "\xD8\xAC",
		"\xF0\x9E\xB9\xA4" => "\xD9\x87",
		"\xF0\x9E\xB9\xA7" => "\xD8\xAD",
		"\xF0\x9E\xB9\xA8" => "\xD8\xB7",
		"\xF0\x9E\xB9\xA9" => "\xD9\x8A",
		"\xF0\x9E\xB9\xAA" => "\xD9\x83",
		"\xF0\x9E\xB9\xAC" => "\xD9\x85",
		"\xF0\x9E\xB9\xAD" => "\xD9\x86",
		"\xF0\x9E\xB9\xAE" => "\xD8\xB3",
		"\xF0\x9E\xB9\xAF" => "\xD8\xB9",
		"\xF0\x9E\xB9\xB0" => "\xD9\x81",
		"\xF0\x9E\xB9\xB1" => "\xD8\xB5",
		"\xF0\x9E\xB9\xB2" => "\xD9\x82",
		"\xF0\x9E\xB9\xB4" => "\xD8\xB4",
		"\xF0\x9E\xB9\xB5" => "\xD8\xAA",
		"\xF0\x9E\xB9\xB6" => "\xD8\xAB",
		"\xF0\x9E\xB9\xB7" => "\xD8\xAE",
		"\xF0\x9E\xB9\xB9" => "\xD8\xB6",
		"\xF0\x9E\xB9\xBA" => "\xD8\xB8",
		"\xF0\x9E\xB9\xBB" => "\xD8\xBA",
		"\xF0\x9E\xB9\xBC" => "\xD9\xAE",
		"\xF0\x9E\xB9\xBE" => "\xDA\xA1",
		"\xF0\x9E\xBA\x80" => "\xD8\xA7",
		"\xF0\x9E\xBA\x81" => "\xD8\xA8",
		"\xF0\x9E\xBA\x82" => "\xD8\xAC",
		"\xF0\x9E\xBA\x83" => "\xD8\xAF",
		"\xF0\x9E\xBA\x84" => "\xD9\x87",
		"\xF0\x9E\xBA\x85" => "\xD9\x88",
		"\xF0\x9E\xBA\x86" => "\xD8\xB2",
		"\xF0\x9E\xBA\x87" => "\xD8\xAD",
		"\xF0\x9E\xBA\x88" => "\xD8\xB7",
		"\xF0\x9E\xBA\x89" => "\xD9\x8A",
		"\xF0\x9E\xBA\x8B" => "\xD9\x84",
		"\xF0\x9E\xBA\x8C" => "\xD9\x85",
		"\xF0\x9E\xBA\x8D" => "\xD9\x86",
		"\xF0\x9E\xBA\x8E" => "\xD8\xB3",
		"\xF0\x9E\xBA\x8F" => "\xD8\xB9",
		"\xF0\x9E\xBA\x90" => "\xD9\x81",
		"\xF0\x9E\xBA\x91" => "\xD8\xB5",
		"\xF0\x9E\xBA\x92" => "\xD9\x82",
		"\xF0\x9E\xBA\x93" => "\xD8\xB1",
		"\xF0\x9E\xBA\x94" => "\xD8\xB4",
		"\xF0\x9E\xBA\x95" => "\xD8\xAA",
		"\xF0\x9E\xBA\x96" => "\xD8\xAB",
		"\xF0\x9E\xBA\x97" => "\xD8\xAE",
		"\xF0\x9E\xBA\x98" => "\xD8\xB0",
		"\xF0\x9E\xBA\x99" => "\xD8\xB6",
		"\xF0\x9E\xBA\x9A" => "\xD8\xB8",
		"\xF0\x9E\xBA\x9B" => "\xD8\xBA",
		"\xF0\x9E\xBA\xA1" => "\xD8\xA8",
		"\xF0\x9E\xBA\xA2" => "\xD8\xAC",
		"\xF0\x9E\xBA\xA3" => "\xD8\xAF",
		"\xF0\x9E\xBA\xA5" => "\xD9\x88",
		"\xF0\x9E\xBA\xA6" => "\xD8\xB2",
		"\xF0\x9E\xBA\xA7" => "\xD8\xAD",
		"\xF0\x9E\xBA\xA8" => "\xD8\xB7",
		"\xF0\x9E\xBA\xA9" => "\xD9\x8A",
		"\xF0\x9E\xBA\xAB" => "\xD9\x84",
		"\xF0\x9E\xBA\xAC" => "\xD9\x85",
		"\xF0\x9E\xBA\xAD" => "\xD9\x86",
		"\xF0\x9E\xBA\xAE" => "\xD8\xB3",
		"\xF0\x9E\xBA\xAF" => "\xD8\xB9",
		"\xF0\x9E\xBA\xB0" => "\xD9\x81",
		"\xF0\x9E\xBA\xB1" => "\xD8\xB5",
		"\xF0\x9E\xBA\xB2" => "\xD9\x82",
		"\xF0\x9E\xBA\xB3" => "\xD8\xB1",
		"\xF0\x9E\xBA\xB4" => "\xD8\xB4",
		"\xF0\x9E\xBA\xB5" => "\xD8\xAA",
		"\xF0\x9E\xBA\xB6" => "\xD8\xAB",
		"\xF0\x9E\xBA\xB7" => "\xD8\xAE",
		"\xF0\x9E\xBA\xB8" => "\xD8\xB0",
		"\xF0\x9E\xBA\xB9" => "\xD8\xB6",
		"\xF0\x9E\xBA\xBA" => "\xD8\xB8",
		"\xF0\x9E\xBA\xBB" => "\xD8\xBA",
		"\xF0\x9F\x84\xAA" => "\xE3\x80\x94\x73\xE3\x80\x95",
		"\xF0\x9F\x84\xAB" => "\x63",
		"\xF0\x9F\x84\xAC" => "\x72",
		"\xF0\x9F\x84\xAD" => "\x63\x64",
		"\xF0\x9F\x84\xAE" => "\x77\x7A",
		"\xF0\x9F\x84\xB0" => "\x61",
		"\xF0\x9F\x84\xB1" => "\x62",
		"\xF0\x9F\x84\xB2" => "\x63",
		"\xF0\x9F\x84\xB3" => "\x64",
		"\xF0\x9F\x84\xB4" => "\x65",
		"\xF0\x9F\x84\xB5" => "\x66",
		"\xF0\x9F\x84\xB6" => "\x67",
		"\xF0\x9F\x84\xB7" => "\x68",
		"\xF0\x9F\x84\xB8" => "\x69",
		"\xF0\x9F\x84\xB9" => "\x6A",
		"\xF0\x9F\x84\xBA" => "\x6B",
		"\xF0\x9F\x84\xBB" => "\x6C",
		"\xF0\x9F\x84\xBC" => "\x6D",
		"\xF0\x9F\x84\xBD" => "\x6E",
		"\xF0\x9F\x84\xBE" => "\x6F",
		"\xF0\x9F\x84\xBF" => "\x70",
		"\xF0\x9F\x85\x80" => "\x71",
		"\xF0\x9F\x85\x81" => "\x72",
		"\xF0\x9F\x85\x82" => "\x73",
		"\xF0\x9F\x85\x83" => "\x74",
		"\xF0\x9F\x85\x84" => "\x75",
		"\xF0\x9F\x85\x85" => "\x76",
		"\xF0\x9F\x85\x86" => "\x77",
		"\xF0\x9F\x85\x87" => "\x78",
		"\xF0\x9F\x85\x88" => "\x79",
		"\xF0\x9F\x85\x89" => "\x7A",
		"\xF0\x9F\x85\x8A" => "\x68\x76",
		"\xF0\x9F\x85\x8B" => "\x6D\x76",
		"\xF0\x9F\x85\x8C" => "\x73\x64",
		"\xF0\x9F\x85\x8D" => "\x73\x73",
		"\xF0\x9F\x85\x8E" => "\x70\x70\x76",
		"\xF0\x9F\x85\x8F" => "\x77\x63",
		"\xF0\x9F\x85\xAA" => "\x6D\x63",
		"\xF0\x9F\x85\xAB" => "\x6D\x64",
		"\xF0\x9F\x85\xAC" => "\x6D\x72",
		"\xF0\x9F\x86\x90" => "\x64\x6A",
		"\xF0\x9F\x88\x80" => "\xE3\x81\xBB\xE3\x81\x8B",
		"\xF0\x9F\x88\x81" => "\xE3\x82\xB3\xE3\x82\xB3",
		"\xF0\x9F\x88\x82" => "\xE3\x82\xB5",
		"\xF0\x9F\x88\x90" => "\xE6\x89\x8B",
		"\xF0\x9F\x88\x91" => "\xE5\xAD\x97",
		"\xF0\x9F\x88\x92" => "\xE5\x8F\x8C",
		"\xF0\x9F\x88\x93" => "\xE3\x83\x87",
		"\xF0\x9F\x88\x94" => "\xE4\xBA\x8C",
		"\xF0\x9F\x88\x95" => "\xE5\xA4\x9A",
		"\xF0\x9F\x88\x96" => "\xE8\xA7\xA3",
		"\xF0\x9F\x88\x97" => "\xE5\xA4\xA9",
		"\xF0\x9F\x88\x98" => "\xE4\xBA\xA4",
		"\xF0\x9F\x88\x99" => "\xE6\x98\xA0",
		"\xF0\x9F\x88\x9A" => "\xE7\x84\xA1",
		"\xF0\x9F\x88\x9B" => "\xE6\x96\x99",
		"\xF0\x9F\x88\x9C" => "\xE5\x89\x8D",
		"\xF0\x9F\x88\x9D" => "\xE5\xBE\x8C",
		"\xF0\x9F\x88\x9E" => "\xE5\x86\x8D",
		"\xF0\x9F\x88\x9F" => "\xE6\x96\xB0",
		"\xF0\x9F\x88\xA0" => "\xE5\x88\x9D",
		"\xF0\x9F\x88\xA1" => "\xE7\xB5\x82",
		"\xF0\x9F\x88\xA2" => "\xE7\x94\x9F",
		"\xF0\x9F\x88\xA3" => "\xE8\xB2\xA9",
		"\xF0\x9F\x88\xA4" => "\xE5\xA3\xB0",
		"\xF0\x9F\x88\xA5" => "\xE5\x90\xB9",
		"\xF0\x9F\x88\xA6" => "\xE6\xBC\x94",
		"\xF0\x9F\x88\xA7" => "\xE6\x8A\x95",
		"\xF0\x9F\x88\xA8" => "\xE6\x8D\x95",
		"\xF0\x9F\x88\xA9" => "\xE4\xB8\x80",
		"\xF0\x9F\x88\xAA" => "\xE4\xB8\x89",
		"\xF0\x9F\x88\xAB" => "\xE9\x81\x8A",
		"\xF0\x9F\x88\xAC" => "\xE5\xB7\xA6",
		"\xF0\x9F\x88\xAD" => "\xE4\xB8\xAD",
		"\xF0\x9F\x88\xAE" => "\xE5\x8F\xB3",
		"\xF0\x9F\x88\xAF" => "\xE6\x8C\x87",
		"\xF0\x9F\x88\xB0" => "\xE8\xB5\xB0",
		"\xF0\x9F\x88\xB1" => "\xE6\x89\x93",
		"\xF0\x9F\x88\xB2" => "\xE7\xA6\x81",
		"\xF0\x9F\x88\xB3" => "\xE7\xA9\xBA",
		"\xF0\x9F\x88\xB4" => "\xE5\x90\x88",
		"\xF0\x9F\x88\xB5" => "\xE6\xBA\x80",
		"\xF0\x9F\x88\xB6" => "\xE6\x9C\x89",
		"\xF0\x9F\x88\xB7" => "\xE6\x9C\x88",
		"\xF0\x9F\x88\xB8" => "\xE7\x94\xB3",
		"\xF0\x9F\x88\xB9" => "\xE5\x89\xB2",
		"\xF0\x9F\x88\xBA" => "\xE5\x96\xB6",
		"\xF0\x9F\x88\xBB" => "\xE9\x85\x8D",
		"\xF0\x9F\x89\x80" => "\xE3\x80\x94\xE6\x9C\xAC\xE3\x80\x95",
		"\xF0\x9F\x89\x81" => "\xE3\x80\x94\xE4\xB8\x89\xE3\x80\x95",
		"\xF0\x9F\x89\x82" => "\xE3\x80\x94\xE4\xBA\x8C\xE3\x80\x95",
		"\xF0\x9F\x89\x83" => "\xE3\x80\x94\xE5\xAE\x89\xE3\x80\x95",
		"\xF0\x9F\x89\x84" => "\xE3\x80\x94\xE7\x82\xB9\xE3\x80\x95",
		"\xF0\x9F\x89\x85" => "\xE3\x80\x94\xE6\x89\x93\xE3\x80\x95",
		"\xF0\x9F\x89\x86" => "\xE3\x80\x94\xE7\x9B\x97\xE3\x80\x95",
		"\xF0\x9F\x89\x87" => "\xE3\x80\x94\xE5\x8B\x9D\xE3\x80\x95",
		"\xF0\x9F\x89\x88" => "\xE3\x80\x94\xE6\x95\x97\xE3\x80\x95",
		"\xF0\x9F\x89\x90" => "\xE5\xBE\x97",
		"\xF0\x9F\x89\x91" => "\xE5\x8F\xAF",
		"\xF0\x9F\xAF\xB0" => "\x30",
		"\xF0\x9F\xAF\xB1" => "\x31",
		"\xF0\x9F\xAF\xB2" => "\x32",
		"\xF0\x9F\xAF\xB3" => "\x33",
		"\xF0\x9F\xAF\xB4" => "\x34",
		"\xF0\x9F\xAF\xB5" => "\x35",
		"\xF0\x9F\xAF\xB6" => "\x36",
		"\xF0\x9F\xAF\xB7" => "\x37",
		"\xF0\x9F\xAF\xB8" => "\x38",
		"\xF0\x9F\xAF\xB9" => "\x39",
		"\xF0\xAF\xA0\x80" => "\xE4\xB8\xBD",
		"\xF0\xAF\xA0\x81" => "\xE4\xB8\xB8",
		"\xF0\xAF\xA0\x82" => "\xE4\xB9\x81",
		"\xF0\xAF\xA0\x83" => "\xF0\xA0\x84\xA2",
		"\xF0\xAF\xA0\x84" => "\xE4\xBD\xA0",
		"\xF0\xAF\xA0\x85" => "\xE4\xBE\xAE",
		"\xF0\xAF\xA0\x86" => "\xE4\xBE\xBB",
		"\xF0\xAF\xA0\x87" => "\xE5\x80\x82",
		"\xF0\xAF\xA0\x88" => "\xE5\x81\xBA",
		"\xF0\xAF\xA0\x89" => "\xE5\x82\x99",
		"\xF0\xAF\xA0\x8A" => "\xE5\x83\xA7",
		"\xF0\xAF\xA0\x8B" => "\xE5\x83\x8F",
		"\xF0\xAF\xA0\x8C" => "\xE3\x92\x9E",
		"\xF0\xAF\xA0\x8D" => "\xF0\xA0\x98\xBA",
		"\xF0\xAF\xA0\x8E" => "\xE5\x85\x8D",
		"\xF0\xAF\xA0\x8F" => "\xE5\x85\x94",
		"\xF0\xAF\xA0\x90" => "\xE5\x85\xA4",
		"\xF0\xAF\xA0\x91" => "\xE5\x85\xB7",
		"\xF0\xAF\xA0\x92" => "\xF0\xA0\x94\x9C",
		"\xF0\xAF\xA0\x93" => "\xE3\x92\xB9",
		"\xF0\xAF\xA0\x94" => "\xE5\x85\xA7",
		"\xF0\xAF\xA0\x95" => "\xE5\x86\x8D",
		"\xF0\xAF\xA0\x96" => "\xF0\xA0\x95\x8B",
		"\xF0\xAF\xA0\x97" => "\xE5\x86\x97",
		"\xF0\xAF\xA0\x98" => "\xE5\x86\xA4",
		"\xF0\xAF\xA0\x99" => "\xE4\xBB\x8C",
		"\xF0\xAF\xA0\x9A" => "\xE5\x86\xAC",
		"\xF0\xAF\xA0\x9B" => "\xE5\x86\xB5",
		"\xF0\xAF\xA0\x9C" => "\xF0\xA9\x87\x9F",
		"\xF0\xAF\xA0\x9D" => "\xE5\x87\xB5",
		"\xF0\xAF\xA0\x9E" => "\xE5\x88\x83",
		"\xF0\xAF\xA0\x9F" => "\xE3\x93\x9F",
		"\xF0\xAF\xA0\xA0" => "\xE5\x88\xBB",
		"\xF0\xAF\xA0\xA1" => "\xE5\x89\x86",
		"\xF0\xAF\xA0\xA2" => "\xE5\x89\xB2",
		"\xF0\xAF\xA0\xA3" => "\xE5\x89\xB7",
		"\xF0\xAF\xA0\xA4" => "\xE3\x94\x95",
		"\xF0\xAF\xA0\xA5" => "\xE5\x8B\x87",
		"\xF0\xAF\xA0\xA6" => "\xE5\x8B\x89",
		"\xF0\xAF\xA0\xA7" => "\xE5\x8B\xA4",
		"\xF0\xAF\xA0\xA8" => "\xE5\x8B\xBA",
		"\xF0\xAF\xA0\xA9" => "\xE5\x8C\x85",
		"\xF0\xAF\xA0\xAA" => "\xE5\x8C\x86",
		"\xF0\xAF\xA0\xAB" => "\xE5\x8C\x97",
		"\xF0\xAF\xA0\xAC" => "\xE5\x8D\x89",
		"\xF0\xAF\xA0\xAD" => "\xE5\x8D\x91",
		"\xF0\xAF\xA0\xAE" => "\xE5\x8D\x9A",
		"\xF0\xAF\xA0\xAF" => "\xE5\x8D\xB3",
		"\xF0\xAF\xA0\xB0" => "\xE5\x8D\xBD",
		"\xF0\xAF\xA0\xB1" => "\xE5\x8D\xBF",
		"\xF0\xAF\xA0\xB2" => "\xE5\x8D\xBF",
		"\xF0\xAF\xA0\xB3" => "\xE5\x8D\xBF",
		"\xF0\xAF\xA0\xB4" => "\xF0\xA0\xA8\xAC",
		"\xF0\xAF\xA0\xB5" => "\xE7\x81\xB0",
		"\xF0\xAF\xA0\xB6" => "\xE5\x8F\x8A",
		"\xF0\xAF\xA0\xB7" => "\xE5\x8F\x9F",
		"\xF0\xAF\xA0\xB8" => "\xF0\xA0\xAD\xA3",
		"\xF0\xAF\xA0\xB9" => "\xE5\x8F\xAB",
		"\xF0\xAF\xA0\xBA" => "\xE5\x8F\xB1",
		"\xF0\xAF\xA0\xBB" => "\xE5\x90\x86",
		"\xF0\xAF\xA0\xBC" => "\xE5\x92\x9E",
		"\xF0\xAF\xA0\xBD" => "\xE5\x90\xB8",
		"\xF0\xAF\xA0\xBE" => "\xE5\x91\x88",
		"\xF0\xAF\xA0\xBF" => "\xE5\x91\xA8",
		"\xF0\xAF\xA1\x80" => "\xE5\x92\xA2",
		"\xF0\xAF\xA1\x81" => "\xE5\x93\xB6",
		"\xF0\xAF\xA1\x82" => "\xE5\x94\x90",
		"\xF0\xAF\xA1\x83" => "\xE5\x95\x93",
		"\xF0\xAF\xA1\x84" => "\xE5\x95\xA3",
		"\xF0\xAF\xA1\x85" => "\xE5\x96\x84",
		"\xF0\xAF\xA1\x86" => "\xE5\x96\x84",
		"\xF0\xAF\xA1\x87" => "\xE5\x96\x99",
		"\xF0\xAF\xA1\x88" => "\xE5\x96\xAB",
		"\xF0\xAF\xA1\x89" => "\xE5\x96\xB3",
		"\xF0\xAF\xA1\x8A" => "\xE5\x97\x82",
		"\xF0\xAF\xA1\x8B" => "\xE5\x9C\x96",
		"\xF0\xAF\xA1\x8C" => "\xE5\x98\x86",
		"\xF0\xAF\xA1\x8D" => "\xE5\x9C\x97",
		"\xF0\xAF\xA1\x8E" => "\xE5\x99\x91",
		"\xF0\xAF\xA1\x8F" => "\xE5\x99\xB4",
		"\xF0\xAF\xA1\x90" => "\xE5\x88\x87",
		"\xF0\xAF\xA1\x91" => "\xE5\xA3\xAE",
		"\xF0\xAF\xA1\x92" => "\xE5\x9F\x8E",
		"\xF0\xAF\xA1\x93" => "\xE5\x9F\xB4",
		"\xF0\xAF\xA1\x94" => "\xE5\xA0\x8D",
		"\xF0\xAF\xA1\x95" => "\xE5\x9E\x8B",
		"\xF0\xAF\xA1\x96" => "\xE5\xA0\xB2",
		"\xF0\xAF\xA1\x97" => "\xE5\xA0\xB1",
		"\xF0\xAF\xA1\x98" => "\xE5\xA2\xAC",
		"\xF0\xAF\xA1\x99" => "\xF0\xA1\x93\xA4",
		"\xF0\xAF\xA1\x9A" => "\xE5\xA3\xB2",
		"\xF0\xAF\xA1\x9B" => "\xE5\xA3\xB7",
		"\xF0\xAF\xA1\x9C" => "\xE5\xA4\x86",
		"\xF0\xAF\xA1\x9D" => "\xE5\xA4\x9A",
		"\xF0\xAF\xA1\x9E" => "\xE5\xA4\xA2",
		"\xF0\xAF\xA1\x9F" => "\xE5\xA5\xA2",
		"\xF0\xAF\xA1\xA0" => "\xF0\xA1\x9A\xA8",
		"\xF0\xAF\xA1\xA1" => "\xF0\xA1\x9B\xAA",
		"\xF0\xAF\xA1\xA2" => "\xE5\xA7\xAC",
		"\xF0\xAF\xA1\xA3" => "\xE5\xA8\x9B",
		"\xF0\xAF\xA1\xA4" => "\xE5\xA8\xA7",
		"\xF0\xAF\xA1\xA5" => "\xE5\xA7\x98",
		"\xF0\xAF\xA1\xA6" => "\xE5\xA9\xA6",
		"\xF0\xAF\xA1\xA7" => "\xE3\x9B\xAE",
		"\xF0\xAF\xA1\xA9" => "\xE5\xAC\x88",
		"\xF0\xAF\xA1\xAA" => "\xE5\xAC\xBE",
		"\xF0\xAF\xA1\xAB" => "\xE5\xAC\xBE",
		"\xF0\xAF\xA1\xAC" => "\xF0\xA1\xA7\x88",
		"\xF0\xAF\xA1\xAD" => "\xE5\xAF\x83",
		"\xF0\xAF\xA1\xAE" => "\xE5\xAF\x98",
		"\xF0\xAF\xA1\xAF" => "\xE5\xAF\xA7",
		"\xF0\xAF\xA1\xB0" => "\xE5\xAF\xB3",
		"\xF0\xAF\xA1\xB1" => "\xF0\xA1\xAC\x98",
		"\xF0\xAF\xA1\xB2" => "\xE5\xAF\xBF",
		"\xF0\xAF\xA1\xB3" => "\xE5\xB0\x86",
		"\xF0\xAF\xA1\xB5" => "\xE5\xB0\xA2",
		"\xF0\xAF\xA1\xB6" => "\xE3\x9E\x81",
		"\xF0\xAF\xA1\xB7" => "\xE5\xB1\xA0",
		"\xF0\xAF\xA1\xB8" => "\xE5\xB1\xAE",
		"\xF0\xAF\xA1\xB9" => "\xE5\xB3\x80",
		"\xF0\xAF\xA1\xBA" => "\xE5\xB2\x8D",
		"\xF0\xAF\xA1\xBB" => "\xF0\xA1\xB7\xA4",
		"\xF0\xAF\xA1\xBC" => "\xE5\xB5\x83",
		"\xF0\xAF\xA1\xBD" => "\xF0\xA1\xB7\xA6",
		"\xF0\xAF\xA1\xBE" => "\xE5\xB5\xAE",
		"\xF0\xAF\xA1\xBF" => "\xE5\xB5\xAB",
		"\xF0\xAF\xA2\x80" => "\xE5\xB5\xBC",
		"\xF0\xAF\xA2\x81" => "\xE5\xB7\xA1",
		"\xF0\xAF\xA2\x82" => "\xE5\xB7\xA2",
		"\xF0\xAF\xA2\x83" => "\xE3\xA0\xAF",
		"\xF0\xAF\xA2\x84" => "\xE5\xB7\xBD",
		"\xF0\xAF\xA2\x85" => "\xE5\xB8\xA8",
		"\xF0\xAF\xA2\x86" => "\xE5\xB8\xBD",
		"\xF0\xAF\xA2\x87" => "\xE5\xB9\xA9",
		"\xF0\xAF\xA2\x88" => "\xE3\xA1\xA2",
		"\xF0\xAF\xA2\x89" => "\xF0\xA2\x86\x83",
		"\xF0\xAF\xA2\x8A" => "\xE3\xA1\xBC",
		"\xF0\xAF\xA2\x8B" => "\xE5\xBA\xB0",
		"\xF0\xAF\xA2\x8C" => "\xE5\xBA\xB3",
		"\xF0\xAF\xA2\x8D" => "\xE5\xBA\xB6",
		"\xF0\xAF\xA2\x8E" => "\xE5\xBB\x8A",
		"\xF0\xAF\xA2\x8F" => "\xF0\xAA\x8E\x92",
		"\xF0\xAF\xA2\x90" => "\xE5\xBB\xBE",
		"\xF0\xAF\xA2\x91" => "\xF0\xA2\x8C\xB1",
		"\xF0\xAF\xA2\x92" => "\xF0\xA2\x8C\xB1",
		"\xF0\xAF\xA2\x93" => "\xE8\x88\x81",
		"\xF0\xAF\xA2\x94" => "\xE5\xBC\xA2",
		"\xF0\xAF\xA2\x95" => "\xE5\xBC\xA2",
		"\xF0\xAF\xA2\x96" => "\xE3\xA3\x87",
		"\xF0\xAF\xA2\x97" => "\xF0\xA3\x8A\xB8",
		"\xF0\xAF\xA2\x98" => "\xF0\xA6\x87\x9A",
		"\xF0\xAF\xA2\x99" => "\xE5\xBD\xA2",
		"\xF0\xAF\xA2\x9A" => "\xE5\xBD\xAB",
		"\xF0\xAF\xA2\x9B" => "\xE3\xA3\xA3",
		"\xF0\xAF\xA2\x9C" => "\xE5\xBE\x9A",
		"\xF0\xAF\xA2\x9D" => "\xE5\xBF\x8D",
		"\xF0\xAF\xA2\x9E" => "\xE5\xBF\x97",
		"\xF0\xAF\xA2\x9F" => "\xE5\xBF\xB9",
		"\xF0\xAF\xA2\xA0" => "\xE6\x82\x81",
		"\xF0\xAF\xA2\xA1" => "\xE3\xA4\xBA",
		"\xF0\xAF\xA2\xA2" => "\xE3\xA4\x9C",
		"\xF0\xAF\xA2\xA3" => "\xE6\x82\x94",
		"\xF0\xAF\xA2\xA4" => "\xF0\xA2\x9B\x94",
		"\xF0\xAF\xA2\xA5" => "\xE6\x83\x87",
		"\xF0\xAF\xA2\xA6" => "\xE6\x85\x88",
		"\xF0\xAF\xA2\xA7" => "\xE6\x85\x8C",
		"\xF0\xAF\xA2\xA8" => "\xE6\x85\x8E",
		"\xF0\xAF\xA2\xA9" => "\xE6\x85\x8C",
		"\xF0\xAF\xA2\xAA" => "\xE6\x85\xBA",
		"\xF0\xAF\xA2\xAB" => "\xE6\x86\x8E",
		"\xF0\xAF\xA2\xAC" => "\xE6\x86\xB2",
		"\xF0\xAF\xA2\xAD" => "\xE6\x86\xA4",
		"\xF0\xAF\xA2\xAE" => "\xE6\x86\xAF",
		"\xF0\xAF\xA2\xAF" => "\xE6\x87\x9E",
		"\xF0\xAF\xA2\xB0" => "\xE6\x87\xB2",
		"\xF0\xAF\xA2\xB1" => "\xE6\x87\xB6",
		"\xF0\xAF\xA2\xB2" => "\xE6\x88\x90",
		"\xF0\xAF\xA2\xB3" => "\xE6\x88\x9B",
		"\xF0\xAF\xA2\xB4" => "\xE6\x89\x9D",
		"\xF0\xAF\xA2\xB5" => "\xE6\x8A\xB1",
		"\xF0\xAF\xA2\xB6" => "\xE6\x8B\x94",
		"\xF0\xAF\xA2\xB7" => "\xE6\x8D\x90",
		"\xF0\xAF\xA2\xB8" => "\xF0\xA2\xAC\x8C",
		"\xF0\xAF\xA2\xB9" => "\xE6\x8C\xBD",
		"\xF0\xAF\xA2\xBA" => "\xE6\x8B\xBC",
		"\xF0\xAF\xA2\xBB" => "\xE6\x8D\xA8",
		"\xF0\xAF\xA2\xBC" => "\xE6\x8E\x83",
		"\xF0\xAF\xA2\xBD" => "\xE6\x8F\xA4",
		"\xF0\xAF\xA2\xBE" => "\xF0\xA2\xAF\xB1",
		"\xF0\xAF\xA2\xBF" => "\xE6\x90\xA2",
		"\xF0\xAF\xA3\x80" => "\xE6\x8F\x85",
		"\xF0\xAF\xA3\x81" => "\xE6\x8E\xA9",
		"\xF0\xAF\xA3\x82" => "\xE3\xA8\xAE",
		"\xF0\xAF\xA3\x83" => "\xE6\x91\xA9",
		"\xF0\xAF\xA3\x84" => "\xE6\x91\xBE",
		"\xF0\xAF\xA3\x85" => "\xE6\x92\x9D",
		"\xF0\xAF\xA3\x86" => "\xE6\x91\xB7",
		"\xF0\xAF\xA3\x87" => "\xE3\xA9\xAC",
		"\xF0\xAF\xA3\x88" => "\xE6\x95\x8F",
		"\xF0\xAF\xA3\x89" => "\xE6\x95\xAC",
		"\xF0\xAF\xA3\x8A" => "\xF0\xA3\x80\x8A",
		"\xF0\xAF\xA3\x8B" => "\xE6\x97\xA3",
		"\xF0\xAF\xA3\x8C" => "\xE6\x9B\xB8",
		"\xF0\xAF\xA3\x8D" => "\xE6\x99\x89",
		"\xF0\xAF\xA3\x8E" => "\xE3\xAC\x99",
		"\xF0\xAF\xA3\x8F" => "\xE6\x9A\x91",
		"\xF0\xAF\xA3\x90" => "\xE3\xAC\x88",
		"\xF0\xAF\xA3\x91" => "\xE3\xAB\xA4",
		"\xF0\xAF\xA3\x92" => "\xE5\x86\x92",
		"\xF0\xAF\xA3\x93" => "\xE5\x86\x95",
		"\xF0\xAF\xA3\x94" => "\xE6\x9C\x80",
		"\xF0\xAF\xA3\x95" => "\xE6\x9A\x9C",
		"\xF0\xAF\xA3\x96" => "\xE8\x82\xAD",
		"\xF0\xAF\xA3\x97" => "\xE4\x8F\x99",
		"\xF0\xAF\xA3\x98" => "\xE6\x9C\x97",
		"\xF0\xAF\xA3\x99" => "\xE6\x9C\x9B",
		"\xF0\xAF\xA3\x9A" => "\xE6\x9C\xA1",
		"\xF0\xAF\xA3\x9B" => "\xE6\x9D\x9E",
		"\xF0\xAF\xA3\x9C" => "\xE6\x9D\x93",
		"\xF0\xAF\xA3\x9D" => "\xF0\xA3\x8F\x83",
		"\xF0\xAF\xA3\x9E" => "\xE3\xAD\x89",
		"\xF0\xAF\xA3\x9F" => "\xE6\x9F\xBA",
		"\xF0\xAF\xA3\xA0" => "\xE6\x9E\x85",
		"\xF0\xAF\xA3\xA1" => "\xE6\xA1\x92",
		"\xF0\xAF\xA3\xA2" => "\xE6\xA2\x85",
		"\xF0\xAF\xA3\xA3" => "\xF0\xA3\x91\xAD",
		"\xF0\xAF\xA3\xA4" => "\xE6\xA2\x8E",
		"\xF0\xAF\xA3\xA5" => "\xE6\xA0\x9F",
		"\xF0\xAF\xA3\xA6" => "\xE6\xA4\x94",
		"\xF0\xAF\xA3\xA7" => "\xE3\xAE\x9D",
		"\xF0\xAF\xA3\xA8" => "\xE6\xA5\x82",
		"\xF0\xAF\xA3\xA9" => "\xE6\xA6\xA3",
		"\xF0\xAF\xA3\xAA" => "\xE6\xA7\xAA",
		"\xF0\xAF\xA3\xAB" => "\xE6\xAA\xA8",
		"\xF0\xAF\xA3\xAC" => "\xF0\xA3\x9A\xA3",
		"\xF0\xAF\xA3\xAD" => "\xE6\xAB\x9B",
		"\xF0\xAF\xA3\xAE" => "\xE3\xB0\x98",
		"\xF0\xAF\xA3\xAF" => "\xE6\xAC\xA1",
		"\xF0\xAF\xA3\xB0" => "\xF0\xA3\xA2\xA7",
		"\xF0\xAF\xA3\xB1" => "\xE6\xAD\x94",
		"\xF0\xAF\xA3\xB2" => "\xE3\xB1\x8E",
		"\xF0\xAF\xA3\xB3" => "\xE6\xAD\xB2",
		"\xF0\xAF\xA3\xB4" => "\xE6\xAE\x9F",
		"\xF0\xAF\xA3\xB5" => "\xE6\xAE\xBA",
		"\xF0\xAF\xA3\xB6" => "\xE6\xAE\xBB",
		"\xF0\xAF\xA3\xB7" => "\xF0\xA3\xAA\x8D",
		"\xF0\xAF\xA3\xB8" => "\xF0\xA1\xB4\x8B",
		"\xF0\xAF\xA3\xB9" => "\xF0\xA3\xAB\xBA",
		"\xF0\xAF\xA3\xBA" => "\xE6\xB1\x8E",
		"\xF0\xAF\xA3\xBB" => "\xF0\xA3\xB2\xBC",
		"\xF0\xAF\xA3\xBC" => "\xE6\xB2\xBF",
		"\xF0\xAF\xA3\xBD" => "\xE6\xB3\x8D",
		"\xF0\xAF\xA3\xBE" => "\xE6\xB1\xA7",
		"\xF0\xAF\xA3\xBF" => "\xE6\xB4\x96",
		"\xF0\xAF\xA4\x80" => "\xE6\xB4\xBE",
		"\xF0\xAF\xA4\x81" => "\xE6\xB5\xB7",
		"\xF0\xAF\xA4\x82" => "\xE6\xB5\x81",
		"\xF0\xAF\xA4\x83" => "\xE6\xB5\xA9",
		"\xF0\xAF\xA4\x84" => "\xE6\xB5\xB8",
		"\xF0\xAF\xA4\x85" => "\xE6\xB6\x85",
		"\xF0\xAF\xA4\x86" => "\xF0\xA3\xB4\x9E",
		"\xF0\xAF\xA4\x87" => "\xE6\xB4\xB4",
		"\xF0\xAF\xA4\x88" => "\xE6\xB8\xAF",
		"\xF0\xAF\xA4\x89" => "\xE6\xB9\xAE",
		"\xF0\xAF\xA4\x8A" => "\xE3\xB4\xB3",
		"\xF0\xAF\xA4\x8B" => "\xE6\xBB\x8B",
		"\xF0\xAF\xA4\x8C" => "\xE6\xBB\x87",
		"\xF0\xAF\xA4\x8D" => "\xF0\xA3\xBB\x91",
		"\xF0\xAF\xA4\x8E" => "\xE6\xB7\xB9",
		"\xF0\xAF\xA4\x8F" => "\xE6\xBD\xAE",
		"\xF0\xAF\xA4\x90" => "\xF0\xA3\xBD\x9E",
		"\xF0\xAF\xA4\x91" => "\xF0\xA3\xBE\x8E",
		"\xF0\xAF\xA4\x92" => "\xE6\xBF\x86",
		"\xF0\xAF\xA4\x93" => "\xE7\x80\xB9",
		"\xF0\xAF\xA4\x94" => "\xE7\x80\x9E",
		"\xF0\xAF\xA4\x95" => "\xE7\x80\x9B",
		"\xF0\xAF\xA4\x96" => "\xE3\xB6\x96",
		"\xF0\xAF\xA4\x97" => "\xE7\x81\x8A",
		"\xF0\xAF\xA4\x98" => "\xE7\x81\xBD",
		"\xF0\xAF\xA4\x99" => "\xE7\x81\xB7",
		"\xF0\xAF\xA4\x9A" => "\xE7\x82\xAD",
		"\xF0\xAF\xA4\x9B" => "\xF0\xA0\x94\xA5",
		"\xF0\xAF\xA4\x9C" => "\xE7\x85\x85",
		"\xF0\xAF\xA4\x9D" => "\xF0\xA4\x89\xA3",
		"\xF0\xAF\xA4\x9E" => "\xE7\x86\x9C",
		"\xF0\xAF\xA4\xA0" => "\xE7\x88\xA8",
		"\xF0\xAF\xA4\xA1" => "\xE7\x88\xB5",
		"\xF0\xAF\xA4\xA2" => "\xE7\x89\x90",
		"\xF0\xAF\xA4\xA3" => "\xF0\xA4\x98\x88",
		"\xF0\xAF\xA4\xA4" => "\xE7\x8A\x80",
		"\xF0\xAF\xA4\xA5" => "\xE7\x8A\x95",
		"\xF0\xAF\xA4\xA6" => "\xF0\xA4\x9C\xB5",
		"\xF0\xAF\xA4\xA7" => "\xF0\xA4\xA0\x94",
		"\xF0\xAF\xA4\xA8" => "\xE7\x8D\xBA",
		"\xF0\xAF\xA4\xA9" => "\xE7\x8E\x8B",
		"\xF0\xAF\xA4\xAA" => "\xE3\xBA\xAC",
		"\xF0\xAF\xA4\xAB" => "\xE7\x8E\xA5",
		"\xF0\xAF\xA4\xAC" => "\xE3\xBA\xB8",
		"\xF0\xAF\xA4\xAD" => "\xE3\xBA\xB8",
		"\xF0\xAF\xA4\xAE" => "\xE7\x91\x87",
		"\xF0\xAF\xA4\xAF" => "\xE7\x91\x9C",
		"\xF0\xAF\xA4\xB0" => "\xE7\x91\xB1",
		"\xF0\xAF\xA4\xB1" => "\xE7\x92\x85",
		"\xF0\xAF\xA4\xB2" => "\xE7\x93\x8A",
		"\xF0\xAF\xA4\xB3" => "\xE3\xBC\x9B",
		"\xF0\xAF\xA4\xB4" => "\xE7\x94\xA4",
		"\xF0\xAF\xA4\xB5" => "\xF0\xA4\xB0\xB6",
		"\xF0\xAF\xA4\xB6" => "\xE7\x94\xBE",
		"\xF0\xAF\xA4\xB7" => "\xF0\xA4\xB2\x92",
		"\xF0\xAF\xA4\xB8" => "\xE7\x95\xB0",
		"\xF0\xAF\xA4\xB9" => "\xF0\xA2\x86\x9F",
		"\xF0\xAF\xA4\xBA" => "\xE7\x98\x90",
		"\xF0\xAF\xA4\xBB" => "\xF0\xA4\xBE\xA1",
		"\xF0\xAF\xA4\xBC" => "\xF0\xA4\xBE\xB8",
		"\xF0\xAF\xA4\xBD" => "\xF0\xA5\x81\x84",
		"\xF0\xAF\xA4\xBE" => "\xE3\xBF\xBC",
		"\xF0\xAF\xA4\xBF" => "\xE4\x80\x88",
		"\xF0\xAF\xA5\x80" => "\xE7\x9B\xB4",
		"\xF0\xAF\xA5\x81" => "\xF0\xA5\x83\xB3",
		"\xF0\xAF\xA5\x82" => "\xF0\xA5\x83\xB2",
		"\xF0\xAF\xA5\x83" => "\xF0\xA5\x84\x99",
		"\xF0\xAF\xA5\x84" => "\xF0\xA5\x84\xB3",
		"\xF0\xAF\xA5\x85" => "\xE7\x9C\x9E",
		"\xF0\xAF\xA5\x86" => "\xE7\x9C\x9F",
		"\xF0\xAF\xA5\x87" => "\xE7\x9C\x9F",
		"\xF0\xAF\xA5\x88" => "\xE7\x9D\x8A",
		"\xF0\xAF\xA5\x89" => "\xE4\x80\xB9",
		"\xF0\xAF\xA5\x8A" => "\xE7\x9E\x8B",
		"\xF0\xAF\xA5\x8B" => "\xE4\x81\x86",
		"\xF0\xAF\xA5\x8C" => "\xE4\x82\x96",
		"\xF0\xAF\xA5\x8D" => "\xF0\xA5\x90\x9D",
		"\xF0\xAF\xA5\x8E" => "\xE7\xA1\x8E",
		"\xF0\xAF\xA5\x8F" => "\xE7\xA2\x8C",
		"\xF0\xAF\xA5\x90" => "\xE7\xA3\x8C",
		"\xF0\xAF\xA5\x91" => "\xE4\x83\xA3",
		"\xF0\xAF\xA5\x92" => "\xF0\xA5\x98\xA6",
		"\xF0\xAF\xA5\x93" => "\xE7\xA5\x96",
		"\xF0\xAF\xA5\x94" => "\xF0\xA5\x9A\x9A",
		"\xF0\xAF\xA5\x95" => "\xF0\xA5\x9B\x85",
		"\xF0\xAF\xA5\x96" => "\xE7\xA6\x8F",
		"\xF0\xAF\xA5\x97" => "\xE7\xA7\xAB",
		"\xF0\xAF\xA5\x98" => "\xE4\x84\xAF",
		"\xF0\xAF\xA5\x99" => "\xE7\xA9\x80",
		"\xF0\xAF\xA5\x9A" => "\xE7\xA9\x8A",
		"\xF0\xAF\xA5\x9B" => "\xE7\xA9\x8F",
		"\xF0\xAF\xA5\x9C" => "\xF0\xA5\xA5\xBC",
		"\xF0\xAF\xA5\x9D" => "\xF0\xA5\xAA\xA7",
		"\xF0\xAF\xA5\x9E" => "\xF0\xA5\xAA\xA7",
		"\xF0\xAF\xA5\xA0" => "\xE4\x88\x82",
		"\xF0\xAF\xA5\xA1" => "\xF0\xA5\xAE\xAB",
		"\xF0\xAF\xA5\xA2" => "\xE7\xAF\x86",
		"\xF0\xAF\xA5\xA3" => "\xE7\xAF\x89",
		"\xF0\xAF\xA5\xA4" => "\xE4\x88\xA7",
		"\xF0\xAF\xA5\xA5" => "\xF0\xA5\xB2\x80",
		"\xF0\xAF\xA5\xA6" => "\xE7\xB3\x92",
		"\xF0\xAF\xA5\xA7" => "\xE4\x8A\xA0",
		"\xF0\xAF\xA5\xA8" => "\xE7\xB3\xA8",
		"\xF0\xAF\xA5\xA9" => "\xE7\xB3\xA3",
		"\xF0\xAF\xA5\xAA" => "\xE7\xB4\x80",
		"\xF0\xAF\xA5\xAB" => "\xF0\xA5\xBE\x86",
		"\xF0\xAF\xA5\xAC" => "\xE7\xB5\xA3",
		"\xF0\xAF\xA5\xAD" => "\xE4\x8C\x81",
		"\xF0\xAF\xA5\xAE" => "\xE7\xB7\x87",
		"\xF0\xAF\xA5\xAF" => "\xE7\xB8\x82",
		"\xF0\xAF\xA5\xB0" => "\xE7\xB9\x85",
		"\xF0\xAF\xA5\xB1" => "\xE4\x8C\xB4",
		"\xF0\xAF\xA5\xB2" => "\xF0\xA6\x88\xA8",
		"\xF0\xAF\xA5\xB3" => "\xF0\xA6\x89\x87",
		"\xF0\xAF\xA5\xB4" => "\xE4\x8D\x99",
		"\xF0\xAF\xA5\xB5" => "\xF0\xA6\x8B\x99",
		"\xF0\xAF\xA5\xB6" => "\xE7\xBD\xBA",
		"\xF0\xAF\xA5\xB7" => "\xF0\xA6\x8C\xBE",
		"\xF0\xAF\xA5\xB8" => "\xE7\xBE\x95",
		"\xF0\xAF\xA5\xB9" => "\xE7\xBF\xBA",
		"\xF0\xAF\xA5\xBA" => "\xE8\x80\x85",
		"\xF0\xAF\xA5\xBB" => "\xF0\xA6\x93\x9A",
		"\xF0\xAF\xA5\xBC" => "\xF0\xA6\x94\xA3",
		"\xF0\xAF\xA5\xBD" => "\xE8\x81\xA0",
		"\xF0\xAF\xA5\xBE" => "\xF0\xA6\x96\xA8",
		"\xF0\xAF\xA5\xBF" => "\xE8\x81\xB0",
		"\xF0\xAF\xA6\x80" => "\xF0\xA3\x8D\x9F",
		"\xF0\xAF\xA6\x81" => "\xE4\x8F\x95",
		"\xF0\xAF\xA6\x82" => "\xE8\x82\xB2",
		"\xF0\xAF\xA6\x83" => "\xE8\x84\x83",
		"\xF0\xAF\xA6\x84" => "\xE4\x90\x8B",
		"\xF0\xAF\xA6\x85" => "\xE8\x84\xBE",
		"\xF0\xAF\xA6\x86" => "\xE5\xAA\xB5",
		"\xF0\xAF\xA6\x87" => "\xF0\xA6\x9E\xA7",
		"\xF0\xAF\xA6\x88" => "\xF0\xA6\x9E\xB5",
		"\xF0\xAF\xA6\x89" => "\xF0\xA3\x8E\x93",
		"\xF0\xAF\xA6\x8A" => "\xF0\xA3\x8E\x9C",
		"\xF0\xAF\xA6\x8B" => "\xE8\x88\x81",
		"\xF0\xAF\xA6\x8C" => "\xE8\x88\x84",
		"\xF0\xAF\xA6\x8D" => "\xE8\xBE\x9E",
		"\xF0\xAF\xA6\x8E" => "\xE4\x91\xAB",
		"\xF0\xAF\xA6\x8F" => "\xE8\x8A\x91",
		"\xF0\xAF\xA6\x90" => "\xE8\x8A\x8B",
		"\xF0\xAF\xA6\x91" => "\xE8\x8A\x9D",
		"\xF0\xAF\xA6\x92" => "\xE5\x8A\xB3",
		"\xF0\xAF\xA6\x93" => "\xE8\x8A\xB1",
		"\xF0\xAF\xA6\x94" => "\xE8\x8A\xB3",
		"\xF0\xAF\xA6\x95" => "\xE8\x8A\xBD",
		"\xF0\xAF\xA6\x96" => "\xE8\x8B\xA6",
		"\xF0\xAF\xA6\x97" => "\xF0\xA6\xAC\xBC",
		"\xF0\xAF\xA6\x98" => "\xE8\x8B\xA5",
		"\xF0\xAF\xA6\x99" => "\xE8\x8C\x9D",
		"\xF0\xAF\xA6\x9A" => "\xE8\x8D\xA3",
		"\xF0\xAF\xA6\x9B" => "\xE8\x8E\xAD",
		"\xF0\xAF\xA6\x9C" => "\xE8\x8C\xA3",
		"\xF0\xAF\xA6\x9D" => "\xE8\x8E\xBD",
		"\xF0\xAF\xA6\x9E" => "\xE8\x8F\xA7",
		"\xF0\xAF\xA6\x9F" => "\xE8\x91\x97",
		"\xF0\xAF\xA6\xA0" => "\xE8\x8D\x93",
		"\xF0\xAF\xA6\xA1" => "\xE8\x8F\x8A",
		"\xF0\xAF\xA6\xA2" => "\xE8\x8F\x8C",
		"\xF0\xAF\xA6\xA3" => "\xE8\x8F\x9C",
		"\xF0\xAF\xA6\xA4" => "\xF0\xA6\xB0\xB6",
		"\xF0\xAF\xA6\xA5" => "\xF0\xA6\xB5\xAB",
		"\xF0\xAF\xA6\xA6" => "\xF0\xA6\xB3\x95",
		"\xF0\xAF\xA6\xA7" => "\xE4\x94\xAB",
		"\xF0\xAF\xA6\xA8" => "\xE8\x93\xB1",
		"\xF0\xAF\xA6\xA9" => "\xE8\x93\xB3",
		"\xF0\xAF\xA6\xAA" => "\xE8\x94\x96",
		"\xF0\xAF\xA6\xAB" => "\xF0\xA7\x8F\x8A",
		"\xF0\xAF\xA6\xAC" => "\xE8\x95\xA4",
		"\xF0\xAF\xA6\xAD" => "\xF0\xA6\xBC\xAC",
		"\xF0\xAF\xA6\xAE" => "\xE4\x95\x9D",
		"\xF0\xAF\xA6\xAF" => "\xE4\x95\xA1",
		"\xF0\xAF\xA6\xB0" => "\xF0\xA6\xBE\xB1",
		"\xF0\xAF\xA6\xB1" => "\xF0\xA7\x83\x92",
		"\xF0\xAF\xA6\xB2" => "\xE4\x95\xAB",
		"\xF0\xAF\xA6\xB3" => "\xE8\x99\x90",
		"\xF0\xAF\xA6\xB4" => "\xE8\x99\x9C",
		"\xF0\xAF\xA6\xB5" => "\xE8\x99\xA7",
		"\xF0\xAF\xA6\xB6" => "\xE8\x99\xA9",
		"\xF0\xAF\xA6\xB7" => "\xE8\x9A\xA9",
		"\xF0\xAF\xA6\xB8" => "\xE8\x9A\x88",
		"\xF0\xAF\xA6\xB9" => "\xE8\x9C\x8E",
		"\xF0\xAF\xA6\xBA" => "\xE8\x9B\xA2",
		"\xF0\xAF\xA6\xBB" => "\xE8\x9D\xB9",
		"\xF0\xAF\xA6\xBC" => "\xE8\x9C\xA8",
		"\xF0\xAF\xA6\xBD" => "\xE8\x9D\xAB",
		"\xF0\xAF\xA6\xBE" => "\xE8\x9E\x86",
		"\xF0\xAF\xA7\x80" => "\xE8\x9F\xA1",
		"\xF0\xAF\xA7\x81" => "\xE8\xA0\x81",
		"\xF0\xAF\xA7\x82" => "\xE4\x97\xB9",
		"\xF0\xAF\xA7\x83" => "\xE8\xA1\xA0",
		"\xF0\xAF\xA7\x84" => "\xE8\xA1\xA3",
		"\xF0\xAF\xA7\x85" => "\xF0\xA7\x99\xA7",
		"\xF0\xAF\xA7\x86" => "\xE8\xA3\x97",
		"\xF0\xAF\xA7\x87" => "\xE8\xA3\x9E",
		"\xF0\xAF\xA7\x88" => "\xE4\x98\xB5",
		"\xF0\xAF\xA7\x89" => "\xE8\xA3\xBA",
		"\xF0\xAF\xA7\x8A" => "\xE3\x92\xBB",
		"\xF0\xAF\xA7\x8B" => "\xF0\xA7\xA2\xAE",
		"\xF0\xAF\xA7\x8C" => "\xF0\xA7\xA5\xA6",
		"\xF0\xAF\xA7\x8D" => "\xE4\x9A\xBE",
		"\xF0\xAF\xA7\x8E" => "\xE4\x9B\x87",
		"\xF0\xAF\xA7\x8F" => "\xE8\xAA\xA0",
		"\xF0\xAF\xA7\x90" => "\xE8\xAB\xAD",
		"\xF0\xAF\xA7\x91" => "\xE8\xAE\x8A",
		"\xF0\xAF\xA7\x92" => "\xE8\xB1\x95",
		"\xF0\xAF\xA7\x93" => "\xF0\xA7\xB2\xA8",
		"\xF0\xAF\xA7\x94" => "\xE8\xB2\xAB",
		"\xF0\xAF\xA7\x95" => "\xE8\xB3\x81",
		"\xF0\xAF\xA7\x96" => "\xE8\xB4\x9B",
		"\xF0\xAF\xA7\x97" => "\xE8\xB5\xB7",
		"\xF0\xAF\xA7\x98" => "\xF0\xA7\xBC\xAF",
		"\xF0\xAF\xA7\x99" => "\xF0\xA0\xA0\x84",
		"\xF0\xAF\xA7\x9A" => "\xE8\xB7\x8B",
		"\xF0\xAF\xA7\x9B" => "\xE8\xB6\xBC",
		"\xF0\xAF\xA7\x9C" => "\xE8\xB7\xB0",
		"\xF0\xAF\xA7\x9D" => "\xF0\xA0\xA3\x9E",
		"\xF0\xAF\xA7\x9E" => "\xE8\xBB\x94",
		"\xF0\xAF\xA7\x9F" => "\xE8\xBC\xB8",
		"\xF0\xAF\xA7\xA0" => "\xF0\xA8\x97\x92",
		"\xF0\xAF\xA7\xA1" => "\xF0\xA8\x97\xAD",
		"\xF0\xAF\xA7\xA2" => "\xE9\x82\x94",
		"\xF0\xAF\xA7\xA3" => "\xE9\x83\xB1",
		"\xF0\xAF\xA7\xA4" => "\xE9\x84\x91",
		"\xF0\xAF\xA7\xA5" => "\xF0\xA8\x9C\xAE",
		"\xF0\xAF\xA7\xA6" => "\xE9\x84\x9B",
		"\xF0\xAF\xA7\xA7" => "\xE9\x88\xB8",
		"\xF0\xAF\xA7\xA8" => "\xE9\x8B\x97",
		"\xF0\xAF\xA7\xA9" => "\xE9\x8B\x98",
		"\xF0\xAF\xA7\xAA" => "\xE9\x89\xBC",
		"\xF0\xAF\xA7\xAB" => "\xE9\x8F\xB9",
		"\xF0\xAF\xA7\xAC" => "\xE9\x90\x95",
		"\xF0\xAF\xA7\xAD" => "\xF0\xA8\xAF\xBA",
		"\xF0\xAF\xA7\xAE" => "\xE9\x96\x8B",
		"\xF0\xAF\xA7\xAF" => "\xE4\xA6\x95",
		"\xF0\xAF\xA7\xB0" => "\xE9\x96\xB7",
		"\xF0\xAF\xA7\xB1" => "\xF0\xA8\xB5\xB7",
		"\xF0\xAF\xA7\xB2" => "\xE4\xA7\xA6",
		"\xF0\xAF\xA7\xB3" => "\xE9\x9B\x83",
		"\xF0\xAF\xA7\xB4" => "\xE5\xB6\xB2",
		"\xF0\xAF\xA7\xB5" => "\xE9\x9C\xA3",
		"\xF0\xAF\xA7\xB6" => "\xF0\xA9\x85\x85",
		"\xF0\xAF\xA7\xB7" => "\xF0\xA9\x88\x9A",
		"\xF0\xAF\xA7\xB8" => "\xE4\xA9\xAE",
		"\xF0\xAF\xA7\xB9" => "\xE4\xA9\xB6",
		"\xF0\xAF\xA7\xBA" => "\xE9\x9F\xA0",
		"\xF0\xAF\xA7\xBB" => "\xF0\xA9\x90\x8A",
		"\xF0\xAF\xA7\xBC" => "\xE4\xAA\xB2",
		"\xF0\xAF\xA7\xBD" => "\xF0\xA9\x92\x96",
		"\xF0\xAF\xA7\xBE" => "\xE9\xA0\x8B",
		"\xF0\xAF\xA7\xBF" => "\xE9\xA0\x8B",
		"\xF0\xAF\xA8\x80" => "\xE9\xA0\xA9",
		"\xF0\xAF\xA8\x81" => "\xF0\xA9\x96\xB6",
		"\xF0\xAF\xA8\x82" => "\xE9\xA3\xA2",
		"\xF0\xAF\xA8\x83" => "\xE4\xAC\xB3",
		"\xF0\xAF\xA8\x84" => "\xE9\xA4\xA9",
		"\xF0\xAF\xA8\x85" => "\xE9\xA6\xA7",
		"\xF0\xAF\xA8\x86" => "\xE9\xA7\x82",
		"\xF0\xAF\xA8\x87" => "\xE9\xA7\xBE",
		"\xF0\xAF\xA8\x88" => "\xE4\xAF\x8E",
		"\xF0\xAF\xA8\x89" => "\xF0\xA9\xAC\xB0",
		"\xF0\xAF\xA8\x8A" => "\xE9\xAC\x92",
		"\xF0\xAF\xA8\x8B" => "\xE9\xB1\x80",
		"\xF0\xAF\xA8\x8C" => "\xE9\xB3\xBD",
		"\xF0\xAF\xA8\x8D" => "\xE4\xB3\x8E",
		"\xF0\xAF\xA8\x8E" => "\xE4\xB3\xAD",
		"\xF0\xAF\xA8\x8F" => "\xE9\xB5\xA7",
		"\xF0\xAF\xA8\x90" => "\xF0\xAA\x83\x8E",
		"\xF0\xAF\xA8\x91" => "\xE4\xB3\xB8",
		"\xF0\xAF\xA8\x92" => "\xF0\xAA\x84\x85",
		"\xF0\xAF\xA8\x93" => "\xF0\xAA\x88\x8E",
		"\xF0\xAF\xA8\x94" => "\xF0\xAA\x8A\x91",
		"\xF0\xAF\xA8\x95" => "\xE9\xBA\xBB",
		"\xF0\xAF\xA8\x96" => "\xE4\xB5\x96",
		"\xF0\xAF\xA8\x97" => "\xE9\xBB\xB9",
		"\xF0\xAF\xA8\x98" => "\xE9\xBB\xBE",
		"\xF0\xAF\xA8\x99" => "\xE9\xBC\x85",
		"\xF0\xAF\xA8\x9A" => "\xE9\xBC\x8F",
		"\xF0\xAF\xA8\x9B" => "\xE9\xBC\x96",
		"\xF0\xAF\xA8\x9C" => "\xE9\xBC\xBB",
		"\xF0\xAF\xA8\x9D" => "\xF0\xAA\x98\x80",
	);
}

/**
 * Helper function for idn_to_* polyfills.
 *
 * Developers: Do not update the data in this function manually. Instead,
 * run "php -f other/update_unicode_data.php" on the command line.
 *
 * @return array "Deviation" character maps for IDNA processing.
 */
function idna_maps_deviation()
{
	return array(
		"\xC3\x9F" => "\x73\x73",
		"\xCF\x82" => "\xCF\x83",
		"\xE2\x80\x8C" => "",
		"\xE2\x80\x8D" => "",
	);
}

/**
 * Helper function for idn_to_* polyfills.
 *
 * Developers: Do not update the data in this function manually. Instead,
 * run "php -f other/update_unicode_data.php" on the command line.
 *
 * @return array Non-STD3 character maps for IDNA processing.
 */
function idna_maps_not_std3()
{
	return array(
		"\xC2\xA0" => "\x20",
		"\xC2\xA8" => "\x20\xCC\x88",
		"\xC2\xAF" => "\x20\xCC\x84",
		"\xC2\xB4" => "\x20\xCC\x81",
		"\xC2\xB8" => "\x20\xCC\xA7",
		"\xCB\x98" => "\x20\xCC\x86",
		"\xCB\x99" => "\x20\xCC\x87",
		"\xCB\x9A" => "\x20\xCC\x8A",
		"\xCB\x9B" => "\x20\xCC\xA8",
		"\xCB\x9C" => "\x20\xCC\x83",
		"\xCB\x9D" => "\x20\xCC\x8B",
		"\xCD\xBA" => "\x20\xCE\xB9",
		"\xCD\xBE" => "\x3B",
		"\xCE\x84" => "\x20\xCC\x81",
		"\xCE\x85" => "\x20\xCC\x88\xCC\x81",
		"\xE1\xBE\xBD" => "\x20\xCC\x93",
		"\xE1\xBE\xBF" => "\x20\xCC\x93",
		"\xE1\xBF\x80" => "\x20\xCD\x82",
		"\xE1\xBF\x81" => "\x20\xCC\x88\xCD\x82",
		"\xE1\xBF\x8D" => "\x20\xCC\x93\xCC\x80",
		"\xE1\xBF\x8E" => "\x20\xCC\x93\xCC\x81",
		"\xE1\xBF\x8F" => "\x20\xCC\x93\xCD\x82",
		"\xE1\xBF\x9D" => "\x20\xCC\x94\xCC\x80",
		"\xE1\xBF\x9E" => "\x20\xCC\x94\xCC\x81",
		"\xE1\xBF\x9F" => "\x20\xCC\x94\xCD\x82",
		"\xE1\xBF\xAD" => "\x20\xCC\x88\xCC\x80",
		"\xE1\xBF\xAE" => "\x20\xCC\x88\xCC\x81",
		"\xE1\xBF\xAF" => "\x60",
		"\xE1\xBF\xBD" => "\x20\xCC\x81",
		"\xE1\xBF\xBE" => "\x20\xCC\x94",
		"\xE2\x80\x80" => "\x20",
		"\xE2\x80\x81" => "\x20",
		"\xE2\x80\x82" => "\x20",
		"\xE2\x80\x83" => "\x20",
		"\xE2\x80\x84" => "\x20",
		"\xE2\x80\x85" => "\x20",
		"\xE2\x80\x86" => "\x20",
		"\xE2\x80\x87" => "\x20",
		"\xE2\x80\x88" => "\x20",
		"\xE2\x80\x89" => "\x20",
		"\xE2\x80\x8A" => "\x20",
		"\xE2\x80\x97" => "\x20\xCC\xB3",
		"\xE2\x80\xAF" => "\x20",
		"\xE2\x80\xBC" => "\x21\x21",
		"\xE2\x80\xBE" => "\x20\xCC\x85",
		"\xE2\x81\x87" => "\x3F\x3F",
		"\xE2\x81\x88" => "\x3F\x21",
		"\xE2\x81\x89" => "\x21\x3F",
		"\xE2\x81\x9F" => "\x20",
		"\xE2\x81\xBA" => "\x2B",
		"\xE2\x81\xBC" => "\x3D",
		"\xE2\x81\xBD" => "\x28",
		"\xE2\x81\xBE" => "\x29",
		"\xE2\x82\x8A" => "\x2B",
		"\xE2\x82\x8C" => "\x3D",
		"\xE2\x82\x8D" => "\x28",
		"\xE2\x82\x8E" => "\x29",
		"\xE2\x84\x80" => "\x61\x2F\x63",
		"\xE2\x84\x81" => "\x61\x2F\x73",
		"\xE2\x84\x85" => "\x63\x2F\x6F",
		"\xE2\x84\x86" => "\x63\x2F\x75",
		"\xE2\x91\xB4" => "\x28\x31\x29",
		"\xE2\x91\xB5" => "\x28\x32\x29",
		"\xE2\x91\xB6" => "\x28\x33\x29",
		"\xE2\x91\xB7" => "\x28\x34\x29",
		"\xE2\x91\xB8" => "\x28\x35\x29",
		"\xE2\x91\xB9" => "\x28\x36\x29",
		"\xE2\x91\xBA" => "\x28\x37\x29",
		"\xE2\x91\xBB" => "\x28\x38\x29",
		"\xE2\x91\xBC" => "\x28\x39\x29",
		"\xE2\x91\xBD" => "\x28\x31\x30\x29",
		"\xE2\x91\xBE" => "\x28\x31\x31\x29",
		"\xE2\x91\xBF" => "\x28\x31\x32\x29",
		"\xE2\x92\x80" => "\x28\x31\x33\x29",
		"\xE2\x92\x81" => "\x28\x31\x34\x29",
		"\xE2\x92\x82" => "\x28\x31\x35\x29",
		"\xE2\x92\x83" => "\x28\x31\x36\x29",
		"\xE2\x92\x84" => "\x28\x31\x37\x29",
		"\xE2\x92\x85" => "\x28\x31\x38\x29",
		"\xE2\x92\x86" => "\x28\x31\x39\x29",
		"\xE2\x92\x87" => "\x28\x32\x30\x29",
		"\xE2\x92\x9C" => "\x28\x61\x29",
		"\xE2\x92\x9D" => "\x28\x62\x29",
		"\xE2\x92\x9E" => "\x28\x63\x29",
		"\xE2\x92\x9F" => "\x28\x64\x29",
		"\xE2\x92\xA0" => "\x28\x65\x29",
		"\xE2\x92\xA1" => "\x28\x66\x29",
		"\xE2\x92\xA2" => "\x28\x67\x29",
		"\xE2\x92\xA3" => "\x28\x68\x29",
		"\xE2\x92\xA4" => "\x28\x69\x29",
		"\xE2\x92\xA5" => "\x28\x6A\x29",
		"\xE2\x92\xA6" => "\x28\x6B\x29",
		"\xE2\x92\xA7" => "\x28\x6C\x29",
		"\xE2\x92\xA8" => "\x28\x6D\x29",
		"\xE2\x92\xA9" => "\x28\x6E\x29",
		"\xE2\x92\xAA" => "\x28\x6F\x29",
		"\xE2\x92\xAB" => "\x28\x70\x29",
		"\xE2\x92\xAC" => "\x28\x71\x29",
		"\xE2\x92\xAD" => "\x28\x72\x29",
		"\xE2\x92\xAE" => "\x28\x73\x29",
		"\xE2\x92\xAF" => "\x28\x74\x29",
		"\xE2\x92\xB0" => "\x28\x75\x29",
		"\xE2\x92\xB1" => "\x28\x76\x29",
		"\xE2\x92\xB2" => "\x28\x77\x29",
		"\xE2\x92\xB3" => "\x28\x78\x29",
		"\xE2\x92\xB4" => "\x28\x79\x29",
		"\xE2\x92\xB5" => "\x28\x7A\x29",
		"\xE2\xA9\xB4" => "\x3A\x3A\x3D",
		"\xE2\xA9\xB5" => "\x3D\x3D",
		"\xE2\xA9\xB6" => "\x3D\x3D\x3D",
		"\xE3\x80\x80" => "\x20",
		"\xE3\x82\x9B" => "\x20\xE3\x82\x99",
		"\xE3\x82\x9C" => "\x20\xE3\x82\x9A",
		"\xE3\x88\x80" => "\x28\xE1\x84\x80\x29",
		"\xE3\x88\x81" => "\x28\xE1\x84\x82\x29",
		"\xE3\x88\x82" => "\x28\xE1\x84\x83\x29",
		"\xE3\x88\x83" => "\x28\xE1\x84\x85\x29",
		"\xE3\x88\x84" => "\x28\xE1\x84\x86\x29",
		"\xE3\x88\x85" => "\x28\xE1\x84\x87\x29",
		"\xE3\x88\x86" => "\x28\xE1\x84\x89\x29",
		"\xE3\x88\x87" => "\x28\xE1\x84\x8B\x29",
		"\xE3\x88\x88" => "\x28\xE1\x84\x8C\x29",
		"\xE3\x88\x89" => "\x28\xE1\x84\x8E\x29",
		"\xE3\x88\x8A" => "\x28\xE1\x84\x8F\x29",
		"\xE3\x88\x8B" => "\x28\xE1\x84\x90\x29",
		"\xE3\x88\x8C" => "\x28\xE1\x84\x91\x29",
		"\xE3\x88\x8D" => "\x28\xE1\x84\x92\x29",
		"\xE3\x88\x8E" => "\x28\xEA\xB0\x80\x29",
		"\xE3\x88\x8F" => "\x28\xEB\x82\x98\x29",
		"\xE3\x88\x90" => "\x28\xEB\x8B\xA4\x29",
		"\xE3\x88\x91" => "\x28\xEB\x9D\xBC\x29",
		"\xE3\x88\x92" => "\x28\xEB\xA7\x88\x29",
		"\xE3\x88\x93" => "\x28\xEB\xB0\x94\x29",
		"\xE3\x88\x94" => "\x28\xEC\x82\xAC\x29",
		"\xE3\x88\x95" => "\x28\xEC\x95\x84\x29",
		"\xE3\x88\x96" => "\x28\xEC\x9E\x90\x29",
		"\xE3\x88\x97" => "\x28\xEC\xB0\xA8\x29",
		"\xE3\x88\x98" => "\x28\xEC\xB9\xB4\x29",
		"\xE3\x88\x99" => "\x28\xED\x83\x80\x29",
		"\xE3\x88\x9A" => "\x28\xED\x8C\x8C\x29",
		"\xE3\x88\x9B" => "\x28\xED\x95\x98\x29",
		"\xE3\x88\x9C" => "\x28\xEC\xA3\xBC\x29",
		"\xE3\x88\x9D" => "\x28\xEC\x98\xA4\xEC\xA0\x84\x29",
		"\xE3\x88\x9E" => "\x28\xEC\x98\xA4\xED\x9B\x84\x29",
		"\xE3\x88\xA0" => "\x28\xE4\xB8\x80\x29",
		"\xE3\x88\xA1" => "\x28\xE4\xBA\x8C\x29",
		"\xE3\x88\xA2" => "\x28\xE4\xB8\x89\x29",
		"\xE3\x88\xA3" => "\x28\xE5\x9B\x9B\x29",
		"\xE3\x88\xA4" => "\x28\xE4\xBA\x94\x29",
		"\xE3\x88\xA5" => "\x28\xE5\x85\xAD\x29",
		"\xE3\x88\xA6" => "\x28\xE4\xB8\x83\x29",
		"\xE3\x88\xA7" => "\x28\xE5\x85\xAB\x29",
		"\xE3\x88\xA8" => "\x28\xE4\xB9\x9D\x29",
		"\xE3\x88\xA9" => "\x28\xE5\x8D\x81\x29",
		"\xE3\x88\xAA" => "\x28\xE6\x9C\x88\x29",
		"\xE3\x88\xAB" => "\x28\xE7\x81\xAB\x29",
		"\xE3\x88\xAC" => "\x28\xE6\xB0\xB4\x29",
		"\xE3\x88\xAD" => "\x28\xE6\x9C\xA8\x29",
		"\xE3\x88\xAE" => "\x28\xE9\x87\x91\x29",
		"\xE3\x88\xAF" => "\x28\xE5\x9C\x9F\x29",
		"\xE3\x88\xB0" => "\x28\xE6\x97\xA5\x29",
		"\xE3\x88\xB1" => "\x28\xE6\xA0\xAA\x29",
		"\xE3\x88\xB2" => "\x28\xE6\x9C\x89\x29",
		"\xE3\x88\xB3" => "\x28\xE7\xA4\xBE\x29",
		"\xE3\x88\xB4" => "\x28\xE5\x90\x8D\x29",
		"\xE3\x88\xB5" => "\x28\xE7\x89\xB9\x29",
		"\xE3\x88\xB6" => "\x28\xE8\xB2\xA1\x29",
		"\xE3\x88\xB7" => "\x28\xE7\xA5\x9D\x29",
		"\xE3\x88\xB8" => "\x28\xE5\x8A\xB4\x29",
		"\xE3\x88\xB9" => "\x28\xE4\xBB\xA3\x29",
		"\xE3\x88\xBA" => "\x28\xE5\x91\xBC\x29",
		"\xE3\x88\xBB" => "\x28\xE5\xAD\xA6\x29",
		"\xE3\x88\xBC" => "\x28\xE7\x9B\xA3\x29",
		"\xE3\x88\xBD" => "\x28\xE4\xBC\x81\x29",
		"\xE3\x88\xBE" => "\x28\xE8\xB3\x87\x29",
		"\xE3\x88\xBF" => "\x28\xE5\x8D\x94\x29",
		"\xE3\x89\x80" => "\x28\xE7\xA5\xAD\x29",
		"\xE3\x89\x81" => "\x28\xE4\xBC\x91\x29",
		"\xE3\x89\x82" => "\x28\xE8\x87\xAA\x29",
		"\xE3\x89\x83" => "\x28\xE8\x87\xB3\x29",
		"\xEF\xAC\xA9" => "\x2B",
		"\xEF\xB1\x9E" => "\x20\xD9\x8C\xD9\x91",
		"\xEF\xB1\x9F" => "\x20\xD9\x8D\xD9\x91",
		"\xEF\xB1\xA0" => "\x20\xD9\x8E\xD9\x91",
		"\xEF\xB1\xA1" => "\x20\xD9\x8F\xD9\x91",
		"\xEF\xB1\xA2" => "\x20\xD9\x90\xD9\x91",
		"\xEF\xB1\xA3" => "\x20\xD9\x91\xD9\xB0",
		"\xEF\xB7\xBA" => "\xD8\xB5\xD9\x84\xD9\x89\x20\xD8\xA7\xD9\x84\xD9\x84\xD9\x87\x20\xD8\xB9\xD9\x84\xD9\x8A\xD9\x87\x20\xD9\x88\xD8\xB3\xD9\x84\xD9\x85",
		"\xEF\xB7\xBB" => "\xD8\xAC\xD9\x84\x20\xD8\xAC\xD9\x84\xD8\xA7\xD9\x84\xD9\x87",
		"\xEF\xB8\x90" => "\x2C",
		"\xEF\xB8\x93" => "\x3A",
		"\xEF\xB8\x94" => "\x3B",
		"\xEF\xB8\x95" => "\x21",
		"\xEF\xB8\x96" => "\x3F",
		"\xEF\xB8\xB3" => "\x5F",
		"\xEF\xB8\xB4" => "\x5F",
		"\xEF\xB8\xB5" => "\x28",
		"\xEF\xB8\xB6" => "\x29",
		"\xEF\xB8\xB7" => "\x7B",
		"\xEF\xB8\xB8" => "\x7D",
		"\xEF\xB9\x87" => "\x5B",
		"\xEF\xB9\x88" => "\x5D",
		"\xEF\xB9\x89" => "\x20\xCC\x85",
		"\xEF\xB9\x8A" => "\x20\xCC\x85",
		"\xEF\xB9\x8B" => "\x20\xCC\x85",
		"\xEF\xB9\x8C" => "\x20\xCC\x85",
		"\xEF\xB9\x8D" => "\x5F",
		"\xEF\xB9\x8E" => "\x5F",
		"\xEF\xB9\x8F" => "\x5F",
		"\xEF\xB9\x90" => "\x2C",
		"\xEF\xB9\x94" => "\x3B",
		"\xEF\xB9\x95" => "\x3A",
		"\xEF\xB9\x96" => "\x3F",
		"\xEF\xB9\x97" => "\x21",
		"\xEF\xB9\x99" => "\x28",
		"\xEF\xB9\x9A" => "\x29",
		"\xEF\xB9\x9B" => "\x7B",
		"\xEF\xB9\x9C" => "\x7D",
		"\xEF\xB9\x9F" => "\x23",
		"\xEF\xB9\xA0" => "\x26",
		"\xEF\xB9\xA1" => "\x2A",
		"\xEF\xB9\xA2" => "\x2B",
		"\xEF\xB9\xA4" => "\x3C",
		"\xEF\xB9\xA5" => "\x3E",
		"\xEF\xB9\xA6" => "\x3D",
		"\xEF\xB9\xA8" => "\x5C",
		"\xEF\xB9\xA9" => "\x24",
		"\xEF\xB9\xAA" => "\x25",
		"\xEF\xB9\xAB" => "\x40",
		"\xEF\xB9\xB0" => "\x20\xD9\x8B",
		"\xEF\xB9\xB2" => "\x20\xD9\x8C",
		"\xEF\xB9\xB4" => "\x20\xD9\x8D",
		"\xEF\xB9\xB6" => "\x20\xD9\x8E",
		"\xEF\xB9\xB8" => "\x20\xD9\x8F",
		"\xEF\xB9\xBA" => "\x20\xD9\x90",
		"\xEF\xB9\xBC" => "\x20\xD9\x91",
		"\xEF\xB9\xBE" => "\x20\xD9\x92",
		"\xEF\xBC\x81" => "\x21",
		"\xEF\xBC\x82" => "\x22",
		"\xEF\xBC\x83" => "\x23",
		"\xEF\xBC\x84" => "\x24",
		"\xEF\xBC\x85" => "\x25",
		"\xEF\xBC\x86" => "\x26",
		"\xEF\xBC\x87" => "\x27",
		"\xEF\xBC\x88" => "\x28",
		"\xEF\xBC\x89" => "\x29",
		"\xEF\xBC\x8A" => "\x2A",
		"\xEF\xBC\x8B" => "\x2B",
		"\xEF\xBC\x8C" => "\x2C",
		"\xEF\xBC\x8F" => "\x2F",
		"\xEF\xBC\x9A" => "\x3A",
		"\xEF\xBC\x9B" => "\x3B",
		"\xEF\xBC\x9C" => "\x3C",
		"\xEF\xBC\x9D" => "\x3D",
		"\xEF\xBC\x9E" => "\x3E",
		"\xEF\xBC\x9F" => "\x3F",
		"\xEF\xBC\xA0" => "\x40",
		"\xEF\xBC\xBB" => "\x5B",
		"\xEF\xBC\xBC" => "\x5C",
		"\xEF\xBC\xBD" => "\x5D",
		"\xEF\xBC\xBE" => "\x5E",
		"\xEF\xBC\xBF" => "\x5F",
		"\xEF\xBD\x80" => "\x60",
		"\xEF\xBD\x9B" => "\x7B",
		"\xEF\xBD\x9C" => "\x7C",
		"\xEF\xBD\x9D" => "\x7D",
		"\xEF\xBD\x9E" => "\x7E",
		"\xEF\xBF\xA3" => "\x20\xCC\x84",
		"\xF0\x9F\x84\x81" => "\x30\x2C",
		"\xF0\x9F\x84\x82" => "\x31\x2C",
		"\xF0\x9F\x84\x83" => "\x32\x2C",
		"\xF0\x9F\x84\x84" => "\x33\x2C",
		"\xF0\x9F\x84\x85" => "\x34\x2C",
		"\xF0\x9F\x84\x86" => "\x35\x2C",
		"\xF0\x9F\x84\x87" => "\x36\x2C",
		"\xF0\x9F\x84\x88" => "\x37\x2C",
		"\xF0\x9F\x84\x89" => "\x38\x2C",
		"\xF0\x9F\x84\x8A" => "\x39\x2C",
		"\xF0\x9F\x84\x90" => "\x28\x61\x29",
		"\xF0\x9F\x84\x91" => "\x28\x62\x29",
		"\xF0\x9F\x84\x92" => "\x28\x63\x29",
		"\xF0\x9F\x84\x93" => "\x28\x64\x29",
		"\xF0\x9F\x84\x94" => "\x28\x65\x29",
		"\xF0\x9F\x84\x95" => "\x28\x66\x29",
		"\xF0\x9F\x84\x96" => "\x28\x67\x29",
		"\xF0\x9F\x84\x97" => "\x28\x68\x29",
		"\xF0\x9F\x84\x98" => "\x28\x69\x29",
		"\xF0\x9F\x84\x99" => "\x28\x6A\x29",
		"\xF0\x9F\x84\x9A" => "\x28\x6B\x29",
		"\xF0\x9F\x84\x9B" => "\x28\x6C\x29",
		"\xF0\x9F\x84\x9C" => "\x28\x6D\x29",
		"\xF0\x9F\x84\x9D" => "\x28\x6E\x29",
		"\xF0\x9F\x84\x9E" => "\x28\x6F\x29",
		"\xF0\x9F\x84\x9F" => "\x28\x70\x29",
		"\xF0\x9F\x84\xA0" => "\x28\x71\x29",
		"\xF0\x9F\x84\xA1" => "\x28\x72\x29",
		"\xF0\x9F\x84\xA2" => "\x28\x73\x29",
		"\xF0\x9F\x84\xA3" => "\x28\x74\x29",
		"\xF0\x9F\x84\xA4" => "\x28\x75\x29",
		"\xF0\x9F\x84\xA5" => "\x28\x76\x29",
		"\xF0\x9F\x84\xA6" => "\x28\x77\x29",
		"\xF0\x9F\x84\xA7" => "\x28\x78\x29",
		"\xF0\x9F\x84\xA8" => "\x28\x79\x29",
		"\xF0\x9F\x84\xA9" => "\x28\x7A\x29",
	);
}

/**
 * Helper function for idn_to_* polyfills.
 *
 * Developers: Do not update the data in this function manually. Instead,
 * run "php -f other/update_unicode_data.php" on the command line.
 *
 * @return array Regular expressions useful for IDNA processing.
 */
function idna_regex()
{
	return array(
		'disallowed_std3' =>
			'\x{0}-\x{2C}' .
			'\x{2F}' .
			'\x{3A}-\x{40}' .
			'\x{5B}-\x{60}' .
			'\x{7B}-\x{7F}' .
			'\x{A0}' .
			'\x{A8}' .
			'\x{AF}' .
			'\x{B4}' .
			'\x{B8}' .
			'\x{2D8}' .
			'\x{2D9}' .
			'\x{2DA}' .
			'\x{2DB}' .
			'\x{2DC}' .
			'\x{2DD}' .
			'\x{37A}' .
			'\x{37E}' .
			'\x{384}' .
			'\x{385}' .
			'\x{1FBD}' .
			'\x{1FBF}' .
			'\x{1FC0}' .
			'\x{1FC1}' .
			'\x{1FCD}' .
			'\x{1FCE}' .
			'\x{1FCF}' .
			'\x{1FDD}' .
			'\x{1FDE}' .
			'\x{1FDF}' .
			'\x{1FED}' .
			'\x{1FEE}' .
			'\x{1FEF}' .
			'\x{1FFD}' .
			'\x{1FFE}' .
			'\x{2000}-\x{200A}' .
			'\x{2017}' .
			'\x{202F}' .
			'\x{203C}' .
			'\x{203E}' .
			'\x{2047}' .
			'\x{2048}' .
			'\x{2049}' .
			'\x{205F}' .
			'\x{207A}' .
			'\x{207C}' .
			'\x{207D}' .
			'\x{207E}' .
			'\x{208A}' .
			'\x{208C}' .
			'\x{208D}' .
			'\x{208E}' .
			'\x{2100}' .
			'\x{2101}' .
			'\x{2105}' .
			'\x{2106}' .
			'\x{2260}' .
			'\x{226E}-\x{226F}' .
			'\x{2474}' .
			'\x{2475}' .
			'\x{2476}' .
			'\x{2477}' .
			'\x{2478}' .
			'\x{2479}' .
			'\x{247A}' .
			'\x{247B}' .
			'\x{247C}' .
			'\x{247D}' .
			'\x{247E}' .
			'\x{247F}' .
			'\x{2480}' .
			'\x{2481}' .
			'\x{2482}' .
			'\x{2483}' .
			'\x{2484}' .
			'\x{2485}' .
			'\x{2486}' .
			'\x{2487}' .
			'\x{249C}' .
			'\x{249D}' .
			'\x{249E}' .
			'\x{249F}' .
			'\x{24A0}' .
			'\x{24A1}' .
			'\x{24A2}' .
			'\x{24A3}' .
			'\x{24A4}' .
			'\x{24A5}' .
			'\x{24A6}' .
			'\x{24A7}' .
			'\x{24A8}' .
			'\x{24A9}' .
			'\x{24AA}' .
			'\x{24AB}' .
			'\x{24AC}' .
			'\x{24AD}' .
			'\x{24AE}' .
			'\x{24AF}' .
			'\x{24B0}' .
			'\x{24B1}' .
			'\x{24B2}' .
			'\x{24B3}' .
			'\x{24B4}' .
			'\x{24B5}' .
			'\x{2A74}' .
			'\x{2A75}' .
			'\x{2A76}' .
			'\x{3000}' .
			'\x{309B}' .
			'\x{309C}' .
			'\x{3200}' .
			'\x{3201}' .
			'\x{3202}' .
			'\x{3203}' .
			'\x{3204}' .
			'\x{3205}' .
			'\x{3206}' .
			'\x{3207}' .
			'\x{3208}' .
			'\x{3209}' .
			'\x{320A}' .
			'\x{320B}' .
			'\x{320C}' .
			'\x{320D}' .
			'\x{320E}' .
			'\x{320F}' .
			'\x{3210}' .
			'\x{3211}' .
			'\x{3212}' .
			'\x{3213}' .
			'\x{3214}' .
			'\x{3215}' .
			'\x{3216}' .
			'\x{3217}' .
			'\x{3218}' .
			'\x{3219}' .
			'\x{321A}' .
			'\x{321B}' .
			'\x{321C}' .
			'\x{321D}' .
			'\x{321E}' .
			'\x{3220}' .
			'\x{3221}' .
			'\x{3222}' .
			'\x{3223}' .
			'\x{3224}' .
			'\x{3225}' .
			'\x{3226}' .
			'\x{3227}' .
			'\x{3228}' .
			'\x{3229}' .
			'\x{322A}' .
			'\x{322B}' .
			'\x{322C}' .
			'\x{322D}' .
			'\x{322E}' .
			'\x{322F}' .
			'\x{3230}' .
			'\x{3231}' .
			'\x{3232}' .
			'\x{3233}' .
			'\x{3234}' .
			'\x{3235}' .
			'\x{3236}' .
			'\x{3237}' .
			'\x{3238}' .
			'\x{3239}' .
			'\x{323A}' .
			'\x{323B}' .
			'\x{323C}' .
			'\x{323D}' .
			'\x{323E}' .
			'\x{323F}' .
			'\x{3240}' .
			'\x{3241}' .
			'\x{3242}' .
			'\x{3243}' .
			'\x{FB29}' .
			'\x{FC5E}' .
			'\x{FC5F}' .
			'\x{FC60}' .
			'\x{FC61}' .
			'\x{FC62}' .
			'\x{FC63}' .
			'\x{FDFA}' .
			'\x{FDFB}' .
			'\x{FE10}' .
			'\x{FE13}' .
			'\x{FE14}' .
			'\x{FE15}' .
			'\x{FE16}' .
			'\x{FE33}-\x{FE34}' .
			'\x{FE35}' .
			'\x{FE36}' .
			'\x{FE37}' .
			'\x{FE38}' .
			'\x{FE47}' .
			'\x{FE48}' .
			'\x{FE49}-\x{FE4C}' .
			'\x{FE4D}-\x{FE4F}' .
			'\x{FE50}' .
			'\x{FE54}' .
			'\x{FE55}' .
			'\x{FE56}' .
			'\x{FE57}' .
			'\x{FE59}' .
			'\x{FE5A}' .
			'\x{FE5B}' .
			'\x{FE5C}' .
			'\x{FE5F}' .
			'\x{FE60}' .
			'\x{FE61}' .
			'\x{FE62}' .
			'\x{FE64}' .
			'\x{FE65}' .
			'\x{FE66}' .
			'\x{FE68}' .
			'\x{FE69}' .
			'\x{FE6A}' .
			'\x{FE6B}' .
			'\x{FE70}' .
			'\x{FE72}' .
			'\x{FE74}' .
			'\x{FE76}' .
			'\x{FE78}' .
			'\x{FE7A}' .
			'\x{FE7C}' .
			'\x{FE7E}' .
			'\x{FF01}' .
			'\x{FF02}' .
			'\x{FF03}' .
			'\x{FF04}' .
			'\x{FF05}' .
			'\x{FF06}' .
			'\x{FF07}' .
			'\x{FF08}' .
			'\x{FF09}' .
			'\x{FF0A}' .
			'\x{FF0B}' .
			'\x{FF0C}' .
			'\x{FF0F}' .
			'\x{FF1A}' .
			'\x{FF1B}' .
			'\x{FF1C}' .
			'\x{FF1D}' .
			'\x{FF1E}' .
			'\x{FF1F}' .
			'\x{FF20}' .
			'\x{FF3B}' .
			'\x{FF3C}' .
			'\x{FF3D}' .
			'\x{FF3E}' .
			'\x{FF3F}' .
			'\x{FF40}' .
			'\x{FF5B}' .
			'\x{FF5C}' .
			'\x{FF5D}' .
			'\x{FF5E}' .
			'\x{FFE3}' .
			'\x{1F101}' .
			'\x{1F102}' .
			'\x{1F103}' .
			'\x{1F104}' .
			'\x{1F105}' .
			'\x{1F106}' .
			'\x{1F107}' .
			'\x{1F108}' .
			'\x{1F109}' .
			'\x{1F10A}' .
			'\x{1F110}' .
			'\x{1F111}' .
			'\x{1F112}' .
			'\x{1F113}' .
			'\x{1F114}' .
			'\x{1F115}' .
			'\x{1F116}' .
			'\x{1F117}' .
			'\x{1F118}' .
			'\x{1F119}' .
			'\x{1F11A}' .
			'\x{1F11B}' .
			'\x{1F11C}' .
			'\x{1F11D}' .
			'\x{1F11E}' .
			'\x{1F11F}' .
			'\x{1F120}' .
			'\x{1F121}' .
			'\x{1F122}' .
			'\x{1F123}' .
			'\x{1F124}' .
			'\x{1F125}' .
			'\x{1F126}' .
			'\x{1F127}' .
			'\x{1F128}' .
			'\x{1F129}',
		'disallowed' =>
			'\x{80}-\x{9F}' .
			'\x{378}-\x{379}' .
			'\x{380}-\x{383}' .
			'\x{38B}' .
			'\x{38D}' .
			'\x{3A2}' .
			'\x{4C0}' .
			'\x{530}' .
			'\x{557}-\x{558}' .
			'\x{58B}-\x{58C}' .
			'\x{590}' .
			'\x{5C8}-\x{5CF}' .
			'\x{5EB}-\x{5EE}' .
			'\x{5F5}-\x{5FF}' .
			'\x{600}-\x{603}' .
			'\x{604}' .
			'\x{605}' .
			'\x{61C}' .
			'\x{6DD}' .
			'\x{70E}' .
			'\x{70F}' .
			'\x{74B}-\x{74C}' .
			'\x{7B2}-\x{7BF}' .
			'\x{7FB}-\x{7FC}' .
			'\x{82E}-\x{82F}' .
			'\x{83F}' .
			'\x{85C}-\x{85D}' .
			'\x{85F}' .
			'\x{86B}-\x{86F}' .
			'\x{88F}' .
			'\x{890}-\x{891}' .
			'\x{892}-\x{897}' .
			'\x{8E2}' .
			'\x{984}' .
			'\x{98D}-\x{98E}' .
			'\x{991}-\x{992}' .
			'\x{9A9}' .
			'\x{9B1}' .
			'\x{9B3}-\x{9B5}' .
			'\x{9BA}-\x{9BB}' .
			'\x{9C5}-\x{9C6}' .
			'\x{9C9}-\x{9CA}' .
			'\x{9CF}-\x{9D6}' .
			'\x{9D8}-\x{9DB}' .
			'\x{9DE}' .
			'\x{9E4}-\x{9E5}' .
			'\x{9FF}-\x{A00}' .
			'\x{A04}' .
			'\x{A0B}-\x{A0E}' .
			'\x{A11}-\x{A12}' .
			'\x{A29}' .
			'\x{A31}' .
			'\x{A34}' .
			'\x{A37}' .
			'\x{A3A}-\x{A3B}' .
			'\x{A3D}' .
			'\x{A43}-\x{A46}' .
			'\x{A49}-\x{A4A}' .
			'\x{A4E}-\x{A50}' .
			'\x{A52}-\x{A58}' .
			'\x{A5D}' .
			'\x{A5F}-\x{A65}' .
			'\x{A77}-\x{A80}' .
			'\x{A84}' .
			'\x{A8E}' .
			'\x{A92}' .
			'\x{AA9}' .
			'\x{AB1}' .
			'\x{AB4}' .
			'\x{ABA}-\x{ABB}' .
			'\x{AC6}' .
			'\x{ACA}' .
			'\x{ACE}-\x{ACF}' .
			'\x{AD1}-\x{ADF}' .
			'\x{AE4}-\x{AE5}' .
			'\x{AF2}-\x{AF8}' .
			'\x{B00}' .
			'\x{B04}' .
			'\x{B0D}-\x{B0E}' .
			'\x{B11}-\x{B12}' .
			'\x{B29}' .
			'\x{B31}' .
			'\x{B34}' .
			'\x{B3A}-\x{B3B}' .
			'\x{B45}-\x{B46}' .
			'\x{B49}-\x{B4A}' .
			'\x{B4E}-\x{B54}' .
			'\x{B58}-\x{B5B}' .
			'\x{B5E}' .
			'\x{B64}-\x{B65}' .
			'\x{B78}-\x{B81}' .
			'\x{B84}' .
			'\x{B8B}-\x{B8D}' .
			'\x{B91}' .
			'\x{B96}-\x{B98}' .
			'\x{B9B}' .
			'\x{B9D}' .
			'\x{BA0}-\x{BA2}' .
			'\x{BA5}-\x{BA7}' .
			'\x{BAB}-\x{BAD}' .
			'\x{BBA}-\x{BBD}' .
			'\x{BC3}-\x{BC5}' .
			'\x{BC9}' .
			'\x{BCE}-\x{BCF}' .
			'\x{BD1}-\x{BD6}' .
			'\x{BD8}-\x{BE5}' .
			'\x{BFB}-\x{BFF}' .
			'\x{C0D}' .
			'\x{C11}' .
			'\x{C29}' .
			'\x{C3A}-\x{C3B}' .
			'\x{C45}' .
			'\x{C49}' .
			'\x{C4E}-\x{C54}' .
			'\x{C57}' .
			'\x{C5B}-\x{C5C}' .
			'\x{C5E}-\x{C5F}' .
			'\x{C64}-\x{C65}' .
			'\x{C70}-\x{C76}' .
			'\x{C8D}' .
			'\x{C91}' .
			'\x{CA9}' .
			'\x{CB4}' .
			'\x{CBA}-\x{CBB}' .
			'\x{CC5}' .
			'\x{CC9}' .
			'\x{CCE}-\x{CD4}' .
			'\x{CD7}-\x{CDC}' .
			'\x{CDF}' .
			'\x{CE4}-\x{CE5}' .
			'\x{CF0}' .
			'\x{CF4}-\x{CFF}' .
			'\x{D0D}' .
			'\x{D11}' .
			'\x{D45}' .
			'\x{D49}' .
			'\x{D50}-\x{D53}' .
			'\x{D64}-\x{D65}' .
			'\x{D80}' .
			'\x{D84}' .
			'\x{D97}-\x{D99}' .
			'\x{DB2}' .
			'\x{DBC}' .
			'\x{DBE}-\x{DBF}' .
			'\x{DC7}-\x{DC9}' .
			'\x{DCB}-\x{DCE}' .
			'\x{DD5}' .
			'\x{DD7}' .
			'\x{DE0}-\x{DE5}' .
			'\x{DF0}-\x{DF1}' .
			'\x{DF5}-\x{E00}' .
			'\x{E3B}-\x{E3E}' .
			'\x{E5C}-\x{E80}' .
			'\x{E83}' .
			'\x{E85}' .
			'\x{E8B}' .
			'\x{EA4}' .
			'\x{EA6}' .
			'\x{EBE}-\x{EBF}' .
			'\x{EC5}' .
			'\x{EC7}' .
			'\x{ECF}' .
			'\x{EDA}-\x{EDB}' .
			'\x{EE0}-\x{EFF}' .
			'\x{F48}' .
			'\x{F6D}-\x{F70}' .
			'\x{F98}' .
			'\x{FBD}' .
			'\x{FCD}' .
			'\x{FDB}-\x{FFF}' .
			'\x{10A0}-\x{10C5}' .
			'\x{10C6}' .
			'\x{10C8}-\x{10CC}' .
			'\x{10CE}-\x{10CF}' .
			'\x{115F}-\x{1160}' .
			'\x{1249}' .
			'\x{124E}-\x{124F}' .
			'\x{1257}' .
			'\x{1259}' .
			'\x{125E}-\x{125F}' .
			'\x{1289}' .
			'\x{128E}-\x{128F}' .
			'\x{12B1}' .
			'\x{12B6}-\x{12B7}' .
			'\x{12BF}' .
			'\x{12C1}' .
			'\x{12C6}-\x{12C7}' .
			'\x{12D7}' .
			'\x{1311}' .
			'\x{1316}-\x{1317}' .
			'\x{135B}-\x{135C}' .
			'\x{137D}-\x{137F}' .
			'\x{139A}-\x{139F}' .
			'\x{13F6}-\x{13F7}' .
			'\x{13FE}-\x{13FF}' .
			'\x{1680}' .
			'\x{169D}-\x{169F}' .
			'\x{16F9}-\x{16FF}' .
			'\x{1716}-\x{171E}' .
			'\x{1737}-\x{173F}' .
			'\x{1754}-\x{175F}' .
			'\x{176D}' .
			'\x{1771}' .
			'\x{1774}-\x{177F}' .
			'\x{17B4}-\x{17B5}' .
			'\x{17DE}-\x{17DF}' .
			'\x{17EA}-\x{17EF}' .
			'\x{17FA}-\x{17FF}' .
			'\x{1806}' .
			'\x{180E}' .
			'\x{181A}-\x{181F}' .
			'\x{1879}-\x{187F}' .
			'\x{18AB}-\x{18AF}' .
			'\x{18F6}-\x{18FF}' .
			'\x{191F}' .
			'\x{192C}-\x{192F}' .
			'\x{193C}-\x{193F}' .
			'\x{1941}-\x{1943}' .
			'\x{196E}-\x{196F}' .
			'\x{1975}-\x{197F}' .
			'\x{19AC}-\x{19AF}' .
			'\x{19CA}-\x{19CF}' .
			'\x{19DB}-\x{19DD}' .
			'\x{1A1C}-\x{1A1D}' .
			'\x{1A5F}' .
			'\x{1A7D}-\x{1A7E}' .
			'\x{1A8A}-\x{1A8F}' .
			'\x{1A9A}-\x{1A9F}' .
			'\x{1AAE}-\x{1AAF}' .
			'\x{1ACF}-\x{1AFF}' .
			'\x{1B4D}-\x{1B4F}' .
			'\x{1B7F}' .
			'\x{1BF4}-\x{1BFB}' .
			'\x{1C38}-\x{1C3A}' .
			'\x{1C4A}-\x{1C4C}' .
			'\x{1C89}-\x{1C8F}' .
			'\x{1CBB}-\x{1CBC}' .
			'\x{1CC8}-\x{1CCF}' .
			'\x{1CFB}-\x{1CFF}' .
			'\x{1F16}-\x{1F17}' .
			'\x{1F1E}-\x{1F1F}' .
			'\x{1F46}-\x{1F47}' .
			'\x{1F4E}-\x{1F4F}' .
			'\x{1F58}' .
			'\x{1F5A}' .
			'\x{1F5C}' .
			'\x{1F5E}' .
			'\x{1F7E}-\x{1F7F}' .
			'\x{1FB5}' .
			'\x{1FC5}' .
			'\x{1FD4}-\x{1FD5}' .
			'\x{1FDC}' .
			'\x{1FF0}-\x{1FF1}' .
			'\x{1FF5}' .
			'\x{1FFF}' .
			'\x{200E}-\x{200F}' .
			'\x{2024}-\x{2026}' .
			'\x{2028}-\x{202E}' .
			'\x{2061}-\x{2063}' .
			'\x{2065}' .
			'\x{2066}-\x{2069}' .
			'\x{206A}-\x{206F}' .
			'\x{2072}-\x{2073}' .
			'\x{208F}' .
			'\x{209D}-\x{209F}' .
			'\x{20C1}-\x{20CF}' .
			'\x{20F1}-\x{20FF}' .
			'\x{2132}' .
			'\x{2183}' .
			'\x{218C}-\x{218F}' .
			'\x{2427}-\x{243F}' .
			'\x{244B}-\x{245F}' .
			'\x{2488}-\x{249B}' .
			'\x{2B74}-\x{2B75}' .
			'\x{2B96}' .
			'\x{2CF4}-\x{2CF8}' .
			'\x{2D26}' .
			'\x{2D28}-\x{2D2C}' .
			'\x{2D2E}-\x{2D2F}' .
			'\x{2D68}-\x{2D6E}' .
			'\x{2D71}-\x{2D7E}' .
			'\x{2D97}-\x{2D9F}' .
			'\x{2DA7}' .
			'\x{2DAF}' .
			'\x{2DB7}' .
			'\x{2DBF}' .
			'\x{2DC7}' .
			'\x{2DCF}' .
			'\x{2DD7}' .
			'\x{2DDF}' .
			'\x{2E5E}-\x{2E7F}' .
			'\x{2E9A}' .
			'\x{2EF4}-\x{2EFF}' .
			'\x{2FD6}-\x{2FEF}' .
			'\x{2FF0}-\x{2FFB}' .
			'\x{2FFC}-\x{2FFF}' .
			'\x{3040}' .
			'\x{3097}-\x{3098}' .
			'\x{3100}-\x{3104}' .
			'\x{3130}' .
			'\x{3164}' .
			'\x{318F}' .
			'\x{31E4}-\x{31EF}' .
			'\x{321F}' .
			'\x{33C2}' .
			'\x{33C7}' .
			'\x{33D8}' .
			'\x{A48D}-\x{A48F}' .
			'\x{A4C7}-\x{A4CF}' .
			'\x{A62C}-\x{A63F}' .
			'\x{A6F8}-\x{A6FF}' .
			'\x{A7CB}-\x{A7CF}' .
			'\x{A7D2}' .
			'\x{A7D4}' .
			'\x{A7DA}-\x{A7F1}' .
			'\x{A82D}-\x{A82F}' .
			'\x{A83A}-\x{A83F}' .
			'\x{A878}-\x{A87F}' .
			'\x{A8C6}-\x{A8CD}' .
			'\x{A8DA}-\x{A8DF}' .
			'\x{A954}-\x{A95E}' .
			'\x{A97D}-\x{A97F}' .
			'\x{A9CE}' .
			'\x{A9DA}-\x{A9DD}' .
			'\x{A9FF}' .
			'\x{AA37}-\x{AA3F}' .
			'\x{AA4E}-\x{AA4F}' .
			'\x{AA5A}-\x{AA5B}' .
			'\x{AAC3}-\x{AADA}' .
			'\x{AAF7}-\x{AB00}' .
			'\x{AB07}-\x{AB08}' .
			'\x{AB0F}-\x{AB10}' .
			'\x{AB17}-\x{AB1F}' .
			'\x{AB27}' .
			'\x{AB2F}' .
			'\x{AB6C}-\x{AB6F}' .
			'\x{ABEE}-\x{ABEF}' .
			'\x{ABFA}-\x{ABFF}' .
			'\x{D7A4}-\x{D7AF}' .
			'\x{D7C7}-\x{D7CA}' .
			'\x{D7FC}-\x{D7FF}' .
			'\x{E000}-\x{F8FF}' .
			'\x{FA6E}-\x{FA6F}' .
			'\x{FADA}-\x{FAFF}' .
			'\x{FB07}-\x{FB12}' .
			'\x{FB18}-\x{FB1C}' .
			'\x{FB37}' .
			'\x{FB3D}' .
			'\x{FB3F}' .
			'\x{FB42}' .
			'\x{FB45}' .
			'\x{FBC3}-\x{FBD2}' .
			'\x{FD90}-\x{FD91}' .
			'\x{FDC8}-\x{FDCE}' .
			'\x{FDD0}-\x{FDEF}' .
			'\x{FE12}' .
			'\x{FE19}' .
			'\x{FE1A}-\x{FE1F}' .
			'\x{FE30}' .
			'\x{FE52}' .
			'\x{FE53}' .
			'\x{FE67}' .
			'\x{FE6C}-\x{FE6F}' .
			'\x{FE75}' .
			'\x{FEFD}-\x{FEFE}' .
			'\x{FF00}' .
			'\x{FFA0}' .
			'\x{FFBF}-\x{FFC1}' .
			'\x{FFC8}-\x{FFC9}' .
			'\x{FFD0}-\x{FFD1}' .
			'\x{FFD8}-\x{FFD9}' .
			'\x{FFDD}-\x{FFDF}' .
			'\x{FFE7}' .
			'\x{FFEF}-\x{FFF8}' .
			'\x{FFF9}-\x{FFFB}' .
			'\x{FFFC}' .
			'\x{FFFD}' .
			'\x{FFFE}-\x{FFFF}' .
			'\x{1000C}' .
			'\x{10027}' .
			'\x{1003B}' .
			'\x{1003E}' .
			'\x{1004E}-\x{1004F}' .
			'\x{1005E}-\x{1007F}' .
			'\x{100FB}-\x{100FF}' .
			'\x{10103}-\x{10106}' .
			'\x{10134}-\x{10136}' .
			'\x{1018F}' .
			'\x{1019D}-\x{1019F}' .
			'\x{101A1}-\x{101CF}' .
			'\x{101FE}-\x{1027F}' .
			'\x{1029D}-\x{1029F}' .
			'\x{102D1}-\x{102DF}' .
			'\x{102FC}-\x{102FF}' .
			'\x{10324}-\x{1032C}' .
			'\x{1034B}-\x{1034F}' .
			'\x{1037B}-\x{1037F}' .
			'\x{1039E}' .
			'\x{103C4}-\x{103C7}' .
			'\x{103D6}-\x{103FF}' .
			'\x{1049E}-\x{1049F}' .
			'\x{104AA}-\x{104AF}' .
			'\x{104D4}-\x{104D7}' .
			'\x{104FC}-\x{104FF}' .
			'\x{10528}-\x{1052F}' .
			'\x{10564}-\x{1056E}' .
			'\x{1057B}' .
			'\x{1058B}' .
			'\x{10593}' .
			'\x{10596}' .
			'\x{105A2}' .
			'\x{105B2}' .
			'\x{105BA}' .
			'\x{105BD}-\x{105FF}' .
			'\x{10737}-\x{1073F}' .
			'\x{10756}-\x{1075F}' .
			'\x{10768}-\x{1077F}' .
			'\x{10786}' .
			'\x{107B1}' .
			'\x{107BB}-\x{107FF}' .
			'\x{10806}-\x{10807}' .
			'\x{10809}' .
			'\x{10836}' .
			'\x{10839}-\x{1083B}' .
			'\x{1083D}-\x{1083E}' .
			'\x{10856}' .
			'\x{1089F}-\x{108A6}' .
			'\x{108B0}-\x{108DF}' .
			'\x{108F3}' .
			'\x{108F6}-\x{108FA}' .
			'\x{1091C}-\x{1091E}' .
			'\x{1093A}-\x{1093E}' .
			'\x{10940}-\x{1097F}' .
			'\x{109B8}-\x{109BB}' .
			'\x{109D0}-\x{109D1}' .
			'\x{10A04}' .
			'\x{10A07}-\x{10A0B}' .
			'\x{10A14}' .
			'\x{10A18}' .
			'\x{10A36}-\x{10A37}' .
			'\x{10A3B}-\x{10A3E}' .
			'\x{10A49}-\x{10A4F}' .
			'\x{10A59}-\x{10A5F}' .
			'\x{10AA0}-\x{10ABF}' .
			'\x{10AE7}-\x{10AEA}' .
			'\x{10AF7}-\x{10AFF}' .
			'\x{10B36}-\x{10B38}' .
			'\x{10B56}-\x{10B57}' .
			'\x{10B73}-\x{10B77}' .
			'\x{10B92}-\x{10B98}' .
			'\x{10B9D}-\x{10BA8}' .
			'\x{10BB0}-\x{10BFF}' .
			'\x{10C49}-\x{10C7F}' .
			'\x{10CB3}-\x{10CBF}' .
			'\x{10CF3}-\x{10CF9}' .
			'\x{10D28}-\x{10D2F}' .
			'\x{10D3A}-\x{10E5F}' .
			'\x{10E7F}' .
			'\x{10EAA}' .
			'\x{10EAE}-\x{10EAF}' .
			'\x{10EB2}-\x{10EFC}' .
			'\x{10F28}-\x{10F2F}' .
			'\x{10F5A}-\x{10F6F}' .
			'\x{10F8A}-\x{10FAF}' .
			'\x{10FCC}-\x{10FDF}' .
			'\x{10FF7}-\x{10FFF}' .
			'\x{1104E}-\x{11051}' .
			'\x{11076}-\x{1107E}' .
			'\x{110BD}' .
			'\x{110C3}-\x{110CC}' .
			'\x{110CD}' .
			'\x{110CE}-\x{110CF}' .
			'\x{110E9}-\x{110EF}' .
			'\x{110FA}-\x{110FF}' .
			'\x{11135}' .
			'\x{11148}-\x{1114F}' .
			'\x{11177}-\x{1117F}' .
			'\x{111E0}' .
			'\x{111F5}-\x{111FF}' .
			'\x{11212}' .
			'\x{11242}-\x{1127F}' .
			'\x{11287}' .
			'\x{11289}' .
			'\x{1128E}' .
			'\x{1129E}' .
			'\x{112AA}-\x{112AF}' .
			'\x{112EB}-\x{112EF}' .
			'\x{112FA}-\x{112FF}' .
			'\x{11304}' .
			'\x{1130D}-\x{1130E}' .
			'\x{11311}-\x{11312}' .
			'\x{11329}' .
			'\x{11331}' .
			'\x{11334}' .
			'\x{1133A}' .
			'\x{11345}-\x{11346}' .
			'\x{11349}-\x{1134A}' .
			'\x{1134E}-\x{1134F}' .
			'\x{11351}-\x{11356}' .
			'\x{11358}-\x{1135C}' .
			'\x{11364}-\x{11365}' .
			'\x{1136D}-\x{1136F}' .
			'\x{11375}-\x{113FF}' .
			'\x{1145C}' .
			'\x{11462}-\x{1147F}' .
			'\x{114C8}-\x{114CF}' .
			'\x{114DA}-\x{1157F}' .
			'\x{115B6}-\x{115B7}' .
			'\x{115DE}-\x{115FF}' .
			'\x{11645}-\x{1164F}' .
			'\x{1165A}-\x{1165F}' .
			'\x{1166D}-\x{1167F}' .
			'\x{116BA}-\x{116BF}' .
			'\x{116CA}-\x{116FF}' .
			'\x{1171B}-\x{1171C}' .
			'\x{1172C}-\x{1172F}' .
			'\x{11747}-\x{117FF}' .
			'\x{1183C}-\x{1189F}' .
			'\x{118F3}-\x{118FE}' .
			'\x{11907}-\x{11908}' .
			'\x{1190A}-\x{1190B}' .
			'\x{11914}' .
			'\x{11917}' .
			'\x{11936}' .
			'\x{11939}-\x{1193A}' .
			'\x{11947}-\x{1194F}' .
			'\x{1195A}-\x{1199F}' .
			'\x{119A8}-\x{119A9}' .
			'\x{119D8}-\x{119D9}' .
			'\x{119E5}-\x{119FF}' .
			'\x{11A48}-\x{11A4F}' .
			'\x{11AA3}-\x{11AAF}' .
			'\x{11AF9}-\x{11AFF}' .
			'\x{11B0A}-\x{11BFF}' .
			'\x{11C09}' .
			'\x{11C37}' .
			'\x{11C46}-\x{11C4F}' .
			'\x{11C6D}-\x{11C6F}' .
			'\x{11C90}-\x{11C91}' .
			'\x{11CA8}' .
			'\x{11CB7}-\x{11CFF}' .
			'\x{11D07}' .
			'\x{11D0A}' .
			'\x{11D37}-\x{11D39}' .
			'\x{11D3B}' .
			'\x{11D3E}' .
			'\x{11D48}-\x{11D4F}' .
			'\x{11D5A}-\x{11D5F}' .
			'\x{11D66}' .
			'\x{11D69}' .
			'\x{11D8F}' .
			'\x{11D92}' .
			'\x{11D99}-\x{11D9F}' .
			'\x{11DAA}-\x{11EDF}' .
			'\x{11EF9}-\x{11EFF}' .
			'\x{11F11}' .
			'\x{11F3B}-\x{11F3D}' .
			'\x{11F5A}-\x{11FAF}' .
			'\x{11FB1}-\x{11FBF}' .
			'\x{11FF2}-\x{11FFE}' .
			'\x{1239A}-\x{123FF}' .
			'\x{1246F}' .
			'\x{12475}-\x{1247F}' .
			'\x{12544}-\x{12F8F}' .
			'\x{12FF3}-\x{12FFF}' .
			'\x{13430}-\x{13438}' .
			'\x{13439}-\x{1343F}' .
			'\x{13456}-\x{143FF}' .
			'\x{14647}-\x{167FF}' .
			'\x{16A39}-\x{16A3F}' .
			'\x{16A5F}' .
			'\x{16A6A}-\x{16A6D}' .
			'\x{16ABF}' .
			'\x{16ACA}-\x{16ACF}' .
			'\x{16AEE}-\x{16AEF}' .
			'\x{16AF6}-\x{16AFF}' .
			'\x{16B46}-\x{16B4F}' .
			'\x{16B5A}' .
			'\x{16B62}' .
			'\x{16B78}-\x{16B7C}' .
			'\x{16B90}-\x{16E3F}' .
			'\x{16E9B}-\x{16EFF}' .
			'\x{16F4B}-\x{16F4E}' .
			'\x{16F88}-\x{16F8E}' .
			'\x{16FA0}-\x{16FDF}' .
			'\x{16FE5}-\x{16FEF}' .
			'\x{16FF2}-\x{16FFF}' .
			'\x{187F8}-\x{187FF}' .
			'\x{18CD6}-\x{18CFF}' .
			'\x{18D09}-\x{1AFEF}' .
			'\x{1AFF4}' .
			'\x{1AFFC}' .
			'\x{1AFFF}' .
			'\x{1B123}-\x{1B131}' .
			'\x{1B133}-\x{1B14F}' .
			'\x{1B153}-\x{1B154}' .
			'\x{1B156}-\x{1B163}' .
			'\x{1B168}-\x{1B16F}' .
			'\x{1B2FC}-\x{1BBFF}' .
			'\x{1BC6B}-\x{1BC6F}' .
			'\x{1BC7D}-\x{1BC7F}' .
			'\x{1BC89}-\x{1BC8F}' .
			'\x{1BC9A}-\x{1BC9B}' .
			'\x{1BCA4}-\x{1CEFF}' .
			'\x{1CF2E}-\x{1CF2F}' .
			'\x{1CF47}-\x{1CF4F}' .
			'\x{1CFC4}-\x{1CFFF}' .
			'\x{1D0F6}-\x{1D0FF}' .
			'\x{1D127}-\x{1D128}' .
			'\x{1D173}-\x{1D17A}' .
			'\x{1D1EB}-\x{1D1FF}' .
			'\x{1D246}-\x{1D2BF}' .
			'\x{1D2D4}-\x{1D2DF}' .
			'\x{1D2F4}-\x{1D2FF}' .
			'\x{1D357}-\x{1D35F}' .
			'\x{1D379}-\x{1D3FF}' .
			'\x{1D455}' .
			'\x{1D49D}' .
			'\x{1D4A0}-\x{1D4A1}' .
			'\x{1D4A3}-\x{1D4A4}' .
			'\x{1D4A7}-\x{1D4A8}' .
			'\x{1D4AD}' .
			'\x{1D4BA}' .
			'\x{1D4BC}' .
			'\x{1D4C4}' .
			'\x{1D506}' .
			'\x{1D50B}-\x{1D50C}' .
			'\x{1D515}' .
			'\x{1D51D}' .
			'\x{1D53A}' .
			'\x{1D53F}' .
			'\x{1D545}' .
			'\x{1D547}-\x{1D549}' .
			'\x{1D551}' .
			'\x{1D6A6}-\x{1D6A7}' .
			'\x{1D7CC}-\x{1D7CD}' .
			'\x{1DA8C}-\x{1DA9A}' .
			'\x{1DAA0}' .
			'\x{1DAB0}-\x{1DEFF}' .
			'\x{1DF1F}-\x{1DF24}' .
			'\x{1DF2B}-\x{1DFFF}' .
			'\x{1E007}' .
			'\x{1E019}-\x{1E01A}' .
			'\x{1E022}' .
			'\x{1E025}' .
			'\x{1E02B}-\x{1E02F}' .
			'\x{1E06E}-\x{1E08E}' .
			'\x{1E090}-\x{1E0FF}' .
			'\x{1E12D}-\x{1E12F}' .
			'\x{1E13E}-\x{1E13F}' .
			'\x{1E14A}-\x{1E14D}' .
			'\x{1E150}-\x{1E28F}' .
			'\x{1E2AF}-\x{1E2BF}' .
			'\x{1E2FA}-\x{1E2FE}' .
			'\x{1E300}-\x{1E4CF}' .
			'\x{1E4FA}-\x{1E7DF}' .
			'\x{1E7E7}' .
			'\x{1E7EC}' .
			'\x{1E7EF}' .
			'\x{1E7FF}' .
			'\x{1E8C5}-\x{1E8C6}' .
			'\x{1E8D7}-\x{1E8FF}' .
			'\x{1E94C}-\x{1E94F}' .
			'\x{1E95A}-\x{1E95D}' .
			'\x{1E960}-\x{1EC70}' .
			'\x{1ECB5}-\x{1ED00}' .
			'\x{1ED3E}-\x{1EDFF}' .
			'\x{1EE04}' .
			'\x{1EE20}' .
			'\x{1EE23}' .
			'\x{1EE25}-\x{1EE26}' .
			'\x{1EE28}' .
			'\x{1EE33}' .
			'\x{1EE38}' .
			'\x{1EE3A}' .
			'\x{1EE3C}-\x{1EE41}' .
			'\x{1EE43}-\x{1EE46}' .
			'\x{1EE48}' .
			'\x{1EE4A}' .
			'\x{1EE4C}' .
			'\x{1EE50}' .
			'\x{1EE53}' .
			'\x{1EE55}-\x{1EE56}' .
			'\x{1EE58}' .
			'\x{1EE5A}' .
			'\x{1EE5C}' .
			'\x{1EE5E}' .
			'\x{1EE60}' .
			'\x{1EE63}' .
			'\x{1EE65}-\x{1EE66}' .
			'\x{1EE6B}' .
			'\x{1EE73}' .
			'\x{1EE78}' .
			'\x{1EE7D}' .
			'\x{1EE7F}' .
			'\x{1EE8A}' .
			'\x{1EE9C}-\x{1EEA0}' .
			'\x{1EEA4}' .
			'\x{1EEAA}' .
			'\x{1EEBC}-\x{1EEEF}' .
			'\x{1EEF2}-\x{1EFFF}' .
			'\x{1F02C}-\x{1F02F}' .
			'\x{1F094}-\x{1F09F}' .
			'\x{1F0AF}-\x{1F0B0}' .
			'\x{1F0C0}' .
			'\x{1F0D0}' .
			'\x{1F0F6}-\x{1F0FF}' .
			'\x{1F100}' .
			'\x{1F1AE}-\x{1F1E5}' .
			'\x{1F203}-\x{1F20F}' .
			'\x{1F23C}-\x{1F23F}' .
			'\x{1F249}-\x{1F24F}' .
			'\x{1F252}-\x{1F25F}' .
			'\x{1F266}-\x{1F2FF}' .
			'\x{1F6D8}-\x{1F6DB}' .
			'\x{1F6ED}-\x{1F6EF}' .
			'\x{1F6FD}-\x{1F6FF}' .
			'\x{1F777}-\x{1F77A}' .
			'\x{1F7DA}-\x{1F7DF}' .
			'\x{1F7EC}-\x{1F7EF}' .
			'\x{1F7F1}-\x{1F7FF}' .
			'\x{1F80C}-\x{1F80F}' .
			'\x{1F848}-\x{1F84F}' .
			'\x{1F85A}-\x{1F85F}' .
			'\x{1F888}-\x{1F88F}' .
			'\x{1F8AE}-\x{1F8AF}' .
			'\x{1F8B2}-\x{1F8FF}' .
			'\x{1FA54}-\x{1FA5F}' .
			'\x{1FA6E}-\x{1FA6F}' .
			'\x{1FA7D}-\x{1FA7F}' .
			'\x{1FA89}-\x{1FA8F}' .
			'\x{1FABE}' .
			'\x{1FAC6}-\x{1FACD}' .
			'\x{1FADC}-\x{1FADF}' .
			'\x{1FAE9}-\x{1FAEF}' .
			'\x{1FAF9}-\x{1FAFF}' .
			'\x{1FB93}' .
			'\x{1FBCB}-\x{1FBEF}' .
			'\x{1FBFA}-\x{1FFFD}' .
			'\x{1FFFE}-\x{1FFFF}' .
			'\x{2A6E0}-\x{2A6FF}' .
			'\x{2B73A}-\x{2B73F}' .
			'\x{2B81E}-\x{2B81F}' .
			'\x{2CEA2}-\x{2CEAF}' .
			'\x{2EBE1}-\x{2F7FF}' .
			'\x{2F868}' .
			'\x{2F874}' .
			'\x{2F91F}' .
			'\x{2F95F}' .
			'\x{2F9BF}' .
			'\x{2FA1E}-\x{2FFFD}' .
			'\x{2FFFE}-\x{2FFFF}' .
			'\x{3134B}-\x{3134F}' .
			'\x{323B0}-\x{3FFFD}' .
			'\x{3FFFE}-\x{3FFFF}' .
			'\x{40000}-\x{4FFFD}' .
			'\x{4FFFE}-\x{4FFFF}' .
			'\x{50000}-\x{5FFFD}' .
			'\x{5FFFE}-\x{5FFFF}' .
			'\x{60000}-\x{6FFFD}' .
			'\x{6FFFE}-\x{6FFFF}' .
			'\x{70000}-\x{7FFFD}' .
			'\x{7FFFE}-\x{7FFFF}' .
			'\x{80000}-\x{8FFFD}' .
			'\x{8FFFE}-\x{8FFFF}' .
			'\x{90000}-\x{9FFFD}' .
			'\x{9FFFE}-\x{9FFFF}' .
			'\x{A0000}-\x{AFFFD}' .
			'\x{AFFFE}-\x{AFFFF}' .
			'\x{B0000}-\x{BFFFD}' .
			'\x{BFFFE}-\x{BFFFF}' .
			'\x{C0000}-\x{CFFFD}' .
			'\x{CFFFE}-\x{CFFFF}' .
			'\x{D0000}-\x{DFFFD}' .
			'\x{DFFFE}-\x{DFFFF}' .
			'\x{E0000}' .
			'\x{E0001}' .
			'\x{E0002}-\x{E001F}' .
			'\x{E0020}-\x{E007F}' .
			'\x{E0080}-\x{E00FF}' .
			'\x{E01F0}-\x{EFFFD}' .
			'\x{EFFFE}-\x{EFFFF}' .
			'\x{F0000}-\x{FFFFD}' .
			'\x{FFFFE}-\x{FFFFF}' .
			'\x{100000}-\x{10FFFD}' .
			'\x{10FFFE}-\x{10FFFF}',
		'ignored' =>
			'\x{AD}' .
			'\x{34F}' .
			'\x{180B}-\x{180D}' .
			'\x{180F}' .
			'\x{200B}' .
			'\x{2060}' .
			'\x{2064}' .
			'\x{FE00}-\x{FE0F}' .
			'\x{FEFF}' .
			'\x{1BCA0}-\x{1BCA3}' .
			'\x{E0100}-\x{E01EF}',
		'deviation' =>
			'\x{DF}' .
			'\x{3C2}' .
			'\x{200C}-\x{200D}',
	);
}

?>